# README

## Installation Instructions
### For CUDA:
1. ``sudo apt-get install -y libglew-dev``
2. add to .bash_rc ``export LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libGLEW.so``
3. install cuda https://pytorch.org/get-started/locally/ 

### Setup repository
1. Install conda for creating the virtual env: https://docs.conda.io/en/latest/miniconda.html 
2. Install Mujoco: https://www.roboti.us/index.html
3. Install any necessary packages for DMC: https://github.com/deepmind/dm_control 
a.  for Mujoco-py``sudo apt install libosmesa6-dev libgl1-mesa-glx libglfw3``
b. ``sudo apt-get install patchelf. ``
4. Install dmc2gym: https://github.com/denisyarats/dmc2gym 
5. Clone the repository and create the conda env using 
``conda env create -f environment.yml`` and activate the env
6. Install local version of dm_control ``pip install -e dm_control/``


## Training
`` python train.py env_name=point_mass exp_name=test num_steps=6e3 agent=sac goal_algo=cusp seed=0 num_steps_alice=100 num_steps_bob=100 symmetrize=True before_update_stale_regrets=50 stale_regret_coeff=.9 ``

Where ``num_steps`` specifies number of episodes, ``num_steps_alice`` or ``num_steps_bob`` specifies trajectory length, ``symmetrize`` enables training two goal generators, and ``before_update_stale_regrets`` controls the episode to begin stale regret updates and ``stale_regret_coeff`` controls the weighting (beta) of the regret updates. For further arguments, see ``config/train.yaml``. 

Results will be logged in ``logdir/``.
