def exp2args_MDMM(_expname):
    expname = _expname.split('geonerfMDMM_')[1]
    other_args = ''
    if expname == 'ver0-adain':
        MDMM_ckpt = './weights/ithaca/01159.pth'

    elif expname == 'ver0-adain_bdd100kIthaca':
        MDMM_ckpt = './weights/bdd100k_ithaca/00259.pth'

    elif expname == 'ver0-adain_new':
        MDMM_ckpt = './weights/ithaca_new/00199.pth'

    elif expname == 'ver0-adain_content_level':
        MDMM_ckpt = './weights/ithaca_content_level/01199.pth'
        other_args += '--content_level'
    
    elif expname == 'ver0-adain_content_level_ithacaBDD100k':
        MDMM_ckpt = './weights/bdd100k_ithaca_content_level/00259.pth'
        other_args += '--content_level'
    
    elif expname == 'ver0-adain_content_level-waymo':
        MDMM_ckpt = './weights/waymo_content_level/01199.pth'
        other_args += '--content_level'
    
    elif expname == 'ver0-adain_content_level-ithacaSunnyNight-659':
        MDMM_ckpt = './weights/ithaca-sunnyNight_content_level/00659.pth'
        other_args += '--content_level'
    
    elif expname == 'ver0-adain_content_level-ithacaSunnyNight':
        MDMM_ckpt = './weights/ithaca-sunnyNight_content_level/01199.pth'
        other_args += '--content_level'

    if 'waymo' in expname:
        args = f'--resume {MDMM_ckpt} --num_domains 3 --pretrain_dataset waymo '
    elif 'ithacaSunnyNight' in expname:
        args = f'--resume {MDMM_ckpt} --num_domains 2 '
    else:
        args = f'--resume {MDMM_ckpt} --num_domains 5 '
    args += other_args

    return args

def exp2args_new(_expname):
    if 'Generalizable' in _expname:
        expname = _expname.split('Generalizable_')[1]
    else:
        expname = _expname.split('geonerfMDMM_')[1]
    if expname == 'ver0_upsample_onlyDTU' or expname == 'ver0': #是在dtu.py刪掉size/2之前train的
        args = ''
    
    elif expname == 'ver0_noDepth':
        args = '--wo_depth_gt_supervise'
    
    elif expname == 'ver0_casConfi': #是在dtu.py刪掉size/2之前train的
        args = '--cas_confi --extra_depth_loss'
    
    elif expname == 'ver0_upsample_onlyDTU_cycle_loss_lamb0p01': #是在dtu.py刪掉size/2之前train的
        args = '--cycle_loss --cycle_loss_lamb 0.01'
    
    elif expname == 'ver0_checkFeat-mode0': # use only level 2
        args = '--check_feat_mode 0'
    
    elif expname == 'ver0_checkFeat-mode1-load': # use the feature generate from another network (size=level2)
        args = '--check_feat_mode 1 --load_costreg'
    
    elif expname == 'ver0_checkFeat-mode2-load': # use the feature generate from another network (size=level2)
        args = '--check_feat_mode 2 --load_costreg'

    elif expname == 'separate_occ_feat': # use the feature generate from another network (size=level2)
        args = '--separate_occ_feat --load_costreg'

    elif expname == 'geneRGBsigma_farViewLoss_noD_addLoss':
        args = '--texFeat --renderer_geneRGBsigma --far_view_loss --renderer_geneRGBsigma_loss'
    
    elif expname == 'edge_loss_noD':
        args = '--edge_loss'
    
    elif expname == 'D':
        args = '--disocclude --geoFeatComplete v1'
    
    elif expname == 'casmvs':
        args = '--cas_confi --extra_depth_loss'

    elif expname == 'stage1':
        args = '--cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike --use_angle_cos --stage1 --use_tex_bias'
    
    elif expname == 'stage1-renderer-v2':
        args = '--cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike_v2 --stage1'
    
    elif expname == 'stage1-renderer-v2_noDepth':
        args = '--cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike_v2 --stage1 --wo_depth_gt_supervise'

    elif expname == 'stage1-renderer-v2-noLsmooth_noDepth':
        args = '--cas_confi --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike_v2 --stage1 --wo_depth_gt_supervise'

    elif expname == 'stage1-upperbound-gauss':
        args = '--upperbound --upperbound_gauss --cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike --use_angle_cos --stage1 --use_tex_bias'
    
    elif expname == 'stage1-v2': # use positional encoding dir_diff & weighted img_color, feature map to 3D space + tex_bias
        args = '--cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike --stage1 --tex_2Dto3D --use_tex_bias --use_angle_both'

    elif expname == 'stage1-v3': # rgb = weighted*img_color
        args = '--cas_confi --extra_depth_loss --texFeat_woUnet --disocclude --feat3dMask --renderer_mvslike --stage1 --weighted_rgb'

    else:
        raise ValueError(f"No expname (new): {expname} !!")

    return args

def exp2args(_expname):
    expname = _expname.split('Generalizable_')[1]
    if expname == 'ver0' or expname == 'try':
        args = ''
    
    elif expname == 'ver0_upsample_onlyDTU':
        args = '--downsample 2 --only_dtu'
    
    elif expname == 'ver0_upsample_onlyDTU_cycle_loss_lamb0p01':
        args = '--downsample 2 --only_dtu --cycle_loss --cycle_loss_lamb 0.01'
    
    elif expname == 'ver0_farViewLoss':
        args = '--far_view_loss'
    
    elif expname == 'ver0_checkFeat-mode0': # use only level 2
        args = '--check_feat_mode 0'
    
    elif expname == 'ver0_checkFeat-mode1': # use the feature generate from another network (size=level2)
        args = '--check_feat_mode 1'

    elif expname == 'ver1-k':
        args = '--disocclude --geoFeatComplete v1'
    
    elif expname == 'ver1-k-D01':
        args = '--disocclude --geoFeatComplete v1 --Deither0or1'

    elif expname == 'ver8': # consist3d-color-g
        args = '--disocclude --geoFeatComplete v1 --consistent3d_loss'

    elif expname == '3dc-g' or expname == '3dc-rgb': # still need comment
        args = '--disocclude --geoFeatComplete v1 --consistent3d_loss'
    
    elif expname == 'DTLoss-gradual':
        args = '--disocclude --geoFeatComplete v1 --DT_loss'

    elif expname == 'O_label':
        args = '--disocclude --geoFeatComplete v1 --O_label_loss'
    
    elif expname == 'P_constraint':
        args = '--disocclude --geoFeatComplete v1 --P_constraint'
    
    elif expname == 'unimvs':
        args = '--unimvs_loss'
    
    elif expname == '3dc-g_noD' or expname == '3dc-g-coord_noD' or expname == '3dc-rgb_noD' or expname == '3dc-g-rgb_noD': # still need comment
        args = '--consistent3d_loss'

    elif expname == 'O_label_01':
        args = '--disocclude --geoFeatComplete v1 --O_label_loss --O_label_01loss --O_label_loss_lamb 0.0001'
    
    elif expname == 'RGBresidual':
        args = '--disocclude --geoFeatComplete v1 --texFeat --texFeatComplete --renderer_RGBresidual'

    elif expname == 'D_gauss':
        args = '--disocclude --geoFeatComplete v1 --D_gauss'
    
    elif expname == 'D_onlyDTU':
        args = '--disocclude --geoFeatComplete v1 --only_dtu'
    
    elif expname == '3dc-g_density01_noD': # still need comment
        args = '--consistent3d_loss --density_01loss'
    
    elif expname == 'new2_3dc-g_density01_noD': # still need comment
        args = '--consistent3d_loss --density_01loss --only_dtu'
    
    elif expname == '3dc-coord_noD_onlyDTU' or expname == '3dc-g-rgb_noD_onlyDTU': # still need comment
        args = '--consistent3d_loss --only_dtu'
    
    elif expname == '3dc-g-rgb_noD_onlyDTU': # still need comment
        args = '--consistent3d_loss --only_dtu --consist3d_g_loss_lamb 0.001'

    elif expname == 'geneRGBsigma':
        args = '--disocclude --geoFeatComplete v1 --texFeat --texFeatComplete --renderer_geneRGBsigma'
    
    elif expname == 'geneRGBsigma_farViewLoss':
        args = '--disocclude --geoFeatComplete v1 --texFeat --texFeatComplete --renderer_geneRGBsigma --far_view_loss'

    elif expname == 'geneRGBsigma_farViewLoss_noD':
        args = '--texFeat --renderer_geneRGBsigma --far_view_loss'
    
    elif expname == 'geneRGBsigma_farViewLoss_noD_addLoss': # new2
        args = '--texFeat --renderer_geneRGBsigma --far_view_loss --renderer_geneRGBsigma_loss --only_dtu'
    
    elif expname == 'geneRGBsigma_att3d_farViewLoss_noD':
        args = '--texFeat --renderer_geneRGBsigma --far_view_loss --attention_3d'

    elif expname == 'geneRGBsigma_dist_farViewLoss_noD':
        args = '--texFeat --renderer_geneRGBsigma_dist --far_view_loss'

    elif expname == 'geneRGBsigma_dist_att3d_farViewLoss_noD':
        args = '--texFeat --renderer_geneRGBsigma_dist --far_view_loss --attention_3d'

    elif expname == 'cycle_loss_noD':
        args = '--cycle_loss'
    
    elif expname == 'cycle_loss_novel_depth_loss_noD':
        args = '--cycle_loss --novel_depth_loss'
    
    elif expname == 'cycle_loss_noD_onlyDTU':
        args = '--cycle_loss --only_dtu'
    
    elif expname == 'edge_loss_noD':
        args = '--edge_loss'
    
    elif expname == 'edge_loss':
        args = '--disocclude --geoFeatComplete v1 --edge_loss'
    
    elif expname == 'edge_loss_onlyDTU':
        args = '--disocclude --geoFeatComplete v1 --edge_loss --only_dtu'


    elif expname == 'wo-ver1-k-upperbound_trial02':
        args = ''

    elif expname == 'ver1-k-upperbound-fixbug':
        args = '--disocclude --geoFeatComplete v1 --upperbound'

    elif expname == 'upperbound-3dc':
        args = '--disocclude --geoFeatComplete v1 --upperbound --consistent3d_loss'

    elif expname == 'upperbound-3dc-g' or expname == 'upperbound-3dc-color': # still need comment
        args = '--disocclude --geoFeatComplete v1 --upperbound --consistent3d_loss'
    
    elif expname == 'upperbound-DTLoss-gradual':
        args = '--disocclude --geoFeatComplete v1 --upperbound --DT_loss'
    
    elif expname == 'upperbound-3dc_DTLoss-gradual':
        args = '--disocclude --geoFeatComplete v1 --upperbound --consistent3d_loss --DT_loss'
    
    elif expname == 'upperbound-P_constraint':
        args = '--disocclude --geoFeatComplete v1 --upperbound --P_constraint'
    
    elif expname == 'upperbound-O_label':
        args = '--disocclude --geoFeatComplete v1 --upperbound --O_label_loss'
    
    elif expname == 'upperbound-3dc-g_DTLoss-gradual_O-label': # still need comment
        args = '--disocclude --geoFeatComplete v1 --upperbound --consistent3d_loss --DT_loss --O_label_loss'
    
    elif expname == 'upperbound_noise':
        args = '--disocclude --geoFeatComplete v1 --upperbound --upperbound_noise'
    
    elif expname == 'upperbound_gauss':
        args = '--disocclude --geoFeatComplete v1 --upperbound --upperbound_gauss'

    elif expname == 'upperbound_noise_gauss' or expname == 'upperbound_noise_gauss-1': # still need comment
        args = '--disocclude --geoFeatComplete v1 --upperbound --upperbound_noise --upperbound_gauss'
    
    else:
        raise ValueError(f"No expname: {expname} !!")

    return args

def addArgs(expname):
    add_args = ''
    if 'LLFFdownsample' in expname:
        add_args += ' --llffdownsample 0.5'
    # if 'freeze' in expname:
    #     add_args += ' --freeze'
    if 'learn_3dfeat_from_GT' in expname:
        add_args += ' --learn_3dfeat_from_GT'
    
    if 'novelView' in expname:
        add_args += ' --train_vis_novel'
    
    if 'ithaca-twoCams' in expname:
        add_args += ' --ithaca_use_two_cams'
    
    if 'geonerfMDMM' in expname:
        add_args += ' --geonerfMDMM'
    
    if 'adaptiveStyleLoss' in expname:
        add_args += ' --adaptive_style_loss'
    
    if 'catDomain' in expname:
        add_args += ' --catDomain'
    
    if 'catStyle' in expname:
        add_args += ' --catStyle'
    
    if 'styleMLPcls' in expname:
        add_args += ' --styleMLP_cls'
    
    if 'styleLast' in expname:
        add_args += ' --styleLast'
    
    if 'patch' in expname:
        add_args += ' --train_patch'
    
    if 'vggLoss' in expname:
        add_args += ' --vgg_loss'
    
    if 'vggLoss-style' in expname:
        add_args += ' --vgg_loss  --vgg_loss_style'
    
    if 'patch_csLoss' in expname:
        add_args += ' --patch_cs_loss'
    
    if 'nerfDepTvLoss' in expname:
        add_args += ' --patch_nerf_depth_tvLoss'

    if 'NVSThenStyle' in expname:
        add_args += ' --NVSThenStyle'
    
    if 'adainNormalize' in expname:
        add_args += ' --adainNormalize'
    
    if 'style3Dfeat' in expname:
        add_args += ' --style3Dfeat'
    
    if 'inputWhole_csLoss' in expname:
        add_args += ' --inputWhole_cs_loss'
    
    if 'woStyleLoss' in expname:
        add_args += ' --wo_style_loss'
    
    if 'inputStyleLoss' in expname:
        add_args += ' --input_style_loss'
    
    if 'timephi' in expname:
        add_args += ' --timephi'
    
    if 'timephiLoss' in expname:
        add_args += ' --timephi --timephi_loss'
    
    if 'freezeExceptTimephi' in expname:
        add_args += ' --freezeExceptTimephi'
        add_args += ' --ckpt ./logs/train_new/geonerfMDMM_ver0-adain_content_level/ckpts/ckpt_step-023384.ckpt'
    
    if 'styleTwoBranch' in expname:
        add_args += ' --styleTwoBranch --timephi --wo_style_loss'
        if 'woZ' in expname:
            add_args += ' --wo_z'
        
        if 'zInputStyle' in expname:
            add_args += ' --zInputStyle'
            if 'zInputStyle_isInput' in expname:
                add_args += ' --zInputStyle_isInput'
                if 'sunnyNight' not in expname:
                    add_args += ' --src_specify sunny'

        if 'sigmoid' in expname:
            add_args += ' --phi_final_actv sigmoid'
        
        if 'fourier' in expname:
            add_args += ' --use_fourier_feature'
        
        if 'branch2NoPhi' in expname:
            add_args += ' --branch2_noPhi'
        
        if 'unparallExtract' in expname:
            add_args += ' --unparallExtract'
        
        if 'zDim16' in expname:
            add_args += ' --z_dim 16'
        
        if 'PEphi' in expname:
            add_args += ' --fourier_phi'
        
        if 'phiNoCosSin' in expname:
            add_args += ' --phi_noCosSin'
        
        if 'update_z' in expname:
            add_args += ' --update_z'
            add_args += ' --ckpt ./logs/train_new/geonerfMDMM_ver0-adain_content_level_styleTwoBranch-mse-woMSE1-sunnyNight-styleWaymo/ckpts/ckpt_step-032699.ckpt'
            add_args += ' --src_specify sunny'

        # loss
        if 'woMSE1' not in expname:
            add_args += ' --input_style_loss'
        if 'branch2cycle' in expname:
            add_args += ' --branch2_cycle_loss'

        if 'styleTwoBranch-v2' in expname:
            add_args += ' --style_D'
        elif 'styleTwoBranch-mse' in expname:
            add_args += ' --STB_style_mse_loss'
            if 'lamb1' in expname:
                add_args += ' --style_lamb 1.0'
        # elif 'styleTwoBranch-mdmm' in expname:
        #     add_args += ' --style_D_mdmm'
        else:
            add_args += ' --STB_style_loss'
        
        if 'mdmm' in expname:
            add_args += ' --style_D_mdmm'
        
        # model
        if 'modelV1' in expname:
            add_args += ' --styleTwoBranch_ver v1' # specialFeat to weight
        elif 'modelV2' in expname:
            add_args += ' --styleTwoBranch_ver v2' # both branch use common feature, weight use special feature
        else:
            add_args += ' --styleTwoBranch_ver v0' # directly add common and special feat output

    if 'styleOneBranch' in expname:
        add_args += ' --timephi --wo_style_loss'
        add_args += ' --input_style_loss'
        if 'add_z' in expname:
            add_args += ' --add_z'
        
        if 'zInputStyle' in expname:
            assert 'add_z' in expname
            add_args += ' --zInputStyle'
            if 'zInputStyle_isInput' in expname:
                add_args += ' --zInputStyle_isInput'
                if 'sunnyNight' not in expname:
                    add_args += ' --src_specify sunny'

    
    if 'weatherEmbedding' in expname:
        add_args += ' --weatherEmbedding'
    
    if 'weatherEncode' in expname:
        add_args += ' --weatherEncode'
    
    if 'weatherEncodeCls' in expname:
        add_args += ' --weatherEncodeCls'
    
    if 'styleWaymo' in expname:
        add_args += ' --style_dataset waymo'
    
    if 'sunnyNight' in expname:
        add_args += ' --src_specify sunny+night'
    
    if 'inputRec' in expname:
        add_args += ' --input_rec_loss'
    
    if 'noLoadCas' in expname:
        add_args += ' --noLoadCas'
    
    if 'noFreezeContent' in expname:
        add_args += ' --noFreezeContent'
    
    if 'contentPyramid' in expname:
        add_args += ' --contentPyramid'
    
    if 'contentFeature' in expname:
        add_args += ' --contentFeature'
        
        add_args += ' --content_level --num_domains 5'
        if 'resume' in expname:
            MDMM_ckpt = '.weight/ithaca_content_level/01199.pth'
            add_args += f' --resume {MDMM_ckpt}'
        else:
            add_args += ' --noFreezeContent'
    
    if 'delta_t' in expname:
        add_args += ' --delta_t'
        if 'delta_t_1x1' in expname:
            add_args += ' --delta_t_1x1'
    
    if 't0Rec' in expname:
        add_args += ' --t0_rec_loss'
    
    if 'zFuse' in expname:
        add_args += ' --z_zInputStyle_Fuse --z_dim 7'
        add_args += ' --delta_t --delta_t_1x1 --t0_rec_loss'
        add_args += ' --zInputStyle'
    
    if 't_reg' in expname:
        add_args += ' --t_regularization'
    
    if 'nightNoRemain' in expname:
        assert 'sunnyNight' not in expname
        add_args += ' --nightNoRemainCode'
        add_args += ' --src_specify sunny'
    
    if 'rgb2t' in expname:
        add_args += ' --rgb2t'

    return add_args


    