import matplotlib.pyplot as plt
import numpy as np
from matplotlib.ticker import ScalarFormatter
import math

time_out_time = 18000
time_out_time = 18000

def expandTOs(arr, exp_cnt):
	if not len(arr) <= exp_cnt:
		breakpoint()
	arr = arr + [time_out_time ]*(exp_cnt - len(arr))
	arr = np.array(arr)
	arr[arr > time_out_time] = time_out_time
	arr = list(arr)
	return arr

def get_success_count(list_a):
	return sum(np.array(list_a) < time_out_time)
#================================================================
#				    **** SAFETY DATA ****
#================================================================
#rerun for smp_10 for those still not finished

# Delay
dly_cnt = 16
s1_dly_grb_0 = expandTOs([0.17268896102905273, 0.04430389404296875, 0.03564739227294922, 0.036334991455078125, 0.03798341751098633, 0.03710579872131348, 0.0369875431060791, 0.03708052635192871, 0.03745269775390625, 0.036843061447143555, 0.03711295127868652, 0.03729605674743652, 0.037943363189697266, 0.03830981254577637, 0.03817319869995117, 0.03974080085754394], dly_cnt)
s1_dly_grb_10 = expandTOs([0.26514482498168945, 0.09734940528869629, 0.09857940673828125, 0.09841084480285645, 0.15425944328308105, 0.09846854209899902, 0.13390851020812988, 0.155991792678833, 0.09577441215515137, 0.09927654266357422, 0.1067051887512207, 0.13343048095703125, 0.14223265647888184, 0.14160847663879395, 0.1370084285736084, 0.13397884368896484], dly_cnt)
s1_dly_grb_25 = expandTOs([0.40781450271606445, 0.21071290969848633, 0.21043705940246582, 0.2105698585510254, 0.31488728523254395, 0.21200346946716309, 0.2975180149078369, 0.3248872756958008, 0.2115311622619629, 0.21857285499572754, 0.23066949844360352, 0.2969338893890381, 0.27980494499206543, 0.2909395694732666, 0.2890152931213379, 0.28771185874938965], dly_cnt)
s1_dly_grb_50 = expandTOs([0.5954623222351074, 0.4078519344329834, 0.41288161277770996, 0.4140439033508301, 0.617642879486084, 0.4157254695892334, 0.5274081230163574, 0.6147270202636719, 0.38858842849731445, 0.4168999195098877, 0.4544484615325928, 0.5274655818939209, 0.5276250839233398, 0.5374593734741211, 0.5381162166595459, 0.5339922904968262], dly_cnt)

s1_dly_z3= expandTOs([0.05431938171386719, 0.03334450721740723, 0.03310847282409668, 0.033294677734375, 0.0337526798248291, 0.032759904861450195, 0.032814741134643555, 0.032678842544555664, 0.032593727111816406, 0.03270435333251953, 0.03437495231628418, 0.03263092041015625, 0.03315544128417969, 0.03272271156311035, 0.0326993465423584, 0.03476285934448242], dly_cnt)
s1_dly_cvc5 = expandTOs([0.06545352935791016, 0.0397639274597168, 0.08708572387695312, 0.10277295112609863, 0.07936763763427734, 0.16608500480651855, 0.03759598731994629, 0.09087276458740234, 0.05953073501586914, 0.06159472465515137, 0.14153194427490234, 0.06702756881713867, 0.15351390838623047, 0.1069185733795166, 0.12424540519714355, 0.13045573234558105], dly_cnt)
s1_dly_msat = expandTOs([0.105743408203125, 9.01462435722351, 34.02068090438843, 139.91383481025696, 120.06518507003784, 630.1616806983948, 0.32013845443725586, 167.89128994941711, 254.28327798843384, 505.9969506263733, 3875.8681240081787, 184.56396913528442, 3909.807832956314, 5616.418485164642, 200.12052297592163, 250.44924902915955], dly_cnt)

s1_dly_grb_Learn = expandTOs([0.13139772415161133, 0.024141550064086914, 0.022542238235473633, 0.022748470306396484, 0.02347874641418457, 0.02336740493774414, 0.023461103439331055, 0.02339959144592285, 0.023518800735473633, 0.023345470428466797, 0.023496389389038086, 0.023814916610717773, 0.02411198616027832, 0.024199724197387695, 0.024074316024780273, 0.024994611740112305], dly_cnt)
s1_dly_nuRLin = expandTOs([0.12720942497253418, 0.040026187896728516, 0.039475440979003906, 0.04001140594482422, 0.03902864456176758, 0.039075613021850586, 0.03921627998352051, 0.0386958122253418, 0.0402836799621582, 0.041388750076293945, 0.0399324893951416, 0.03939652442932129, 0.039533138275146484, 0.03996920585632324, 0.03941154479980469], dly_cnt)


# Blink
blk_cnt = 25
s1_blk_grb_0 = expandTOs([0.4289381504058838, 0.43096351623535156, 0.3858518600463867, 0.47727322578430176, 0.3929271697998047, 0.42862868309020996, 0.3348691463470459, 0.5015549659729004, 0.5624203681945801, 0.3844642639160156, 0.4896526336669922, 0.3888232707977295, 0.3280467987060547, 0.4706432819366455, 0.5321571826934814, 0.3116919994354248, 0.523263692855835, 0.3511323928833008, 0.6412923336029053, 0.6456530094146729, 0.8199992179870605, 0.7243683338165283, 0.5314631462097168,  0.4935719966888428, 0.6704835891723633], blk_cnt)
s1_blk_grb_10 = expandTOs([0.8142297267913818, 0.641279935836792, 0.5673122406005859, 0.7626173496246338, 0.9210634231567383, 1.5925891399383545, 1.4853506088256836, 1.1746926307678223, 1.7278821468353271, 0.7296764850616455, 1.4845576286315918, 0.8830592632293701, 1.3944849967956543, 1.2987987995147705, 1.0784552097320557, 1.4432744979858398, 2.0098583698272705, 1.0597796440124512, 2.449502944946289, 2.086699962615967, 12.032084941864014], blk_cnt)
s1_blk_grb_25  = expandTOs([5.633308410644531, 2.09899640083313, 5.2708680629730225, 6.175920724868774, 2.9667437076568604, 4.085428714752197, 2.730436086654663, 4.500996828079224, 4.134687900543213, 4.614686727523804, 4.8355278968811035, 4.202957391738892, 4.723128318786621, 6.694967269897461, 8.839599609375, 5.339372158050537, 5.473330974578857, 21.35218334197998, 4.4577460289001465, 13.430376291275024, 22.033610582351685, 80.74839496612549, 538.9055893421173], blk_cnt)
s1_blk_grb_50 = expandTOs([4.2645440101623535, 14.90969443321228, 11.27249526977539, 2.402071475982666, 10.834929704666138, 2.741729974746704, 2.6994874477386475, 10.625266313552856, 7.098562479019165, 20.622370719909668, 38.42024207115173, 8.88111400604248, 10.317240953445435, 29.312896490097046, 21.057910442352295, 13.47481894493103, 12.188922643661499, 38.246488094329834, 12.14060354232788], blk_cnt)

s1_blk_z3= expandTOs([0.5229554176330566, 1.6762733459472656, 0.683574914932251, 0.45514941215515137, 0.5129878520965576, 0.41687774658203125, 0.6265425682067871, 0.13602757453918457, 1.2728867530822754, 0.3469350337982178, 100.53867387771606, 0.6043884754180908, 522.5874123573303, 1.0986201763153076, 1.0747649669647217, 1.4944453239440918, 0.2474205493927002, 1.9543747901916504, 0.8038501739501953, 2.7611711025238037, 1.252115249633789, 2.3262720108032227, 1.2442700862884521, 2.8588714599609375, 1.756213665008545], blk_cnt)
s1_blk_cvc5  = expandTOs([0.38745665550231934, 0.9343173503875732, 0.9661564826965332, 1.03328537940979, 1.061117172241211, 2.0443179607391357, 1.2017955780029297, 1.7518513202667236, 1.2912850379943848, 1.0388717651367188, 1.139674186706543, 0.9118051528930664, 1.159989356994629, 0.8936049938201904, 1.8222730159759521, 0.8420009613037109, 0.8612105846405029, 1.0568840503692627, 1.2037513256072998, 2.1338698863983154, 0.9345133304595947, 1.061589241027832, 1.1794054508209229, 1.543152093887329, 1.2663347721099854], blk_cnt)
s1_blk_msat  = expandTOs([0.27515649795532227, 0.14703726768493652, 0.12764930725097656, 0.25351476669311523, 0.1711430549621582, 0.14131927490234375, 0.22369956970214844, 20.988137245178223, 9.142311811447144, 24.42202353477478, 14.876574039459229, 14.522783279418945, 14.814801692962646, 14.824692249298096, 15.167099714279175, 15.083373308181763, 15.40175175666809, 15.353410482406616, 15.614787578582764, 15.695931434631348, 16.094264030456543, 15.724169731140137, 16.26513147354126, 16.239882230758667, 1.07920503616333], blk_cnt)

s1_blk_grb_Learn = expandTOs([0.22256088256835938, 0.2801532745361328, 0.2559773921966553, 0.33238649368286133, 0.2547426223754883, 0.29106950759887695, 0.2094569206237793, 0.3446509838104248, 0.40041422843933105, 0.24850678443908691, 0.357043981552124, 0.25646042823791504, 0.22452211380004883, 0.3234086036682129, 0.37366819381713867, 0.20106267929077148, 0.3672678470611572, 0.22398686408996582, 0.4554424285888672, 0.4622480869293213, 0.6263160705566406, 0.517754316329956, 0.3629913330078125, 0.31998610496520996, 0.47613286972045], blk_cnt)
s1_blk_nuRLin = expandTOs([], blk_cnt)

# GRAY
gry_cnt = 11
s1_gry_grb_0  = expandTOs([0.2778890132904053, 0.1587533950805664, 0.16796541213989258, 0.16057181358337402, 0.16588282585144043, 0.1623363494873047, 0.16821551322937012, 0.16235923767089844, 0.1736762523651123, 0.20023822784423828, 0.1725597381591797], gry_cnt)
s1_gry_grb_10 = expandTOs([0.6528761386871338, 0.5328412055969238, 0.5332505702972412, 0.5402839183807373, 0.5415916442871094, 0.6517324447631836, 0.5469977855682373, 0.5476181507110596, 0.5456733703613281, 0.6323766708374023, 0.6289558410644531], gry_cnt)
s1_gry_grb_25 = expandTOs([1.6280291080474854, 1.3341712951660156, 1.4341847896575928, 1.4488403797149658, 1.4079992771148682, 1.377014398574829, 1.4916505813598633, 1.305954933166504, 1.3675405979156494, 1.3466153144836426, 1.2622132301330566], gry_cnt)
s1_gry_grb_50 = expandTOs([2.3957033157348633, 2.3124074935913086, 2.607468605041504, 3.8334760665893555, 5.160614013671875, 3.036839008331299, 2.756624937057495, 2.8022100925445557, 3.412571907043457, 3.7132761478424072, 2.6758272647857666], gry_cnt)

s1_gry_z3= expandTOs([0.12969136238098145, 0.11489319801330566, 0.11445140838623047, 0.14129376411437988, 0.0929572582244873, 0.09294247627258301, 0.09445309638977051, 0.0895233154296875, 0.09596085548400879, 0.09594249725341797, 0.10055828094482422], gry_cnt)
s1_gry_cvc5 = expandTOs([0.7263870239257812, 1.5332286357879639, 0.3788583278656006, 1.6181864738464355, 2.9851064682006836, 1.150197982788086, 6.046432018280029, 4.57188606262207, 6.2555155754089355, 1.896620512008667, 5.872137069702148], gry_cnt)
s1_gry_msat = expandTOs([0.388063907623291, 1.5836482048034668, 1.1225166320800781, 0.9970760345458984, 102.40167784690857, 1411.7358496189117, 0.9584305286407471, 2.26181697845459], gry_cnt)

s1_gry_grb_Learn = expandTOs([0.07561707496643066, 0.09889054298400879, 0.10750460624694824, 0.09953093528747559, 0.10400962829589844, 0.09986758232116699, 0.10683751106262207, 0.09968423843383789, 0.1113131046295166, 0.1287379264831543, 0.10931658744812012], gry_cnt)
s1_gry_nuRLin = expandTOs([], gry_cnt)


# i2c
i2c_cnt  = 20
s1_i2c_grb_0  = expandTOs([1.7663791179656982, 105.87663531303406, 120.36131525039673, 242.4063959121704], i2c_cnt)
s1_i2c_grb_10  = expandTOs([1.0539135932922363], i2c_cnt)
s1_i2c_grb_25   = expandTOs([1.855292558670044], i2c_cnt)
s1_i2c_grb_50  = expandTOs([1.260540246963501], i2c_cnt)

s1_i2c_z3 = expandTOs([0.9496989250183105, 10.801752090454102, 14.736971616744995, 33.40475559234619, 34.33263826370239, 76.62571811676025, 55.06875562667847, 208.04584336280823, 42.94350838661194, 187.50965094566345, 65.81698799133301, 145.1418116092682, 122.85551834106445, 79.52372288703918, 74.4942672252655, 185.96975183486938, 69.27730107307434, 203.17440342903137, 158.45450806617737, 76.86599087715149], i2c_cnt)
s1_i2c_cvc5   = expandTOs([5.7913782596588135, 832.7346947193146, 546.1266918182373, 7743.112428426743, 2472.8794419765472, 2710.955483198166, 2603.3057730197906, 1527.3708119392395, 914.1162896156311, 33953.47161960602, 11974.916501522064], i2c_cnt)
s1_i2c_msat   = expandTOs([1.558436632156372, 18.509764194488525], i2c_cnt)

s1_i2c_grb_Learn  = expandTOs([1.0650458335876465, 104.2569932937622, 118.90071725845337, 240.4509522914886], i2c_cnt)
s1_i2c_nuRLin = expandTOs([], i2c_cnt)

# LCD 
lcd_cnt  = 14
s1_lcd_grb_0   = expandTOs([0.5128650665283203, 0.3264446258544922, 0.30274081230163574, 0.34117960929870605, 0.37061524391174316, 0.3987748622894287, 0.28803420066833496, 0.3069283962249756, 0.3363685607910156, 0.3691139221191406, 0.4713418483734131, 0.39830589294433594, 0.3104832172393799, 0.35863399505615234], lcd_cnt)
s1_lcd_grb_10  = expandTOs([0.5591740608215332, 0.4301786422729492, 0.4142794609069824, 0.38680028915405273, 0.501176118850708, 0.4945840835571289, 0.4718787670135498, 0.4877893924713135, 0.42258405685424805, 0.4093482494354248, 0.46154069900512695, 0.5289340019226074, 0.4675440788269043, 0.4864182472229004], lcd_cnt)
s1_lcd_grb_25  = expandTOs([0.6967508792877197, 0.4714052677154541, 0.49767184257507324, 0.5707440376281738, 0.5982351303100586, 0.5425155162811279, 0.5630478858947754, 0.5027749538421631, 0.7004873752593994, 0.639509916305542, 0.6433641910552979, 0.5765297412872314, 0.5855152606964111, 0.812666654586792], lcd_cnt)
s1_lcd_grb_50  = expandTOs([.1398193836212158, 0.8914196491241455, 0.8972277641296387, 0.7754333019256592, 0.8903815746307373, 1.0291855335235596, 0.8262054920196533, 0.8612360954284668, 0.9327054023742676, 0.8038904666900635, 1.00535249710083, 1.3447861671447754, 1.018113613128662, 1.0789473056793213], lcd_cnt)

s1_lcd_z3 = expandTOs([0.9701046943664551, 0.7870330810546875, 1.4369897842407227, 0.5500335693359375, 0.99131178855896, 0.7175164222717285, 2.4336869716644287, 1.18245267868042, 1.030297040939331, 1.5093388557434082, 1.5260677337646484, 6.789773941040039, 1.8189756870269775, 4.001905918121338], lcd_cnt)
s1_lcd_cvc5  = expandTOs([0.38016343116760254, 0.6217484474182129, 0.8710017204284668, 0.7103309631347656, 0.7557094097137451, 0.849647045135498, 0.5275700092315674, 0.8965797424316406, 1.2879400253295898, 0.6451675891876221, 0.9810481071472168, 1.5137817859649658, 30.496987104415894, 1.7158164978027344], lcd_cnt)
s1_lcd_msat  = expandTOs([0.6168410778045654, 11.047751903533936, 0.5659518241882324, 0.7615408897399902, 0.5799851417541504, 0.6885159015655518, 1.1355578899383545, 972.9911210536957, 0.8781378269195557, 1.2377300262451172], lcd_cnt)

s1_lcd_grb_Learn  = expandTOs([0.26780247688293457, 0.13474369049072266, 0.1061406135559082, 0.1437366008758545, 0.11431097984313965, 0.12199902534484863, 0.08139371871948242, 0.06852197647094727, 0.13226890563964844, 0.14828991889953613, 0.21050786972045898, 0.12022757530212402, 0.11464071273803711, 0.0937032699584961], lcd_cnt)
s1_lcd_nuRLin = expandTOs([0.47694849967956543, 0.32758641242980957, 0.3080110549926758, 0.33706140518188477, 0.3930683135986328, 0.4049837589263916, 0.2954704761505127, 0.3185269832611084, 0.34855079650878906, 0.3889145851135254, 0.46347951889038086, 0.41843366622924805, 0.32570672035217285, 0.3658905029296875], lcd_cnt)

# Load-Store 
ls_cnt  = 16
s1_ls_grb_0  = expandTOs([0.41113781929016113, 0.20228266716003418, 0.30730128288269043, 0.33927369117736816, 0.466963529586792, 0.283280611038208, 0.6322424411773682, 0.8400535583496094, 0.2710435390472412, 0.3637707233428955, 0.3351452350616455, 0.583369255065918, 0.23598146438598633, 0.6481983661651611, 0.32395505905151367, 0.5367641448974609], ls_cnt)
s1_ls_grb_10  = expandTOs([0.6560215950012207, 0.47260379791259766, 0.3649876117706299, 0.4680817127227783, 1.0177876949310303, 0.7306182384490967, 0.6606740951538086, 0.9589848518371582, 0.5306918621063232, 0.5778396129608154, 0.3988914489746094, 1.6173064708709717, 0.5673329830169678, 1.115894079208374, 0.47240638732910156, 0.7259788513183594], ls_cnt)
s1_ls_grb_25   = expandTOs([0.998161792755127, 0.621628999710083, 0.7655057907104492, 0.6921827793121338, 1.2829887866973877, 1.1464824676513672, 1.2444202899932861, 1.9555861949920654, 0.9210357666015625, 1.3584282398223877, 0.9928374290466309, 1.1252217292785645, 0.8435409069061279, 2.2234535217285156, 1.55072021484375, 1.11368727684021], ls_cnt)
s1_ls_grb_50  = expandTOs([2.1033432483673096, 1.1660716533660889, 2.0319948196411133, 3.0706675052642822, 6.768357515335083, 1.8570871353149414, 5.598160028457642, 2.6105804443359375, 5.580981016159058, 2.2974252700805664, 2.848021984100342, 4.183189630508423, 7.1477134227752686, 5.784935235977173, 5.732431173324585, 7.554817199707031], ls_cnt)

s1_ls_z3 = expandTOs([0.2856893539428711, 0.09616422653198242, 0.1530900001525879, 0.1964857578277588, 0.3890395164489746, 0.5094180107116699, 0.22140812873840332, 1.0128941535949707, 0.2803819179534912, 0.27340054512023926, 0.516089677810669, 0.2457735538482666, 0.3229401111602783, 0.308880090713501, 266.49850726127625, 0.17747950553894043], ls_cnt)
s1_ls_cvc5   = expandTOs([0.17299747467041016, 0.49274396896362305, 0.5129082202911377, 0.2591736316680908, 0.5423519611358643, 0.3887016773223877, 0.9312279224395752, 0.4487888813018799, 0.5286245346069336, 0.36281800270080566, 0.27694249153137207, 0.4693140983581543, 22.580435514450073, 0.9230098724365234, 1.7705965042114258, 0.8520758152008057], ls_cnt)
s1_ls_msat   = expandTOs([0.28145289421081543, 0.26311302185058594, 0.35183095932006836, 1.6657724380493164, 0.38613295555114746, 6.490973234176636, 13.529406309127808, 0.20012474060058594, 0.4381411075592041, 0.43016529083251953, 0.29384398460388184, 0.22382783889770508, 0.3086841106414795, 0.31076598167419434, 0.7313728332519531, 0.28119921684265137], ls_cnt)

s1_ls_grb_Learn  = expandTOs([0.2723977565765381, 0.12387228012084961, 0.20366311073303223, 0.21898102760314941, 0.3455338478088379, 0.19794964790344238, 0.4918982982635498, 0.656609058380127, 0.18235540390014648, 0.25105714797973633, 0.22505664825439453, 0.4532158374786377, 0.16519951820373535, 0.5101580619812012, 0.23662924766540527, 0.40699148178100586], ls_cnt)
s1_ls_nuRLin = expandTOs([0.385831356048584, 0.20476365089416504, 0.31664109230041504, 0.36767125129699707, 0.5245709419250488, 0.2997782230377197, 0.7231643199920654, 0.9334118366241455, 0.27675867080688477, 0.3834969997406006, 0.3739781379699707, 0.632312536239624, 0.24758386611938477, 0.702761173248291, 0.34444546699523926, 0.5946049690246582], ls_cnt)

# PWM
pwm_cnt  = 12
s1_pwm_grb_0   = expandTOs([0.1724989414215088, 0.04947328567504883, 0.04802656173706055, 0.04743242263793945, 0.04768729209899902, 0.04802346229553223, 0.04824352264404297, 0.048050642013549805, 0.048174381256103516, 0.048285484313964844, 0.0614778995513916, 0.048514366149902344], pwm_cnt)
s1_pwm_grb_10  = expandTOs([0.3112351894378662, 0.1871507167816162, 0.19052910804748535, 0.18823647499084473, 0.18790411949157715, 0.19416141510009766, 0.19375205039978027, 0.19226527214050293, 0.19165277481079102, 0.19427800178527832, 0.20833945274353027, 0.2058546543121338], pwm_cnt)
s1_pwm_grb_25  = expandTOs([0.5166680812835693, 0.37140464782714844, 0.3898019790649414, 0.38954806327819824, 0.39366722106933594, 0.39600133895874023, 0.3937187194824219, 0.4026672840118408, 0.4017801284790039, 0.39849066734313965, 0.41413259506225586, 0.42955994606018066], pwm_cnt)
s1_pwm_grb_50  = expandTOs([0.8827106952667236, 0.7236068248748779, 0.7428128719329834, 0.7483880519866943, 0.7555506229400635, 0.7683961391448975, 0.7695844173431396, 0.7754518985748291, 0.7782976627349854, 0.7786197662353516, 0.8303647041320801, 0.8510782718658447], pwm_cnt)

s1_pwm_z3 = expandTOs([0.0894918441772461, 0.05329012870788574, 0.05173921585083008, 0.05124068260192871, 0.05094194412231445, 0.05317568778991699, 0.052716970443725586, 0.05231070518493652, 0.05217313766479492, 0.05479574203491211, 0.05337715148925781, 0.05347776412963867], pwm_cnt)
s1_pwm_cvc5  = expandTOs([0.05489182472229004, 0.046933650970458984, 0.04818892478942871, 0.04938220977783203, 0.05905604362487793, 0.05160403251647949, 0.06406784057617188, 0.06518864631652832, 0.057627201080322266, 0.08099150657653809, 0.06804037094116211, 0.07378292083740234], pwm_cnt)
s1_pwm_msat  = expandTOs([0.07378625869750977, 0.03527426719665527, 0.032037973403930664, 0.040285587310791016, 0.042446136474609375, 0.03952145576477051, 0.03145790100097656, 0.035175323486328125, 0.030988454818725586, 0.03800702095031738, 0.04056429862976074, 0.046777963638305664], pwm_cnt)

s1_pwm_grb_Learn   = expandTOs([0.13427019119262695, 0.029741525650024414, 0.03084564208984375, 0.030816078186035156, 0.03078317642211914, 0.03066396713256836, 0.03098464012145996, 0.03111886978149414, 0.030931949615478516, 0.030933856964111328, 0.03968048095703125, 0.030605316162109375], pwm_cnt)
s1_pwm_nuRLin = expandTOs([0.13749337196350098, 0.048207998275756836, 0.04679107666015625, 0.04689598083496094, 0.04818010330200195, 0.04746365547180176, 0.04731035232543945, 0.0469973087310791, 0.047530412673950195, 0.04748988151550293, 0.0554966926574707, 0.049005985260009766], pwm_cnt)

# SevenSeg 
sg7_cnt  = 15
s1_sg7_grb_0  = expandTOs([1.0070040225982666, 0.38071131706237793, 0.8190011978149414, 0.8386368751525879, 0.4952545166015625, 0.9683458805084229, 0.49831604957580566, 0.5077483654022217, 1.374234676361084, 0.8911635875701904, 1.3282899856567383, 0.6289544105529785, 1.1846575736999512, 0.6811075210571289, 1.1774122714996338], sg7_cnt)
s1_sg7_grb_10  = expandTOs([1.7064545154571533, 9.43917179107666, 4.8697004318237305, 8.9337477684021, 1.1261382102966309, 2.4797894954681396, 4.685058116912842, 1.370802640914917, 6.114884376525879, 8.037878513336182, 1.6125810146331787, 1.7544918060302734, 2.1274237632751465, 1.9449303150177002, 2.7665414810180664], sg7_cnt)
s1_sg7_grb_25   = expandTOs([16.886929750442505, 9.96726679801941, 27.542906045913696, 15.450214624404907, 19.704182147979736, 2.5749385356903076, 15.570815324783325, 3.2789387702941895, 3.7036423683166504, 4.6635801792144775, 8.096070528030396, 4.688997507095337, 10.774210691452026, 3.040724277496338, 8.180161237716675], sg7_cnt)
s1_sg7_grb_50  = expandTOs([], sg7_cnt)

s1_sg7_z3 = expandTOs([0.6358983516693115, 1.2549564838409424, 1.4654896259307861, 1.0939500331878662, 1.3212761878967285, 3.76128888130188, 3.4928319454193115], sg7_cnt)
s1_sg7_cvc5   = expandTOs([23.091803789138794, 74.93615484237671, 26.89862322807312, 10.388944864273071, 334.7558288574219, 87.3740861415863, 50.63823866844177], sg7_cnt)
s1_sg7_msat   = expandTOs([25.69415807723999], sg7_cnt)

s1_sg7_grb_Learn  = expandTOs([0.6110501289367676, 0.2352449893951416, 0.5492875576019287, 0.555452823638916, 0.32378220558166504, 0.7034375667572021, 0.295734167098999, 0.32551097869873047, 1.0575342178344727, 0.6126594543457031, 0.9988110065460205, 0.4227015972137451, 0.8710556030273438, 0.46920084953308105, 0.8682868480682373], sg7_cnt)
s1_sg7_nuRLin = expandTOs([], sg7_cnt)

# Thermocouple
tmp_cnt  = 17
s1_tmp_grb_0   = expandTOs([1.6693527698516846, 1.1123542785644531, 0.8234281539916992, 1.6130638122558594, 1.03122878074646, 1.4721012115478516, 0.5413186550140381, 0.7644882202148438, 0.9840390682220459, 0.6656675338745117, 0.8764369487762451, 5.893537282943726, 1.8466308116912842, 3.2567319869995117, 1.3711540699005127, 1.8230266571044922, 2.313070297241211], tmp_cnt)
s1_tmp_grb_10  = expandTOs([3.0761067867279053, 2.0910465717315674, 4.066877841949463, 1.4503161907196045, 1.3704311847686768, 1.7637858390808105, 8.254964590072632, 6.190641403198242, 4.257655620574951, 7.27720308303833, 7.383955955505371, 5.684274673461914, 8.573264598846436, 6.260011672973633, 1.1159918308258057, 5.385552406311035, 3.630908012390136], tmp_cnt)
s1_tmp_grb_25  = expandTOs([9.404188871383667, 4.181030988693237, 10.008635997772217, 10.08122444152832, 7.710555553436279, 7.204033136367798, 5.7258453369140625, 21.28050470352173, 12.668777465820312, 13.836132049560547, 9.41230034828186, 3.677109479904175, 13.014742851257324, 11.16300106048584, 206.8965482711792, 38.839491844177246, 26.386736392974854], tmp_cnt)
s1_tmp_grb_50  = expandTOs([13.29617977142334, 9.165400981903076, 41.02032732963562, 46.617175579071045, 25.094029664993286, 13.738905906677246, 30.4468355178833, 44.79234313964844, 14.74702787399292, 32.76844310760498, 59.546141624450684, 19.08191752433777, 44.01500725746155, 67.6545615196228, 11.310271739959717], tmp_cnt)

s1_tmp_z3 = expandTOs([6.434302091598511, 18.122801303863525, 26.163043975830078, 24.163888216018677, 306.72803711891174, 52.00415086746216, 72.0266010761261, 87.26248478889465, 45.53060603141785, 228.06113386154175, 140.17817378044128, 74.54868650436401, 173.31624102592468, 316.58194494247437, 104.0023820400238, 665.1521790027618, 1320.7570307254791], tmp_cnt)
s1_tmp_cvc5  = expandTOs([68.25933456420898, 205.70622491836548, 416.20115637779236, 299.23251581192017, 144.0553388595581, 543.0443258285522, 218.73127102851868, 435.8713343143463, 519.3620619773865], tmp_cnt)
s1_tmp_msat  = expandTOs([3.8504281044006348, 24.411869287490845], tmp_cnt)

s1_tmp_grb_Learn  = expandTOs([1.26664137840271, 0.8465070724487305, 0.5603296756744385, 1.3615622520446777, 0.7283196449279785, 1.2286787033081055, 0.29065799713134766, 0.46867847442626953, 0.6726741790771484, 0.3874549865722656, 0.547126054763794, 5.479728698730469, 1.624284267425537, 2.907604694366455, 0.9918034076690674, 1.4919202327728271, 1.9284214973449707], tmp_cnt)
s1_tmp_nuRLin = expandTOs([], tmp_cnt)

# UART Transmit
utt_cnt  = 10
s1_utt_grb_0  = expandTOs([0.3119323253631592, 0.1388852596282959, 0.1126718521118164, 0.10954546928405762, 0.19684100151062012, 0.15983891487121582, 0.18270349502563477, 0.2550504207611084, 0.17252373695373535, 0.2524406909942627], utt_cnt)
s1_utt_grb_10  = expandTOs([0.34108781814575195, 0.2797672748565674, 0.20158958435058594, 0.2184593677520752, 0.1838703155517578, 0.2390282154083252, 0.19040679931640625, 0.1876537799835205, 0.2566993236541748, 0.48558521270751953], utt_cnt)
s1_utt_grb_25   = expandTOs([0.44922542572021484, 0.2787957191467285, 0.36338353157043457, 0.3741304874420166, 0.3492898941040039, 0.41904115676879883, 0.4740941524505615, 0.3629920482635498, 0.4198117256164551, 0.4109835624694824], utt_cnt)
s1_utt_grb_50  = expandTOs([0.7717034816741943, 0.6030514240264893, 0.5793566703796387, 0.6543660163879395, 0.7422513961791992, 0.7716162204742432, 0.7649037837982178, 0.6436173915863037, 1.0951716899871826, 0.9153151512145996], utt_cnt)

s1_utt_z3 = expandTOs([0.06870174407958984, 0.3390038013458252, 0.39347243309020996, 0.4030163288116455, 0.2925379276275635, 0.8278055191040039, 0.1243126392364502, 0.08635449409484863, 0.10373973846435547, 0.08738327026367188], utt_cnt)
s1_utt_cvc5   = expandTOs([0.502138614654541, 0.263232946395874, 0.12801337242126465, 0.13891100883483887, 0.13414835929870605, 0.19760560989379883, 0.14147257804870605, 0.1327064037322998, 0.14790940284729004, 0.14490652084350586], utt_cnt)
s1_utt_msat   = expandTOs([0.12753772735595703, 0.0999448299407959, 0.2820580005645752, 0.7865676879882812, 0.365175724029541, 0.45998191833496094], utt_cnt)

s1_utt_grb_Learn  = expandTOs([.22472834587097168, 0.08065915107727051, 0.06376361846923828, 0.06167316436767578, 0.12276124954223633, 0.09586048126220703, 0.11694121360778809, 0.13619470596313477, 0.1006467342376709, 0.1495201587677002], utt_cnt)
s1_utt_nuRLin = expandTOs([0.24849414825439453, 0.14696741104125977, 0.11671710014343262, 0.11112427711486816, 0.19961166381835938, 0.16465067863464355, 0.19576168060302734, 0.28318357467651367, 0.19591474533081055, 0.29374146461486816], utt_cnt)

# VGA
vga_cnt  = 10
s1_vga_grb_0  = expandTOs([0.47684359550476074, 0.3039548397064209, 0.41293954849243164, 0.3560950756072998, 0.36209559440612793, 0.502293586730957, 0.24692821502685547, 0.3391289710998535, 0.4585435390472412, 0.4727010726928711], vga_cnt)
s1_vga_grb_10  = expandTOs([0.4629969596862793, 0.296703577041626, 0.3612368106842041, 0.2980835437774658, 0.41996240615844727, 0.37917661666870117, 0.3079977035522461, 0.3647618293762207, 0.4437398910522461, 0.33918070793151855], vga_cnt)
s1_vga_grb_25   = expandTOs([0.6719486713409424, 0.5468547344207764, 0.7221903800964355, 0.5305850505828857, 0.6274809837341309, 0.7119145393371582, 0.5336403846740723, 0.6291792392730713, 0.6851987838745117, 0.5233442783355713], vga_cnt)
s1_vga_grb_50  = expandTOs([1.2207772731781006, 1.0201241970062256, 1.3116717338562012, 1.0318162441253662, 1.1170153617858887, 1.4030613899230957, 1.0551867485046387, 1.1410274505615234, 1.6089146137237549, 1.106457471847534], vga_cnt)

s1_vga_z3 = expandTOs([7.259249210357666, 65.11669301986694, 57.162312269210815, 27.896265268325806, 8721.621081352234, 16.31743597984314], vga_cnt)
s1_vga_cvc5   = expandTOs([22.42674994468689, 545.3949151039124, 17.363621711730957, 13547.332184791565, 25.143957138061523], vga_cnt)
s1_vga_msat   = expandTOs([3.1756632328033447, 29.406394004821777, 13.006518602371216, 68.9130117893219, 41.99494028091431, 17.503852605819702, 65.62688755989075, 220.82735800743103], vga_cnt)

s1_vga_grb_Learn  = expandTOs([0.31310319900512695, 0.1655712127685547, 0.21425890922546387, 0.17689871788024902, 0.18814802169799805, 0.25900697708129883, 0.12993192672729492, 0.17294836044311523, 0.15590476989746094, 0.2195425033569336], vga_cnt)
s1_vga_nuRLin = expandTOs([0.2519819736480713, 0.14780139923095703, 0.11790585517883301, 0.11302590370178223, 0.20403528213500977, 0.16955232620239258, 0.19597935676574707, 0.2854301929473877, 0.18563175201416016, 0.2753572463989258], vga_cnt)

# Delay
dly_cnt = 16
s2_dly_grb_0 = expandTOs([0.153350830078125, 0.05619001388549805, 0.03914070129394531, 0.039972543716430664, 0.040157318115234375, 0.0402073860168457, 0.03977155685424805, 0.039470672607421875, 0.0394139289855957, 0.04007411003112793, 0.039743661880493164, 0.03937029838562012, 0.039778709411621094, 0.04022359848022461, 0.040694475173950195, 0.040292978286743164], dly_cnt)
s2_dly_grb_10 = expandTOs([.2540552616119385, 0.11277413368225098, 0.11284708976745605, 0.11283493041992188, 0.14822769165039062, 0.11539363861083984, 0.13654017448425293, 0.1455070972442627, 0.11331391334533691, 0.11472678184509277, 0.1222386360168457, 0.1401987075805664, 0.13942527770996094, 0.1388850212097168, 0.1358482837677002, 0.14067697525024414], dly_cnt)
s2_dly_grb_25  = expandTOs([0.4324030876159668, 0.2417125701904297, 0.22391104698181152, 0.25622081756591797, 0.337726354598999, 0.2623021602630615, 0.3247833251953125, 0.36423420906066895, 0.22511577606201172, 0.24609947204589844, 0.2736837863922119, 0.3033447265625, 0.299572229385376, 0.300243616104126, 0.3048889636993408, 0.3075220584869385], dly_cnt)
s2_dly_grb_50 = expandTOs([0.6134347915649414, 0.37351417541503906, 0.37917590141296387, 0.38427090644836426, 0.576756477355957, 0.4414989948272705, 0.550405740737915, 0.6638696193695068, 0.3913888931274414, 0.42217493057250977, 0.4680213928222656, 0.5210034847259521, 0.523820161819458, 0.5315306186676025, 0.5235722064971924, 0.5249514579772949], dly_cnt)

s2_dly_z3= expandTOs([0.19560599327087402, 0.08053421974182129, 0.0817253589630127, 0.11275696754455566, 0.09194517135620117, 0.09920382499694824, 0.13184046745300293, 0.10003042221069336, 0.17734980583190918, 0.16985487937927246, 0.08544158935546875, 0.10535693168640137, 0.15291881561279297, 0.2071220874786377, 0.22539258003234863, 0.33124542236328125], dly_cnt)
s2_dly_cvc5  = expandTOs([0.10464715957641602, 0.0746455192565918, 0.0718543529510498, 0.1125032901763916, 0.12062931060791016, 0.12900280952453613, 0.08263111114501953, 0.12768983840942383, 0.14256000518798828, 0.15288686752319336, 0.2404160499572754, 0.13386273384094238, 0.16380715370178223, 0.20693397521972656, 0.18140602111816406, 0.24075555801391602], dly_cnt)
s2_dly_msat  = expandTOs([0.11601662635803223, 0.06822896003723145, 0.0633549690246582, 0.06838583946228027, 0.12119388580322266, 0.059258222579956055, 57.31882882118225, 0.1455390453338623, 0.05570030212402344, 0.05991387367248535, 0.05540919303894043, 1121.2021219730377, 0.33022093772888184, 0.06697368621826172, 0.06741642951965332, 0.06299066543579102], dly_cnt)

s2_dly_grb_Learn = expandTOs([0.11862540245056152, 0.0360865592956543, 0.025922536849975586, 0.026719093322753906, 0.026701688766479492, 0.02683091163635254, 0.026197195053100586, 0.026137113571166992, 0.0261380672454834, 0.026170969009399414, 0.02590465545654297, 0.025774717330932617, 0.025924205780029297, 0.026500463485717773, 0.02673482894897461, 0.026620149612426758], dly_cnt)
s2_dly_nuRLin = expandTOs([0.12399101257324219, 0.046553850173950195, 0.04108095169067383, 0.04114794731140137, 0.04103517532348633, 0.04094433784484863, 0.04107666015625, 0.04222536087036133, 0.041623592376708984, 0.04168534278869629, 0.04176688194274902, 0.041680335998535156, 0.04287910461425781, 0.04228639602661133, 0.042586326599121094, 0.042589664459228516], dly_cnt)

# LCD 
lcd_cnt  = 14
s2_lcd_grb_0   = expandTOs([0.3744475841522217, 0.6569976806640625, 1.0379955768585205, 0.7955536842346191, 0.5607647895812988, 1.3121490478515625, 0.6457509994506836, 1.2552368640899658, 1.0464251041412354, 1.0171985626220703, 0.9032928943634033, 1.0433743000030518, 0.7686617374420166, 0.9996068477630615], lcd_cnt)
s2_lcd_grb_10  = expandTOs([0.45855212211608887, 2.0369436740875244, 1.6991736888885498, 0.6823899745941162, 1.344029188156128, 1.4968836307525635, 0.9885094165802002, 1.3396074771881104, 1.4844152927398682, 0.850907564163208, 1.6920499801635742, 0.8064835071563721, 0.7801175117492676, 1.5545353889465332], lcd_cnt)
s2_lcd_grb_25  = expandTOs([0.7221052646636963, 5.619730472564697, 1.5022001266479492, 3.1346681118011475, 2.7727210521698, 2.6390163898468018, 1.3497893810272217, 2.8539159297943115, 3.512192487716675, 2.383587598800659, 1.526818037033081, 2.8299238681793213, 1.8094167709350586, 1.8869011402130127], lcd_cnt)
s2_lcd_grb_50  = expandTOs([0.9257256984710693, 2.1653287410736084, 3.2276782989501953, 2.043818473815918, 3.930274248123169, 4.16417384147644, 2.3268208503723145, 6.454309463500977, 12.511771440505981, 5.4273436069488525, 4.804975748062134, 4.552258253097534, 2.795029878616333, 2.4243698120117188], lcd_cnt)

s2_lcd_z3 = expandTOs([0.36649394035339355, 3.9965813159942627, 5.499258756637573, 7.863182306289673, 4.443525075912476, 10.735510110855103, 10.094292879104614, 35.554291009902954, 15.90503191947937, 50.6115779876709, 17.56399440765381, 37.362372636795044, 20.69506573677063, 279.4190511703491], lcd_cnt)
s2_lcd_cvc5  = expandTOs([0.4699711799621582, 40.074471950531006, 16.250685930252075, 54.015748739242554], lcd_cnt)
s2_lcd_msat  = expandTOs([0.27619481086730957, 10.433403015136719], lcd_cnt)

s2_lcd_grb_Learn  = expandTOs([0.17767930030822754, 0.3936307430267334, 0.6491725444793701, 0.4206423759460449, 0.26582813262939453, 0.9465279579162598, 0.29060864448547363, 0.8417568206787109, 0.7327580451965332, 0.6174511909484863, 0.524782657623291, 0.6705255508422852, 0.30856752395629883, 0.5729119777679443], lcd_cnt)
s2_lcd_nuRLin = expandTOs([], lcd_cnt)

# VGA
vga_cnt  = 10
s2_vga_grb_0  = expandTOs([0.39482593536376953, 0.2528114318847656, 0.23386526107788086, 0.1909198760986328, 0.3700594902038574, 0.22572565078735352, 0.2738068103790283, 0.3073461055755615, 0.4390859603881836, 0.4481022357940674], vga_cnt)
s2_vga_grb_10  = expandTOs([0.5886483192443848, 0.3724699020385742, 0.38568711280822754, 0.37032485008239746, 0.37946510314941406, 0.3863859176635742, 0.37798094749450684, 0.4046134948730469, 0.4567389488220215, 0.32613325119018555], vga_cnt)
s2_vga_grb_25   = expandTOs([0.7236206531524658, 0.5272705554962158, 0.7080998420715332, 0.6071720123291016, 0.5818612575531006, 0.6734626293182373, 0.5500900745391846, 0.6004655361175537, 0.6952228546142578, 0.5542416572570801], vga_cnt)
s2_vga_grb_50  = expandTOs([1.2503716945648193, 1.1032516956329346, 1.2428231239318848, 0.986872673034668, 1.1686575412750244, 1.3508145809173584, 1.0208556652069092, 1.2658674716949463, 1.2834713459014893, 1.09120273590087], vga_cnt)

s2_vga_z3 = expandTOs([19.83074975013733, 426.928040266037, 23.73414444923401, 610.9105324745178, 155.01579689979553, 11.343292474746704, 276.76409578323364, 39.43835997581482], vga_cnt)
s2_vga_cvc5   = expandTOs([49.7796540260315, 197.49417805671692, 24.59614062309265, 42.86223554611206, 94.32489132881165, 7.294045686721802, 5.897345542907715, 33.42148542404175, 58.19141101837158], vga_cnt)
s2_vga_msat   = expandTOs([2.7806577682495117, 38.28641223907471, 12.320468425750732, 5.742961883544922, 27.479154586791992, 12.65209436416626, 65.77598810195923, 13.357749462127686], vga_cnt)

s2_vga_grb_Learn  = expandTOs([0.2502284049987793, 0.1480553150177002, 0.12152957916259766, 0.11158347129821777, 0.21711134910583496, 0.13635897636413574, 0.15871763229370117, 0.18553590774536133, 0.21300625801086426, 0.21177148818969727], vga_cnt)
s2_vga_nuRLin = expandTOs([0.3550150394439697, 0.2513723373413086, 0.22853374481201172, 0.1913280487060547, 0.3770108222961426, 0.22873544692993164, 0.27897119522094727, 0.3111906051635742, 0.43951940536499023, 0.44438767433166504], vga_cnt)


#================================================================
#				  **** LIVENESS DATA ****
#================================================================

# Delay
l1_dly_cnt = 16
l1_dly_grb_0 = expandTOs([0.1820521354675293, 0.037711143493652344, 0.031456947326660156, 0.03102278709411621, 0.031060457229614258, 0.03165626525878906, 0.03174400329589844, 0.03126811981201172, 0.03186917304992676, 0.03231644630432129, 0.031545400619506836, 0.03229641914367676, 0.03207111358642578, 0.03223848342895508, 0.0326237678527832, 0.032662391662597656], dly_cnt)
l1_dly_grb_10 = expandTOs([0.2249441146850586, 0.10970425605773926, 0.11234283447265625, 0.11260032653808594, 0.16236329078674316, 0.11683058738708496, 0.14654278755187988, 0.15760445594787598, 0.10944652557373047, 0.1123969554901123, 0.1227419376373291, 0.1403491497039795, 0.13925576210021973, 0.14056897163391113, 0.1379408836364746, 0.13837885856628418], dly_cnt)
l1_dly_grb_25 = expandTOs([0.3447606563568115, 0.1905221939086914, 0.19255924224853516, 0.19665980339050293, 0.3086686134338379, 0.19682073593139648, 0.2647132873535156, 0.30565309524536133, 0.1791212558746338, 0.19875717163085938, 0.2249758243560791, 0.2663276195526123, 0.27327466011047363, 0.2725484371185303, 0.2749056816101074, 0.2725033760070801], dly_cnt)
l1_dly_grb_50 = expandTOs([0.6389570236206055, 0.41357994079589844, 0.4136638641357422, 0.42920756340026855, 0.6046440601348877, 0.422879695892334, 0.5243020057678223, 0.6080167293548584, 0.4024529457092285, 0.4255824089050293, 0.4696786403656006, 0.5303597450256348, 0.525609016418457, 0.5422728061676025, 0.5535271167755127, 0.5520319938659668], dly_cnt)

l1_dly_z3= expandTOs([0.0675203800201416, 0.07493925094604492, 0.07680630683898926, 0.09241104125976562, 0.0630645751953125, 0.16318988800048828, 0.11055827140808105, 0.06358194351196289, 0.08306336402893066, 0.0786445140838623, 0.07967710494995117, 0.10958242416381836, 0.05061626434326172, 0.04949355125427246, 0.11577486991882324, 0.08235979080200195], dly_cnt)
l1_dly_cvc5 = expandTOs([0.04503488540649414, 0.05319523811340332, 0.08492851257324219, 0.09458279609680176, 0.035614013671875, 0.04715275764465332, 0.04596590995788574, 0.09265470504760742, 0.08525657653808594, 0.07204151153564453, 0.08617615699768066, 0.03835105895996094, 0.04533791542053223, 0.04269838333129883, 0.07813119888305664, 0.0506436824798584], dly_cnt)
l1_dly_msat = expandTOs([0.10251593589782715, 0.04995417594909668, 0.050176143646240234, 0.0622258186340332, 0.05515146255493164, 0.0561680793762207, 0.13015055656433105, 0.05395841598510742, 0.0532381534576416, 0.08852887153625488, 0.054166555404663086, 0.07064199447631836, 0.06499791145324707, 0.04439592361450195, 0.04115724563598633, 0.03822517395019531], dly_cnt)

l1_dly_grb_Learn = expandTOs([0.14207768440246582, 0.018023252487182617, 0.018262147903442383, 0.017974853515625, 0.01799297332763672, 0.018125057220458984, 0.018100738525390625, 0.018012046813964844, 0.018165111541748047, 0.018604278564453125, 0.018164634704589844, 0.01847052574157715, 0.0183868408203125, 0.01834559440612793, 0.018503189086914062, 0.018718242645263672], dly_cnt)
l1_dly_nuRLin = expandTOs([0.11588644981384277, 0.0333409309387207, 0.03453993797302246, 0.03407931327819824, 0.032985687255859375, 0.032898664474487305, 0.033522605895996094, 0.03421354293823242, 0.033736228942871094, 0.033066511154174805, 0.03326416015625, 0.031975746154785156, 0.033455848693847656, 0.03229331970214844, 0.03293943405151367, 0.033092498779296875], dly_cnt)


# Blink
l1_blk_cnt = 25
l1_blk_grb_0 = expandTOs([0.9449403285980225, 0.9981272220611572, 1.666778564453125, 1.7056868076324463, 2.7824950218200684, 9.530980348587036, 8.320268630981445, 16.344488859176636, 4.3548877239227295, 7.665502548217773, 30.11214280128479, 72.0486855506897, 245.78235173225403, time_out_time, 19.513662815093994], blk_cnt)
l1_blk_grb_10 = expandTOs([2.971379518508911, 9.359848260879517, 6.0842132568359375, 19.93118119239807, 46.24408721923828, 65.03725290298462], blk_cnt)
l1_blk_grb_25  = expandTOs([21.018428564071655, 10.436352252960205, 25.67827796936035, 47.55005359649658, 30.553289651870728, 85.51157712936401, 75.65414571762085, 39.814409494400024, 28.74000072479248, 62.89865756034851], blk_cnt)
l1_blk_grb_50 = expandTOs([34.73712491989136, 34.70671558380127, 116.80104875564575, 113.64421582221985, 162.22160387039185, 109.86137318611145, 213.204833984375, 99.93101167678833, 64.81617379188538, 203.76654362678528], blk_cnt)

l1_blk_z3= expandTOs([0.605074405670166, 0.7505433559417725, 1.5307807922363281, 0.7693889141082764, 0.799645185470581, 0.5219449996948242, 0.7638871669769287, 1.8550825119018555, 51.153300523757935, 1.964850902557373, 4.89506721496582, 16.014256238937378, 1.2015745639801025, 1.36216139793396, 3163.236119031906, 2028.8466384410858, 3.888096570968628, 43.97060704231262, 1.4622905254364014, 1.5942859649658203, 2.286799192428589, 9.12118673324585, 424.23005080223083, 2.125354290008545, 598.3695340156555], blk_cnt)
l1_blk_cvc5  = expandTOs([1.7793152332305908, 4.20192289352417, 3.1007189750671387, 10.167939186096191, 6.888594150543213, 29.863789081573486, 34.97624063491821, 10.360777378082275, 14.47469973564148, 15.810864210128784, 103.0867645740509, 19.28823208808899, 100.48784565925598, 11.524068355560303, 10.557316303253174, 42.740559816360474, 46.20363211631775], blk_cnt)
l1_blk_msat  = expandTOs([0.4269134998321533, 0.1693711280822754, 0.23868441581726074, 0.2993130683898926, 0.1567401885986328, 0.26644468307495117, 0.28403449058532715, 0.44742465019226074, 0.293198823928833, 0.23822402954101562, 0.19608807563781738, 0.2540934085845947, 0.7676472663879395, 0.16109919548034668, 0.3735785484313965, 0.3046109676361084, 0.20757365226745605, 0.9791538715362549, 1.5407986640930176, 2.373432159423828, 0.7908952236175537, 0.1939692497253418, 1.1736464500427246, 1.9107894897460938, 1.8576793670654297], blk_cnt)

l1_blk_grb_Learn = expandTOs([0.726670503616333, 0.8227386474609375, 1.5211284160614014, 1.530421257019043, 2.5263237953186035, 9.19347596168518, 8.018087148666382, 15.83118748664856, 4.063840627670288, 7.374587774276733, 29.509313821792603, 71.42634606361389, 244.13323187828064, time_out_time, 19.16128373146057], blk_cnt)
l1_gry_nuRLin = expandTOs([], gry_cnt)

# GRAY
l1_gry_cnt = 11
l1_gry_grb_0  = expandTOs([0.7308735847473145, 0.3076820373535156, 1.0622432231903076, 0.37218189239501953, 0.8532602787017822, 0.9010670185089111, 6.59437108039856, 0.456073522567749, 1.2172880172729492, 1.058197259902954, 1.3764078617095947], gry_cnt)
l1_gry_grb_10 = expandTOs([1.2259230613708496, 15.759974956512451, 4.044828414916992, 12.683234453201294], gry_cnt)
l1_gry_grb_25 = expandTOs([4.68946385383606, 4.721182107925415, 26.134419918060303, 10.067949533462524, 31.715419054031372, 113.9338812828064, 26.4633686542511, 33.637027978897095, 16.534681797027588, 62.08327269554138, 371.91162633895874], gry_cnt)
l1_gry_grb_50 = expandTOs([.281952142715454, 25.43038558959961, 61.84803223609924, 63.678354263305664, 73.96324753761292, 108.38502216339111, 234.66286325454712, 62.5631787776947, 66.64297938346863, 89.43073654174805, 434.3767280578613], gry_cnt)

l1_gry_z3= expandTOs([0.48752856254577637, 0.4207289218902588, 0.7482116222381592, 0.849388599395752, 0.9038786888122559, 0.42840147018432617, 8.349837064743042, 2.7974236011505127, 7.476702928543091, 51.31633996963501, 22.187078952789307], gry_cnt)
l1_gry_cvc5 = expandTOs([0.12294483184814453, 0.4190495014190674, 2.883113384246826, 2.4738311767578125, 249.66261839866638, 412.4648299217224, 8.533027410507202, 730.2419049739838, 10.068075895309448, 100.07596445083618, 3.11806583404541], gry_cnt)
l1_gry_msat = expandTOs([0.5681557655334473, 0.5272731781005859, 0.19357705116271973, 0.10550832748413086, 0.10399174690246582, 0.10399818420410156, 0.10646772384643555, 0.07671356201171875, 0.0759587287902832, 0.07529592514038086, 0.07674050331115723], gry_cnt)

l1_gry_grb_Learn = expandTOs([0.4880847930908203, 0.2257692813873291, 0.9581942558288574, 0.28698062896728516, 0.7396552562713623, 0.788193941116333, 6.450157642364502, 0.3608219623565674, 1.0898659229278564, 0.9286034107208252, 1.2426557540893555], gry_cnt)
l1_blk_nuRLin = expandTOs([], blk_cnt)

# i2c
l1_i2c_cnt  = 20
l1_i2c_grb_0  = expandTOs([0.23960375785827637, 0.2344222068786621, 0.5024683475494385, 0.7664930820465088, 1.6159818172454834, 1.074380874633789, 1.0656342506408691, 0.38210272789001465, 1.7419791221618652, 1.1966755390167236, 1.9505040645599365, 0.7063443660736084, 0.5732753276824951, 0.1426374912261963, 0.6379601955413818, 0.22470617294311523, 1.0062706470489502, 0.6336245536804199, 0.21230435371398926, 0.2112429141998291], i2c_cnt)
l1_i2c_grb_10  = expandTOs([0.25373029708862305, 0.2366020679473877, 0.5378968715667725, 1.012631893157959, 0.8432273864746094, 0.9420580863952637, 0.2472679615020752, 2.2054765224456787, 1.46272611618042, 1.7965590953826904, 0.46028661727905273, 0.9218649864196777, 0.5155239105224609, 0.715705394744873, 0.44033288955688477, 0.5192739963531494, 0.34396910667419434, 0.1702284812927246, 0.6932930946350098, 0.4984891414642334], i2c_cnt)
l1_i2c_grb_25   = expandTOs([0.2545795440673828, 0.7132976055145264, 0.6864297389984131, 1.0300602912902832, 1.5232629776000977, 0.35651183128356934, 0.2973940372467041, 2.2374267578125, 4.977447509765625, 0.766559362411499, 1.8885478973388672, 1.6354198455810547, 1.223278284072876, 1.2210073471069336, 0.38106369972229004, 0.402069091796875, 0.9176955223083496, 6.03284478187561, 1.8018758296966553, 3.4302895069122314], i2c_cnt)
l1_i2c_grb_50  = expandTOs([0.33338236808776855, 0.8556265830993652, 0.8745415210723877, 1.3214802742004395, 1.2240662574768066, 0.8980200290679932, 2.3356716632843018, 1.7783489227294922, 1.2998840808868408, 1.9223759174346924, 3.4231629371643066, 2.6066203117370605, 5.2557337284088135, 0.9824385643005371, 1.8195343017578125, 4.78872013092041, 1.6600770950317383, 1.3418116569519043, 0.5885894298553467, 4.023035287857056], i2c_cnt)

l1_i2c_z3 = expandTOs([0.10334086418151855, 0.2791476249694824, 0.44686222076416016, 0.24894213676452637, 0.3271300792694092, 0.34871387481689453, 0.2312014102935791, 0.32761383056640625, 0.424591064453125, 0.2533884048461914, 0.18499374389648438, 0.295379638671875, 0.23354530334472656, 0.3878517150878906, 0.2894001007080078, 0.2607576847076416, 0.4626345634460449, 0.47385191917419434, 0.8339903354644775, 0.7151243686676025], i2c_cnt)
l1_i2c_cvc5   = expandTOs([0.11421036720275879, 0.24797677993774414, 0.317990779876709, 0.2573232650756836, 0.38706207275390625, 0.3539700508117676, 0.3285243511199951, 0.47359442710876465, 0.44658803939819336, 0.3963484764099121, 0.24909067153930664, 0.5150384902954102, 0.7050909996032715, 0.5399103164672852, 0.4105033874511719, 0.5463128089904785, 0.4095323085784912, 0.5755133628845215, 0.7439982891082764, 0.9802923202514648], i2c_cnt)
l1_i2c_msat   = expandTOs([0.15053510665893555, 0.15678763389587402, 0.20823931694030762, 0.24119091033935547, 0.23024225234985352, 0.2305920124053955, 0.17531204223632812, 0.2493915557861328, 0.3658101558685303, 0.18510913848876953, 0.18657732009887695, 0.3464224338531494, 0.2989630699157715, 0.3622274398803711, 0.42168188095092773, 0.44073486328125, 0.3071475028991699, 0.524982213973999, 0.5839276313781738, 0.42702174186706543], i2c_cnt)

l1_i2c_grb_Learn  = expandTOs([0.1679842472076416, 0.06022143363952637, 0.07096576690673828, 0.07393479347229004, 0.1790018081665039, 0.1431715488433838, 0.09098362922668457, 0.05719423294067383, 0.047553062438964844, 0.046888113021850586, 0.2193126678466797, 0.18880081176757812, 0.34987974166870117, 0.06687808036804199, 0.4408087730407715, 0.05002307891845703, 0.35040998458862305, 0.20804405212402344, 0.0814664363861084, 0.13709044456481934], i2c_cnt)
l1_i2c_nuRLin = expandTOs([0.16737055778503418, 0.24044132232666016, 0.5080084800720215, 0.7773902416229248, 1.630124807357788, 1.0851109027862549, 1.0851843357086182, 0.39199018478393555, 1.7585275173187256, 1.2010886669158936, 1.9833178520202637, 0.7360005378723145, 0.6174013614654541, 0.15785646438598633, 0.6515707969665527, 0.23308110237121582, 1.0420727729797363, 0.6508116722106934, 0.21386265754699707, 0.21194005012512207], i2c_cnt)

# LCD 
l1_lcd_cnt  = 14
l1_lcd_grb_0   = expandTOs([0.3565652370452881, 0.3065760135650635, 0.27588748931884766, 0.7420730590820312, 0.3283042907714844, 0.36271047592163086, 0.5228474140167236, 0.3989236354827881, 0.7657566070556641, 0.9376893043518066, 0.36278533935546875, 1.9138119220733643, 0.43732547760009766, 0.35239744186401367], lcd_cnt)
l1_lcd_grb_10  = expandTOs([0.4254302978515625, 0.3167917728424072, 0.42258143424987793, 0.4866623878479004, 0.4598679542541504, 0.5656614303588867, 0.28264737129211426, 1.1757071018218994, 0.4741084575653076, 0.29415225982666016, 0.8570008277893066, 1.615710735321045, 2.00868558883667, 4.1141369342803955], lcd_cnt)
l1_lcd_grb_25  = expandTOs([0.49950408935546875, 0.6030051708221436, 0.4220693111419678, 0.47278571128845215, 0.45554113388061523, 0.6427290439605713, 0.6904282569885254, 0.5696372985839844, 0.6330904960632324, 0.6389667987823486, 0.8703827857971191, 1.5811574459075928, 1.9697463512420654, 1.5564892292022705], lcd_cnt)
l1_lcd_grb_50  = expandTOs([0.8271486759185791, 0.7373147010803223, 0.7187323570251465, 0.8393740653991699, 0.76603102684021, 0.9840173721313477, 1.077451229095459, 0.9069433212280273, 2.597139358520508, 0.8525941371917725, 1.2677876949310303, 4.1522910594940186, 1.2114558219909668, 3.2051284313201904], lcd_cnt)

l1_lcd_z3 = expandTOs([0.17751622200012207, 0.14979219436645508, 0.16926026344299316, 0.14447641372680664, 0.1746203899383545, 0.2139730453491211, 0.14849519729614258, 0.18260669708251953, 0.20743608474731445, 0.18046259880065918, 0.17210650444030762, 0.18349123001098633, 0.18173718452453613, 0.1793012619018554], lcd_cnt)
l1_lcd_cvc5  = expandTOs([0.25632715225219727, 0.1975545883178711, 0.3676784038543701, 0.2917017936706543, 0.33887600898742676, 0.3382985591888428, 0.3488154411315918, 0.4226210117340088, 0.5124692916870117, 0.49979519844055176, 0.3963310718536377, 0.7107808589935303, 0.830970287322998, 0.5870246887207031], lcd_cnt)
l1_lcd_msat  = expandTOs([0.43224573135375977, 0.26493215560913086, 0.14310598373413086, 0.26288366317749023, 0.47023653984069824, 0.32144832611083984, 0.42575716972351074, 0.31472301483154297, 0.39081263542175293, 0.3163259029388428, 0.40137815475463867, 0.49103474617004395, 0.37707066535949707, 0.37892651557922363], lcd_cnt)

l1_lcd_grb_Learn   = expandTOs([0.14727497100830078, 0.06213974952697754, 0.03861832618713379, 0.03679800033569336, 0.062345266342163086, 0.0495452880859375, 0.05256342887878418, 0.050475358963012695, 0.060376644134521484, 0.04698371887207031, 0.047048330307006836, 0.05579042434692383, 0.07292437553405762, 0.04764580726623535], lcd_cnt)
l1_lcd_nuRLin = expandTOs([0.31187009811401367, 0.3140909671783447, 0.28568387031555176, 0.7593679428100586, 0.37121033668518066, 0.37495970726013184, 0.5300300121307373, 0.4059882164001465, 0.7774059772491455, 0.9497027397155762, 0.3745756149291992, 1.9331865310668945, 0.4455265998840332, 0.36534762382507324], lcd_cnt)

# Load-Store 
l1_ls_cnt  = 16
l1_ls_grb_0  = expandTOs([], ls_cnt)
l1_ls_grb_10  = expandTOs([210.0039138793945, 1076.202086687088], ls_cnt)
l1_ls_grb_25   = expandTOs([1433.417522907257], ls_cnt)
l1_ls_grb_50  = expandTOs([], ls_cnt)

l1_ls_z3 = expandTOs([18.585850477218628, 41.562108516693115, 76.37201881408691, 67.99269938468933, 124.9456136226654, 212.74164938926697, 201.5614562034607, 87.75405287742615, 161.90435457229614, 293.92411375045776, 287.3485791683197, 529.7024788856506, 588.7121176719666, 375.71269369125366], ls_cnt)
l1_ls_cvc5   = expandTOs([291.44459795951843, 466.186311006546, 1946.533459186554, 422.9385268688202, 1059.3929505348206, 2274.55744099617, 3161.125015258789, 2689.049283027649, 12602.626794576645], ls_cnt)
l1_ls_msat   = expandTOs([2.2449798583984375], ls_cnt)

l1_ls_grb_Learn  = expandTOs([], ls_cnt)
l1_ls_nuRLin = expandTOs([], ls_cnt)

# PWM
l1_pwm_cnt  = 12
l1_pwm_grb_0   = expandTOs([0.1843869686126709, 0.03134727478027344, 0.026205778121948242, 0.02596426010131836, 0.026117563247680664, 0.024770736694335938, 0.025197744369506836, 0.025294065475463867, 0.02504873275756836, 0.025536060333251953, 0.02568960189819336, 0.0251557826995849], pwm_cnt)
l1_pwm_grb_10  = expandTOs([0.1969432830810547, 0.10617280006408691, 0.10804462432861328, 0.10879325866699219, 0.10821747779846191, 0.11069488525390625, 0.11056160926818848, 0.10984134674072266, 0.1094357967376709, 0.11097478866577148, 0.11335182189941406, 0.11224198341369629], pwm_cnt)
l1_pwm_grb_25  = expandTOs([.3035106658935547, 0.2068631649017334, 0.20984220504760742, 0.19925928115844727, 0.1983187198638916, 0.19832134246826172, 0.19847822189331055, 0.1945347785949707, 0.2075214385986328, 0.20805597305297852, 0.20947575569152832, 0.20880913734436035], pwm_cnt)
l1_pwm_grb_50  = expandTOs([0.598461389541626, 0.43035244941711426, 0.4397876262664795, 0.4451305866241455, 0.4342319965362549, 0.43355870246887207, 0.43491697311401367, 0.4344615936279297, 0.4375741481781006, 0.43816614151000977, 0.4389166831970215, 0.4408903121948242], pwm_cnt)

l1_pwm_z3 = expandTOs([0.043961286544799805, 0.023224353790283203, 0.022873640060424805, 0.02313518524169922, 0.02234959602355957, 0.022400617599487305, 0.02250385284423828, 0.022896289825439453, 0.023934125900268555, 0.02332162857055664, 0.0235898494720459, 0.023977994918823242], pwm_cnt)
l1_pwm_cvc5  = expandTOs([0.04235982894897461, 0.015398263931274414, 0.0162351131439209, 0.015865087509155273, 0.01597428321838379, 0.016101837158203125, 0.015626907348632812, 0.01648712158203125, 0.016888141632080078, 0.016574859619140625, 0.016649484634399414, 0.01691579818725586], pwm_cnt)
l1_pwm_msat  = expandTOs([0.046692609786987305, 0.016663551330566406, 0.015801429748535156, 0.01618051528930664, 0.016057491302490234, 0.01628708839416504, 0.016021251678466797, 0.01597309112548828, 0.016359567642211914, 0.018007516860961914, 0.015479803085327148, 0.015200376510620117], pwm_cnt)

l1_pwm_grb_Learn   = expandTOs([0.14217257499694824, 0.014050483703613281, 0.0138702392578125, 0.013655900955200195, 0.013876914978027344, 0.013192892074584961, 0.013365983963012695, 0.013468027114868164, 0.013193130493164062, 0.013404607772827148, 0.013234615325927734, 0.013362884521484375], pwm_cnt)
l1_pwm_nuRLin = expandTOs([0.11696052551269531, 0.02665114402770996, 0.025511741638183594, 0.025599956512451172, 0.025943279266357422, 0.025754690170288086, 0.025829076766967773, 0.025763511657714844, 0.025660276412963867, 0.026302099227905273, 0.026874780654907227, 0.026729106903076172], pwm_cnt)

# SevenSeg 
l1_sg7_cnt  = 15
l1_sg7_grb_0  = expandTOs([0.2293562889099121, 0.13264679908752441, 0.19655466079711914, 0.16145873069763184, 0.36763834953308105, 0.37853050231933594, 0.9606165885925293, 0.5487508773803711, 1.2532978057861328, 1.6010489463806152, 0.42777132987976074, 0.8720571994781494, 0.23895812034606934, 0.20140457153320312, 1.7664299011230469], sg7_cnt)
l1_sg7_grb_10  = expandTOs([0.29386353492736816, 0.27051734924316406, 0.19607758522033691, 0.292999267578125, 0.4194912910461426, 0.3902435302734375, 0.425494909286499, 0.32167863845825195, 0.9031312465667725, 0.8572165966033936, 0.3988933563232422, 0.4908473491668701, 1.837975025177002, 4.242172479629517, 0.40991854667663574], sg7_cnt)
l1_sg7_grb_25   = expandTOs([0.4045445919036865, 0.3211522102355957, 0.2906820774078369, 0.4927396774291992, 0.5175516605377197, 0.7106094360351562, 1.1440532207489014, 0.44634151458740234, 1.75227952003479, 0.5722928047180176, 0.43555212020874023, 0.6093850135803223, 0.9559941291809082, 2.073519229888916, 0.30536580085754395], sg7_cnt)
l1_sg7_grb_50  = expandTOs([0.5680384635925293, 0.46506237983703613, 0.4102182388305664, 0.6401863098144531, 0.6365840435028076, 1.1925749778747559, 1.4433913230895996, 0.7278604507446289, 1.4727039337158203, 4.181339502334595, 1.080441951751709, 1.7708570957183838, 2.4274892807006836, 0.7949256896972656, 0.8026142120361328], sg7_cnt)

l1_sg7_z3 = expandTOs([0.07173323631286621, 0.0514070987701416, 0.03882265090942383, 0.03862190246582031, 0.038614511489868164, 0.038818359375, 0.03993701934814453, 0.04158449172973633, 0.0397791862487793, 0.03928494453430176, 0.04005289077758789, 0.04024243354797363, 0.040366411209106445, 0.040380239486694336, 0.04066133499145508], sg7_cnt)
l1_sg7_cvc5   = expandTOs([0.06704330444335938, 0.03173565864562988, 0.029827594757080078, 0.030861377716064453, 0.030542612075805664, 0.030631065368652344, 0.03209686279296875, 0.03141522407531738, 0.03147077560424805, 0.03128314018249512, 0.03204679489135742, 0.03865551948547363, 0.031510114669799805, 0.03281283378601074, 0.032058000564575195], sg7_cnt)
l1_sg7_msat   = expandTOs([0.07133841514587402, 0.055572509765625, 0.04339146614074707, 0.039971113204956055, 0.03818821907043457, 0.03963160514831543, 0.03889346122741699, 0.03390955924987793, 0.035552024841308594, 0.04563713073730469, 0.039087772369384766, 0.043621063232421875, 0.03680086135864258, 0.04580998420715332, 0.04313993453979492], sg7_cnt)

l1_sg7_grb_Learn  = expandTOs([0.14255642890930176, 0.040637969970703125, 0.050640106201171875, 0.027811765670776367, 0.04985308647155762, 0.05171394348144531, 0.03564143180847168, 0.03464937210083008, 0.03570818901062012, 0.03524947166442871, 0.03647017478942871, 0.026998281478881836, 0.04595017433166504, 0.04779863357543945, 0.0290679931640625], sg7_cnt)
l1_sg7_nuRLin = expandTOs([0.17786288261413574, 0.13507938385009766, 0.20068979263305664, 0.16446709632873535, 0.371584415435791, 0.3843691349029541, 0.9731857776641846, 0.5526218414306641, 1.2612051963806152, 1.6041102409362793, 0.43308115005493164, 0.8818380832672119, 0.24434208869934082, 0.20656776428222656, 1.7726540565490723], sg7_cnt)


# Thermocouple
l1_tmp_cnt  = 17
l1_tmp_grb_0   = expandTOs([0.2225971221923828, 0.076995849609375, 0.06920886039733887, 0.0680382251739502, 0.06851458549499512, 0.07269072532653809, 0.07240653038024902, 0.06174039840698242, 0.07313179969787598, 0.07404160499572754, 0.07093286514282227, 0.07039022445678711, 0.06328701972961426, 0.07461762428283691, 0.07545971870422363, 0.06410598754882812, 0.07559442520141602], tmp_cnt)
l1_tmp_grb_10  = expandTOs([0.22548127174377441, 0.10257720947265625, 0.10465574264526367, 0.10438251495361328, 0.10458040237426758, 0.10464239120483398, 0.10475945472717285, 0.11013150215148926, 0.10660791397094727, 0.10722994804382324, 0.10855388641357422, 0.11198782920837402, 0.1129307746887207, 0.1069803237915039, 0.10745930671691895, 0.10785436630249023, 0.10945582389831543], tmp_cnt)
l1_tmp_grb_25  = expandTOs([0.2644045352935791, 0.17329859733581543, 0.1782228946685791, 0.21589922904968262, 0.17740821838378906, 0.21664881706237793, 0.17818093299865723, 0.20051813125610352, 0.20765352249145508, 0.20284032821655273, 0.22812390327453613, 0.21761775016784668, 0.20162749290466309, 0.1941211223602295, 0.19243788719177246, 0.19572782516479492, 0.19744277000427246], tmp_cnt)
l1_tmp_grb_50  = expandTOs([0.37338995933532715, 0.31206822395324707, 0.2905292510986328, 0.3666708469390869, 0.3028984069824219, 0.37671661376953125, 0.3049581050872803, 0.3728978633880615, 0.3453857898712158, 0.3131120204925537, 0.4472672939300537, 0.3907344341278076, 0.31836819648742676, 0.3182029724121094, 0.32450294494628906, 0.3230438232421875, 0.32487988471984863], tmp_cnt)

l1_tmp_z3 = expandTOs([0.11133956909179688, 0.12060165405273438, 0.17333412170410156, 0.14392566680908203, 0.15807843208312988, 0.2482597827911377, 0.16868376731872559, 0.21827411651611328, 0.2660377025604248, 0.23418474197387695, 0.12241077423095703, 0.24097418785095215, 0.22076177597045898, 0.29099583625793457, 0.31901979446411133, 0.3333864212036133, 0.384141206741333], tmp_cnt)
l1_tmp_cvc5  = expandTOs([0.08407807350158691, 0.14784693717956543, 0.07864189147949219, 0.24935030937194824, 0.08690547943115234, 0.22310566902160645, 0.14376330375671387, 0.2904205322265625, 0.5672907829284668, 0.39531946182250977, 0.2756807804107666, 0.22347688674926758, 0.11468791961669922, 0.23048949241638184, 0.13492751121520996, 0.1365509033203125, 1.0612609386444092], tmp_cnt)
l1_tmp_msat  = expandTOs([0.1026604175567627, 0.09064507484436035, 0.08361577987670898, 0.08712220191955566, 0.0872650146484375, 0.08339905738830566, 0.1325223445892334, 0.06584596633911133, 0.08432412147521973, 0.15649056434631348, 0.06105399131774902, 0.17322516441345215, 0.15901470184326172, 0.15410947799682617, 0.13006234169006348, 0.10446047782897949, 0.13907694816589355], tmp_cnt)

l1_tmp_grb_Learn  = expandTOs([0.15753746032714844, 0.038526058197021484, 0.03761577606201172, 0.03615212440490723, 0.03722262382507324, 0.03954267501831055, 0.03963828086853027, 0.03214073181152344, 0.03946542739868164, 0.03945660591125488, 0.03777289390563965, 0.03677988052368164, 0.0316159725189209, 0.039624691009521484, 0.03964543342590332, 0.03200340270996094, 0.03941750526428223], tmp_cnt)
l1_tmp_nuRLin = expandTOs([0.16865038871765137, 0.08428812026977539, 0.07246112823486328, 0.07220005989074707, 0.07268977165222168, 0.07370948791503906, 0.07509946823120117, 0.06285572052001953, 0.07411074638366699, 0.07494354248046875, 0.0735318660736084, 0.07366490364074707, 0.0646514892578125, 0.07605504989624023, 0.07895541191101074, 0.06605815887451172, 0.0756831169128418], tmp_cnt)

# UART Transmit
l1_utt_cnt  = 10
l1_utt_grb_0  = expandTOs([0.23276019096374512, 0.17168974876403809, 0.18857502937316895, 0.1976454257965088, 0.4787912368774414, 0.7879183292388916, 1.8245019912719727, 0.27731990814208984, 0.23956751823425293, 0.26810359954833984], utt_cnt)
l1_utt_grb_10  = expandTOs([0.252657413482666, 0.20743131637573242, 0.38833045959472656, 0.34663915634155273, 1.152472734451294, 1.9129083156585693, 0.21794700622558594, 0.363828182220459, 1.1769413948059082, 0.30466198921203613], utt_cnt)
l1_utt_grb_25   = expandTOs([0.2856876850128174, 0.2802410125732422, 0.24480509757995605, 0.4971191883087158, 0.5704450607299805, 0.3966693878173828, 0.349773645401001, 0.28675341606140137, 0.5650825500488281, 0.3025684356689453], utt_cnt)
l1_utt_grb_50  = expandTOs([0.4550039768218994, 0.4532599449157715, 0.5892469882965088, 0.4389677047729492, 0.5206282138824463, 0.6179625988006592, 0.5019729137420654, 0.7044744491577148, 1.826988697052002, 1.181203842163086], utt_cnt)

l1_utt_z3 = expandTOs([0.13921499252319336, 0.08929681777954102, 0.19696927070617676, 0.1519792079925537, 0.0946805477142334, 0.15805363655090332, 0.32793211936950684, 0.09186053276062012, 0.1303701400756836, 0.1417694091796875], utt_cnt)
l1_utt_cvc5   = expandTOs([0.255079984664917, 0.2713637351989746, 0.18534445762634277, 0.40097618103027344, 0.531832218170166, 1.1139209270477295, 0.7402021884918213, 0.9265480041503906, 0.2194843292236328, 1.1352262496948242], utt_cnt)
l1_utt_msat   = expandTOs([0.13796567916870117, 0.12392449378967285, 0.07963037490844727, 0.06771516799926758, 0.10465860366821289, 0.07648682594299316, 0.1205136775970459, 0.09725141525268555, 0.11028504371643066, 0.0812842845916748], utt_cnt)

l1_utt_grb_Learn  = expandTOs([0.16708827018737793, 0.1070868968963623, 0.08307218551635742, 0.1358325481414795, 0.10521411895751953, 0.10219001770019531, 0.06473994255065918, 0.15491437911987305, 0.14313697814941406, 0.17317700386047363], utt_cnt)
l1_utt_nuRLin = expandTOs([0.1856553554534912, 0.18337583541870117, 0.20201539993286133, 0.21711492538452148, 0.5007882118225098, 0.804732084274292, 1.8336544036865234, 0.29688119888305664, 0.24251961708068848, 0.2903616428375244], utt_cnt)

# VGA
l1_vga_cnt  = 10
l1_vga_grb_0  = expandTOs([0.24695873260498047, 0.10921978950500488, 0.11446380615234375, 0.15965533256530762, 0.11236214637756348, 0.1210944652557373, 0.22419166564941406, 0.10716795921325684, 0.10934782028198242, 0.11361265182495117], vga_cnt)
l1_vga_grb_10  = expandTOs([0.26020336151123047, 0.17949867248535156, 0.2008357048034668, 0.2350630760192871, 0.14764142036437988, 0.20648527145385742, 0.2361607551574707, 0.20370173454284668, 0.2638125419616699, 0.23296546936035156], vga_cnt)
l1_vga_grb_25   = expandTOs([0.3080587387084961, 0.29291462898254395, 0.3427419662475586, 0.31139326095581055, 0.2878131866455078, 0.34531092643737793, 0.2971475124359131, 0.2371065616607666, 0.35677146911621094, 0.3117218017578125], vga_cnt)
l1_vga_grb_50  = expandTOs([0.542083740234375, 0.48343348503112793, 0.5431022644042969, 0.5552921295166016, 0.47089195251464844, 0.5821876525878906, 0.4816396236419678, 0.3779318332672119, 0.45195984840393066, 0.42711877822875977], vga_cnt)

l1_vga_z3 = expandTOs([0.3425028324127197, 0.13650250434875488, 8.6928870677948, 0.21461081504821777, 0.27110767364501953, 36.673346757888794, 1.7841427326202393, 22.406694889068604, 38.12300515174866, 24.923916339874268], vga_cnt)
l1_vga_cvc5   = expandTOs([0.32865333557128906, 0.8644769191741943, 2.4737956523895264, 0.6420044898986816, 0.7795748710632324, 4.134234428405762, 3.893470525741577, 31.76741123199463, 6.2393639087677, 1.9027175903320312], vga_cnt)
l1_vga_msat   = expandTOs([0.605966329574585, 0.5019268989562988, 12.831369400024414, 3.16276216506958, 0.4623706340789795, 17.570775032043457, 36.55685496330261, 95.79778385162354, 72.42210483551025, 291.26462149620056], vga_cnt)

l1_vga_grb_Learn  = expandTOs([0.16725587844848633, 0.05711627006530762, 0.06391716003417969, 0.06635737419128418, 0.06357216835021973, 0.06621384620666504, 0.0639491081237793, 0.059337615966796875, 0.0592348575592041, 0.0583345890045166], vga_cnt)
l1_vga_nuRLin = expandTOs([0.1906590461730957, 0.11314058303833008, 0.12200474739074707, 0.16602540016174316, 0.11653876304626465, 0.12760567665100098, 0.23088407516479492, 0.11056685447692871, 0.11414718627929688, 0.11742115020751953], vga_cnt)

# Delay 2
l2_dly_cnt = 16
l2_dly_grb_0 = expandTOs([0.18658137321472168, 0.040488481521606445, 0.04027557373046875, 0.0404055118560791, 0.04105997085571289, 0.040448665618896484, 0.041391849517822266, 0.04105782508850098, 0.04082846641540527, 0.04126906394958496, 0.04246807098388672, 0.041217803955078125, 0.0426332950592041, 0.1909177303314209, 0.20612263679504395, 0.06028127670288086], dly_cnt)
l2_dly_grb_10 = expandTOs([0.24680256843566895, 0.10258674621582031, 0.14888906478881836, 0.1051321029663086, 0.5120828151702881, 0.10762858390808105, 0.41583991050720215, 0.45500802993774414, 0.10473775863647461, 0.10620236396789551, 0.11445116996765137, 0.24397993087768555, 0.18019914627075195, 0.15307927131652832, 0.17306208610534668, 0.1983325481414795], dly_cnt)
l2_dly_grb_25 = expandTOs([0.40186572074890137, 0.2532196044921875, 0.29802489280700684, 0.4967536926269531, 0.7439043521881104, 0.5210614204406738, 0.34325575828552246, 0.5076093673706055, 0.5377357006072998, 0.478313684463501, 0.5297150611877441, 0.6017715930938721, 0.7128753662109375, 0.4851980209350586, 0.5770912170410156, 0.5239882469177246], dly_cnt)
l2_dly_grb_50 = expandTOs([0.6585102081298828, 0.4873673915863037, 0.48784780502319336, 0.5184791088104248, 0.7239468097686768, 0.7268507480621338, 1.0793571472167969, 0.7230546474456787, 0.6026146411895752, 0.48831915855407715, 0.8611924648284912, 0.8459796905517578, 0.7447195053100586, 0.6078131198883057, 1.618717908859253, 2.26570200920105], dly_cnt)

l2_dly_z3= expandTOs([0.11356186866760254, 0.10883975028991699, 0.13262200355529785, 0.06211662292480469, 0.21422934532165527, 0.0619044303894043, 0.1893930435180664, 0.22907114028930664, 0.08161282539367676, 0.08156204223632812, 0.1204981803894043, 0.12239646911621094, 0.1255207061767578, 0.081695556640625, 0.18979334831237793, 0.18823790550231934], dly_cnt)
l2_dly_cvc5 = expandTOs([0.05626869201660156, 0.1388561725616455, 0.0728447437286377, 0.14305329322814941, 0.0944516658782959, 0.1743452548980713, 0.0890653133392334, 0.2879447937011719, 0.10576701164245605, 0.13582062721252441, 0.21909117698669434, 0.23038554191589355, 0.29541969299316406, 0.18192172050476074, 0.19548726081848145, 0.3452072143554687], dly_cnt)
l2_dly_msat = expandTOs([0.05084347724914551, 0.10331249237060547, 0.11170196533203125, 0.10561704635620117, 0.039903879165649414, 0.04441046714782715, 0.0409853458404541, 0.04443097114562988, 0.039014339447021484, 0.041558027267456055, 0.04371333122253418, 0.0400996208190918, 0.04451322555541992, 0.04075479507446289, 0.045135498046875, 0.04259490966796875], dly_cnt)

l2_dly_grb_Learn = expandTOs([0.1339867115020752, 0.024143695831298828, 0.024235010147094727, 0.024096965789794922, 0.024266481399536133, 0.024058818817138672, 0.024129390716552734, 0.023891925811767578, 0.023834705352783203, 0.02408909797668457, 0.024200916290283203, 0.024080276489257812, 0.024144887924194336, 0.14595556259155273, 0.1543583869934082, 0.04145312309265137], dly_cnt)
l2_dly_nuRLin = expandTOs([0.15436744689941406, 0.04199671745300293, 0.04062318801879883, 0.040789127349853516, 0.04107522964477539, 0.04157066345214844, 0.04195117950439453, 0.04218149185180664, 0.042685508728027344, 0.04303145408630371, 0.0430448055267334, 0.04261922836303711, 0.04343605041503906, 0.19640183448791504, 0.20962309837341309, 0.06281065940856934], dly_cnt)


# GRAY 2
l2_gry_cnt = 11
l2_gry_grb_0  = expandTOs([1.0214447975158691, 1.8455872535705566, 0.7426412105560303, 0.42804861068725586, 0.9705495834350586, 0.5909030437469482, 1.7340922355651855, 2.6277480125427246, 5.040562629699707, 4.16300892829895, 6.966182470321655], gry_cnt)
l2_gry_grb_10 = expandTOs([1.2196288108825684, 3.928881883621216, 2.0092954635620117, 3.9681081771850586, 9.595924377441406, 6.092801094055176, 24.668998956680298, 9.531748056411743, 11.527864217758179, 11.763136863708496, 12.29952597618103], gry_cnt)
l2_gry_grb_25 = expandTOs([4.675544023513794, 3.580557107925415, 6.132666826248169, 22.496740579605103, 10.429975509643555, 20.848764419555664, 17.92091202735901, 20.444499254226685, 13.279700994491577, 17.14933490753174, 152.4447147846222], gry_cnt)
l2_gry_grb_50 = expandTOs([7.997143268585205, 15.392472505569458, 11.687628746032715, 42.26376223564148, 98.11092495918274, 112.17915391921997], gry_cnt)

l2_gry_z3= expandTOs([1.2101023197174072, 0.7737569808959961, 0.6164731979370117, 1.4472193717956543, 1.363140344619751, 3.973428964614868, 1.6016178131103516, 1.9109954833984375, 0.6262843608856201, 9.17240309715271, 0.5633471012115479], gry_cnt)
l2_gry_cvc5 = expandTOs([6.546294927597046, 6.378337383270264, 13.408415079116821, 1.2155532836914062, 7.597621440887451, 4.0612952709198, 9.771408796310425, 11.021768569946289, 17.49049997329712, 1.891845464706421, 17.109877109527588], gry_cnt)
l2_gry_msat = expandTOs([1.2444026470184326, 0.23838114738464355, 0.36829304695129395, 0.32842206954956055, 0.3482983112335205, 0.5126028060913086, 0.30443716049194336, 0.4565114974975586, 0.3631422519683838, 0.2765042781829834, 0.35986948013305664], gry_cnt)

l2_gry_grb_Learn = expandTOs([0.6592388153076172, 1.6221802234649658, 0.5762772560119629, 0.3202536106109619, 0.7880849838256836, 0.4499831199645996, 1.561713695526123, 2.4130430221557617, 4.824731349945068, 3.9042062759399414, 6.75545358657836], gry_cnt)
l2_gry_nuRLin = expandTOs([], gry_cnt)

# SevenSeg 2
l2_sg7_cnt  = 15
l2_sg7_grb_0  = expandTOs([0.26705002784729004, 0.2275395393371582, 0.33928608894348145, 0.5982437133789062, 0.766362190246582, 1.245844841003418, 1.527402639389038, 1.2495887279510498, 1.9190568923950195, 2.679857015609741, 2.6851606369018555, 1.6777031421661377, 1.382328987121582, 2.9970216751098633, 8.870852708816528], sg7_cnt)
l2_sg7_grb_10  = expandTOs([0.4699361324310303, 0.7277905941009521, 0.6790070533752441, 0.7875587940216064, 13.301812410354614, 1.8696703910827637, 183.8213529586792, 1.5222127437591553, 1.7540709972381592, 3.973952531814575, 1.815368890762329, 2.503424644470215, 2.4771976470947266, 2.649935007095337, 0.9318835735321045], sg7_cnt)
l2_sg7_grb_25   = expandTOs([0.689356803894043, 0.5883338451385498, 0.9787428379058838, 0.9369907379150391, 1.126690149307251, 1.3794357776641846, 1.7326164245605469, 1.3474440574645996, 1.7078962326049805, 2.3920233249664307, 1.8010916709899902, 2.8146817684173584, 2.154174327850342, 0.7506828308105469, 1.1048521995544434], sg7_cnt)
l2_sg7_grb_50  = expandTOs([1.0039374828338623, 1.162304401397705, 1.4200899600982666, 1.1466658115386963, 2.3132853507995605, 2.396369695663452, 3.6125640869140625, 1.1878464221954346, 2.2981081008911133, 3.155710458755493, 1.187279462814331, 2.602114200592041, 4.322014570236206, 2.5663821697235107, 1.6567926406860352], sg7_cnt)

l2_sg7_z3 = expandTOs([0.2014298439025879, 0.14027833938598633, 0.18722772598266602, 0.1447908878326416, 0.18420028686523438, 0.10338497161865234, 0.1981964111328125, 0.10518360137939453, 0.20180034637451172, 0.26009464263916016, 0.10961103439331055, 0.22309565544128418, 0.20284414291381836, 0.18548035621643066, 0.1597120761871338], sg7_cnt)
l2_sg7_cvc5   = expandTOs([0.20673775672912598, 0.17415475845336914, 0.2976410388946533, 0.34455442428588867, 0.18811893463134766, 0.30086851119995117, 1.689990520477295, 3.1616456508636475, 0.8548643589019775, 0.3851199150085449, 0.3378872871398926, 0.3655836582183838, 0.21078062057495117, 0.571467399597168, 0.24502968788146973], sg7_cnt)
l2_sg7_msat   = expandTOs([0.11418867111206055, 0.2590508460998535, 0.3101038932800293, 0.08356547355651855, 0.26598405838012695, 0.3673701286315918, 0.25055408477783203, 0.23117852210998535, 0.3360719680786133, 0.4481313228607178, 0.3990635871887207, 0.23245692253112793, 0.31049370765686035, 0.3109281063079834, 0.24271368980407715], sg7_cnt)

l2_sg7_grb_Learn  = expandTOs([0.175201416015625, 0.06692647933959961, 0.08845829963684082, 0.23383402824401855, 0.08058047294616699, 0.20650362968444824, 0.13936853408813477, 0.419283390045166, 0.3031280040740967, 0.4488048553466797, 0.21316194534301758, 0.28882312774658203, 0.1633005142211914, 0.5390639305114746, 0.26706886291503906], sg7_cnt)
l2_sg7_nuRLin = expandTOs([0.21613430976867676, 0.22999286651611328, 0.3440070152282715, 0.6170017719268799, 0.7720816135406494, 1.2674305438995361, 1.535715103149414, 1.2784628868103027, 1.9676554203033447, 2.7376790046691895, 2.695441246032715, 1.6977324485778809, 1.397303581237793, 3.0777101516723633, 8.902519226074219], sg7_cnt)



# GRAY 3
l3_gry_cnt = 11
l3_gry_grb_0  = expandTOs([1.07747220993042, 0.5654995441436768, 0.50299072265625, 7.7356085777282715, 0.9643089771270752, 0.5485901832580566, 0.8032903671264648, 1.6421418190002441, 2.0104048252105713, 3.268519163131714, 0.7602722644805908], gry_cnt)
l3_gry_grb_10 = expandTOs([7.933849573135376, 4.488088607788086, 7.629578113555908, 3.779264211654663, 10.85449504852295, 10.522497415542603, 18.028264045715332, 72.21816921234131, 8.543114423751831, 17.489453077316284, 76.65646457672119], gry_cnt)
l3_gry_grb_25 = expandTOs([10.986433744430542, 3.3562052249908447, 19.511666774749756, 30.721277236938477, 12.255542278289795, 56.74440932273865, 45.71413040161133, 35.93222427368164, 9.223845720291138, 44.342493295669556, 57.2085542678833], gry_cnt)
l3_gry_grb_50 = expandTOs([15.34245491027832, 12.687833070755005, 21.41021180152893, 39.81812930107117, 87.01825499534607], gry_cnt)

l3_gry_z3= expandTOs([0.7863037586212158, 0.5008544921875, 0.28009963035583496, 0.2356705665588379, 0.6110343933105469, 2.986931085586548, 4.538117170333862, 10.485867977142334, 16.750709295272827, 4.8267199993133545, 1.1989593505859375], gry_cnt)
l3_gry_cvc5 = expandTOs([9.742647171020508, 4.498160123825073, 0.8052117824554443, 31.668503761291504, 0.768798828125, 588.9158089160919, 984.1513419151306, 4.924566745758057, 22.326411485671997, 2.4023616313934326, 3.282362937927246], gry_cnt)
l3_gry_msat = expandTOs([0.7890274524688721, 0.47072839736938477, 0.5125758647918701, 0.26102161407470703, 0.1892087459564209, 0.39943432807922363, 0.43828272819519043, 0.8657999038696289, 0.6239128112792969, 0.5875988006591797, 0.5195522308349609], gry_cnt)

l3_gry_grb_Learn = expandTOs([0.8048121929168701, 0.4314718246459961, 0.38791561126708984, 7.405237436294556, 0.7844719886779785, 0.4036591053009033, 0.6645894050598145, 1.5022029876708984, 1.8467442989349365, 3.0654544830322266, 0.6182243824005127], gry_cnt)
l3_gry_nuRLin = expandTOs([], gry_cnt)

#================================================================
#		      **** SAFETY + LIVENESS DATA ****
#================================================================

# Delay
sl1_dly_cnt = 16
sl1_dly_grb_0 = expandTOs([0.18473052978515625, 0.041895151138305664, 0.03940129280090332, 0.05243825912475586, 0.05246758460998535, 0.052590370178222656, 0.05168271064758301, 0.05254220962524414, 0.052313804626464844, 0.05188345909118652, 0.05231595039367676, 0.05159592628479004, 0.05257105827331543, 0.05304265022277832, 0.05233025550842285, 0.053550004959106445], dly_cnt)
sl1_dly_grb_10 = expandTOs([0.3238072395324707, 0.17137360572814941, 0.17484402656555176, 0.179304838180542, 0.23807883262634277, 0.17938470840454102, 0.2125716209411621, 0.23977947235107422, 0.16566133499145508, 0.17750263214111328, 0.1954488754272461, 0.23100709915161133, 0.23118972778320312, 0.23252224922180176, 0.23399758338928223, 0.23419880867004395], dly_cnt)
sl1_dly_grb_25 = expandTOs([0.5517821311950684, 0.34911584854125977, 0.35384535789489746, 0.3819918632507324, 0.5391089916229248, 0.4155902862548828, 0.5070884227752686, 0.5494661331176758, 0.3717339038848877, 0.3923923969268799, 0.4370105266571045, 0.4790823459625244, 0.48363471031188965, 0.48564767837524414, 0.49724316596984863, 0.4936714172363281], dly_cnt)
sl1_dly_grb_50 = expandTOs([0.849492073059082, 0.6042582988739014, 0.6190626621246338, 0.6298506259918213, 0.9656286239624023, 0.6768996715545654, 0.8679065704345703, 1.0265288352966309, 0.604015588760376, 0.6865525245666504, 0.7643387317657471, 0.872675895690918, 0.8960864543914795, 0.8861751556396484, 0.891984224319458, 0.9087598323822021], dly_cnt)

sl1_dly_z3= expandTOs([0.1632707118988037, 0.1494450569152832, 0.2037951946258545, 0.255950927734375, 0.21697592735290527, 0.1384296417236328, 0.2550070285797119, 0.17354154586791992, 0.09885239601135254, 0.13530445098876953, 0.18349123001098633, 0.16184020042419434, 0.13692903518676758, 0.16112303733825684, 0.2009897232055664, 0.1673295497894287], dly_cnt)
sl1_dly_cvc5 = expandTOs([.19539093971252441, 0.11133074760437012, 0.15233492851257324, 0.13799214363098145, 0.1939074993133545, 0.11697602272033691, 0.1214301586151123, 0.2617981433868408, 0.1411116123199463, 0.1758863925933838, 0.16282892227172852, 0.3218507766723633, 0.676215410232544, 0.3713982105255127, 0.3764173984527588, 0.3790912628173828], dly_cnt)
sl1_dly_msat = expandTOs([0.13333868980407715, 0.08536839485168457, 0.10681700706481934, 0.0838782787322998, 0.09000349044799805, 0.08957719802856445, 0.10161876678466797, 0.09505009651184082, 0.11316037178039551, 0.13686871528625488, 0.12805390357971191, 0.1105341911315918, 0.2449178695678711, 0.13507342338562012, 0.13854050636291504, 0.22250652313232422], dly_cnt)

sl1_dly_grb_Learn = expandTOs([0.14241313934326172, 0.02476644515991211, 0.024821043014526367, 0.03271842002868652, 0.03252243995666504, 0.03258085250854492, 0.0314180850982666, 0.03186917304992676, 0.03189730644226074, 0.03188061714172363, 0.03195929527282715, 0.03187298774719238, 0.03221535682678223, 0.03229570388793945, 0.03156399726867676, 0.03203248977661133], dly_cnt)
sl1_dly_nuRLin = expandTOs([0.13135457038879395, 0.03938698768615723, 0.03918719291687012, 0.051286935806274414, 0.05103588104248047, 0.05591082572937012, 0.05390667915344238, 0.053985595703125, 0.052822113037109375, 0.05346226692199707, 0.05359792709350586, 0.052687644958496094, 0.05365467071533203, 0.0538175106048584, 0.05521082878112793, 0.05471086502075195], dly_cnt)

# Blink
sl1_blk_cnt = 25
sl1_blk_grb_0 = expandTOs([1.964860439300537, 5.905908823013306, 5.640369892120361, 6.513334274291992, 5.02116584777832, 4.898184776306152, 65.59291481971741, 35.11016821861267, 10.663327693939209, 6.603809356689453, 232.5495011806488], blk_cnt)
sl1_blk_grb_10 = expandTOs([27.933054208755493, 35.948039293289185, 6.332775115966797, 57.369404554367065], blk_cnt)
sl1_blk_grb_25  = expandTOs([28.47138476371765, 74.5752944946289], blk_cnt)
sl1_blk_grb_50 = expandTOs([158.64214825630188, 111.1571397781372], blk_cnt)

sl1_blk_z3= expandTOs([0.5179359912872314, 0.9157083034515381, 0.6303627490997314, 0.2602508068084717, 0.6761524677276611, 1.454350233078003, 1.241159439086914, 44.66648983955383, 56.10008406639099, 27.5697340965271, 236.60089540481567, 0.9146096706390381, 1465.475751876831, 1.8365442752838135, 0.6985912322998047, 31051.251623153687, 1.2350385189056396, 0.834089994430542, 70.87227034568787, 2.343618154525757, 1.5409555435180664, 0.9130222797393799, 2.1042206287384033, 2.712993621826172, 2.060009479522705], blk_cnt)
sl1_blk_cvc5  = expandTOs([0.42063069343566895, 1.3136112689971924, 2.65152645111084, 2.9660463333129883, 11.484497785568237, 3.6393415927886963, 13.602263927459717, 31.79478120803833, 45.20673060417175, 159.99639701843262, 91.20154356956482, 5.102503776550293, 13.141320705413818, 589.131246805191, 6057.759076356888, 3826.1691653728485, 25741.855667114258, 485.38766527175903, 2587.074286699295, 13.053832530975342], blk_cnt)
sl1_blk_msat  = expandTOs([0.1491553783416748, 0.07494878768920898, 0.11124753952026367, 0.08289122581481934, 0.07917666435241699, 0.08070182800292969, 0.07715392112731934, 0.0824577808380127, 0.07889962196350098, 0.06605672836303711, 0.079864501953125, 0.06684637069702148, 0.0837700366973877, 0.06969618797302246, 0.08564567565917969, 0.0697944164276123, 0.12441444396972656, 0.07541632652282715, 0.0879974365234375, 0.07548356056213379, 0.10941028594970703, 0.14498615264892578, 0.11323118209838867, 0.151566743850708, 0.07816505432128906], blk_cnt)

sl1_blk_grb_Learn = expandTOs([1.577031135559082, 5.543941259384155, 5.260401487350464, 6.249144077301025, 4.410274267196655, 2.9290566444396973, 62.68936824798584, 23.059102296829224, 9.979437112808228, 6.0824198722839355, 231.8655853271484], blk_cnt)
sl1_blk_nuRLin = expandTOs([], blk_cnt)

# GRAY
sl1_gry_cnt = 11
sl1_gry_grb_0  = expandTOs([8.841725826263428, 10.621649980545044, 1.7817742824554443, 13.130027294158936, 5.810837268829346, 5.406471490859985, 5.963604688644409, 6.013225555419922, 4.281418800354004, 150.70747542381287, 56.194823026657104], gry_cnt)
sl1_gry_grb_10 = expandTOs([8.852677583694458, 25.905450105667114, 60.70765018463135, 60.49871873855591, 64.62735509872437, 389.9894714355469, 197.15562224388123, 58.69272971153259, 45.13340520858765], gry_cnt)
sl1_gry_grb_25 = expandTOs([33.01075792312622, 80.07595372200012, 102.92161870002747, 196.9295334815979, 78.0225510597229, 393.2251410484314, 580.3045761585236, 106.04939222335815, 30.553501844406128], gry_cnt)
sl1_gry_grb_50 = expandTOs([], gry_cnt)

sl1_gry_z3= expandTOs([0.7707862854003906, 0.5731048583984375, 0.8252379894256592, 2.482445001602173, 0.7075977325439453, 0.6193563938140869, 3.5086264610290527, 1.2083995342254639, 24.596993446350098, 0.3558192253112793, 111.7842390537262], gry_cnt)
sl1_gry_cvc5 = expandTOs([3.7900283336639404, 3.18949031829834, 10.197774171829224, 12.172879934310913, 23.9289767742157, 21.314432382583618, 37.44190073013306, 34.78084897994995, 11144.697379112244, 2465.557959794998, 22.465111017227173], gry_cnt)
sl1_gry_msat = expandTOs([0.5548624992370605, 0.3705594539642334, 6.36664891242981, 15.166490077972412, 0.34424614906311035, 259.569833278656, 253.11400198936462, 1.05806303024292, 0.3674027919769287, 0.7098472118377686, 0.38912248611450195], gry_cnt)

sl1_gry_grb_Learn = expandTOs([8.473814010620117, 10.284818172454834, 1.6053245067596436, 12.588967561721802, 5.568489074707031, 5.1105170249938965, 5.668216705322266, 5.778269529342651, 4.01729154586792, 149.92491221427917, 55.69488167762756], gry_cnt)
sl1_gry_nuRLin = expandTOs([], gry_cnt)


# i2c
sl1_i2c_cnt  = 20
sl1_i2c_grb_0  = expandTOs([1.5677900314331055, 160.68709778785706, time_out_time, time_out_time, 152.25655937194824], i2c_cnt)
sl1_i2c_grb_10  = expandTOs([1.1553072929382324, 288.2285053730011], i2c_cnt)
sl1_i2c_grb_25   = expandTOs([2.2320637702941895, 578.9228370189667], i2c_cnt)
sl1_i2c_grb_50  = expandTOs([1.0801887512207031, 2950.330179452896], i2c_cnt)

sl1_i2c_z3 = expandTOs([0.784184455871582, 10.888267993927002, 38.24973726272583, 48.98787784576416, 35.904258012771606, 23.0077223777771, 59.25073170661926, 72.46637535095215, 113.37505841255188, 56.36800742149353, 171.8876519203186, 188.62211680412292, 101.13857960700989, 119.30736899375916, 122.20393919944763, 251.0238401889801, 292.52676653862, 519.5446393489838, 679.2318935394287, 2253.94892740249], i2c_cnt)
sl1_i2c_cvc5   = expandTOs([2.1092498302459717, 62.49083185195923, 188.2566466331482, 85.68607926368713, 91.677090883255, 103.26240658760071, 192.73877382278442, 455.7038745880127, 302.4203383922577, 572.1222701072693, 427.1670436859131, 194.54490494728088, 497.8408079147339, 349.4319362640381, 789.2034876346588, 741.9776895046234, 2261.6458382606506, 1845.3776371479034, 1018.2616381645203, 1263.4407830238342], i2c_cnt)
sl1_i2c_msat   = expandTOs([0.25292325019836426], i2c_cnt)

sl1_i2c_grb_Learn  = expandTOs([1.1069221496582031, 157.37434840202332, time_out_time, time_out_time, 142.4734845161438], i2c_cnt)
sl1_i2c_nuRLin = expandTOs([], i2c_cnt)

# LCD 
sl1_lcd_cnt  = 14
sl1_lcd_grb_0   = expandTOs([4.083368301391602, 2.4129116535186768, 2.434457778930664, 25.61070489883423, 56.045276165008545, 43.606531620025635, 22.01821231842041, 14.778889179229736, 65.98915410041809, 7.844622611999512, 38.882078409194946, 111.05659461021423, 75.3249180316925, 23.06046986579895], lcd_cnt)
sl1_lcd_grb_10  = expandTOs([2.552084445953369, 11.009076595306396, 2.72355580329895, 77.74343037605286, 51.39805030822754, 71.24438548088074, 56.57309865951538, 66.92347741127014, 23.76221752166748, 10.641124486923218, 53.13886857032776, 59.82328534126282, 27.499952793121338, 45.39277648925781], lcd_cnt)
sl1_lcd_grb_25  = expandTOs([3.8726701736450195, 4.730670928955078, 13.617435216903687, 4.079197883605957, 45.78393197059631, 97.55399107933044, 21.4474356174469, 56.21407961845398, 146.2151801586151, 51.454445362091064, 61.27143859863281, 41.218472719192505, 125.9172568321228, 137.6017622947693], lcd_cnt)
sl1_lcd_grb_50  = expandTOs([8.0380539894104, 40.20792102813721, 10.18563961982727, 11.871690511703491, 85.86914467811584, 95.66058087348938, 348.66764855384827, 116.01384711265564, 138.906423330307, 186.73053884506226, 406.13520669937134, 151.48353838920593], lcd_cnt)

sl1_lcd_z3 = expandTOs([0.19536924362182617, 0.18210148811340332, 0.28755736351013184, 0.1842489242553711, 0.3319711685180664, 0.39556884765625, 0.2860708236694336, 0.31808972358703613, 0.33881330490112305, 0.30927014350891113, 0.3295867443084717, 0.2215290069580078, 0.31930971145629883, 0.3095703125], lcd_cnt)
sl1_lcd_cvc5  = expandTOs([0.29706859588623047, 0.40900206565856934, 0.36288905143737793, 0.22618746757507324, 0.5562288761138916, 0.38961005210876465, 0.46033644676208496, 0.5818536281585693, 0.6395242214202881, 0.32012414932250977, 0.5170490741729736, 0.6751670837402344, 0.5859625339508057, 0.6506829261779785], lcd_cnt)
sl1_lcd_msat  = expandTOs([.46604037284851074, 0.3539607524871826, 0.31495213508605957, 0.5198991298675537, 0.5274505615234375, 0.3568563461303711, 0.37741661071777344, 0.335921049118042, 0.303696870803833, 0.4707319736480713, 0.29009389877319336, 0.27904200553894043, 0.41486144065856934, 0.44069504737854004], lcd_cnt)

sl1_lcd_grb_Learn  = expandTOs([3.4471869468688965, 1.9577248096466064, 1.995323896408081, 24.599819660186768, 54.48163056373596, 42.05507302284241, 20.990909099578857, 13.323282241821289, 63.46107602119446, 6.844087839126587, 37.6661958694458, 108.25553917884827, 55.190853118896484, 16.06357717514038], lcd_cnt)
sl1_lcd_nuRLin = expandTOs([], lcd_cnt)

# Load-Store 
sl1_ls_cnt  = 16
sl1_ls_grb_0  = expandTOs([0.49466729164123535, 0.4985625743865967, 0.5563898086547852, 0.46497464179992676, 0.4704608917236328, 0.3357362747192383, 0.4754326343536377, 0.5034255981445312, 0.4717588424682617, 0.5451631546020508, 0.6139497756958008, 0.5047671794891357, 0.6525683403015137, 0.6351287364959717, 0.7798829078674316, 0.8866896629333496], ls_cnt)
sl1_ls_grb_10  = expandTOs([1.3171570301055908, 1.2909836769104004, 0.8193159103393555, 0.8186967372894287, 0.8958709239959717, 0.9379825592041016, 1.7813653945922852, 1.3113195896148682, 0.6148390769958496, 0.5748136043548584, 2.232828378677368, 0.8890917301177979, 0.8266236782073975, 1.3185293674468994, 1.217282772064209, 1.6217877864837646], ls_cnt)
sl1_ls_grb_25   = expandTOs([3.4337029457092285, 2.615973472595215, 1.8575279712677002, 1.1188478469848633, 2.1795501708984375, 1.4458186626434326, 1.4249036312103271, 7.839922904968262, 1.5627098083496094, 2.433234930038452, 2.803579807281494, 11.746123313903809, 7.385562181472778, 2.8404359817504883, 3.4607508182525635, 3.924501419067383], ls_cnt)
sl1_ls_grb_50  = expandTOs([5.1770384311676025, 2.5768680572509766, 2.647042989730835, 11.665161609649658, 9.903368949890137, 3.345700740814209, 3.361668586730957, 58.83553624153137, 12.237069129943848, 12.599526166915894, 13.175390243530273, 17.63925552368164, 6.914937734603882, 7.356635570526123, 5.154676675796509, 9.4199960231781], ls_cnt)

sl1_ls_z3 = expandTOs([0.6994996070861816, 2.5924272537231445, 0.43119192123413086, 0.5925300121307373, 1.0627989768981934, 1.7235534191131592, 0.8854930400848389, 2.235050916671753, 0.5006988048553467, 5.513771057128906, 2.2885777950286865, 16.189901113510132, 14.467657327651978, 4.035535097122192, 2.761270761489868, 222.79512286186218], ls_cnt)
sl1_ls_cvc5   = expandTOs([0.2584812641143799, 0.3580136299133301, 0.4057765007019043, 0.345775842666626, 0.3075449466705322, 0.39159226417541504, 0.3168056011199951, 0.26935577392578125, 0.4368934631347656, 0.5902791023254395, 0.5505566596984863, 0.32312607765197754, 0.2993500232696533, 0.2806107997894287, 0.2953646183013916, 0.6092190742492676], ls_cnt)
sl1_ls_msat   = expandTOs([0.4782404899597168, 0.4517197608947754, 1.4252638816833496, 0.8351931571960449, 0.4661104679107666, 2.573814868927002, 0.505145788192749, 4.3075361251831055, 0.2929399013519287, 3.6873199939727783, 0.535750150680542, 2.693241596221924, 2.7931625843048096, 2.5932185649871826, 3.0307226181030273, 6.79583740234375], ls_cnt)

sl1_ls_grb_Learn  = expandTOs([0.1789226531982422, 0.2589719295501709, 0.25755906105041504, 0.1835002899169922, 0.20097684860229492, 0.11916399002075195, 0.1848773956298828, 0.21031665802001953, 0.17444872856140137, 0.2006525993347168, 0.2446727752685547, 0.22968459129333496, 0.2372448444366455, 0.2258610725402832, 0.28287839889526367, 0.3449711799621582], ls_cnt)
sl1_ls_nuRLin = expandTOs([], ls_cnt)

# PWM
sl1_pwm_cnt  = 12
sl1_pwm_grb_0   = expandTOs([0.2386162281036377, 0.08424639701843262, 0.11408257484436035, 0.11951947212219238, 0.10460638999938965, 0.10583281517028809, 0.10385346412658691, 0.12699580192565918, 0.13409948348999023, 0.1540067195892334, 0.13550305366516113, 0.19064784049987793], pwm_cnt)
sl1_pwm_grb_10  = expandTOs([0.4204258918762207, 0.3074333667755127, 0.30459165573120117, 0.30286407470703125, 0.32039356231689453, 0.32594966888427734, 0.3078882694244385, 0.34220361709594727, 0.3242356777191162, 0.33331751823425293, 0.3529016971588135, 0.3292100429534912], pwm_cnt)
sl1_pwm_grb_25  = expandTOs([0.8862826824188232, 0.7265017032623291, 0.7047183513641357, 0.710777997970581, 0.738086462020874, 0.7440755367279053, 0.7445399761199951, 0.7203881740570068, 0.7391042709350586, 0.7543816566467285, 0.7620315551757812, 0.7205445766448975], pwm_cnt)
sl1_pwm_grb_50  = expandTOs([1.4471919536590576, 1.4385757446289062, 1.4571709632873535, 1.484865665435791, 1.5099053382873535, 1.5348644256591797, 1.5690827369689941, 1.5718064308166504, 1.5898573398590088, 1.576369285583496, 1.5240602493286133, 1.4981341361999512], pwm_cnt)

sl1_pwm_z3 = expandTOs([0.08846306800842285, 0.05328035354614258, 0.0551304817199707, 0.054764747619628906, 0.0705413818359375, 0.0900261402130127, 0.041010141372680664, 0.0410006046295166, 0.0408785343170166, 0.041059017181396484, 0.04063868522644043, 0.04099130630493164], pwm_cnt)
sl1_pwm_cvc5  = expandTOs([0.11162209510803223, 0.25954699516296387, 0.4018833637237549, 0.06744241714477539, 0.06796455383300781, 0.07431745529174805, 0.08336448669433594, 0.08403468132019043, 0.09319472312927246, 0.07568931579589844, 0.0887606143951416, 13.796365976333618], pwm_cnt)
sl1_pwm_msat  = expandTOs([0.0806586742401123, 0.06831908226013184, 0.06331038475036621, 0.06323885917663574, 0.0644228458404541, 0.06847572326660156, 0.06788825988769531, 0.07199549674987793, 0.0737919807434082, 0.07643890380859375, 0.08011078834533691, 0.08464217185974121], pwm_cnt)

sl1_pwm_grb_Learn  = expandTOs([0.15939879417419434, 0.04787325859069824, 0.04813814163208008, 0.04759097099304199, 0.04773855209350586, 0.04702401161193848, 0.048067569732666016, 0.04686427116394043, 0.04680180549621582, 0.04795670509338379, 0.0507960319519043, 0.04144740104675293], pwm_cnt)
sl1_pwm_nuRLin = expandTOs([0.18936705589294434, 0.08720707893371582, 0.11496567726135254, 0.12897682189941406, 0.10803699493408203, 0.10904645919799805, 0.10598254203796387, 0.1304318904876709, 0.13919758796691895, 0.1590275764465332, 0.1411910057067871, 0.19712042808532715], pwm_cnt)

# SevenSeg 
sl1_sg7_cnt  = 15
sl1_sg7_grb_0  = expandTOs([34.40891933441162, 92.7163565158844, 121.59593772888184, 93.11797380447388, 261.1418716907501, time_out_time, 252.55326461791992, 527.2797145843506, time_out_time, time_out_time, time_out_time, 1037.515111207962, 1232.4702293872833], sg7_cnt)
sl1_sg7_grb_10  = expandTOs([126.55897760391235], sg7_cnt)
sl1_sg7_grb_25   = expandTOs([236.71135663986206], sg7_cnt)
sl1_sg7_grb_50  = expandTOs([], sg7_cnt)

sl1_sg7_z3 = expandTOs([1.5786371231079102, 2.2484211921691895, 1.9665751457214355, 7.510337591171265, 21.983909845352173, 20.045673847198486, 9.82409954071045, 9.17870569229126, 15.382655382156372], sg7_cnt)
sl1_sg7_cvc5   = expandTOs([8.80731749534607, 16.918981552124023, 18.808489322662354, 23.002477169036865, 25.61462092399597, 24.61712074279785, 46.0658700466156, 20.24995994567871], sg7_cnt)
sl1_sg7_msat   = expandTOs([1.1099603176116943, 2.6796224117279053, 1.409975528717041, 2.967038869857788, 1.5954666137695312, 9.140232801437378, 4.441462993621826], sg7_cnt)

sl1_sg7_grb_Learn  = expandTOs([32.92718195915222, 89.24951958656311, 118.71403384208679, 90.481773853302, 251.684415102005, time_out_time, 233.55796813964844, 489.5227174758911, time_out_time, time_out_time, time_out_time, 1011.9145247936249, 1220.1988141536713], sg7_cnt)
sl1_sg7_nuRLin = expandTOs([], sg7_cnt)

# Thermocouple
sl1_tmp_cnt  = 17
sl1_tmp_grb_0   = expandTOs([0.33093786239624023, 0.2651047706604004, 0.21975111961364746, 0.2158184051513672, 0.2294161319732666, 0.23107290267944336, 0.25826382637023926, 0.23257780075073242, 0.20345091819763184, 0.2404177188873291, 0.26024889945983887, 0.21515941619873047, 0.27878785133361816, 0.2178335189819336, 0.236159086227417, 0.2166004180908203, 0.21785473823547363], tmp_cnt)
sl1_tmp_grb_10  = expandTOs([0.5249791145324707, 0.4078092575073242, 0.3808176517486572, 0.4255857467651367, 0.37867069244384766, 0.4179806709289551, 0.37287425994873047, 0.42572665214538574, 0.4274735450744629, 0.3814716339111328, 0.41672778129577637, 0.4207041263580322, 0.4117391109466553, 0.40847349166870117, 0.40903210639953613, 0.4100661277770996, 0.4090874195098877], tmp_cnt)
sl1_tmp_grb_25  = expandTOs([0.6609618663787842, 0.6022310256958008, 0.6098670959472656, 0.6531050205230713, 0.6075849533081055, 0.6497137546539307, 0.6042418479919434, 0.6152827739715576, 0.6572542190551758, 0.5975375175476074, 0.6507730484008789, 0.6425445079803467, 0.644061803817749, 0.6009266376495361, 0.6019906997680664, 0.6008608341217041, 0.5999703407287598], tmp_cnt)
sl1_tmp_grb_50  = expandTOs([1.1264419555664062, 1.1670467853546143, 1.2408804893493652, 1.3435323238372803, 1.2907028198242188, 1.36063814163208, 1.5175764560699463, 1.4154407978057861, 1.2698438167572021, 1.100008487701416, 1.3686039447784424, 1.3871970176696777, 1.1463050842285156, 1.092726707458496, 1.1042430400848389, 1.1148746013641357, 1.0961177349090576], tmp_cnt)

sl1_tmp_z3 = expandTOs([0.24302244186401367, 0.4639699459075928, 0.5316438674926758, 1.1206302642822266, 0.8012590408325195, 0.785470724105835, 1.6912827491760254, 1.2335929870605469, 0.6828548908233643, 2.0801870822906494, 1.0146429538726807, 8.661252975463867, 0.454775333404541, 0.8650836944580078, 15.941881656646729, 40.13473081588745, 93.73735857009888], tmp_cnt)
sl1_tmp_cvc5  = expandTOs([2.1703665256500244, 2.0069406032562256, 0.32228970527648926, 0.9626564979553223, 1.0629291534423828, 3.443706512451172, 3.77595853805542, 1.8960273265838623, 4.991814851760864, 4.287183046340942, 11.503798961639404, 2.4477927684783936, 33159.21279215813], tmp_cnt)
sl1_tmp_msat  = expandTOs([0.26043128967285156, 0.3547031879425049, 0.5153818130493164, 0.9444103240966797, 0.3886263370513916, 0.5848875045776367, 0.3222544193267822, 1.2328205108642578, 1.0028350353240967, 2.436959981918335, 0.7174506187438965, 0.6653261184692383, 0.6255373954772949, 1.3959555625915527, 1.0987451076507568], tmp_cnt)

sl1_tmp_grb_Learn  = expandTOs([0.11132574081420898, 0.170302152633667, 0.13526105880737305, 0.12863898277282715, 0.1406407356262207, 0.1399669647216797, 0.1665024757385254, 0.14315319061279297, 0.12161755561828613, 0.14848732948303223, 0.16591954231262207, 0.1343393325805664, 0.1760709285736084, 0.1339128017425537, 0.14490199089050293, 0.12765264511108398, 0.12810420989990234], tmp_cnt)
sl1_tmp_nuRLin = expandTOs([], tmp_cnt)

# UART Transmit
sl1_utt_cnt  = 10
sl1_utt_grb_0  = expandTOs([0.2836878299713135, 0.11203551292419434, 0.08108353614807129, 0.08942317962646484, 0.08315753936767578, 0.08472847938537598, 0.08548331260681152, 0.10060691833496094, 0.08885884284973145, 0.08722352981567383], utt_cnt)
sl1_utt_grb_10  = expandTOs([0.29225754737854004, 0.14830350875854492, 0.17627549171447754, 0.16860580444335938, 0.15122699737548828, 0.16095948219299316, 0.183030366897583, 0.13120818138122559, 0.15905189514160156, 0.13566970825195312], utt_cnt)
sl1_utt_grb_25   = expandTOs([0.36983275413513184, 0.23125481605529785, 0.24810338020324707, 0.24359750747680664, 0.23238849639892578, 0.23610615730285645, 0.3567204475402832, 0.2060718536376953, 0.21136236190795898, 0.2195878028869629], utt_cnt)
sl1_utt_grb_50  = expandTOs([.6363193988800049, 0.4071953296661377, 0.4795544147491455, 0.5805990695953369, 0.5363283157348633, 0.7027437686920166, 0.5768313407897949, 0.4365837574005127, 0.4833247661590576, 0.525719404220581], utt_cnt)

sl1_utt_z3 = expandTOs([0.928438663482666, 0.2153937816619873, 0.8347063064575195, 0.14418745040893555, 0.048143625259399414, 0.04622626304626465, 0.04819631576538086, 0.04623603820800781, 0.28554844856262207, 0.05031108856201172], utt_cnt)
sl1_utt_cvc5   = expandTOs([0.48400235176086426, 1.128418207168579, 2.4610300064086914, 1.2473533153533936, 16.624829292297363, 6.632372140884399, 10.432504177093506, 1.8774900436401367, 9.82589602470398, 6866.52611374855], utt_cnt)
sl1_utt_msat   = expandTOs([0.8183772563934326, 1.1824214458465576, 0.5107431411743164, 0.275773286819458, 0.46948719024658203, 0.9532949924468994, 0.28550148010253906, 1.038855791091919, 786.8815720081329, 0.9307553768157959], utt_cnt)

sl1_utt_grb_Learn  = expandTOs([0.19866037368774414, 0.06471657752990723, 0.04160046577453613, 0.04961252212524414, 0.0441739559173584, 0.0438234806060791, 0.04487872123718262, 0.05361437797546387, 0.043837785720825195, 0.04625368118286133], utt_cnt)
sl1_utt_nuRLin = expandTOs([0.22617435455322266, 0.1146688461303711, 0.0820009708404541, 0.09068608283996582, 0.083953857421875, 0.08618330955505371, 0.08596134185791016, 0.10465383529663086, 0.08980631828308105, 0.08666825294494629], utt_cnt)


# VGA
sl1_vga_cnt  = 10
sl1_vga_grb_0  = expandTOs([19.5980544090271, 8.641579389572144, 5.602804183959961, 3.4682483673095703, 11.062709331512451, 6.132077693939209, 3.9874017238616943, 2.312453269958496, 2.5878448486328125, 3.3227999210357666], vga_cnt)
sl1_vga_grb_10  = expandTOs([5.128139972686768, 15.483453512191772, 26.586893320083618, 35.73064398765564, 13.759779453277588, 6.875127792358398, 12.376490116119385, 7.168241739273071, 9.62874984741211, 15.891234159469604], vga_cnt)
sl1_vga_grb_25   = expandTOs([26.739002466201782, 6.923009395599365, 5.940417528152466, 8.528759002685547, 79.53156971931458, 22.573323965072632, 19.657133102416992, 20.335102558135986, 11.383090257644653, 22.62264895439148], vga_cnt)
sl1_vga_grb_50  = expandTOs([40.37460374832153, 8.434559106826782, 48.405296325683594, 22.923498392105103, 113.92978715896606, 159.00761461257935, 4.0759117603302, 21.070444345474243, 118.518958568573, 17.85246205329895], vga_cnt)

sl1_vga_z3 = expandTOs([0.851020336151123, 1.6621594429016113, 0.9502298831939697, 4.919314861297607, 3.913085699081421, 2.6684558391571045, 3.3175625801086426, 9.468951225280762, 5.900821924209595, 3.5225436687469482], vga_cnt)
sl1_vga_cvc5   = expandTOs([0.18476033210754395, 0.9825863838195801, 0.6555080413818359, 0.8578286170959473, 10.174935340881348, 566.5528385639191, 1.7844562530517578, 2.4786622524261475, 0.6673462390899658, 2.0760157108306885], vga_cnt)
sl1_vga_msat   = expandTOs([0.8531227111816406, 3.66119122505188, 28109.43176317215, 2.257497549057007, 11.12492036819458, 3.819471597671509, 2.252730369567871, 5.920340538024902, 6.2001495361328125, 5.103986501693726], vga_cnt)

sl1_vga_grb_Learn  = expandTOs([18.440808534622192, 8.086836814880371, 4.990867614746094, 2.0113484859466553, 9.683396816253662, 5.100726366043091, 3.400547504425049, 1.8976922035217285, 2.1527328491210938, 2.8492863178253174], vga_cnt)
sl1_vga_nuRLin = expandTOs([], vga_cnt)

# Delay
sl2_dly_cnt = 16
sl2_dly_grb_0 = expandTOs([0.16849112510681152, 0.08438634872436523, 0.0573117733001709, 0.05545496940612793, 0.0555419921875, 0.05481886863708496, 0.05609273910522461, 0.05647134780883789, 0.05622744560241699, 0.0559687614440918, 0.05633711814880371, 0.05638003349304199, 0.05637955665588379, 0.0567171573638916, 0.05692887306213379, 0.0568079948425293], dly_cnt)
sl2_dly_grb_10 = expandTOs([0.4490170478820801, 0.24869012832641602, 0.26326894760131836, 0.27585554122924805, 0.334108829498291, 0.2736799716949463, 0.3139200210571289, 0.3397676944732666, 0.25078725814819336, 0.26139307022094727, 0.2837705612182617, 0.318650484085083, 0.3158712387084961, 0.3176248073577881, 0.32189464569091797, 0.32076072692871094], dly_cnt)
sl2_dly_grb_25 = expandTOs([0.7778749465942383, 0.5917768478393555, 0.6371455192565918, 0.598212718963623, 0.7876460552215576, 0.6001355648040771, 0.7027561664581299, 0.7972948551177979, 0.5776693820953369, 0.6105804443359375, 0.6616358757019043, 0.7353959083557129, 0.7269234657287598, 0.7311038970947266, 0.7511119842529297, 0.742781400680542], dly_cnt)
sl2_dly_grb_50 = expandTOs([1.3080558776855469, 0.9932029247283936, 1.0456748008728027, 1.0469441413879395, 1.5443799495697021, 1.085062026977539, 1.2929768562316895, 1.5549530982971191, 1.0208945274353027, 1.0769155025482178, 1.2128467559814453, 1.344074010848999, 1.3451409339904785, 1.3579521179199219, 1.3485958576202393, 1.365703582763671], dly_cnt)

sl2_dly_z3= expandTOs([0.2240128517150879, 0.1480264663696289, 0.22655582427978516, 0.16874480247497559, 0.18233275413513184, 0.2091226577758789, 0.15259909629821777, 0.16509747505187988, 0.2894885540008545, 0.4778933525085449, 0.23807048797607422, 0.29853343963623047, 0.2270979881286621, 0.23293471336364746, 0.3333470821380615, 17.061126947402954], dly_cnt)
sl2_dly_cvc5 = expandTOs([0.0612332820892334, 0.06884765625, 0.09007143974304199, 0.07871341705322266, 0.07610082626342773, 0.08043932914733887, 0.1041102409362793, 0.10096406936645508, 0.128281831741333, 0.13664817810058594, 0.08608555793762207, 0.11643075942993164, 0.3414919376373291, 0.11699223518371582, 0.1261293888092041, 0.25176262855529785], dly_cnt)
sl2_dly_msat = expandTOs([0.1285386085510254, 0.08343672752380371, 0.08010554313659668, 0.0800480842590332, 0.08660674095153809, 0.11658525466918945, 0.08208489418029785, 0.0934147834777832, 0.09895133972167969, 0.13451361656188965, 0.3758060932159424, 0.08690690994262695, 11.709673643112183, 0.1545569896697998, 0.12255215644836426, 0.27714014053344727], dly_cnt)

sl2_dly_grb_Learn = expandTOs([0.12801647186279297, 0.04283261299133301, 0.03566765785217285, 0.03543281555175781, 0.0341029167175293, 0.03365349769592285, 0.03423190116882324, 0.034482479095458984, 0.03405904769897461, 0.03428053855895996, 0.034216880798339844, 0.034258365631103516, 0.0342402458190918, 0.0343165397644043, 0.03419232368469238, 0.03427720069885254], dly_cnt)
sl2_dly_nuRLin = expandTOs([0.1300065517425537, 0.0700984001159668, 0.0597994327545166, 0.057390689849853516, 0.05854296684265137, 0.05827975273132324, 0.05793261528015137, 0.059046268463134766, 0.05917692184448242, 0.05915260314941406, 0.05910348892211914, 0.05966520309448242, 0.05857729911804199, 0.058898210525512695, 0.058860063552856445, 0.05881643295288086], dly_cnt)

# GRAY
sl2_gry_cnt = 11
sl2_gry_grb_0  = expandTOs([3.24749493598938, 1.5808227062225342, 5.504240274429321, 1.7526841163635254, 4.766321897506714, 4.66336727142334, 2.5002822875976562, 2.2626307010650635, 7.44799017906189, 3.0022075176239014, 11.82418107986450], gry_cnt)
sl2_gry_grb_10 = expandTOs([24.113277435302734, 12.41479778289795, 40.042192697525024, 24.688642024993896, 37.384061098098755, 101.70251512527466, 25.17911696434021, 39.06014442443848, 30.40877103805542], gry_cnt)
sl2_gry_grb_25 = expandTOs([34.88134264945984, 51.78632664680481], gry_cnt)
sl2_gry_grb_50 = expandTOs([], gry_cnt)

sl2_gry_z3= expandTOs([0.3413996696472168, 1.1190125942230225, 1.0649259090423584, 2.72039532661438, 2.5459306240081787, 0.5268573760986328, 14.069043159484863, 0.765521764755249, 52.65672969818115, 46.36871933937073, 13.3365001678466], gry_cnt)
sl2_gry_cvc5 = expandTOs([3.050372838973999, 6.398150205612183, 3.6845250129699707, 17.779160976409912, 144.27567172050476, 18.97832202911377, 3.5201621055603027, 13.653289318084717, 9.662582159042358, 6.371967792510986, 5.410636901855469], gry_cnt)
sl2_gry_msat = expandTOs([0.2131333351135254, 0.39650917053222656, 0.2593533992767334, 0.1593339443206787, 0.18390369415283203, 0.15525579452514648, 0.1609194278717041, 0.11364579200744629, 0.11230659484863281, 0.11310434341430664, 0.11177730560302734], gry_cnt)

sl2_gry_grb_Learn = expandTOs([2.800291061401367, 1.3618121147155762, 5.218754768371582, 1.564100980758667, 4.443172216415405, 4.310588359832764, 2.2435050010681152, 2.051758050918579, 7.098769903182983, 2.7333006858825684, 11.576117277145386], gry_cnt)
sl2_gry_nuRLin = expandTOs([], gry_cnt)


# Load-Store 
sl2_ls_cnt  = 16
sl2_ls_grb_0  = expandTOs([0.9977624416351318, 1.011429786682129, 0.8949024677276611, 0.5728988647460938, 0.4675865173339844, 0.6570253372192383, 0.5389766693115234, 0.6322343349456787, 0.651146650314331, 0.6266803741455078, 0.6781585216522217, 0.5899093151092529, 0.6557712554931641, 0.6370439529418945, 0.5593736171722412, 0.7148864269256592], ls_cnt)
sl2_ls_grb_10  = expandTOs([3.6183695793151855, 4.441715955734253, 0.7900712490081787, 0.9329774379730225, 4.312173128128052, 1.428191900253296, 1.0430028438568115, 3.325540065765381, 1.0021071434020996, 1.3689589500427246, 7.276748418807983, 3.177452802658081, 2.8230032920837402, 3.4235966205596924, 3.184730291366577, 3.0527913570404053], ls_cnt)
sl2_ls_grb_25   = expandTOs([4.771969318389893, 4.952539682388306, 7.867533445358276, 3.152344226837158, 23.7175133228302, 9.530325889587402, 8.794869899749756, 13.119035482406616, 5.213903188705444, 9.227359533309937, 2.894124984741211, 6.680225372314453, 8.21610975265503, 8.602958679199219, 10.915284633636475, 12.488479137420654], ls_cnt)
sl2_ls_grb_50  = expandTOs([94.36392831802368, 16.64281177520752, 12.958441972732544, 20.687474966049194], ls_cnt)

sl2_ls_z3 = expandTOs([0.23521065711975098, 0.768669605255127, 0.2677910327911377, 1.9566192626953125, 2.5787160396575928, 0.19136357307434082, 0.38548755645751953, 1.339693546295166, 0.14681744575500488, 0.45564770698547363, 0.6030316352844238, 0.5564515590667725, 0.5090591907501221, 3.1226603984832764, 0.25398993492126465, 7.780485391616821], ls_cnt)
sl2_ls_cvc5   = expandTOs([0.2942650318145752, 0.356708288192749, 0.2884244918823242, 0.5028934478759766, 0.520258903503418, 0.2743387222290039, 0.515878438949585, 0.8048453330993652, 0.3113887310028076, 0.4526553153991699, 0.702507734298706, 0.743283748626709, 0.6162288188934326, 0.953808069229126, 0.7290685176849365, 0.8164219856262207], ls_cnt)
sl2_ls_msat   = expandTOs([0.33812451362609863, 0.6329545974731445, 0.42575836181640625, 0.2587168216705322, 0.6529879570007324, 0.248795747756958, 0.42346811294555664, 2.198838233947754, 0.40103769302368164, 0.2626802921295166, 0.33644890785217285, 0.5253407955169678, 0.6157639026641846, 0.9161553382873535, 0.5931003093719482, 77.34920358657837], ls_cnt)

sl2_ls_grb_Learn  = expandTOs([0.5779821872711182, 0.45015954971313477, 0.46540307998657227, 0.2745046615600586, 0.1748495101928711, 0.3233962059020996, 0.2026078701019287, 0.31831836700439453, 0.23115038871765137, 0.3053267002105713, 0.32112574577331543, 0.25565028190612793, 0.2899160385131836, 0.30052804946899414, 0.21303200721740723, 0.29628467559814453], ls_cnt)
sl2_ls_nuRLin = expandTOs([], ls_cnt)




# Combine the data

grb_0   = np.array(s1_dly_grb_0 + s2_dly_grb_0 + s1_lcd_grb_0 + s2_lcd_grb_0 + s1_blk_grb_0 + s1_tmp_grb_0 + s1_sg7_grb_0 + s1_i2c_grb_0 + s1_pwm_grb_0 + s1_vga_grb_0 + s2_vga_grb_0 + s1_utt_grb_0 + s1_ls_grb_0 + s1_gry_grb_0 +
				   l1_dly_grb_0 + l1_lcd_grb_0 + l1_blk_grb_0 + l1_tmp_grb_0 + l1_sg7_grb_0 + l1_i2c_grb_0 + l1_pwm_grb_0 + l1_vga_grb_0 + l1_utt_grb_0 + l1_ls_grb_0 + l1_gry_grb_0 + l2_dly_grb_0 + l2_sg7_grb_0 + l2_gry_grb_0 + l3_gry_grb_0 +
				   sl1_dly_grb_0 + sl1_lcd_grb_0 + sl1_blk_grb_0 + sl1_tmp_grb_0 + sl1_sg7_grb_0 + sl1_i2c_grb_0 + sl1_pwm_grb_0 + sl1_vga_grb_0 + sl1_utt_grb_0 + sl1_ls_grb_0 + sl2_ls_grb_0 + sl1_gry_grb_0 + sl2_dly_grb_0 + sl2_gry_grb_0)

grb_10     = np.array(s1_dly_grb_10 + s2_dly_grb_10 + s1_lcd_grb_10 + s2_lcd_grb_10 + s1_blk_grb_10 + s1_tmp_grb_10 + s1_sg7_grb_10 + s1_i2c_grb_10 + s1_pwm_grb_10 + s1_vga_grb_10 + s2_vga_grb_10 + s1_utt_grb_10 + s1_ls_grb_10 + s1_gry_grb_10 +
				   l1_dly_grb_10 + l1_lcd_grb_10 + l1_blk_grb_10 + l1_tmp_grb_10 + l1_sg7_grb_10 + l1_i2c_grb_10 + l1_pwm_grb_10 + l1_vga_grb_10 + l1_utt_grb_10 + l1_ls_grb_10 + l1_gry_grb_10 + l2_dly_grb_10 + l2_sg7_grb_10 + l2_gry_grb_10 + l3_gry_grb_10 +
				   sl1_dly_grb_10 + sl1_lcd_grb_10 + sl1_blk_grb_10 + sl1_tmp_grb_10 + sl1_sg7_grb_10 + sl1_i2c_grb_10 + sl1_pwm_grb_10 + sl1_vga_grb_10 + sl1_utt_grb_10 + sl1_ls_grb_10 + sl2_ls_grb_10 + sl1_gry_grb_10 + sl2_dly_grb_10 + sl2_gry_grb_10)

grb_25     = np.array(s1_dly_grb_25 + s2_dly_grb_25 + s1_lcd_grb_25 + s2_lcd_grb_25 + s1_blk_grb_25 + s1_tmp_grb_25 + s1_sg7_grb_25 + s1_i2c_grb_25 + s1_pwm_grb_25 + s1_vga_grb_25  + s2_vga_grb_25 + s1_utt_grb_25 + s1_ls_grb_25 + s1_gry_grb_25 +
				   l1_dly_grb_25 + l1_lcd_grb_25 + l1_blk_grb_25 + l1_tmp_grb_25 + l1_sg7_grb_25 + l1_i2c_grb_25 + l1_pwm_grb_25 + l1_vga_grb_25 + l1_utt_grb_25 + l1_ls_grb_25 + l1_gry_grb_25 + l2_dly_grb_25 + l2_sg7_grb_25 + l2_gry_grb_25 + l3_gry_grb_25 +
				   sl1_dly_grb_25 + sl1_lcd_grb_25 + sl1_blk_grb_25 + sl1_tmp_grb_25 + sl1_sg7_grb_25 + sl1_i2c_grb_25 + sl1_pwm_grb_25 + sl1_vga_grb_25 + sl1_utt_grb_25 + sl1_ls_grb_25 + sl2_ls_grb_25 + sl1_gry_grb_25 + sl2_dly_grb_25 + sl2_gry_grb_25)

grb_50     = np.array(s1_dly_grb_50 + s2_dly_grb_50 + s1_lcd_grb_50 + s2_lcd_grb_50 + s1_blk_grb_50 + s1_tmp_grb_50 + s1_sg7_grb_50 + s1_i2c_grb_50 + s1_pwm_grb_50 + s1_vga_grb_50 + s2_vga_grb_50 + s1_utt_grb_50 + s1_ls_grb_50 + s1_gry_grb_50 +
				   l1_dly_grb_50 + l1_lcd_grb_50 + l1_blk_grb_50 + l1_tmp_grb_50 + l1_sg7_grb_50 + l1_i2c_grb_50 + l1_pwm_grb_50 + l1_vga_grb_50 + l1_utt_grb_50 + l1_ls_grb_50 + l1_gry_grb_50 + l2_dly_grb_50 + l2_sg7_grb_50 + l2_gry_grb_50 + l3_gry_grb_50 +
				   sl1_dly_grb_50 + sl1_lcd_grb_50 + sl1_blk_grb_50 + sl1_tmp_grb_50 + sl1_sg7_grb_50 + sl1_i2c_grb_50 + sl1_pwm_grb_50 + sl1_vga_grb_50 + sl1_utt_grb_50 + sl1_ls_grb_50 + sl2_ls_grb_50 + sl1_gry_grb_50 + sl2_dly_grb_50 + sl2_gry_grb_50)

z3s     = np.array(s1_dly_z3 + s2_dly_z3 + s1_lcd_z3 + s2_lcd_z3 + s1_blk_z3 + s1_tmp_z3 + s1_sg7_z3 + s1_i2c_z3 + s1_pwm_z3 + s1_vga_z3 + s2_vga_z3 + s1_utt_z3 + s1_ls_z3  + s1_gry_z3 +
				   l1_dly_z3 + l1_lcd_z3 + l1_blk_z3 + l1_tmp_z3 + l1_sg7_z3 + l1_i2c_z3 + l1_pwm_z3 + l1_vga_z3 + l1_utt_z3 + l1_ls_z3 + l1_gry_z3 + l2_dly_z3 + l2_sg7_z3 + l2_gry_z3 + l3_gry_z3 +
				   sl1_dly_z3 + sl1_lcd_z3 + sl1_blk_z3 + sl1_tmp_z3 + sl1_sg7_z3 + sl1_i2c_z3 + sl1_pwm_z3 + sl1_vga_z3 + sl1_utt_z3 + sl1_ls_z3 + sl2_ls_z3 + sl1_gry_z3 + sl2_dly_z3 + sl2_gry_z3)

cvc5s   = np.array(s1_dly_cvc5 + s2_dly_cvc5 + s1_lcd_cvc5 + s2_lcd_cvc5 + s1_blk_cvc5 + s1_tmp_cvc5 + s1_sg7_cvc5 + s1_i2c_cvc5 + s1_pwm_cvc5 + s1_vga_cvc5 + s2_vga_cvc5 + s1_utt_cvc5 + s1_ls_cvc5 + s1_gry_cvc5 +
				   l1_dly_cvc5 + l1_lcd_cvc5 + l1_blk_cvc5 + l1_tmp_cvc5 + l1_sg7_cvc5 + l1_i2c_cvc5 + l1_pwm_cvc5 + l1_vga_cvc5 + l1_utt_cvc5 + l1_ls_cvc5 + l1_gry_cvc5 + l2_dly_cvc5 + l2_sg7_cvc5 + l2_gry_cvc5 + l3_gry_cvc5 +
				   sl1_dly_cvc5 + sl1_lcd_cvc5 + sl1_blk_cvc5 + sl1_tmp_cvc5 + sl1_sg7_cvc5 + sl1_i2c_cvc5 + sl1_pwm_cvc5 + sl1_vga_cvc5 + sl1_utt_cvc5 + sl1_ls_cvc5 + sl2_ls_cvc5 + sl1_gry_cvc5 + sl2_dly_cvc5 + sl2_gry_cvc5)

msats     = np.array(s1_dly_msat + s2_dly_msat + s1_lcd_msat + s2_lcd_msat + s1_blk_msat + s1_tmp_msat + s1_sg7_msat + s1_i2c_msat + s1_pwm_msat + s1_vga_msat + s2_vga_msat + s1_utt_msat + s1_ls_msat + s1_gry_msat +
				   l1_dly_msat + l1_lcd_msat + l1_blk_msat + l1_tmp_msat + l1_sg7_msat + l1_i2c_msat + l1_pwm_msat + l1_vga_msat + l1_utt_msat + l1_ls_msat + l1_gry_msat + l2_dly_msat + l2_sg7_msat + l2_gry_msat + l3_gry_msat +
				   sl1_dly_msat + sl1_lcd_msat + sl1_blk_msat + sl1_tmp_msat + sl1_sg7_msat + sl1_i2c_msat + sl1_pwm_msat + sl1_vga_msat + sl1_utt_msat + sl1_ls_msat + sl2_ls_msat + sl1_gry_msat + sl2_dly_msat + sl2_gry_msat)


nuRLin     = np.array(s1_dly_nuRLin + s2_dly_nuRLin + s1_lcd_nuRLin + s2_lcd_nuRLin + s1_blk_nuRLin + s1_tmp_nuRLin + s1_sg7_nuRLin + s1_i2c_nuRLin + s1_pwm_nuRLin + s1_vga_nuRLin + s2_vga_nuRLin + s1_utt_nuRLin + s1_ls_nuRLin + s1_gry_nuRLin +
				   l1_dly_nuRLin + l1_lcd_nuRLin + l1_blk_nuRLin + l1_tmp_nuRLin + l1_sg7_nuRLin + l1_i2c_nuRLin + l1_pwm_nuRLin + l1_vga_nuRLin + l1_utt_nuRLin + l1_ls_nuRLin + l1_gry_nuRLin + l2_dly_nuRLin + l2_sg7_nuRLin + l2_gry_nuRLin + l3_gry_nuRLin +
				   sl1_dly_nuRLin + sl1_lcd_nuRLin + sl1_blk_nuRLin + sl1_tmp_nuRLin + sl1_sg7_nuRLin + sl1_i2c_nuRLin + sl1_pwm_nuRLin + sl1_vga_nuRLin + sl1_utt_nuRLin + sl1_ls_nuRLin + sl2_ls_nuRLin + sl1_gry_nuRLin + sl2_dly_nuRLin + sl2_gry_nuRLin)


grb_Learn     = np.array(s1_dly_grb_Learn + s2_dly_grb_Learn + s1_lcd_grb_Learn + s2_lcd_grb_Learn + s1_blk_grb_Learn + s1_tmp_grb_Learn + s1_sg7_grb_Learn + s1_i2c_grb_Learn + s1_pwm_grb_Learn + s1_vga_grb_Learn + s2_vga_grb_Learn + s1_utt_grb_Learn + s1_ls_grb_Learn + s1_gry_grb_Learn +
				   l1_dly_grb_Learn + l1_lcd_grb_Learn + l1_blk_grb_Learn + l1_tmp_grb_Learn + l1_sg7_grb_Learn + l1_i2c_grb_Learn + l1_pwm_grb_Learn + l1_vga_grb_Learn + l1_utt_grb_Learn + l1_ls_grb_Learn + l1_gry_grb_Learn + l2_dly_grb_Learn + l2_sg7_grb_Learn + l2_gry_grb_Learn + l3_gry_grb_Learn +
				   sl1_dly_grb_Learn + sl1_lcd_grb_Learn + sl1_blk_grb_Learn + sl1_tmp_grb_Learn + sl1_sg7_grb_Learn + sl1_i2c_grb_Learn + sl1_pwm_grb_Learn + sl1_vga_grb_Learn + sl1_utt_grb_Learn + sl1_ls_grb_Learn + sl2_ls_grb_Learn + sl1_gry_grb_Learn + sl2_dly_grb_Learn + sl2_gry_grb_Learn)


grb_bst  = np.minimum(np.minimum(np.minimum(grb_0, grb_10), grb_25), grb_50)

sol_bst  = np.minimum(np.minimum(np.minimum(grb_0, z3s), cvc5s), msats)






#----------------------------------------------------------------------------------
#							 Figures
#----------------------------------------------------------------------------------

def cactusPlotLinearNeural(grb_0, nuRLin):
	method1_times = grb_0.copy()
	method2_times = nuRLin.copy()

	method1_times.sort()
	method2_times.sort()


	num_tasks = len(method1_times)
	tasks_completed = np.arange(1, num_tasks + 1)/num_tasks*100
	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	plt.figure(figsize=(10, 6))

	plt.step(tasks_completed, method1_times, label='Auto Arch. (default)', color='green', linewidth=3, where='post', alpha=0.7, marker='x', markevery=30)
	plt.step(tasks_completed, method2_times, label='Only Linear Arch.', color='purple', linewidth=3, where='post', alpha=0.7, marker='D', markevery=30)
	
	plt.ylim(0.01, time_out_time)
	plt.xlim(1, 100)
	#plt.yscale('function', functions = (lambda x : x**(1/3), lambda x : x**(3)))
	plt.yscale('log')

	ax = plt.gca()
	ax.yaxis.set_major_formatter(formatter)
	plt.tick_params(axis='both', which='major', labelsize=16)

	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label)
	cst_value = [20, 40, 60, 80, 100]  # 10 ticks spaced evenly between -1 and 1
	cst_label = [ str(cst)+"%" for cst in cst_value]
	plt.xticks(cst_value, cst_label)
	plt.legend()
	plt.grid(True, linestyle='--', alpha=0.5)
	plt.legend(fontsize=18)
	plt.show()

def cactusPlotRndSmp(grb_0, grb_10, grb_25, grb_50, grb_bst):
	method1_times = grb_0.copy()
	method2_times = grb_10.copy()
	method3_times = grb_25.copy()
	method4_times = grb_50.copy()
	method5_times = grb_bst.copy()
	
	method1_times.sort()
	method2_times.sort()
	method3_times.sort()
	method4_times.sort()
	method5_times.sort()

	num_tasks = len(method1_times)
	tasks_completed = np.arange(1, num_tasks + 1)/num_tasks*100
	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	plt.figure(figsize=(10, 6))

	plt.step(tasks_completed, method1_times, label='No Smp. @Iter0', color='green', linewidth=3, where='post', alpha=0.7, marker='x', markevery=30)
	plt.step(tasks_completed, method2_times, label='10 Smp. @Iter0', color='blue', linewidth=3, where='post', alpha=0.7, marker='s', markevery=30)
	plt.step(tasks_completed, method3_times, label='25 Smp. @Iter0', color='purple', linewidth=3, where='post', alpha=0.7, marker='D', markevery=30)
	plt.step(tasks_completed, method4_times, label='50 Smp. @Iter0', color='red', linewidth=3, where='post', alpha=0.7, marker='^', markevery=30)
	plt.step(tasks_completed, method5_times, label='Best', color='brown', linewidth=3, where='post', alpha=0.7, marker='v', markevery=30)

	plt.ylim(0.01, time_out_time)
	plt.xlim(1, 100)
	#plt.yscale('function', functions = (lambda x : x**(1/3), lambda x : x**(3)))
	plt.yscale('log')

	ax = plt.gca()
	ax.yaxis.set_major_formatter(formatter)
	plt.tick_params(axis='both', which='major', labelsize=16)

	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label)
	cst_value = [20, 40, 60, 80, 100]  # 10 ticks spaced evenly between -1 and 1
	cst_label = [ str(cst)+"%" for cst in cst_value]
	plt.xticks(cst_value, cst_label)
	plt.legend()
	plt.grid(True, linestyle='--', alpha=0.5)
	plt.legend(fontsize=18)
	plt.show()

def cactusPlotSolver(grbs, z3s, cvc5s, msats, sol_bst):
	method1_times = grbs.copy()
	method2_times = z3s.copy()
	method3_times = cvc5s.copy()
	method4_times = msats.copy()
	method5_times = sol_bst.copy()
	
	method1_times.sort()
	method2_times.sort()
	method3_times.sort()
	method4_times.sort()
	method5_times.sort()


	num_tasks = len(method1_times)
	tasks_completed = np.arange(1, num_tasks + 1)/num_tasks*100
	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	plt.figure(figsize=(10, 6))

	plt.step(tasks_completed, method1_times, label='Gurobi (default)', color='green', linewidth=3, where='post', alpha=0.7, marker='x', markevery=30)
	plt.step(tasks_completed, method2_times, label='Z3', color='blue', linewidth=3, where='post', alpha=0.7, marker='s', markevery=30)
	plt.step(tasks_completed, method3_times, label='CVC5', color='purple', linewidth=3, where='post', alpha=0.7, marker='D', markevery=30)
	plt.step(tasks_completed, method4_times, label='MathSAT', color='red', linewidth=3, where='post', alpha=0.7, marker='^', markevery=30)
	plt.step(tasks_completed, method5_times, label='Best', color='brown', linewidth=3, where='post', alpha=0.7, marker='v', markevery=30)

	
	plt.ylim(0.01, time_out_time)
	plt.xlim(1, 100)
	#plt.yscale('function', functions = (lambda x : x**(1/3), lambda x : x**(3)))
	plt.yscale('log')

	ax = plt.gca()
	ax.yaxis.set_major_formatter(formatter)
	plt.tick_params(axis='both', which='major', labelsize=16)


	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label)
	cst_value = [20, 40, 60, 80, 100]  # 10 ticks spaced evenly between -1 and 1
	cst_label = [ str(cst)+"%" for cst in cst_value]
	plt.xticks(cst_value, cst_label)
	plt.legend()
	plt.grid(True, linestyle='--', alpha=0.5)
	plt.legend(fontsize=18)
	plt.show()

def landslidePlot(our_total, our_learn):
	T = our_total.copy()
	L = our_learn.copy()


	n_values = np.arange(1, len(T) + 1)/(len(T))*100
	sum_tool = np.add(T, L) #np.add(np.add(nuX,ABC),nuR)
	sorted_tuples = sorted(zip(sum_tool,T, L))
	sum_tool, T, L = zip(*sorted_tuples)

	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	
	#plt.plot(n_values, np.array(T)/np.array(L), color='#0E2E16')
	plt.plot(n_values, T, color='#0E2E16')
	plt.plot(n_values, L, color='#184E25')
	plt.xlim(1, round(np.sum(np.array(T)< time_out_time)/(len(L))*100))
	plt.ylim(0.01, time_out_time)
		
	plt.fill_between(n_values, T, L, color='#0E2E16', alpha=0.2, hatch='o')
	
	plt.fill_between(n_values[:-10], L[:-10], color='#184E25', alpha=0.3)
	plt.fill_between(n_values[-11:], L[-11:], color='#041809', alpha=0.3 )
	plt.tick_params(axis='both', which='major', labelsize=16)

	
	cst_value = [20, 40, 60, 75, round(np.sum(np.array(T)< time_out_time)/(len(T))*100)]  # 10 ticks spaced evenly between -1 and 1
	cst_label = [ str(cst)+"%" for cst in cst_value]
	plt.xticks(cst_value, cst_label)
	plt.gca().set_yscale('log')
	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label)
	plt.grid(linestyle='--', alpha=1)
	plt.show()

def stat1():
	all_runs = np.concatenate([
	grb_0, grb_10, grb_25, grb_50,
	z3s, cvc5s, msats,
	], axis=0)

	print(f"Our Ablation Study exhaust {np.sum(all_runs)/(60*60)} hrs. for {len(all_runs)} total tasks\n")

def stat2():
	sum_less5 = 0
	cnt_less5 = 0

	sum_more5 = 0
	cnt_more5 = 0

	for i in range(len(grb_0)):
		if grb_0[i] < 5:
			sum_less5 += grb_Learn[i]/grb_0[i]
			cnt_less5 += 1
		else:
			sum_more5 += grb_Learn[i]/grb_0[i]
			cnt_more5 += 1
	print(f"For completetions under 5s, learning accounts for {sum_less5/cnt_less5*100} % time; for longer, {sum_more5/cnt_more5*100}")

def stat3():
	print(f"\nGurobi does {np.sum(grb_0 < 25)/len(grb_0)*100} % tasks in under 25 sec, and only {np.sum((grb_0 >= 25) & (grb_0 < time_out_time))/len(grb_0)*100} % more tasks after that")

	print(f"{np.sum(z3s<time_out_time)/len(z3s)*100}  % tasks completed by z3")
	print(f"{np.sum(grb_0<time_out_time)/len(z3s)*100}  % tasks completed by grb_0")
	print(f"{np.sum(msats<time_out_time)/len(z3s)*100}  % tasks completed by msats")
	print(f"{np.sum(cvc5s<time_out_time)/len(z3s)*100}  % tasks completed by cvc5s")

	sum_cvc5 = 0
	cnt_cvc5 = 0

	sum_msat = 0
	cnt_msat = 0

	for i in range(len(grb_0)):
		if (z3s[i] < time_out_time) and (cvc5s[i] < time_out_time):
			sum_cvc5 += z3s[i]/cvc5s[i]
			cnt_cvc5 += 1
		if (z3s[i] < time_out_time) and (msats[i] < time_out_time):
			sum_msat += z3s[i]/msats[i]
			cnt_msat += 1


	print(f"\nZ3 does. {(np.sum(z3s < time_out_time) - np.sum(grb_0 < time_out_time))/len(grb_0)*100} % more tasks than Gurobi")
	print(f"Z3 is faster than MSAT and CVC5 by {sum_msat/cnt_msat} and {sum_cvc5/cnt_cvc5} times\n")


def stat4():
	sum_z3 = 0
	cnt_z3 = 0

	for i in range(len(grb_0)):
		if (grb_0[i] < time_out_time) and (z3s[i] < time_out_time):
			sum_z3 += grb_0[i]/z3s[i]
			cnt_z3 += 1

	print(f"\nZ3 does. {(np.sum(z3s < time_out_time) - np.sum(grb_0 < time_out_time))/len(grb_0)*100} % more tasks than Gurobi")
	print(f"Gurobi is faster than z3 by {sum_z3/cnt_z3}\n")

def stat5():
	print(f"{np.sum(nuRLin<time_out_time)/len(nuRLin)*100}  % tasks completed by Our Linear")

	temp_nuRLin = nuRLin.copy()
	temp_nuRLin[temp_nuRLin >= time_out_time] = 0
	print(f"Our Linear completes no more tasks after {max(temp_nuRLin)} sec")


def count_table():
	print(f"----------------- PURE-SAFETY  -----------------\n")
	print("        ---------     Gurobi RndSmp:0      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_grb_0)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_grb_0)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_grb_0)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_grb_0)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_grb_0)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_grb_0)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_grb_0)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_grb_0)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_grb_0)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_grb_0)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_grb_0)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_grb_0)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_grb_0)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_grb_0)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:10      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_grb_10)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_grb_10)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_grb_10)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_grb_10)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_grb_10)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_grb_10)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_grb_10)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_grb_10)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_grb_10)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_grb_10)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_grb_10)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_grb_10)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_grb_10)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_grb_10)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:25      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_grb_25)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_grb_25)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_grb_25)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_grb_25)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_grb_25)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_grb_25)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_grb_25)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_grb_25)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_grb_25)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_grb_25)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_grb_25)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_grb_25)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_grb_25)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_grb_25)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:50      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_grb_50)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_grb_50)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_grb_50)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_grb_50)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_grb_50)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_grb_50)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_grb_50)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_grb_50)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_grb_50)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_grb_50)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_grb_50)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_grb_50)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_grb_50)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_grb_50)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     z3      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_z3)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_z3)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_z3)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_z3)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_z3)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_z3)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_z3)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_z3)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_z3)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_z3)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_z3)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_z3)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_z3)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_z3)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     cvc5      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_cvc5)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_cvc5)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_cvc5)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_cvc5)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_cvc5)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_cvc5)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_cvc5)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_cvc5)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_cvc5)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_cvc5)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_cvc5)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_cvc5)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_cvc5)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_cvc5)} / {len(s1_gry_grb_0)} \n")

	print("        ---------     msat      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_msat)} / {len(s1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(s2_dly_msat)} / {len(s2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(s1_lcd_msat)} / {len(s1_lcd_grb_0)} \n")
	print(f"LCD_2  : {get_success_count(s2_lcd_msat)} / {len(s2_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(s1_vga_msat)} / {len(s1_vga_grb_0)} \n")
	print(f"VGA_2  : {get_success_count(s2_vga_msat)} / {len(s2_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(s1_blk_msat)} / {len(s1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_msat)} / {len(s1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(s1_sg7_msat)} / {len(s1_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(s1_i2c_msat)} / {len(s1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(s1_pwm_msat)} / {len(s1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(s1_utt_msat)} / {len(s1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( s1_ls_msat)} / {len( s1_ls_grb_0)}  \n")
	print(f"Gray_1 : {get_success_count(s1_gry_msat)} / {len(s1_gry_grb_0)} \n")

	print(f"\n\n\n----------------- PURE-LIVENESS  -----------------\n")
	print("        ---------     Gurobi RndSmp:0      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_grb_0)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_grb_0)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_grb_0)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_grb_0)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_grb_0)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_grb_0)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_grb_0)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_grb_0)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_grb_0)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_grb_0)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_grb_0)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_grb_0)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_grb_0)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_grb_0)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_grb_0)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:10      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_grb_10)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_grb_10)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_grb_10)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_grb_10)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_grb_10)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_grb_10)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_grb_10)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_grb_10)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_grb_10)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_grb_10)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_grb_10)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_grb_10)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_grb_10)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_grb_10)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_grb_10)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:25      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_grb_25)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_grb_25)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_grb_25)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_grb_25)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_grb_25)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_grb_25)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_grb_25)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_grb_25)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_grb_25)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_grb_25)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_grb_25)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_grb_25)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_grb_25)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_grb_25)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_grb_25)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     Gurobi RndSmp:50      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_grb_50)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_grb_50)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_grb_50)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_grb_50)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_grb_50)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_grb_50)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_grb_50)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_grb_50)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_grb_50)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_grb_50)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_grb_50)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_grb_50)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_grb_50)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_grb_50)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_grb_50)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     z3      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_z3)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_z3)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_z3)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_z3)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_z3)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_z3)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_z3)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_z3)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_z3)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_z3)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_z3)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_z3)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_z3)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_z3)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_z3)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     cvc5      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_cvc5)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_cvc5)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_cvc5)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_cvc5)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_cvc5)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_cvc5)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_cvc5)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_cvc5)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_cvc5)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_cvc5)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_cvc5)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_cvc5)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_cvc5)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_cvc5)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_cvc5)} / {len(l3_gry_grb_0)} \n")

	print("        ---------     msat      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_msat)} / {len(l1_dly_grb_0)} \n")
	print(f"delay_2: {get_success_count(l2_dly_msat)} / {len(l2_dly_grb_0)} \n")
	print(f"LCD_1  : {get_success_count(l1_lcd_msat)} / {len(l1_lcd_grb_0)} \n")
	print(f"VGA_1  : {get_success_count(l1_vga_msat)} / {len(l1_vga_grb_0)} \n")
	print(f"Blink_1: {get_success_count(l1_blk_msat)} / {len(l1_blk_grb_0)} \n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_msat)} / {len(l1_tmp_grb_0)} \n")
	print(f"7sg_1  : {get_success_count(l1_sg7_msat)} / {len(l1_sg7_grb_0)} \n")
	print(f"7sg_2  : {get_success_count(l2_sg7_msat)} / {len(l2_sg7_grb_0)} \n")
	print(f"i2c_1  : {get_success_count(l1_i2c_msat)} / {len(l1_i2c_grb_0)} \n")
	print(f"PWM_1  : {get_success_count(l1_pwm_msat)} / {len(l1_pwm_grb_0)} \n")
	print(f"UART_1 : {get_success_count(l1_utt_msat)} / {len(l1_utt_grb_0)} \n")
	print(f"LS_1   : {get_success_count( l1_ls_msat)} / {len( l1_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_msat)} / {len(l1_gry_grb_0)} \n")
	print(f"Gray_2 : {get_success_count(l2_gry_msat)} / {len(l2_gry_grb_0)} \n")
	print(f"Gray_3 : {get_success_count(l3_gry_msat)} / {len(l3_gry_grb_0)} \n")

	print(f"\n\n\n----------------- SAFETY-LIVENESS  -----------------\n")
	print("        ---------     Gurobi RndSmp:0     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_grb_0)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_grb_0)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_grb_0)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_grb_0)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_grb_0)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_grb_0)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_grb_0)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_grb_0)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_grb_0)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_grb_0)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_grb_0)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_grb_0)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_grb_0)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_grb_0)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     Gurobi RndSmp:10     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_grb_10)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_grb_10)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_grb_10)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_grb_10)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_grb_10)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_grb_10)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_grb_10)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_grb_10)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_grb_10)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_grb_10)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_grb_10)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_grb_10)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_grb_10)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_grb_10)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     Gurobi RndSmp:25     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_grb_25)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_grb_25)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_grb_25)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_grb_25)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_grb_25)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_grb_25)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_grb_25)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_grb_25)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_grb_25)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_grb_25)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_grb_25)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_grb_25)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_grb_25)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_grb_25)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     Gurobi RndSmp:50     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_grb_50)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_grb_50)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_grb_50)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_grb_50)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_grb_50)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_grb_50)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_grb_50)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_grb_50)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_grb_50)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_grb_50)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_grb_50)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_grb_50)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_grb_50)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_grb_50)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     z3     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_z3)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_z3)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_z3)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_z3)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_z3)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_z3)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_z3)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_z3)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_z3)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_z3)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_z3)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_z3)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_z3)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_z3)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     cvc5     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_cvc5)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_cvc5)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_cvc5)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_cvc5)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_cvc5)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_cvc5)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_cvc5)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_cvc5)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_cvc5)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_cvc5)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_cvc5)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_cvc5)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_cvc5)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_cvc5)} / {len(sl2_gry_grb_0)}\n")

	print("        ---------     msat     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_msat)} / {len(sl1_dly_grb_0)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_msat)} / {len(sl2_dly_grb_0)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_msat)} / {len(sl1_lcd_grb_0)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_msat)} / {len(sl1_vga_grb_0)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_msat)} / {len(sl1_blk_grb_0)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_msat)} / {len(sl1_tmp_grb_0)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_msat)} / {len(sl1_sg7_grb_0)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_msat)} / {len(sl1_i2c_grb_0)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_msat)} / {len(sl1_pwm_grb_0)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_msat)} / {len(sl1_utt_grb_0)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_msat)} / {len( sl1_ls_grb_0)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_msat)} / {len( sl2_ls_grb_0)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_msat)} / {len(sl1_gry_grb_0)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_msat)} / {len(sl2_gry_grb_0)}\n")



#----------------------------------------------------------------------------------
#							 Choices
#----------------------------------------------------------------------------------
stat1()
stat2()
stat3()
stat4()
stat5()
while(True):
	print("1) Cactus Plot (Linear ablation) 2)Cactus Plot (Rnd) 3)Cactus Plot (Solvers) 4) Table")
	ch = int(input("Enter your choice: "))
	if(ch == 1):
		cactusPlotLinearNeural(grb_0, nuRLin)
	if(ch == 2):
		cactusPlotRndSmp(grb_0, grb_10, grb_25, grb_50, grb_bst)
	if(ch == 3):
		cactusPlotSolver(grb_0, z3s, cvc5s, msats, sol_bst)
	if (ch == 4):
		count_table()
	else:
		print("Please enter an number between 1 to 1 ")



