
import matplotlib.pyplot as plt
import numpy as np
from matplotlib.ticker import ScalarFormatter
import math

time_out_time = 18000
time_out_time = 18000

def expandTOs(arr, exp_cnt):
	if not len(arr) <= exp_cnt:
		breakpoint()
	arr = arr + [time_out_time ]*(exp_cnt - len(arr))
	arr = np.array(arr)
	arr[arr > time_out_time] = time_out_time
	arr = list(arr)
	return arr

colors_catus = [
    "#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd",
    "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf"
]

def get_success_count(list_a):
	return sum(np.array(list_a) < time_out_time)

#================================================================
#				    **** SAFETY DATA ****
#================================================================

# Delay
dly_cnt = 16
s1_dly_nuX = expandTOs([0.030040979385375977, 0.026370525360107422, 0.027262210845947266, 0.028682231903076172, 0.03299379348754883, 0.028966665267944336, 0.030070066452026367, 0.03266739845275879, 0.03003406524658203, 0.029548168182373047, 0.05318021774291992, 0.03122997283935547, 0.032160282135009766, 0.03418993949890137, 0.03476524353027344, 0.03594470024108887], dly_cnt)
s1_dly_nuRauto = expandTOs([0.17268896102905273, 0.04430389404296875, 0.03564739227294922, 0.036334991455078125, 0.03798341751098633, 0.03710579872131348, 0.0369875431060791, 0.03708052635192871, 0.03745269775390625, 0.036843061447143555, 0.03711295127868652, 0.03729605674743652, 0.037943363189697266, 0.03830981254577637, 0.03817319869995117, 0.03974080085754394], dly_cnt)
s1_dly_abc = expandTOs([0.2044522762298584, 0.20286226272583008, 0.20395755767822266, 0.2042684555053711, 0.2021036148071289, 0.20459556579589844, 0.20347118377685547, 0.20603489875793457, 0.20244383811950684, 0.2033836841583252, 0.20345067977905273, 0.20310759544372559, 0.20377898216247559, 0.2035684585571289, 0.2028813362121582, 0.20358824729919434], dly_cnt)
s1_dly_rIC3 = expandTOs([0.009859, 0.009464, 0.010067, 0.010791, 0.009534, 0.010433, 0.011242, 0.010989, 0.011527, 0.011019, 0.011837, 0.011263, 0.011310, 0.012048, 0.016634, 0.012567], dly_cnt)

s1_dly_nuRLin = expandTOs([0.12720942497253418, 0.040026187896728516, 0.039475440979003906, 0.04001140594482422, 0.03902864456176758, 0.039075613021850586, 0.03921627998352051, 0.0386958122253418, 0.0402836799621582, 0.041388750076293945, 0.0399324893951416, 0.03939652442932129, 0.039533138275146484, 0.03996920585632324, 0.03941154479980469], dly_cnt)
s1_dly_NMC24 = expandTOs([], dly_cnt)


# Blink
blk_cnt = 25
s1_blk_nuX = expandTOs([0.02293562889099121, 0.02315998077392578, 0.023675918579101562, 0.02442145347595215, 0.0242767333984375, 0.024524211883544922, 0.02509021759033203, 0.02579045295715332, 0.026370763778686523, 0.026615142822265625, 0.028254032135009766, 0.027946949005126953, 0.02888178825378418, 0.02936387062072754, 0.029541015625, 0.030495166778564453, 0.031000375747680664, 0.03167462348937988, 0.03322005271911621, 0.03416109085083008, 0.0345916748046875, 0.034375667572021484, 0.03722381591796875, 0.03644442558288574, 0.03837084770202637], blk_cnt)
s1_blk_nuRauto = expandTOs([0.4289381504058838, 0.43096351623535156, 0.3858518600463867, 0.47727322578430176, 0.3929271697998047, 0.42862868309020996, 0.3348691463470459, 0.5015549659729004, 0.5624203681945801, 0.3844642639160156, 0.4896526336669922, 0.3888232707977295, 0.3280467987060547, 0.4706432819366455, 0.5321571826934814, 0.3116919994354248, 0.523263692855835, 0.3511323928833008, 0.6412923336029053, 0.6456530094146729, 0.8199992179870605, 0.7243683338165283, 0.5314631462097168,  0.4935719966888428, 0.6704835891723633], blk_cnt)
s1_blk_abc = expandTOs([0.20444440841674805, 0.20515704154968262, 0.20308852195739746, 0.2047748565673828, 0.2041795253753662, 0.20598816871643066, 0.20535993576049805, 0.2037653923034668, 0.20543766021728516, 0.20392990112304688, 0.20400071144104004, 0.20475101470947266, 0.20336055755615234, 0.2045145034790039, 0.2062087059020996, 0.20387959480285645, 0.2039339542388916, 0.2038404941558838, 0.20459485054016113, 0.20436406135559082, 0.20644879341125488, 0.20658636093139648, 0.2049236297607422, 0.20673751831054688, 0.20789432525634766], blk_cnt)
s1_blk_rIC3 = expandTOs([0.011647, 0.011816, 0.013966, 0.012717, 0.023335, 0.015738, 0.015766, 0.015471, 0.014050, 0.027752, 0.015250, 0.015279, 0.042303, 0.016858, 0.024550, 0.018213, 0.020894, 0.023677, 0.025529, 0.017724, 0.018868, 0.034580, 0.021762, 0.018834, 0.025061], blk_cnt)

s1_blk_nuRLin = expandTOs([], blk_cnt)
s1_blk_NMC24 = expandTOs([], blk_cnt)

# GRAY
gry_cnt = 11
s1_gry_nuX = expandTOs([0.028487205505371094, 0.031219959259033203, 0.0328984260559082, 0.03413105010986328, 0.03813910484313965, 0.05219006538391113, 0.07533860206604004, 0.24613618850708008, 0.7870800495147705, 2.074509859085083, 2.9359495639801025], gry_cnt)
s1_gry_nuRauto = expandTOs([0.2778890132904053, 0.1587533950805664, 0.16796541213989258, 0.16057181358337402, 0.16588282585144043, 0.1623363494873047, 0.16821551322937012, 0.16235923767089844, 0.1736762523651123, 0.20023822784423828, 0.1725597381591797], gry_cnt)
s1_gry_abc = expandTOs([0.20354056358337402, 0.20216989517211914, 0.20295214653015137, 0.2045755386352539, 0.20316624641418457, 0.20495891571044922, 0.20473122596740723, 0.20406460762023926, 0.20366406440734863, 0.2035989761352539, 0.20226025581359863, ], gry_cnt)
s1_gry_rIC3 = expandTOs([0.016104, 0.019099, 0.023542, 0.018835, 0.031706, 0.054328, 0.055008, 0.028555, 0.02339, 0.052857, 0.051250], gry_cnt)

s1_gry_nuRLin = expandTOs([], gry_cnt)
s1_gry_NMC24 = expandTOs([], gry_cnt)


# i2c
i2c_cnt = 20
s1_i2c_nuX  = expandTOs([0.03220510482788086, 0.06327152252197266, 0.07178544998168945, 0.08001399040222168, 0.07488131523132324, 0.07992339134216309, 0.08086323738098145, 0.0801548957824707, 0.0835564136505127, 0.07710957527160645, 0.08678030967712402, 0.08441424369812012, 0.08884310722351074, 0.0868825912475586, 0.0871572494506836, 0.08854508399963379, 0.09043455123901367, 0.10308980941772461, 0.10687875747680664, 0.11394953727722168], i2c_cnt)
s1_i2c_nuRauto = expandTOs([1.7663791179656982, 105.87663531303406, 118.90071725845337, 240.4509522914886], i2c_cnt)
s1_i2c_abc  = expandTOs([0.20179438591003418, 0.20731186866760254, 0.2038888931274414, 0.20456695556640625, 0.2052443027496338, 0.20425033569335938, 0.20294570922851562, 0.20368361473083496, 0.20373749732971191, 0.20405220985412598, 0.20372390747070312, 0.20392823219299316, 0.20225214958190918, 0.2039346694946289, 0.20373868942260742, 0.2029256820678711, 0.20200562477111816, 0.20387840270996094, 0.20365428924560547, 0.2046515941619873], i2c_cnt)
s1_i2c_rIC3 = expandTOs([0.006740, 0.009313, 0.009707, 0.010384, 0.010978, 0.010272, 0.011302, 0.011129, 0.010628, 0.01047, 0.011205, 0.011712, 0.011265, 0.010844, 0.011590, 0.011379, 0.011512, 0.011779, 0.012454, 0.012307, ], i2c_cnt)

s1_i2c_nuRLin = expandTOs([], i2c_cnt)
s1_i2c_NMC24 = expandTOs([], i2c_cnt)


# LCD 
lcd_cnt = 14
s1_lcd_nuX  = expandTOs([0.25145506858825684, 0.27614569664001465, 0.9953658580780029, 1.1048991680145264, 1.7091083526611328, 4.479804277420044, 4.266952991485596, 6.248399972915649, 7.3617165088653564, 5.656280279159546, 4.607275724411011, 5.52309250831604, 20.552037715911865, 28.355974912643433], lcd_cnt)
s1_lcd_nuRauto = expandTOs([0.5128650665283203, 0.3264446258544922, 0.30274081230163574, 0.34117960929870605, 0.37061524391174316, 0.3987748622894287, 0.28803420066833496, 0.3069283962249756, 0.3363685607910156, 0.3691139221191406, 0.4713418483734131, 0.39830589294433594, 0.3104832172393799, 0.35863399505615234], lcd_cnt)
s1_lcd_abc  = expandTOs([0.21066880226135254, 0.21045780181884766, 0.21100401878356934, 0.2109372615814209, 0.21357488632202148, 0.21436595916748047, 0.21262478828430176, 0.21344304084777832, 0.21528410911560059, 0.21546387672424316, 0.21424627304077148, 0.21981430053710938, 0.21294474601745605, 0.21297001838684082], lcd_cnt)
s1_lcd_rIC3  = expandTOs([0.036005, 0.027823, 0.032893, 0.038528, 0.033411, 0.037832, 0.038458, 0.049394, 0.047238, 0.046504, 0.035337, 0.048160, 0.061216, 0.059325 ], lcd_cnt)

s1_lcd_nuRLin = expandTOs([0.47694849967956543, 0.32758641242980957, 0.3080110549926758, 0.33706140518188477, 0.3930683135986328, 0.4049837589263916, 0.2954704761505127, 0.3185269832611084, 0.34855079650878906, 0.3889145851135254, 0.46347951889038086, 0.41843366622924805, 0.32570672035217285, 0.3658905029296875], lcd_cnt)
s1_lcd_NMC24 = expandTOs([], lcd_cnt)

# Load-Store 
ls_cnt = 16
s1_ls_nuX  = expandTOs([0.0509648323059082, 0.05794501304626465, 0.075775146484375, 0.11185693740844727, 0.14206480979919434, 0.1897737979888916, 0.23723912239074707, 0.27348875999450684, 0.304638147354126, 0.339738130569458, 0.38173818588256836, 0.41564202308654785, 0.763085126876831, 1.4754149913787842, 2.939922332763672, 5.850224733352661], ls_cnt)
s1_ls_nuRauto = expandTOs([0.41113781929016113, 0.20228266716003418, 0.30730128288269043, 0.33927369117736816, 0.466963529586792, 0.283280611038208, 0.6322424411773682, 0.8400535583496094, 0.2710435390472412, 0.3637707233428955, 0.3351452350616455, 0.583369255065918, 0.23598146438598633, 0.6481983661651611, 0.32395505905151367, 0.5367641448974609], ls_cnt)
s1_ls_abc  = expandTOs([0.16795849800109863, 0.27550435066223145, 0.1580209732055664, 0.17001819610595703, 0.15703940391540527, 0.17486238479614258, 0.16205358505249023, 0.16400623321533203, 0.16218185424804688, 0.1723496913909912, 0.16353988647460938, 0.24177074432373047, 0.1740741729736328, 0.2889084815979004, 0.28386616706848145, 0.35938096046447754 ], ls_cnt)
s1_ls_rIC3  = expandTOs([0.360419, 0.068200, 1.704094, 2.025032, 7.966962, 8.945122, 8.807920, 5.746103, 8.982190, 25.382614, 31.722306, 19.187758, 41.803931, 57.713582, 544.234278, 392.297693], ls_cnt)

s1_ls_nuRLin = expandTOs([0.385831356048584, 0.20476365089416504, 0.31664109230041504, 0.36767125129699707, 0.5245709419250488, 0.2997782230377197, 0.7231643199920654, 0.9334118366241455, 0.27675867080688477, 0.3834969997406006, 0.3739781379699707, 0.632312536239624, 0.24758386611938477, 0.702761173248291, 0.34444546699523926, 0.5946049690246582], ls_cnt)
s1_ls_NMC24 = expandTOs([], ls_cnt)


# PWM run again for rIC3
pwm_cnt = 12
s1_pwm_nuX  = expandTOs([0.02416253089904785, 0.024208784103393555, 0.023900985717773438, 0.024380207061767578, 0.024509429931640625, 0.024554729461669922, 0.02503657341003418, 0.025130748748779297, 0.025829076766967773, 0.025946617126464844, 0.02683281898498535, 0.02727341651916504], pwm_cnt)
s1_pwm_nuRauto = expandTOs([0.1724989414215088, 0.04947328567504883, 0.04802656173706055, 0.04743242263793945, 0.04768729209899902, 0.04802346229553223, 0.04824352264404297, 0.048050642013549805, 0.048174381256103516, 0.048285484313964844, 0.0614778995513916, 0.048514366149902344], pwm_cnt)
s1_pwm_abc  = expandTOs([0.20297026634216309, 0.20053815841674805, 0.2037804126739502, 0.20212626457214355, 0.2039783000946045, 0.20295977592468262, 0.20285367965698242, 0.2037642002105713, 0.2034158706665039, 0.20532941818237305, 0.20170831680297852, 0.2013249397277832, ], pwm_cnt)
s1_pwm_rIC3  = expandTOs([30.614694, 140.967785 ], pwm_cnt)

s1_pwm_nuRLin = expandTOs([0.13749337196350098, 0.048207998275756836, 0.04679107666015625, 0.04689598083496094, 0.04818010330200195, 0.04746365547180176, 0.04731035232543945, 0.0469973087310791, 0.047530412673950195, 0.04748988151550293, 0.0554966926574707, 0.049005985260009766], pwm_cnt)
s1_pwm_NMC24 = expandTOs([], pwm_cnt)


# SevenSeg 
sg7_cnt = 15
s1_sg7_nuX  = expandTOs([0.026485919952392578, 0.027287721633911133, 0.02627277374267578, 0.02583479881286621, 0.02816462516784668, 0.02787041664123535, 0.02778792381286621, 0.028392791748046875, 0.029266834259033203, 0.027821063995361328, 0.029692411422729492, 0.029972076416015625, 0.02906203269958496, 0.029578685760498047, 0.03051018714904785], sg7_cnt)
s1_sg7_nuRauto = expandTOs([1.0070040225982666, 0.38071131706237793, 0.8190011978149414, 0.8386368751525879, 0.4952545166015625, 0.9683458805084229, 0.49831604957580566, 0.5077483654022217, 1.374234676361084, 0.8911635875701904, 1.3282899856567383, 0.6289544105529785, 1.1846575736999512, 0.6811075210571289, 1.1774122714996338], sg7_cnt)
s1_sg7_abc  = expandTOs([0.20322465896606445, 0.20216917991638184, 0.20500922203063965, 0.20415544509887695, 0.2048335075378418, 0.2083280086517334, 0.20373797416687012, 0.20432162284851074, 0.2039792537689209, 0.20386362075805664, 0.20335030555725098, 0.2039794921875, 0.20241618156433105, 0.20650196075439453, 0.20310473442077637], sg7_cnt)
s1_sg7_rIC3  = expandTOs([0.014123, 0.011684, 0.012625, 0.012278, 0.011855, 0.013185, 0.016902, 0.018432, 0.013221, 0.012832, 0.019886, 0.018321, 0.013077, 0.013538, 0.014785], sg7_cnt)

s1_sg7_nuRLin = expandTOs([], sg7_cnt)
s1_sg7_NMC24 = expandTOs([], sg7_cnt)

# Thermocouple
tmp_cnt = 17
s1_tmp_nuX  = expandTOs([0.13670802116394043, 0.12762045860290527, 0.1321876049041748, 0.13033080101013184, 0.1330103874206543, 0.13812661170959473, 0.15387892723083496, 0.15154814720153809, 0.1719217300415039, 0.19987225532531738, 0.20703744888305664, 0.2236003875732422, 0.26993274688720703, 0.3136577606201172, 0.6698548793792725, 1.1190507411956787, 2.2157375812530518], tmp_cnt)
s1_tmp_nuRauto = expandTOs([1.6693527698516846, 1.1123542785644531, 0.8234281539916992, 1.6130638122558594, 1.03122878074646, 1.4721012115478516, 0.5413186550140381, 0.7644882202148438, 0.9840390682220459, 0.6656675338745117, 0.8764369487762451, 5.893537282943726, 1.8466308116912842, 3.2567319869995117, 1.3711540699005127, 1.8230266571044922, 2.313070297241211], tmp_cnt)
s1_tmp_abc  = expandTOs([0.20534491539001465, 0.20676946640014648, 0.20702171325683594, 0.20594024658203125, 0.20594072341918945, 0.20744562149047852, 0.2067430019378662, 0.20684289932250977, 0.20652461051940918, 0.2068493366241455, 0.20781159400939941, 0.2064354419708252, 0.20825624465942383, 0.2087104320526123, 0.20874810218811035, 0.20597314834594727, 0.2071232795715332], tmp_cnt)
s1_tmp_rIC3  = expandTOs([0.034273, 0.044671, 0.049309, 0.038676, 0.039184, 0.030906, 0.055089, 0.039886, 0.047346, 0.046265, 0.039274, 0.053286, 0.029117, 0.043906, 0.045405, 0.060698, 0.060678], tmp_cnt)

s1_tmp_nuRLin = expandTOs([], tmp_cnt)
s1_tmp_NMC24 = expandTOs([], tmp_cnt)



# UART Transmit
utt_cnt = 10
s1_utt_nuX  = expandTOs([0.028671979904174805, 0.034505605697631836, 0.038695335388183594, 0.03812742233276367, 0.039617061614990234, 0.0393679141998291, 0.06300663948059082, 0.05139732360839844, 0.05770421028137207, 0.04754972457885742], utt_cnt)
s1_utt_nuRauto = expandTOs([0.3119323253631592, 0.1388852596282959, 0.1126718521118164, 0.10954546928405762, 0.19684100151062012, 0.15983891487121582, 0.18270349502563477, 0.2550504207611084, 0.17252373695373535, 0.2524406909942627], utt_cnt)
s1_utt_abc  = expandTOs([0.20316624641418457, 0.20200610160827637, 0.20441269874572754, 0.20307707786560059, 0.20424580574035645, 0.20276856422424316, 0.2040393352508545, 0.20250630378723145, 0.2026224136352539, 0.20175814628601074 ], utt_cnt)
s1_utt_rIC3  = expandTOs([0.008939, 0.011471, 0.011496, 0.013422, 0.013884, 0.013741, 0.015436, 0.015086, 0.014578, 0.016016, ], utt_cnt)

s1_utt_nuRLin = expandTOs([0.24849414825439453, 0.14696741104125977, 0.11671710014343262, 0.11112427711486816, 0.19961166381835938, 0.16465067863464355, 0.19576168060302734, 0.28318357467651367, 0.19591474533081055, 0.29374146461486816], utt_cnt)
s1_utt_NMC24 = expandTOs([], utt_cnt)


# VGA
vga_cnt = 10
s1_vga_nuX  = expandTOs([0.06713294982910156, 0.06907391548156738, 0.07214021682739258, 0.0728139877319336, 0.07763028144836426, 0.07822680473327637, 0.07791590690612793, 0.07915163040161133, 0.08115911483764648, 0.07885313034057617], vga_cnt)
s1_vga_nuRauto = expandTOs([0.47684359550476074, 0.3039548397064209, 0.41293954849243164, 0.3560950756072998, 0.36209559440612793, 0.502293586730957, 0.24692821502685547, 0.3391289710998535, 0.4585435390472412, 0.4727010726928711], vga_cnt)
s1_vga_abc  = expandTOs([0.21127700805664062, 0.21161794662475586, 0.21359968185424805, 0.21264219284057617, 0.2131795883178711, 0.2154233455657959, 0.21825551986694336, 0.2121140956878662, 0.21495270729064941, 0.21043825149536133], vga_cnt)
s1_vga_rIC3  = expandTOs([0.070781, 0.103693, 0.222877, 0.571716, 0.051595, 0.083528, 2.256614, 0.100665, 4.251688, 2.737361], vga_cnt)

s1_vga_nuRLin = expandTOs([0.2519819736480713, 0.14780139923095703, 0.11790585517883301, 0.11302590370178223, 0.20403528213500977, 0.16955232620239258, 0.19597935676574707, 0.2854301929473877, 0.18563175201416016, 0.2753572463989258], vga_cnt)
s1_vga_NMC24 = expandTOs([], vga_cnt)


# Delay
dly_cnt = 16
s2_dly_nuX = expandTOs([0.035855770111083984, 0.03373551368713379, 0.03897285461425781, 0.049715280532836914, 0.06775212287902832, 0.07076048851013184, 0.08459925651550293, 0.10022592544555664, 0.10588192939758301, 0.11005067825317383, 0.16709375381469727, 0.13437581062316895, 0.22622394561767578, 0.4209771156311035, 0.7972798347473145, 1.5846350193023682], dly_cnt)
s2_dly_nuRauto = expandTOs([0.153350830078125, 0.05619001388549805, 0.03914070129394531, 0.039972543716430664, 0.040157318115234375, 0.0402073860168457, 0.03977155685424805, 0.039470672607421875, 0.0394139289855957, 0.04007411003112793, 0.039743661880493164, 0.03937029838562012, 0.039778709411621094, 0.04022359848022461, 0.040694475173950195, 0.040292978286743164], dly_cnt)
s2_dly_abc = expandTOs([0.20786619186401367, 0.2052764892578125, 0.20773768424987793, 0.20728731155395508, 0.20431971549987793, 0.20490550994873047, 0.2071070671081543, 0.20824790000915527, 0.20830988883972168, 0.20691156387329102, 0.209014892578125, 0.2067854404449463, 0.20767664909362793, 0.20773887634277344, 0.20709013938903809, 0.2072441577911377], dly_cnt)
s2_dly_rIC3 = expandTOs([0.014238, 0.017036, 0.014427, 0.019200, 0.015602, 0.014196, 0.09561, 0.015535, 0.017390, 0.014045, 0.016212, 0.032448, 0.019899, 0.018899, 0.014808, 0.018671], dly_cnt)

s2_dly_nuRLin = expandTOs([0.12399101257324219, 0.046553850173950195, 0.04108095169067383, 0.04114794731140137, 0.04103517532348633, 0.04094433784484863, 0.04107666015625, 0.04222536087036133, 0.041623592376708984, 0.04168534278869629, 0.04176688194274902, 0.041680335998535156, 0.04287910461425781, 0.04228639602661133, 0.042586326599121094, 0.042589664459228516], dly_cnt)
s2_dly_NMC24 = expandTOs([], dly_cnt)


# LCD 
lcd_cnt = 14
s2_lcd_nuX  = expandTOs([0.08562731742858887, 0.08144831657409668, 0.09254002571105957, 0.10640859603881836, 0.10938382148742676, 0.11051201820373535, 0.10692000389099121, 0.11674857139587402, 0.11158943176269531, 0.12675166130065918, 0.11658310890197754, 0.12995624542236328, 0.1296539306640625, 0.13634538650512695], lcd_cnt)
s2_lcd_nuRauto = expandTOs([.3744475841522217, 0.6569976806640625, 1.0379955768585205, 0.7955536842346191, 0.5607647895812988, 1.3121490478515625, 0.6457509994506836, 1.2552368640899658, 1.0464251041412354, 1.0171985626220703, 0.9032928943634033, 1.0433743000030518, 0.7686617374420166, 0.9996068477630615], lcd_cnt)
s2_lcd_abc  = expandTOs([0.22153425216674805, 0.21132516860961914, 0.2135295867919922, 0.21732544898986816, 0.2190854549407959, 2.4600772857666016, 0.21983098983764648, 0.21953105926513672, 0.2198774814605713, 0.2224729061126709, 0.22057104110717773, 0.21986961364746094, 0.22240161895751953, 0.22176361083984375, ], lcd_cnt)
s2_lcd_rIC3  = expandTOs([0.058625, 0.631883, 0.042001, 3.877619, 0.047090, 0.072890, 13.451935, 0.060017, 0.062747, 0.056944, 0.048412, 2.489278, 13.851578, 15.699633 ], lcd_cnt)

s2_lcd_nuRLin = expandTOs([], lcd_cnt)
s2_lcd_NMC24 = expandTOs([], lcd_cnt)


# VGA
vga_cnt = 10
s2_vga_nuX  = expandTOs([0.06481814384460449, 0.06937694549560547, 0.0728764533996582, 0.0722649097442627, 0.07763266563415527, 0.07785964012145996, 0.07830095291137695, 0.07979655265808105, 0.0817258358001709, 0.0798332691192627], vga_cnt)
s2_vga_nuRauto = expandTOs([0.39482593536376953, 0.2528114318847656, 0.23386526107788086, 0.1909198760986328, 0.3700594902038574, 0.22572565078735352, 0.2738068103790283, 0.3073461055755615, 0.4390859603881836, 0.4481022357940674], vga_cnt)
s2_vga_abc  = expandTOs([0.21104025840759277, 0.21220970153808594, 0.21236443519592285, 0.21164941787719727, 0.21162819862365723, 0.2145519256591797, 0.2128918170928955, 0.21032929420471191, 0.2203993797302246, 0.21414422988891602], vga_cnt)
s2_vga_rIC3 = expandTOs([0.741910, 1.039069, 1.300450, 4.892160, 1.554558, 4.274453, 1.485458, 4.324625, 2.890368, 9.708955], vga_cnt)

s2_vga_nuRLin = expandTOs([0.3550150394439697, 0.2513723373413086, 0.22853374481201172, 0.1913280487060547, 0.3770108222961426, 0.22873544692993164, 0.27897119522094727, 0.3111906051635742, 0.43951940536499023, 0.44438767433166504], vga_cnt)
s2_vga_NMC24 = expandTOs([], vga_cnt)


#================================================================
#				    **** LIVENESS DATA ****
#================================================================

# Delay 
dly_cnt = 16
l1_dly_nuX = expandTOs([0.03858232498168945, 0.043894052505493164, 0.05910849571228027, 0.0926969051361084, 0.1255333423614502, 0.15096020698547363, 0.18881964683532715, 0.2095508575439453, 0.2628519535064697, 0.2704277038574219, 0.34399986267089844, 0.35773706436157227, 0.663055419921875, 1.3621790409088135, 2.875823974609375, 5.805109262466431], dly_cnt)
l1_dly_nuRauto = expandTOs([0.1820521354675293, 0.037711143493652344, 0.031456947326660156, 0.03102278709411621, 0.031060457229614258, 0.03165626525878906, 0.03174400329589844, 0.03126811981201172, 0.03186917304992676, 0.03231644630432129, 0.031545400619506836, 0.03229641914367676, 0.03207111358642578, 0.03223848342895508, 0.0326237678527832, 0.032662391662597656], dly_cnt)
l1_dly_abc = expandTOs([52.81676125526428, 564.9397447109222, 726.9786138534546, 5770.074857234955, time_out_time, time_out_time], dly_cnt)
l1_dly_rIC3 = expandTOs([37.012008, 77.063933, 231.928165, 1268.979428, 1342.776991, 1277.026380, 3595.838801, 7066.637570, time_out_time, time_out_time, time_out_time, time_out_time], dly_cnt)

l1_dly_nuRLin = expandTOs([0.11588644981384277, 0.0333409309387207, 0.03453993797302246, 0.03407931327819824, 0.032985687255859375, 0.032898664474487305, 0.033522605895996094, 0.03421354293823242, 0.033736228942871094, 0.033066511154174805, 0.03326416015625, 0.031975746154785156, 0.033455848693847656, 0.03229331970214844, 0.03293943405151367, 0.033092498779296875], dly_cnt)
l1_dly_NMC24 = expandTOs([33.142608404159546, 28.224438905715942, 50.512372970581055, 50.623450756073, 61.64803767204285, 106.9015371799469, 128.28470134735107, 103.46116971969604, 130.99651098251343, 171.07259607315063, 232.0998523235321, 318.29369950294495, 379.26619005203247, 720.8686738014221, 2354.5325870513916, 5512.056367397308], dly_cnt)

# GRAY
gry_cnt = 11
l1_gry_nuX = expandTOs([0.06020188331604004, 0.3721311092376709, 0.27810215950012207, 0.08218622207641602, 0.13409090042114258, 0.2946465015411377, 0.5579447746276855, 107.23641896247864, 78.01766967773438, 237.11850309371948, 269.44686007499695], gry_cnt)
l1_gry_nuRauto = expandTOs([0.7308735847473145, 0.3076820373535156, 1.0622432231903076, 0.37218189239501953, 0.8532602787017822, 0.9010670185089111, 6.59437108039856, 0.456073522567749, 1.2172880172729492, 1.058197259902954, 1.376407861709594], gry_cnt)
l1_gry_abc = expandTOs([9.093504428863525, 46.07087826728821, 153.71570253372192, 761.8900926113129, 4900.288044691086, time_out_time], gry_cnt)
l1_gry_rIC3 = expandTOs([2.985693, 15.195640, 247.860769, 31.150507, 405.761667, 3866.110153, 1591.693535, time_out_time], gry_cnt)

l1_gry_nuRLin = expandTOs([], gry_cnt)
l1_gry_NMC24 = expandTOs([18.547565698623657, 16.8611843585968, 16.856225967407227, 39.80517816543579, 44.001333236694336, 92.80047273635864, 110.75677442550659, 137.99051308631897, 395.6424617767334, 1167.6637978553772, 3676.166624069214], gry_cnt)

# Blink
blk_cnt = 25
l1_blk_nuX = expandTOs([0.20348644256591797, 0.7469120025634766, 2.9582931995391846, 12.255648136138916, 52.02224063873291, 233.53709721565247, 1120.0086522102356, 4709.863304615021, 19534.7850959301, 76639.16440010071], blk_cnt)
l1_blk_nuRauto = expandTOs([0.9449403285980225, 0.9981272220611572, 1.666778564453125, 1.7056868076324463, 2.7824950218200684, 9.530980348587036, 8.320268630981445, 16.344488859176636, 4.3548877239227295, 7.665502548217773, 30.11214280128479, 72.0486855506897, 245.78235173225403, time_out_time, 19.513662815093994], blk_cnt)
l1_blk_abc = expandTOs([35.8149528503418, 66.75948667526245, 347.20376467704773, 2803.237073659897, 14454.793749332428, time_out_time], blk_cnt)
l1_blk_rIC3 = expandTOs([1.934547, 13.496018, 36.711218, 87.42926, 1682.473349, 8977.317654, time_out_time], blk_cnt)

l1_blk_nuRLin = expandTOs([], blk_cnt)
l1_blk_NMC24 = expandTOs([], blk_cnt)

# i2c 
i2c_cnt = 20 
l1_i2c_nuX  = expandTOs([0.03444051742553711, 6.603396415710449, 28.84437322616577, 148.1797616481781, 384.2525441646576, 774.3364906311035, 1428.4818439483643, 2079.552573442459, 3013.920620203018, 3926.971701145172, 5226.788523197174, 6515.364369392395, 8644.015457391739, 9734.912023067474, 11589.00191450119, 13452.82740688324, 28774.11834716797], i2c_cnt)
l1_i2c_nuRauto = expandTOs([0.23960375785827637, 0.2344222068786621, 0.5024683475494385, 0.7664930820465088, 1.6159818172454834, 1.074380874633789, 1.0656342506408691, 0.38210272789001465, 1.7419791221618652, 1.1966755390167236, 1.9505040645599365, 0.7063443660736084, 0.5732753276824951, 0.1426374912261963, 0.6379601955413818, 0.22470617294311523, 1.0062706470489502, 0.6336245536804199, 0.21230435371398926, 0.2112429141998291], i2c_cnt)
l1_i2c_abc  = expandTOs([0.3360428810119629, 240.90265583992004, 2868.292138338089, 5793.218767166138, time_out_time], i2c_cnt)
l1_i2c_rIC3 = expandTOs([0.034007, 83.836941, 298.736378, 1017.248208, 468.575576, 6182.047328, 2398.229328, time_out_time, time_out_time], i2c_cnt)

l1_i2c_nuRLin = expandTOs([0.16737055778503418, 0.24044132232666016, 0.5080084800720215, 0.7773902416229248, 1.630124807357788, 1.0851109027862549, 1.0851843357086182, 0.39199018478393555, 1.7585275173187256, 1.2010886669158936, 1.9833178520202637, 0.7360005378723145, 0.6174013614654541, 0.15785646438598633, 0.6515707969665527, 0.23308110237121582, 1.0420727729797363, 0.6508116722106934, 0.21386265754699707, 0.21194005012512207], i2c_cnt)
l1_i2c_NMC24 = expandTOs([30.421859979629517, 60.24652934074402, 61.04117488861084, 96.05848360061646, 94.39399218559265, 120.17194366455078, 151.4361674785614, 127.52948522567749, 167.12311053276062, 157.93316912651062, 256.57208943367004, 269.6943769454956, 341.36149549484253, 161.46304655075073, 346.8461890220642, 313.06346797943115, 375.58633065223694, 494.4127607345581, 663.005077123642, 837.7209513187408], i2c_cnt)


# LCD 
lcd_cnt = 14
l1_lcd_nuX  = expandTOs([0.294205904006958, 0.4565448760986328, 4.070156097412109, 5.791097164154053, 11.818007469177246, 37.69225549697876, 31.16353726387024, 204.16739344596863, 492.9008948802948, 412.6497838497162, 56.004955530166626, 472.2407350540161, 10342.991541147232, 24939.541664361954], lcd_cnt)
l1_lcd_nuRauto = expandTOs([0.3565652370452881, 0.3065760135650635, 0.27588748931884766, 0.7420730590820312, 0.3283042907714844, 0.36271047592163086, 0.5228474140167236, 0.3989236354827881, 0.7657566070556641, 0.9376893043518066, 0.36278533935546875, 1.9138119220733643, 0.43732547760009766, 0.35239744186401367], lcd_cnt)
l1_lcd_abc  = expandTOs([80.1956059932708, 584.3537640571594, 2718.2183356285095, 4044.9913759231567, 10538.425052404404, time_out_time, time_out_time, ], lcd_cnt)
l1_lcd_rIC3 = expandTOs([21.380294, 273.710352, 132.995878, 1915.442628, 1633.804799, 6290.475717, 15331.225266, time_out_time ], lcd_cnt)

l1_lcd_nuRLin = expandTOs([0.31187009811401367, 0.3140909671783447, 0.28568387031555176, 0.7593679428100586, 0.37121033668518066, 0.37495970726013184, 0.5300300121307373, 0.4059882164001465, 0.7774059772491455, 0.9497027397155762, 0.3745756149291992, 1.9331865310668945, 0.4455265998840332, 0.36534762382507324], lcd_cnt)
l1_lcd_NMC24 = expandTOs([38.69275164604187, 33.29680895805359, 30.031394243240356], lcd_cnt)

# Load-Store 
ls_cnt = 16
l1_ls_nuX  = expandTOs([1.6054527759552002, 4.810068130493164, 20.314061164855957, 102.05252051353455, 249.60309600830078, 471.7980365753174, 805.2205119132996, 1235.2471702098846, 1503.7248983383179, 2084.5889797210693, 2678.038686990738, 3579.0402660369873, 18005.165501356125, 75758.71285104752], ls_cnt)
l1_ls_nuRauto = expandTOs([], ls_cnt)
l1_ls_abc  = expandTOs([640.1963376998901, 2346.673709869384, 11504.12538266182, time_out_time, time_out_time, time_out_time], ls_cnt)
l1_ls_rIC3 = expandTOs([26.391330, 86.038438, 362.320688, 5594.982138, 2384.866210, 8062.983294, 15719.984298, time_out_time], ls_cnt)

l1_ls_nuRLin = expandTOs([], ls_cnt)
l1_ls_NMC24 = expandTOs([48.275370836257935, 34.965832471847534, 42.31152033805847, 106.04925894737244, 112.62324500083923, 169.52160620689392, 188.35367012023926, 202.51686215400696, 257.3043668270111, 271.76443219184875, 288.1831359863281, 384.57205271720886, 890.4164361953735, 1987.7501029968262, 11739.237475395203], ls_cnt)


# PWM
pwm_cnt = 12
l1_pwm_nuX  = expandTOs([1.121885061264038, 4.756253242492676, 20.443345546722412, 93.568687915802, 449.07849884033203, 2330.4829449653625, 11272.547907114029, 50947.01918411255], pwm_cnt)
l1_pwm_nuRauto = expandTOs([0.1843869686126709, 0.03134727478027344, 0.026205778121948242, 0.02596426010131836, 0.026117563247680664, 0.024770736694335938, 0.025197744369506836, 0.025294065475463867, 0.02504873275756836, 0.025536060333251953, 0.02568960189819336, 0.02515578269958496], pwm_cnt)
l1_pwm_abc  = expandTOs([404.2903542518616, 1697.7754015922546, 15111.163884401321, time_out_time, time_out_time, time_out_time], pwm_cnt)
l1_pwm_rIC3 = expandTOs([69.288988, 335.547083, 2754.884848, 14829.204219, time_out_time, time_out_time, time_out_time], pwm_cnt)

l1_pwm_nuRLin = expandTOs([0.11696052551269531, 0.02665114402770996, 0.025511741638183594, 0.025599956512451172, 0.025943279266357422, 0.025754690170288086, 0.025829076766967773, 0.025763511657714844, 0.025660276412963867, 0.026302099227905273, 0.026874780654907227, 0.026729106903076172], pwm_cnt)
l1_pwm_NMC24 = expandTOs([24.23664093017578, 42.04116415977478, 58.512532472610474, 44.84540557861328, 126.76409840583801, 113.02721977233887, 358.5179841518402, 417.5405797958374, 1070.8891837596893, 2368.7655050754547], pwm_cnt)


# SevenSeg 
sg7_cnt = 15
l1_sg7_nuX  = expandTOs([0.034978389739990234, 0.04037141799926758, 0.048209190368652344, 0.05679821968078613, 4.974998235702515, 0.1647951602935791, 0.25991201400756836, 0.26950740814208984, 0.42387986183166504, 0.4771754741668701, 0.5853619575500488, 0.5914876461029053, 1.1646289825439453, 2.4711692333221436, 6.400533199310303], sg7_cnt)
l1_sg7_nuRauto = expandTOs([0.2293562889099121, 0.13264679908752441, 0.19655466079711914, 0.16145873069763184, 0.36763834953308105, 0.37853050231933594, 0.9606165885925293, 0.5487508773803711, 1.2532978057861328, 1.6010489463806152, 0.42777132987976074, 0.8720571994781494, 0.23895812034606934, 0.20140457153320312, 1.7664299011230469], sg7_cnt)
l1_sg7_abc  = expandTOs([26.98600482940674, 112.37078261375427, 491.5962383747101, 994.8423466682434, 3360.214072704315, time_out_time], sg7_cnt)
l1_sg7_rIC3 = expandTOs([4.787272, 7.440081, 15.092347, 49.300561, 129.970410, 916.244823, 6460.068406, 7263.168276, 3023.584808, time_out_time, time_out_time, time_out_time], sg7_cnt)

l1_sg7_nuRLin = expandTOs([0.17786288261413574, 0.13507938385009766, 0.20068979263305664, 0.16446709632873535, 0.371584415435791, 0.3843691349029541, 0.9731857776641846, 0.5526218414306641, 1.2612051963806152, 1.6041102409362793, 0.43308115005493164, 0.8818380832672119, 0.24434208869934082, 0.20656776428222656, 1.7726540565490723], sg7_cnt)
l1_sg7_NMC24 = expandTOs([19.747166872024536, 16.273811101913452, 30.917808771133423, 29.817863702774048, 55.70861601829529, 49.672282457351685, 89.93308591842651, 84.24337601661682, 185.88687205314636, 190.747150182724, 169.86813163757324, 154.16046714782715, 339.13406920433044, 607.764741897583, 1549.0940222740173], sg7_cnt)

# Thermocouple 
tmp_cnt = 17
l1_tmp_nuX  = expandTOs([0.09305500984191895, 0.09789419174194336, 0.11313843727111816, 0.1199498176574707, 0.11958789825439453, 0.127716064453125, 0.14728593826293945, 0.15805864334106445, 0.19266963005065918, 0.24492573738098145, 0.27913856506347656, 0.32689380645751953, 0.3872370719909668, 0.6203105449676514, 1.2878413200378418, 2.5881354808807373, 5.400800704956055], tmp_cnt)
l1_tmp_nuRauto = expandTOs([0.2225971221923828, 0.076995849609375, 0.06920886039733887, 0.0680382251739502, 0.06851458549499512, 0.07269072532653809, 0.07240653038024902, 0.06174039840698242, 0.07313179969787598, 0.07404160499572754, 0.07093286514282227, 0.07039022445678711, 0.06328701972961426, 0.07461762428283691, 0.07545971870422363, 0.06410598754882812, 0.07559442520141602], tmp_cnt)
l1_tmp_abc  = expandTOs([0.3927152156829834, 12.136533498764038, 91.64498901367188, 144.86973094940186, 161.4782907962799, 769.8558423519135, 1153.1309323310852, 1517.6024599075317, 9489.68583035469, time_out_time, time_out_time, time_out_time, time_out_time], tmp_cnt)
l1_tmp_rIC3 = expandTOs([0.124131, 5.417660, 7.543899, 35.531700, 53.02105, 27.295537, 175.728068, 72.321800, 213.087745, 942.027022, 2434.084249, 10696.058512, 5530.157569, time_out_time], tmp_cnt)

l1_tmp_nuRLin = expandTOs([0.16865038871765137, 0.08428812026977539, 0.07246112823486328, 0.07220005989074707, 0.07268977165222168, 0.07370948791503906, 0.07509946823120117, 0.06285572052001953, 0.07411074638366699, 0.07494354248046875, 0.0735318660736084, 0.07366490364074707, 0.0646514892578125, 0.07605504989624023, 0.07895541191101074, 0.06605815887451172, 0.0756831169128418], tmp_cnt)
l1_tmp_NMC24 = expandTOs([20.96560001373291, 72.52162480354309, 119.09860014915466, 117.99782848358154, 113.66848492622375, 165.08317804336548, 212.8567032814026, 270.5074551105499, 291.9272165298462, 392.30703234672546], tmp_cnt)



# UART Transmit 
utt_cnt = 10
l1_utt_nuX  = expandTOs([0.028980016708374023, 0.03595304489135742, 0.05397486686706543, 0.07598686218261719, 0.038587331771850586, 0.048345088958740234, 0.17232751846313477, 0.1130831241607666, 0.09701776504516602, 0.06869721412658691], utt_cnt)
l1_utt_nuRauto = expandTOs([0.23276019096374512, 0.17168974876403809, 0.18857502937316895, 0.1976454257965088, 0.4787912368774414, 0.7879183292388916, 1.8245019912719727, 0.27731990814208984, 0.23956751823425293, 0.26810359954833984], utt_cnt)
l1_utt_abc  = expandTOs([0.15180468559265137, 0.24730229377746582, 0.18385791778564453, 0.25693559646606445, 0.2903592586517334, 0.35848569869995117, 0.16197609901428223, 0.2789297103881836, 0.31107664108276367, 0.2935307025909424], utt_cnt)
l1_utt_rIC3 = expandTOs([0.021066, 0.027122, 0.031449, 0.037123, 0.050425, 0.063636, 0.070670, 0.090473, 0.171379, 0.059471], utt_cnt)

l1_utt_nuRLin = expandTOs([0.1856553554534912, 0.18337583541870117, 0.20201539993286133, 0.21711492538452148, 0.5007882118225098, 0.804732084274292, 1.8336544036865234, 0.29688119888305664, 0.24251961708068848, 0.2903616428375244], utt_cnt)
l1_utt_NMC24 = expandTOs([30.887571573257446, 28.128801345825195, 108.91433262825012, 56.40873885154724, 2421.5109124183655, 2690.8935346603394, 185.5976004600525, 1773.2656621932983, 3268.543028116226, 66.85275506973267], utt_cnt)


# VGA 
vga_cnt = 10
l1_vga_nuX  = expandTOs([15.617372989654541, 615.1072981357574, 12101.096885204315, 14086.527141094208, 72296.93351435661, time_out_time], vga_cnt)
l1_vga_nuRauto = expandTOs([0.24695873260498047, 0.10921978950500488, 0.11446380615234375, 0.15965533256530762, 0.11236214637756348, 0.1210944652557373, 0.22419166564941406, 0.10716795921325684, 0.10934782028198242, 0.11361265182495117], vga_cnt)
l1_vga_abc  = expandTOs([15.893747806549072, 137.43080592155457, 1045.6370599269867, 5268.028206586838, 11656.880952119827, time_out_time, time_out_time], vga_cnt)
l1_vga_rIC3 = expandTOs([7.939453, 87.590720, 381.229065, 427.471130, 1871.410127, 15091.337718, time_out_time], vga_cnt)

l1_vga_nuRLin = expandTOs([0.1906590461730957, 0.11314058303833008, 0.12200474739074707, 0.16602540016174316, 0.11653876304626465, 0.12760567665100098, 0.23088407516479492, 0.11056685447692871, 0.11414718627929688, 0.11742115020751953], vga_cnt)
l1_vga_NMC24 = expandTOs([112.90812277793884, 153.31058955192566, 173.0646436214447, 208.63280987739563, 238.922372341156, 262.9045081138611, 372.58693051338196, 402.05338621139526, 419.32613611221313], vga_cnt)


# Delay 2 
dly2_cnt = 16
l2_dly_nuX  = expandTOs([0.044739484786987305, 0.050733089447021484, 0.07141399383544922, 0.1150808334350586, 0.16736340522766113, 0.19897937774658203, 0.2627253532409668, 0.30222582817077637, 0.3645174503326416, 0.3837718963623047, 0.515207052230835, 0.5056741237640381, 1.0071766376495361, 1.993692398071289, 4.151374101638794, 8.432751893997192], dly2_cnt)
l2_dly_nuRauto = expandTOs([0.18658137321472168, 0.040488481521606445, 0.04027557373046875, 0.0404055118560791, 0.04105997085571289, 0.040448665618896484, 0.041391849517822266, 0.04105782508850098, 0.04082846641540527, 0.04126906394958496, 0.04246807098388672, 0.041217803955078125, 0.0426332950592041, 0.1909177303314209, 0.20612263679504395, 0.06028127670288086], dly2_cnt)
l2_dly_abc  = expandTOs([64.97111511230469, 237.33797025680542, 754.6549825668335, 9445.491074323654, time_out_time], dly2_cnt)
l2_dly_rIC3 = expandTOs([31.387707, 86.040150, 313.896153, 1256.240674, 4845.118030, 6323.238493, time_out_time], dly2_cnt)

l2_dly_nuRLin = expandTOs([0.15436744689941406, 0.04199671745300293, 0.04062318801879883, 0.040789127349853516, 0.04107522964477539, 0.04157066345214844, 0.04195117950439453, 0.04218149185180664, 0.042685508728027344, 0.04303145408630371, 0.0430448055267334, 0.04261922836303711, 0.04343605041503906, 0.19640183448791504, 0.20962309837341309, 0.06281065940856934], dly2_cnt)
l2_dly_NMC24 = expandTOs([85.81671452522278, 87.87318420410156, 93.09430313110352, 143.01677536964417, 196.55076551437378, 275.9576370716095, 279.8107876777649, 330.4914000034332, 1722.6971261501312, 525.6187536716461, 268.56938338279724, 638.2461733818054, 1114.4637560844421, 6472.060342788696, 6643.428668022156, 10420.99836063385], dly2_cnt)


# GRAY 2 
gry2_cnt = 11
l2_gry_nuX = expandTOs([0.060816287994384766, 0.38780975341796875, 0.3099837303161621, 0.08414673805236816, 0.1445009708404541, 0.32990431785583496, 0.6149857044219971, 107.18673157691956, 83.59595227241516, 277.0287070274353, 280.8156671524048], gry_cnt)
l2_gry_nuRauto = expandTOs([1.0214447975158691, 1.8455872535705566, 0.7426412105560303, 0.42804861068725586, 0.9705495834350586, 0.5909030437469482, 1.7340922355651855, 2.6277480125427246, 5.040562629699707, 4.16300892829895, 6.966182470321655], gry_cnt)
l2_gry_abc = expandTOs([11.704928159713745, 56.93130135536194, 158.28838849067688, 933.1001751422882, 13774.513096809387, time_out_time], gry_cnt)
l2_gry_rIC3 = expandTOs([4.396740, 12.683893, 28.945380, 250.254025, 1467.145741, 1129.935748, time_out_time], gry_cnt)

l2_gry_nuRLin = expandTOs([], gry_cnt)
l2_gry_NMC24 = expandTOs([43.616421937942505, 76.18716502189636, 142.89978528022766, 157.71475172042847, 185.83244013786316, 227.69621682167053, 598.0651893615723, 886.9436786174774, 1488.3242809772491, 3474.1113085746765, 6322.1831407547], gry_cnt)


# SevenSeg 2 

sg7_2_cnt = 15
l2_sg7_nuX  = expandTOs([0.20152568817138672, 0.7520303726196289, 1.7193753719329834, 3.3729372024536133, 4333.2171149253845, 111.15795183181763, 277.4801518917084, 425.17749857902527, 834.4584817886353, 1192.985743522644, 1719.1422214508057, 2197.304788827896, 10749.362680196762], sg7_cnt)
l2_sg7_nuRauto = expandTOs([0.26705002784729004, 0.2275395393371582, 0.33928608894348145, 0.5982437133789062, 0.766362190246582, 1.245844841003418, 1.527402639389038, 1.2495887279510498, 1.9190568923950195, 2.679857015609741, 2.6851606369018555, 1.6777031421661377, 1.382328987121582, 2.9970216751098633, 8.870852708816528], sg7_cnt)
l2_sg7_abc  = expandTOs([16.485806703567505, 174.560382604599, 231.25437235832214, 660.5579659938812, 5915.274455070496, time_out_time], sg7_cnt)
l2_sg7_rIC3 = expandTOs([6.692541, 20.396385, 48.473444, 57.676712, 131.957938, 1126.632400, 1418.323362, 2475.430093, time_out_time, time_out_time, time_out_time], sg7_cnt)

l2_sg7_nuRLin = expandTOs([0.21613430976867676, 0.22999286651611328, 0.3440070152282715, 0.6170017719268799, 0.7720816135406494, 1.2674305438995361, 1.535715103149414, 1.2784628868103027, 1.9676554203033447, 2.7376790046691895, 2.695441246032715, 1.6977324485778809, 1.397303581237793, 3.0777101516723633, 8.902519226074219], sg7_cnt)
l2_sg7_NMC24 = expandTOs([32.59631133079529, 65.11694240570068, 49.167938470840454, 60.45397233963013, 82.73022103309631, 164.59725713729858, 135.87106490135193, 172.88807773590088, 466.1614201068878, 155.64796566963196, 261.82570934295654, 240.37607979774475, 401.6879711151123, 1305.6200485229492, 1881.4033274650574], sg7_cnt)


# GRAY 3
gry3_cnt = 11
l3_gry_nuX = expandTOs([0.06513714790344238, 0.415332555770874, 0.30843067169189453, 0.09635686874389648, 0.144881010055542, 0.3339526653289795, 0.617943525314331, 114.27715158462524, 87.90371942520142, 284.46486496925354, 275.22217869758606], gry_cnt)
l3_gry_nuRauto = expandTOs([1.07747220993042, 0.5654995441436768, 0.50299072265625, 7.7356085777282715, 0.9643089771270752, 0.5485901832580566, 0.8032903671264648, 1.6421418190002441, 2.0104048252105713, 3.268519163131714, 0.760272264480590], gry_cnt)
l3_gry_abc = expandTOs([11.883198022842407, 50.38086175918579, 189.1870834827423, 876.1393022537231, 3749.8298873901367, 17187.989867925644], gry_cnt)
l3_gry_rIC3 = expandTOs([4.406329, 65.035841, 74.691875, 73.728797, 134.922855, 406.398138, time_out_time], gry_cnt)

l3_gry_nuRLin = expandTOs([], gry_cnt)
l3_gry_NMC24 = expandTOs([49.143126010894775, 43.062296628952026, 76.65219020843506, 93.79826879501343, 93.26754188537598, 147.6376793384552, 403.2260127067566, 506.5884392261505, 1122.503969669342, 2657.1565721035004, 5395.314639806747], gry_cnt)

#================================================================
#				    **** SAFETY + LIVENESS DATA ****
#================================================================

# Delay 
dly_cnt = 16
sl1_dly_nuX = expandTOs([1.7292490005493164, 4.787796974182129, 19.22469210624695, 83.21119499206543, 204.8928666114807, 371.80931854248047, 631.6776416301727, 910.5519087314606, 1385.0180158615112, 1797.944359779358, 2398.681429862976, 2701.039211511612, 10678.077184677124, 42514.581857442856], dly_cnt)
sl1_dly_nuRauto = expandTOs([0.18473052978515625, 0.041895151138305664, 0.03940129280090332, 0.05243825912475586, 0.05246758460998535, 0.052590370178222656, 0.05168271064758301, 0.05254220962524414, 0.052313804626464844, 0.05188345909118652, 0.05231595039367676, 0.05159592628479004, 0.05257105827331543, 0.05304265022277832, 0.05233025550842285, 0.053550004959106445], dly_cnt)
sl1_dly_abc = expandTOs([102.55855369567871, 169.51924467086792, 3021.908792257309, time_out_time, time_out_time, time_out_time], dly_cnt)
sl1_dly_rIC3 = expandTOs([31.117752, 149.269840, 103.751338, 2118.283859, 5719.951826, 12213.000891, 3803.623064, 6102.548705, 7060.669075, time_out_time, time_out_time, time_out_time, time_out_time, time_out_time, time_out_time, time_out_time], dly_cnt)

sl1_dly_nuRLin = expandTOs([0.13135457038879395, 0.03938698768615723, 0.03918719291687012, 0.051286935806274414, 0.05103588104248047, 0.05591082572937012, 0.05390667915344238, 0.053985595703125, 0.052822113037109375, 0.05346226692199707, 0.05359792709350586, 0.052687644958496094, 0.05365467071533203, 0.0538175106048584, 0.05521082878112793, 0.05471086502075195], dly_cnt)
sl1_dly_NMC24 = expandTOs([], dly_cnt)


# GRAY
gry_cnt = 11
sl1_gry_nuX = expandTOs([0.41520261764526367, 9.054845333099365, 69.31888699531555, 12.910959243774414, 58.23894762992859, 294.70810770988464, 1497.8905620574951, time_out_time], gry_cnt)
sl1_gry_nuRauto = expandTOs([8.841725826263428, 10.621649980545044, 1.7817742824554443, 13.130027294158936, 5.810837268829346, 5.406471490859985, 5.963604688644409, 6.013225555419922, 4.281418800354004, 150.70747542381287, 56.194823026657104], gry_cnt)
sl1_gry_abc = expandTOs([15.041693687438965, 47.69937181472778, 226.95616006851196, 805.8360583782196, 2851.1884157657623, time_out_time], gry_cnt)
sl1_gry_rIC3 = expandTOs([7.325388, 27.489362, 178.684433, 87.670327, 2182.269180, 1214.882218, 4598.162350, time_out_time, time_out_time], gry_cnt)

sl1_gry_nuRLin = expandTOs([], gry_cnt)
sl1_gry_NMC24 = expandTOs([], gry_cnt)

                         
# Blink
blk_cnt = 25
sl1_blk_nuX = expandTOs([0.03417515754699707, 0.0427858829498291, 0.06595182418823242, 0.10881900787353516, 0.20556354522705078, 0.38326072692871094, 0.8114974498748779, 1.6132688522338867, 3.3303651809692383, 7.0069122314453125, 14.441313982009888, 30.24952721595764, 62.42170310020447, 127.46393465995789, 257.7595865726471, 542.9728240966797, 1096.922466993332, 2231.5499897003174, 4643.489197731018, 14560.58609175682, 29857.629811525345], blk_cnt)
sl1_blk_nuRauto = expandTOs([.964860439300537, 5.905908823013306, 5.640369892120361, 6.513334274291992, 5.02116584777832, 4.898184776306152, 65.59291481971741, 35.11016821861267, 10.663327693939209, 6.603809356689453, 232.5495011806488], blk_cnt)
sl1_blk_abc = expandTOs([29.518478870391846, 197.20607089996338, 306.40212988853455, 1418.3008472919464, time_out_time ], blk_cnt)
sl1_blk_rIC3 = expandTOs([2.863051, 5.738666, 23.398129, 51.980885, 216.760681, 9056.518843, time_out_time, time_out_time], blk_cnt)

sl1_blk_nuRLin = expandTOs([], blk_cnt)
sl1_blk_NMC24 = expandTOs([], blk_cnt)

                         
# i2c 
i2c_cnt = 20
sl1_i2c_nuX  = expandTOs([0.03676557540893555, 4.553584098815918, 23.107648372650146, 117.79312586784363, 315.8290045261383, 608.2991058826447, 1125.7549231052399, 1690.0247514247894, 2524.031901359558, 3462.4616408348083, 3841.4925231933594, 4829.832211971283, 6069.188185930252, 6994.100030183792, 8677.539034366608, 9745.384610176086, 19462.996284484863], i2c_cnt)
sl1_i2c_nuRauto = expandTOs([1.5677900314331055, 160.68709778785706, time_out_time, time_out_time, 152.25655937194824], i2c_cnt)
sl1_i2c_abc  = expandTOs([0.20504283905029297, 0.2060842514038086, 0.27633023262023926, 0.2037193775177002, 0.2029111385345459, 0.20253467559814453, 0.20151376724243164, 0.2904167175292969, 0.2035987377166748, 0.31121253967285156, 0.2032921314239502, 0.20166373252868652, 0.20170140266418457, 0.20237421989440918, 0.20443272590637207, 0.2018592357635498, 0.20156121253967285, 0.20600271224975586, 0.20177888870239258, 0.20352768898010254], i2c_cnt)
sl1_i2c_rIC3  = expandTOs([0.007715, 0.010700, 0.010843, 0.011615, 0.012414, 0.011581, 0.012293, 0.012905, 0.012513, 0.011770, 0.012503, 0.012460, 0.012495, 0.012518, 0.012489, 0.012598, 0.012418, 0.013207, 0.013494, 0.014089], i2c_cnt)

sl1_i2c_nuRLin = expandTOs([], i2c_cnt)
sl1_i2c_NMC24 = expandTOs([], i2c_cnt)


# LCD 
lcd_cnt = 14
sl1_lcd_nuX  = expandTOs([0.42185187339782715, 1.0941195487976074, 155.84505581855774, 254.17631769180298, 920.0847549438477, 4137.775183439255, 5514.220568656921, 11444.991988897324, 14072.311669826508, 12712.871897220612, 11038.950852394104, 13464.882939338684, time_out_time], lcd_cnt)
sl1_lcd_nuRauto = expandTOs([4.083368301391602, 2.4129116535186768, 2.434457778930664, 25.61070489883423, 56.045276165008545, 43.606531620025635, 22.01821231842041, 14.778889179229736, 65.98915410041809, 7.844622611999512, 38.882078409194946, 111.05659461021423, 75.3249180316925, 23.06046986579895], lcd_cnt)
sl1_lcd_abc  = expandTOs([6.593155145645142, 22.43172001838684, 6.443439483642578, 37.680256843566895, 120.49959802627563, 165.30602431297302, 865.1579794883728, 1215.877696275711, 6671.829730272293, 5972.260271787643, 3104.6372051239014, 1546.902185201645, time_out_time, time_out_time], lcd_cnt)
sl1_lcd_rIC3 = expandTOs([1.453007, 4.345255, 8.340851, 16.041042, 20.458806, 50.373557, 55.347371, 92.170681, 117.447679, 95.610273, 153.708522, 522.703883, 2649.344316, 15678.898932], lcd_cnt)

sl1_lcd_nuRLin = expandTOs([], lcd_cnt)
sl1_lcd_NMC24 = expandTOs([], lcd_cnt)

# Load-Store 
ls_cnt = 16
sl1_ls_nuX  = expandTOs([9.02592921257019, 29.618873119354248, 138.8334903717041, 683.9999680519104, 1963.4309377670288, 3592.623198747635, 5638.029273033142, 8186.455895900726, 10231.762048244476, 12537.487889766693, 16950.866082191467, 22112.50052165985], ls_cnt)
sl1_ls_nuRauto = expandTOs([0.49466729164123535, 0.4985625743865967, 0.5563898086547852, 0.46497464179992676, 0.4704608917236328, 0.3357362747192383, 0.4754326343536377, 0.5034255981445312, 0.4717588424682617, 0.5451631546020508, 0.6139497756958008, 0.5047671794891357, 0.6525683403015137, 0.6351287364959717, 0.7798829078674316, 0.8866896629333496], ls_cnt)
sl1_ls_abc  = expandTOs([391.39660716056824, 1292.9900755882263, 16600.596026182175, time_out_time, time_out_time, time_out_time], ls_cnt)
sl1_ls_rIC3 = expandTOs([186.340070, 433.694733, 297.736490, 3992.815844, 11516.430677, time_out_time, time_out_time, time_out_time, time_out_time], ls_cnt)

sl1_ls_nuRLin = expandTOs([], ls_cnt)
sl1_ls_NMC24 = expandTOs([], ls_cnt)


# PWM
pwm_cnt = 12
sl1_pwm_nuX  = expandTOs([3.125112771987915, 13.252418756484985, 57.38608908653259, 273.42026376724243, 1576.1084687709808, 9215.978384494781, 41643.71946597099], pwm_cnt)
sl1_pwm_nuRauto = expandTOs([0.2386162281036377, 0.08424639701843262, 0.11408257484436035, 0.11951947212219238, 0.10460638999938965, 0.10583281517028809, 0.10385346412658691, 0.12699580192565918, 0.13409948348999023, 0.1540067195892334, 0.13550305366516113, 0.19064784049987793], pwm_cnt)
sl1_pwm_abc  = expandTOs([529.9583625793457, 3209.5791351795197, 16190.275993585587, time_out_time, time_out_time], pwm_cnt)
sl1_pwm_rIC3 = expandTOs([104.516747, 495.672909, 2678.699076, 15727.758023, time_out_time, time_out_time, time_out_time, time_out_time, time_out_time], pwm_cnt)

sl1_pwm_nuRLin = expandTOs([0.18936705589294434, 0.08720707893371582, 0.11496567726135254, 0.12897682189941406, 0.10803699493408203, 0.10904645919799805, 0.10598254203796387, 0.1304318904876709, 0.13919758796691895, 0.1590275764465332, 0.1411910057067871, 0.19712042808532715], pwm_cnt)
sl1_pwm_NMC24 = expandTOs([], pwm_cnt)


# SevenSeg 
sg7_cnt = 15
sl1_sg7_nuX  = expandTOs([0.026430606842041016, 0.025936365127563477, 0.027713537216186523, 0.026323795318603516, 0.02929234504699707, 0.028609752655029297, 0.028684139251708984, 0.029138565063476562, 0.029590606689453125, 0.028706789016723633, 0.030977249145507812, 0.02969980239868164, 0.02987813949584961, 0.030839204788208008, 0.030716419219970703], sg7_cnt)
sl1_sg7_nuRauto = expandTOs([4.40891933441162, 92.7163565158844, 121.59593772888184, 93.11797380447388, 261.1418716907501, time_out_time, 252.55326461791992, 527.2797145843506, time_out_time, time_out_time, time_out_time, 1037.515111207962, 1232.4702293872833], sg7_cnt)
sl1_sg7_abc  = expandTOs([42.778621673583984, 418.49402046203613, 383.3295028209686, 1325.1629526615143, 11079.08333659172, time_out_time], sg7_cnt)
sl1_sg7_rIC3 = expandTOs([2.899053, 28.611951, 85.959729, 60.984110, 346.809344, 4234.921025, 17883.308448, 14170.214835, time_out_time], sg7_cnt)

sl1_sg7_nuRLin = expandTOs([], sg7_cnt)
sl1_sg7_NMC24 = expandTOs([], sg7_cnt)


# Thermocouple 
tmp_cnt = 17
sl1_tmp_nuX  = expandTOs([0.7378413677215576, 3.5268490314483643, 5.349167823791504, 44.858392000198364, 29.837612628936768, 88.21816396713257, 74.20687127113342, 150.8505413532257, 286.439879655838, 769.0948441028595, 1509.2655820846558, 2045.6037271022797, 2858.220217704773, 6122.445128917694, 33996.737822532654], tmp_cnt)
sl1_tmp_nuRauto = expandTOs([0.33093786239624023, 0.2651047706604004, 0.21975111961364746, 0.2158184051513672, 0.2294161319732666, 0.23107290267944336, 0.25826382637023926, 0.23257780075073242, 0.20345091819763184, 0.2404177188873291, 0.26024889945983887, 0.21515941619873047, 0.27878785133361816, 0.2178335189819336, 0.236159086227417, 0.2166004180908203, 0.21785473823547363], tmp_cnt)
sl1_tmp_abc  = expandTOs([0.44710254669189453, 33.724576473236084, 73.89875149726868, 54.740148305892944, 92.79968857765198, 94.64842486381531, 878.2118704319, 787.5671153068542, 3355.3584847450256, 3542.4604408740997, 3905.190735578537, time_out_time, time_out_time, time_out_time], tmp_cnt)
sl1_tmp_rIC3 = expandTOs([0.128475, 2.059443, 7.340325, 13.604773, 20.752386, 16.102198, 38.865918, 34.845747, 213.892932, 615.415617, 840.688012, 1485.367805, 3173.839911, 2682.664708, time_out_time], tmp_cnt)

sl1_tmp_nuRLin = expandTOs([], tmp_cnt)
sl1_tmp_NMC24 = expandTOs([], tmp_cnt)



# UART Transmit
utt_cnt = 10
sl1_utt_nuX  = expandTOs([0.03061985969543457, 0.04313063621520996, 0.08560299873352051, 0.41001367568969727, 0.05476212501525879, 0.07370853424072266, 2.6032819747924805, 0.513587474822998, 0.29959988594055176, 0.17646527290344238], utt_cnt)
sl1_utt_nuRauto = expandTOs([0.2836878299713135, 0.11203551292419434, 0.08108353614807129, 0.08942317962646484, 0.08315753936767578, 0.08472847938537598, 0.08548331260681152, 0.10060691833496094, 0.08885884284973145, 0.08722352981567383], utt_cnt)
sl1_utt_abc  = expandTOs([0.31820249557495117, 0.2734839916229248, 0.2415447235107422, 0.24127769470214844, 0.3100428581237793, 0.267822265625, 0.3732433319091797, ], utt_cnt)
sl1_utt_rIC3 = expandTOs([0.037279, 0.049640, 0.078806, 0.055971, 0.072909, 0.068700, 0.061937, 0.113871, 0.100113 ], utt_cnt)

sl1_utt_nuRLin = expandTOs([0.22617435455322266, 0.1146688461303711, 0.0820009708404541, 0.09068608283996582, 0.083953857421875, 0.08618330955505371, 0.08596134185791016, 0.10465383529663086, 0.08980631828308105, 0.08666825294494629], utt_cnt)
sl1_utt_NMC24 = expandTOs([], utt_cnt)


# VGA 
vga_cnt = 10
sl1_vga_nuX  = expandTOs([0.13991785049438477, 0.2938966751098633, 1.0018982887268066, 0.9121789932250977, 1.601520299911499, 2.4737935066223145, 6.733147859573364, 7.903909921646118, 12.424234390258789, 32.51867723464966], vga_cnt)
sl1_vga_nuRauto = expandTOs([19.5980544090271, 8.641579389572144, 5.602804183959961, 3.4682483673095703, 11.062709331512451, 6.132077693939209, 3.9874017238616943, 2.312453269958496, 2.5878448486328125, 3.3227999210357666], vga_cnt)
sl1_vga_abc  = expandTOs([1.1461961269378662, 6.517640590667725, 32.51337146759033, 31.69547152519226, 33.419198989868164, 82.19744896888733, 136.25595808029175, 108.1104462146759, 543.376179933548, 577.7537264823914], vga_cnt)
sl1_vga_rIC3 = expandTOs([0.880592, 3.083518, 6.89865, 7.738405, 20.541836, 18.702058, 37.740297, 65.679046, 73.445525, 79.245472], vga_cnt)

sl1_vga_nuRLin = expandTOs([], vga_cnt)
sl1_vga_NMC24 = expandTOs([], vga_cnt)


# Delay 
dly_cnt = 16
sl2_dly_nuX = expandTOs([1.7684061527252197, 5.0180864334106445, 21.729917287826538, 101.67662024497986, 242.19723916053772, 457.30537819862366, 729.6484482288361, 1055.8812885284424, 1525.1611380577087, 2058.5895562171936, 2615.2334501743317, 3345.006036758423, 13778.609865188599, 53956.57745099068], dly_cnt)
sl2_dly_nuRauto = expandTOs([0.16849112510681152, 0.08438634872436523, 0.0573117733001709, 0.05545496940612793, 0.0555419921875, 0.05481886863708496, 0.05609273910522461, 0.05647134780883789, 0.05622744560241699, 0.0559687614440918, 0.05633711814880371, 0.05638003349304199, 0.05637955665588379, 0.0567171573638916, 0.05692887306213379, 0.0568079948425293], dly_cnt)
sl2_dly_abc = expandTOs([242.14064383506775, 402.7590608596802, 4535.846311569214, time_out_time, time_out_time, time_out_time], dly_cnt)
sl2_dly_rIC3 = expandTOs([24.910002, 128.809533, 88.251367, 1293.666362, 1329.855489, 5451.448754, 5382.555396, 16273.843979, 8768.817575, time_out_time, time_out_time], dly_cnt)

sl2_dly_nuRLin = expandTOs([0.1300065517425537, 0.0700984001159668, 0.0597994327545166, 0.057390689849853516, 0.05854296684265137, 0.05827975273132324, 0.05793261528015137, 0.059046268463134766, 0.05917692184448242, 0.05915260314941406, 0.05910348892211914, 0.05966520309448242, 0.05857729911804199, 0.058898210525512695, 0.058860063552856445, 0.05881643295288086], dly_cnt)
sl2_dly_NMC24 = expandTOs([], dly_cnt)


# Load-Store 
ls_cnt = 16
sl2_ls_nuX  = expandTOs([], ls_cnt)
sl2_ls_nuRauto = expandTOs([0.9977624416351318, 1.011429786682129, 0.8949024677276611, 0.5728988647460938, 0.4675865173339844, 0.6570253372192383, 0.5389766693115234, 0.6322343349456787, 0.651146650314331, 0.6266803741455078, 0.6781585216522217, 0.5899093151092529, 0.6557712554931641, 0.6370439529418945, 0.5593736171722412, 0.7148864269256592], ls_cnt)
sl2_ls_abc  = expandTOs([108.03835105895996, 201.08016180992126, 6072.0576293468475, 8553.691765069962, time_out_time, time_out_time], ls_cnt)
sl2_ls_rIC3 = expandTOs([12.660656, 26.313089, 216.831913, 5758.090890, 16361.858360, 7471.625817, 2531.373784, time_out_time, time_out_time], ls_cnt)

sl2_ls_nuRLin = expandTOs([], ls_cnt)
sl2_ls_NMC24 = expandTOs([], ls_cnt)


# GRAY 
gry_cnt = 11
sl2_gry_nuX = expandTOs([0.3114023208618164, 18.866820096969604, 8.541805744171143, 13.897789716720581, 67.18905067443848, 333.7783818244934, 1544.3919384479523, 57420.391444683075], gry_cnt)
sl2_gry_nuRauto = expandTOs([3.24749493598938, 1.5808227062225342, 5.504240274429321, 1.7526841163635254, 4.766321897506714, 4.66336727142334, 2.5002822875976562, 2.2626307010650635, 7.44799017906189, 3.0022075176239014, 11.824181079864502], gry_cnt)
sl2_gry_abc = expandTOs([28.032103538513184, 163.16620779037476, 193.43644785881042, 711.1160497665405, 2831.0496361255646, 17602.78768968582], gry_cnt)
sl2_gry_rIC3 = expandTOs([3.957745, 5.331823, 31.350826, 77.638517, 214.730635, 607.283511, 2856.754024, time_out_time, time_out_time], gry_cnt)

sl2_gry_nuRLin = expandTOs([], gry_cnt)
sl2_gry_NMC24 = expandTOs([], gry_cnt)


# Combine the data

s_nuX      = np.array(s1_dly_nuX + s2_dly_nuX + s1_lcd_nuX + s2_lcd_nuX + s2_vga_nuX  + s2_vga_nuX + s1_blk_nuX + s1_tmp_nuX + s1_sg7_nuX + s1_i2c_nuX + s1_pwm_nuX + s1_utt_nuX + s1_ls_nuX + s1_gry_nuX)
l_nuX      = np.array(l1_dly_nuX + l1_lcd_nuX + l1_blk_nuX + l1_tmp_nuX + l1_sg7_nuX + l1_i2c_nuX + l1_pwm_nuX + l1_vga_nuX + l1_utt_nuX + l1_ls_nuX + l1_gry_nuX + l2_dly_nuX + l2_sg7_nuX + l2_gry_nuX + l3_gry_nuX)
sl_nuX     = np.array(sl1_dly_nuX + sl1_lcd_nuX + sl1_blk_nuX + sl1_tmp_nuX + sl1_sg7_nuX + sl1_i2c_nuX + sl1_pwm_nuX + sl1_vga_nuX + sl1_utt_nuX + sl1_ls_nuX + sl1_gry_nuX + sl2_ls_nuX  + sl2_dly_nuX + sl2_gry_nuX)

s_nuRauto     = np.array(s1_dly_nuRauto + s2_dly_nuRauto + s1_lcd_nuRauto + s2_lcd_nuRauto + s2_vga_nuRauto + s2_vga_nuRauto +  s1_blk_nuRauto + s1_tmp_nuRauto + s1_sg7_nuRauto + s1_i2c_nuRauto + s1_pwm_nuRauto + s1_utt_nuRauto + s1_ls_nuRauto + s1_gry_nuRauto)
l_nuRauto     = np.array(l1_dly_nuRauto + l1_lcd_nuRauto + l1_blk_nuRauto + l1_tmp_nuRauto + l1_sg7_nuRauto + l1_i2c_nuRauto + l1_pwm_nuRauto + l1_vga_nuRauto + l1_utt_nuRauto + l1_ls_nuRauto + l1_gry_nuRauto + l2_dly_nuRauto + l2_sg7_nuRauto + l2_gry_nuRauto + l3_gry_nuRauto)
sl_nuRauto     = np.array(sl1_dly_nuRauto + sl1_lcd_nuRauto + sl1_blk_nuRauto + sl1_tmp_nuRauto + sl1_sg7_nuRauto + sl1_i2c_nuRauto + sl1_pwm_nuRauto + sl1_vga_nuRauto + sl1_utt_nuRauto + sl1_ls_nuRauto + sl1_gry_nuRauto + sl2_ls_nuRauto + sl2_dly_nuRauto + sl2_gry_nuRauto)

s_abc      = np.array(s1_dly_abc + s2_dly_abc + s1_lcd_abc +  s2_vga_abc  + s2_vga_abc +  s2_lcd_abc + s1_blk_abc + s1_tmp_abc + s1_sg7_abc + s1_i2c_abc + s1_pwm_abc + s1_utt_abc + s1_ls_abc + s1_gry_abc)
l_abc      = np.array(l1_dly_abc + l1_lcd_abc + l1_blk_abc + l1_tmp_abc + l1_sg7_abc + l1_i2c_abc + l1_pwm_abc + l1_vga_abc + l1_utt_abc + l1_ls_abc + l1_gry_abc + l2_dly_abc + l2_sg7_abc + l2_gry_abc + l3_gry_abc)
sl_abc     = np.array(sl1_dly_abc + sl1_lcd_abc + sl1_blk_abc + sl1_tmp_abc + sl1_sg7_abc + sl1_i2c_abc + sl1_pwm_abc + sl1_vga_abc + sl1_utt_abc + sl1_ls_abc + sl1_gry_abc + sl2_ls_abc + sl2_dly_abc + sl2_gry_abc)

s_rIC3      = np.array(s1_dly_rIC3 + s2_dly_rIC3 + s1_lcd_rIC3 +  s2_vga_rIC3  + s2_vga_rIC3 +  s2_lcd_rIC3 + s1_blk_rIC3 + s1_tmp_rIC3 + s1_sg7_rIC3 + s1_i2c_rIC3 + s1_pwm_rIC3 + s1_utt_rIC3 + s1_ls_rIC3 + s1_gry_rIC3)
l_rIC3      = np.array(l1_dly_rIC3 + l1_lcd_rIC3 + l1_blk_rIC3 + l1_tmp_rIC3 + l1_sg7_rIC3 + l1_i2c_rIC3 + l1_pwm_rIC3 + l1_vga_rIC3 + l1_utt_rIC3 + l1_ls_rIC3 + l1_gry_rIC3 + l2_dly_rIC3 + l2_sg7_rIC3 + l2_gry_rIC3 + l3_gry_rIC3)
sl_rIC3     = np.array(sl1_dly_rIC3 + sl1_lcd_rIC3 + sl1_blk_rIC3 + sl1_tmp_rIC3 + sl1_sg7_rIC3 + sl1_i2c_rIC3 + sl1_pwm_rIC3 + sl1_vga_rIC3 + sl1_utt_rIC3 + sl1_ls_rIC3 + sl1_gry_rIC3 + sl2_ls_rIC3 + sl2_dly_rIC3 + sl2_gry_rIC3)

s_nuRLin      = np.array(s1_dly_nuRLin + s2_dly_nuRLin + s1_lcd_nuRLin + s2_lcd_nuRLin + s2_vga_nuRLin  + s2_vga_nuRLin +  s1_blk_nuRLin + s1_tmp_nuRLin + s1_sg7_nuRLin + s1_i2c_nuRLin + s1_pwm_nuRLin + s1_utt_nuRLin + s1_ls_nuRLin + s1_gry_nuRLin)
l_nuRLin      = np.array(l1_dly_nuRLin + l1_lcd_nuRLin + l1_blk_nuRLin + l1_tmp_nuRLin + l1_sg7_nuRLin + l1_i2c_nuRLin + l1_pwm_nuRLin + l1_vga_nuRLin + l1_utt_nuRLin + l1_ls_nuRLin + l1_gry_nuRLin + l2_dly_nuRLin + l2_sg7_nuRLin + l2_gry_nuRLin + l3_gry_nuRLin)
sl_nuRLin     = np.array(sl1_dly_nuRLin + sl1_lcd_nuRLin + sl1_blk_nuRLin + sl1_tmp_nuRLin + sl1_sg7_nuRLin + sl1_i2c_nuRLin + sl1_pwm_nuRLin + sl1_vga_nuRLin + sl1_utt_nuRLin + sl1_ls_nuRLin + sl1_gry_nuRLin + sl2_ls_nuRLin + sl2_dly_nuRLin + sl2_gry_nuRLin)

s_NMC24      = np.array(s1_dly_NMC24 + s2_dly_NMC24 + s1_lcd_NMC24 + s2_lcd_NMC24 + s2_vga_NMC24  + s2_vga_NMC24 +  s1_blk_NMC24 + s1_tmp_NMC24 + s1_sg7_NMC24 + s1_i2c_NMC24 + s1_pwm_NMC24 + s1_utt_NMC24 + s1_ls_NMC24 + s1_gry_NMC24)
l_NMC24      = np.array(l1_dly_NMC24 + l1_lcd_NMC24 + l1_blk_NMC24 + l1_tmp_NMC24 + l1_sg7_NMC24 + l1_i2c_NMC24 + l1_pwm_NMC24 + l1_vga_NMC24 + l1_utt_NMC24 + l1_ls_NMC24 + l1_gry_NMC24 + l2_dly_NMC24 + l2_sg7_NMC24 + l2_gry_NMC24 + l3_gry_NMC24)
sl_NMC24     = np.array(sl1_dly_NMC24 + sl1_lcd_NMC24 + sl1_blk_NMC24 + sl1_tmp_NMC24 + sl1_sg7_NMC24 + sl1_i2c_NMC24 + sl1_pwm_NMC24 + sl1_vga_NMC24 + sl1_utt_NMC24 + sl1_ls_NMC24 + sl1_gry_NMC24 + sl2_ls_NMC24 + sl2_dly_NMC24 + sl2_gry_NMC24)



#----------------------------------------------------------------------------------
#						State Space Size
#----------------------------------------------------------------------------------

dly_sss = [(2**3)*750, (2**3)*1250, (2**3)*2500, (2**3)*5000, (2**3)*7500, (2**3)*10000, (2**3)*12500, (2**3)*15000, (2**3)*17500, (2**3)*20000, (2**3)*22500, (2**3)*25000, (2**3)*50000, (2**3)*100000, (2**3)*200000, (2**3)*400000]

gry_sss = [(2**9), 2**10, 2**11, 2**12, 2**13, 2**14, 2**15, 2**16, 2**17, 2**18, 2**19]

blk_sss = [2**11, 2**12, 2**13, 2**14, 2**15, 2**16, 2**17, 2**18, 2**19, 2**20, 2**21, 2**22, 2**23, 2**24, 2**25, 2**26, 2**27, 2**28, 2**29, 2**30, 2**31, 2**32, 2**33, 2**34, 2**35]

i2c_sss = [(2**3)*500, (2**3)*1000, (2**3)*2000, (2**3)*4000, (2**3)*6000, (2**3)*8000, (2**3)*10000, (2**3)*12000, (2**3)*14000, (2**3)*16000, (2**3)*18000, (2**3)*20000, (2**3)*22000, (2**3)*24000, (2**3)*26000, (2**3)*28000, (2**3)*40000, (2**3)*70000, (2**3)*140000, (2**3)*280000]

lcd_sss = [(2**12)*500, (2**12)*1000, (2**12)*1500, (2**12)*2500, (2**12)*5000, (2**12)*7500, (2**12)*10000, (2**12)*12500, (2**12)*15000, (2**12)*17500, (2**12)*20000, (2**12)*22500, (2**12)*90000, (2**12)*180000]

ls_sss = [(2**2)*750, (2**2)*1250, (2**2)*2500, (2**2)*5000, (2**2)*7500, (2**2)*10000, (2**2)*12500, (2**2)*15000, (2**2)*17500, (2**2)*20000, (2**2)*22500, (2**2)*25000, (2**2)*50000, (2**2)*100000, (2**2)*200000, (2**2)*400000]

pwm_sss = [2**11, (2**12), 2**13, 2**14, 2**15, 2**16, 2**17, 2**18, 2**19, 2**20, 2**21, 2**22]

sg7_sss = [2**7*250, 2**7*500, 2**7*750, 2**7*1000, 2**7*2500, 2**7*5000, 2**7*7500, 2**7*10000, 2**7*12500, 2**7*15000, 2**7*17500, 2**7*20000, 2**7*40000, 2**7*80000, 2**7*160000]

tmp_sss = [2**33*30, 2**33*300, 2**33*600, 2**33*900, 2**33*1200, 2**33*1800, 2**33*2400, 2**33*3000, 2**33*6000, 2**33*9000, 2**33*12000, 2**33*15000, 2**33*18000, 2**33*36000, 2**33*72000, 2**33*144000, 2**33*288000]

utt_sss = [2**10, 2**13, 2**15, 2**16, 2**17, 2**18, 2**19, 2**21, 2**22, 2**23]

vga_sss = [(94*1)**2*2**5, (94*2)**2*2**5, (94*3)**2*2**6, (94*4)**2*2**6, (94*5)**2*2**7, (94*6)**2*2**7, (94*8)**2*2**8, (94*10)**2*2**8, (94*12)**2*2**9, (94*16)**2*2**9]

dly2_sss = [2**3*750, 2**3*1250, 2**3*2500, 2**3*5000, 2**3*7500, 2**3*10000, 2**3*12500, 2**3*15000, 2**3*17500, 2**3*20000, 2**3*22500, 2**3*25000, 2**3*50000, 2**3*100000, 2**3*200000, 2**3*400000]

gry2_sss = [2**9, 2**10, 2**11, (2**12), 2**13, 2**14, 2**15, 2**16, 2**17, 2**18, 2**19]

sg7_2_sss = [2**7*250, 2**7*500, 2**7*750, 2**7*1000, 2**7*2500, 2**7*5000, 2**7*7500, 2**7*10000, 2**7*12500, 2**7*15000, 2**7*17500, 2**7*20000, 2**7*40000, 2**7*80000, 2**7*160000]

gry3_sss = [2**9, 2**10, 2**11, (2**12), 2**13, 2**14, 2**15, 2**16, 2**17, 2**18, 2**19]

s_sss      = np.array(dly_sss + dly_sss + lcd_sss + lcd_sss + vga_sss  + vga_sss + blk_sss + tmp_sss + sg7_sss + i2c_sss + pwm_sss + utt_sss +  ls_sss + gry_sss)
l_sss      = np.array(dly_sss + lcd_sss + blk_sss + tmp_sss + sg7_sss  + i2c_sss + pwm_sss + vga_sss + utt_sss +  ls_sss + gry_sss + dly_sss + sg7_sss + gry_sss + gry_sss)
sl_sss     = np.array(dly_sss + lcd_sss + blk_sss + tmp_sss + sg7_sss + i2c_sss + pwm_sss + vga_sss + utt_sss + ls_sss + gry_sss + ls_sss  + dly_sss + gry_sss)

#----------------------------------------------------------------------------------
#							 Figures
#----------------------------------------------------------------------------------


def cactusPlot(nuX, nuRauto, abc, rIC3, NMC24, nuRLin):
	method1_times = nuX.copy()
	method2_times = nuRauto.copy()
	method3_times = abc.copy()
	method5_times = NMC24.copy()
	method6_times = nuRLin.copy()
	method7_times = rIC3.copy()


	
	method1_times.sort()
	method2_times.sort()
	method3_times.sort()
	method5_times.sort()
	method6_times.sort()
	method7_times.sort()

	num_tasks = len(method1_times)
	tasks_completed = np.arange(1, num_tasks + 1)/num_tasks*100
	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	plt.figure(figsize=(10, 6))

	plt.step(tasks_completed, method1_times, label='nuXmv', color=colors_catus[0],
	         linewidth=3, where='post', alpha=0.7, marker='o', markevery=10)
	
	plt.step(tasks_completed, method3_times, label='ABC', color=colors_catus[1],
	         linewidth=3, where='post', alpha=0.7, marker='x', markevery=10)
	
	plt.step(tasks_completed, method7_times, label='rIC3', color=colors_catus[5],
	         linewidth=3, where='post', alpha=0.7, marker='^', markevery=10)
	
	plt.step(tasks_completed, method5_times, label='NMC24', color=colors_catus[3],
	         linewidth=3, where='post', alpha=0.7, marker='^', markevery=10)
	
	#plt.step(tasks_completed, method6_times, label='our-linear', color=colors_catus[4],
	#         linewidth=3, where='post', alpha=0.7, marker='D', markevery=10)
	
	plt.step(tasks_completed, method2_times, label='Our', color='green',
	         linewidth=3, where='post', alpha=0.7, marker='^', markevery=10)

	
	
	plt.ylim(0.01, time_out_time)
	plt.xlim(1, 100)
	#plt.yscale('function', functions = (lambda x : x**(1/3), lambda x : x**(3)))
	plt.yscale('log')

	ax = plt.gca()
	ax.yaxis.set_major_formatter(formatter)
	plt.tick_params(axis='both', which='major', labelsize=16)

	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label,)
	cst_value = [20, 40, 60, 80, 100]  # 10 ticks spaced evenly between -1 and 1
	cst_label = [ str(cst)+"%" for cst in cst_value]
	plt.xticks(cst_value, cst_label)
	plt.grid(True, linestyle='--', alpha=0.5)
	#plt.legend(fontsize=18)
	plt.show()

def matrixPlot(x_a, y_a, x_name, y_name, sizes):
	x_a[x_a >= time_out_time] = time_out_time * 1.35 # To make the time outs appear on the right of the 5hr line
	y_a[y_a >= time_out_time] = time_out_time * 1.35

	x = x_a.copy()
	y = y_a.copy()
	#sorted_tuples = sorted(zip(sizes, x, y), reverse=True)
	#sizes, x, y = zip(*sorted_tuples)
	
	# Create scatter plot
	plt.figure(figsize=(10, 8))
	x_cnt = np.arange(time_out_time+1)
	y_1x = 1 * x_cnt
	plt.plot(x_cnt, y_1x, color='red', linewidth=1, linestyle='dashed')
	y_10x = 0.1 * x_cnt
	plt.plot(x_cnt, y_10x, color='red', linewidth=1, linestyle='dashed')
	y_100x = 0.01 * x_cnt
	plt.plot(x_cnt, y_100x, color='red', linewidth=1, linestyle='dashed')
	y_1000x = 0.001 * x_cnt
	plt.plot(x_cnt, y_1000x, color='red', linewidth=1, linestyle='dashed')
	y_10000x = 0.0001 * x_cnt
	plt.plot(x_cnt, y_10000x, color='red', linewidth=1, linestyle='dashed')
	y_100000x = 0.00001 * x_cnt
	plt.plot(x_cnt, y_100000x, color='red', linewidth=1, linestyle='dashed')
	plt.scatter(x, y, s=np.log(sizes)*17, alpha=0.8, c=sizes, norm = "log", edgecolors='black', linewidths=1.5)


	formatter = ScalarFormatter()
	formatter.set_scientific(True)
	formatter.set_powerlimits((-1,1))
	
	# Add grid and adjust axis limits
	plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)
	plt.xlim(0.01, time_out_time*2)
	plt.ylim(0.01, time_out_time*2)
	plt.yscale('log')
	plt.xscale('log')
	
	# Add colorbar for better understanding of point sizes
	cbar = plt.colorbar( orientation='vertical').ax.tick_params(labelsize=16)
	
	plt.gca().add_patch(plt.Rectangle((time_out_time*.97, 0), 100000, 900000, color='red', linestyle='dotted', alpha=0.1, linewidth=1))
	plt.gca().add_patch(plt.Rectangle((0, time_out_time*.97), 900000, 100000, color='red',linestyle='dotted', alpha=0.1, linewidth=1))
	plt.plot([18000, 18000], [18000,0], color='black', linewidth=1)
	plt.plot([0,18000], [18000, 18000],  color='black', linewidth=1)

	#plt.text(1.2, time_out_time*1.1, 'Out of Time', fontsize=19, color='red')
	cst_value = [0.03, 0.1, 0.3, 1,  5,  15, 1*60, 5*60, 20*60, 60*60, 5*60*60]  
	cst_label = ['.03s', '.1s', '.3s', '1s', '5s', '15s', '1m', '5m', '20m', '1h', '5h']
	plt.yticks(cst_value, cst_label)
	plt.xticks(cst_value, cst_label)
	plt.tick_params(axis='both', which='major', labelsize=19)
		
	plt.show()
    
#----------------------------------------------------------------------------------
#							 Statistics
#----------------------------------------------------------------------------------
def stat1():
	print(f"In {np.sum(s_nuRauto<time_out_time)/len(s_nuRauto)*100}  % pure-safety      tasks completed by our-auto")
	print(f"In {np.sum(l_nuRauto<time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by our-auto")
	print(f"In {np.sum(sl_nuRauto<time_out_time)/len(sl_nuRauto)*100} % safety-liveness tasks completed by our-auto\n")

	print(f"In {np.sum(s_nuRLin<time_out_time)/len(s_nuRauto)*100}  % pure-safety      tasks completed by our-linear")
	print(f"In {np.sum(l_nuRLin<time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by our-linear")
	print(f"In {np.sum(sl_nuRLin<time_out_time)/len(sl_nuRauto)*100} % safety-liveness tasks completed by our-linear\n")

	print(f"In {np.sum(s_nuX <time_out_time)/len(s_nuRauto)*100}  % pure-safety      tasks completed by nuXmv --BDD")
	print(f"In {np.sum(l_nuX <time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by nuXmv --BDD")
	print(f"In {np.sum(sl_nuX<time_out_time)/len(sl_nuRauto)*100} % safety-liveness tasks completed by nuXmv --BDD\n")

	print(f"In {np.sum(s_rIC3 <time_out_time)/len(s_nuRauto)*100}  % pure-safety      tasks completed by rIC3")
	print(f"In {np.sum(l_rIC3 <time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by rIC3")
	print(f"In {np.sum(sl_rIC3<time_out_time)/len(sl_nuRauto)*100} % safety-liveness tasks completed by rIC3\n")

	print(f"In {np.sum(s_abc <time_out_time)/len(s_nuRauto)*100}  % pure-safety      tasks completed by ABC")
	print(f"In {np.sum(l_abc <time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by ABC")
	print(f"In {np.sum(sl_abc<time_out_time)/len(sl_nuRauto)*100} % safety-liveness tasks completed by ABC\n")

	print(f"In {np.sum(l_NMC24 <time_out_time)/len(l_nuRauto)*100}  % pure-liveness    tasks completed by NMC'24\n")


def stat2():
	print(f"In {np.sum(s_nuX>s_nuRauto)/len(s_nuRauto)*100} % safety tasks our-auto is faster than nuXmv --BDD")
	print(f"In {np.sum(s_rIC3>s_nuRauto)/len(s_nuRauto)*100} % safety tasks our-auto is faster than rIC3  ")
	print(f"In {np.sum(s_abc>s_nuRauto)/len(s_nuRauto)*100} % safety tasks our-auto is faster than ABC  \n")


def stat3():
	best_s = np.minimum(np.minimum(s_nuX,s_abc), s_rIC3)
	print(f"In {np.sum((s_nuRauto <= 1) & (best_s <= 1))/len(s_nuRauto)*100} % safety tasks both us (our-auto) and best of others finished in 1sec\n")
	print("--------------------------------------------\n")

def stat4():
	st_1 = (np.sum(l_nuRauto < 1)    - np.sum(l_nuX < 1))/len(l_nuX)*100
	st_2 = (np.sum(l_nuRauto < 1*60)   - np.sum(l_nuX < 1*60))/len(l_nuX)*100
	st_3 = (np.sum(l_nuRauto < 1*60*60) - np.sum(l_nuX < 1*60*60))/len(l_nuX)*100

	st_4 = (np.sum(l_nuRauto < 1)    - np.sum(l_abc < 1))/len(l_nuX)*100
	st_5 = (np.sum(l_nuRauto < 1*60)   - np.sum(l_abc < 1*60))/len(l_nuX)*100
	st_6 = (np.sum(l_nuRauto < 1*60*60) - np.sum(l_abc < 1*60*60))/len(l_nuX)*100

	st_7 = (np.sum(l_nuRauto < 1)    - np.sum(l_NMC24 < 1))/len(l_nuX)*100
	st_8 = (np.sum(l_nuRauto < 1*60)   - np.sum(l_NMC24 < 1*60))/len(l_nuX)*100
	st_9 = (np.sum(l_nuRauto < 1*60*60) - np.sum(l_NMC24 < 1*60*60))/len(l_nuX)*100

	st_13 = (np.sum(l_nuRauto < 1)    - np.sum(l_rIC3 < 1))/len(l_nuX)*100
	st_14 = (np.sum(l_nuRauto < 1*60)   - np.sum(l_rIC3 < 1*60))/len(l_nuX)*100
	st_15 = (np.sum(l_nuRauto < 1*60*60) - np.sum(l_rIC3 < 1*60*60))/len(l_nuX)*100

	print(f"For Pure-liveness, our-auto completes {st_1} % more than nuXmv --BDD, {st_13} % more than rIC3 , {st_4} % more than ABC and {st_7} more than NMC'24 in 1 sec, at 1 min the numbers are {st_2}, {st_14}, {st_5}, {st_8}, repectively and they become {st_3}, {st_15}, {st_6}, {st_9}, at 1 hours. \n")

	l_abc_a = l_abc.copy()
	l_nuX_a = l_nuX.copy()
	l_rIC3_a = l_rIC3.copy()
	l_NMC24_a = l_NMC24.copy()
	l_nuRauto_a = l_nuRauto.copy()
	l_abc_a.sort()
	l_nuX_a.sort()
	l_rIC3_a.sort()
	l_NMC24_a.sort()
	l_nuRauto_a.sort()

	print(f"82% Pure-liveness tasks nuXmv --BDD {l_nuX_a[int(0.821917808219178*(len(l_nuX_a))) + 1 ]} s and our auto tool {l_nuRauto_a[int(0.821917808219178*(len(l_nuRauto_a))) + 1]} s")
	print(f"79% Pure-liveness tasks NMC'24 {l_NMC24_a[int(0.7853881278538812*(len(l_NMC24_a))) + 1]} s and our auto tool {l_nuRauto_a[int(0.7853881278538812*(len(l_nuRauto_a))) + 1]} s")
	print(f"50%  Pure-liveness tasks rIC3 {l_rIC3_a[int(0.502283105022831*(len(l_rIC3_a))) + 1 ]} s and our auto tool {l_nuRauto_a[int(0.502283105022831*(len(l_nuRauto_a))) + 1]} s")
	print(f"36% Pure-liveness tasks ABC {l_abc_a[int(0.3561643835616438*(len(l_abc_a))) + 1]} s and our auto tool {l_nuRauto_a[int(0.3561643835616438*(len(l_nuRauto_a))) + 1]} s\n")
	print("--------------------------------------------\n")

def stat5():
	l_best_other = np.minimum(np.minimum(np.minimum(l_nuX,l_abc), l_NMC24), l_rIC3)
	st_51 = np.sum((l_best_other >= time_out_time) & (l_nuRauto < time_out_time))/len(l_nuRauto)*100
	print(f"In {st_51} % liveness tasks everyone but us timeout")
	print(f"In {np.sum(l_best_other>l_nuRauto)/len(l_nuRauto)*100} % liveness tasks our-auto is       faster than others")
	print(f"In {np.sum(l_best_other>l_nuRauto*10)/len(l_nuRauto)*100} % liveness tasks our-auto is 10  X faster than others")
	print(f"In {np.sum(l_best_other>l_nuRauto*10**2)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^2 X faster than others")
	print(f"In {np.sum(l_best_other>l_nuRauto*10**3)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^3  X faster than others")
	print(f"In {np.sum(l_best_other>l_nuRauto*10**4)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^4 X faster than others")
	print(f"In {np.sum(l_best_other>l_nuRauto*10**5)/len(l_nuRauto)*100} % safety-liveness tasks our-auto is 10^5 X faster than others\n")


	print(f"In {np.sum(l_NMC24>l_nuRauto)/len(l_nuRauto)*100} % liveness tasks our-auto is       faster than NMC'24")
	print(f"In {np.sum(l_NMC24>l_nuRauto*10)/len(l_nuRauto)*100} % liveness tasks our-auto is 10  X faster than NMC'24")
	print(f"In {np.sum(l_NMC24>l_nuRauto*10**2)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^2 X faster than NMC'24")
	print(f"In {np.sum(l_NMC24>l_nuRauto*10**3)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^3 X faster than NMC'24")
	print(f"In {np.sum(l_NMC24>l_nuRauto*10**4)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^4 X faster than NMC'24")
	print(f"In {np.sum(l_NMC24>l_nuRauto*10**5)/len(l_nuRauto)*100} % liveness tasks our-auto is 10^5 X faster than NMC'24\n")
	print("--------------------------------------------\n")


def stat6():
	st_61 = (np.sum(sl_nuRauto < 1)    - np.sum(sl_nuX < 1))/len(sl_nuX)*100
	st_62 = (np.sum(sl_nuRauto < 1*60)   - np.sum(sl_nuX < 1*60))/len(sl_nuX)*100
	st_63 = (np.sum(sl_nuRauto < 1*60*60) - np.sum(sl_nuX < 1*60*60))/len(sl_nuX)*100

	st_64 = (np.sum(sl_nuRauto < 1)    - np.sum(sl_abc < 1))/len(sl_nuX)*100
	st_65 = (np.sum(sl_nuRauto < 1*60)   - np.sum(sl_abc < 1*60))/len(sl_nuX)*100
	st_66 = (np.sum(sl_nuRauto < 1*60*60) - np.sum(sl_abc < 1*60*60))/len(sl_nuX)*100

	st_610 = (np.sum(sl_nuRauto < 1)    - np.sum(sl_rIC3 < 1))/len(sl_nuX)*100
	st_611 = (np.sum(sl_nuRauto < 1*60)   - np.sum(sl_rIC3 < 1*60))/len(sl_nuX)*100
	st_612 = (np.sum(sl_nuRauto < 1*60*60) - np.sum(sl_rIC3 < 1*60*60))/len(sl_nuX)*100

	print(f"For safety-liveness our-auto completes {st_61} % more than nuXmv --BDD, {st_610} % more than rIC3,  {st_64} % more than ABC in 1 sec, at 1 min the numbers are {st_62}, {st_611}, {st_65}, repectively and they become {st_63}, {st_612}, {st_66}, at 1 hours.\n")

	sl_abc_a = sl_abc.copy()
	sl_nuX_a = sl_nuX.copy()
	sl_rIC3_a = sl_rIC3.copy()
	sl_nuRauto_a = sl_nuRauto.copy()
	sl_abc_a.sort()
	sl_nuX_a.sort()
	sl_rIC3_a.sort()
	sl_nuRauto_a.sort()

	print(f"74%  safety-liveness tasks nuXmv {sl_nuX_a[int(0.736842105263157*(len(sl_nuX_a))) + 1 ]} s and our auto tool {sl_nuRauto_a[int(0.736842105263157*(len(sl_nuRauto_a))) + 1]} s")
	print(f"62%  safety-liveness tasks rIC3  {sl_rIC3_a[int(0.6172248803827751*(len(sl_rIC3_a))) + 1 ]} s and our auto tool {sl_nuRauto_a[int(0.6172248803827751*(len(sl_nuRauto_a))) + 1]} s")
	print(f"46%  safety-liveness tasks ABC   {sl_abc_a[int(0.45933014354066984*(len(sl_abc_a))) + 1]} s and our auto tool {sl_nuRauto_a[int(0.45933014354066984*(len(sl_nuRauto_a))) + 1]} s\n")

def stat7():
	sl_best_other = np.minimum(np.minimum(sl_nuX,sl_abc), sl_rIC3)
	st_71 = np.sum((sl_best_other >= time_out_time) & (sl_nuRauto < time_out_time))/len(sl_nuRauto)*100
	print(f"In {st_71} % safety-liveness tasks everyone but us timeout")
	print(f"In {np.sum(sl_best_other>sl_nuRauto)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is       faster than others")
	print(f"In {np.sum(sl_best_other>sl_nuRauto*10)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is 10  X faster than others")
	print(f"In {np.sum(sl_best_other>sl_nuRauto*10**2)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is 10^2 X faster than others")
	print(f"In {np.sum(sl_best_other>sl_nuRauto*10**3)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is 10^3 X faster than others")
	print(f"In {np.sum(sl_best_other>sl_nuRauto*10**4)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is 10^4 X faster than others")
	print(f"In {np.sum(sl_best_other>sl_nuRauto*10**5)/len(sl_nuRauto)*100} % safety-liveness tasks our-auto is 10^5 X faster than others\n")


def stat8():
	all_runs = np.concatenate([
    s_nuX, l_nuX, sl_nuX,
    s_nuRauto, l_nuRauto, sl_nuRauto,
    s_abc, l_abc, sl_abc,
    s_nuRLin, l_nuRLin, sl_nuRLin,
    l_NMC24,
    s_rIC3, l_rIC3, sl_rIC3
	], axis=0)

	print(f"Our Main experiments exhaust {np.sum(all_runs)/(60*60)} hrs. for {len(all_runs)} total tasks")

def stat9():
    all_nuX = np.concatenate([s_nuX, l_nuX, sl_nuX], axis = 0)
    all_our = np.concatenate([s_nuRauto, l_nuRauto, sl_nuRauto], axis = 0)
    all_abc = np.concatenate([s_abc, l_abc, sl_abc], axis = 0)
    all_NMC = np.concatenate([np.array([time_out_time]*len(s_nuX)), l_NMC24, np.array([time_out_time]*len(sl_nuX))], axis = 0)
    all_rIC3 = np.concatenate([s_rIC3, l_rIC3, sl_rIC3], axis = 0)

    all_bst =  np.minimum(np.minimum(np.minimum(all_nuX, all_abc), all_NMC), all_rIC3)

    print(f"In {np.sum(all_bst>all_our*1)/len(all_our)*100} % tasks our-auto is 1 X faster everyone else")
    print(f"In {np.sum(all_bst>all_our*10)/len(all_our)*100} % tasks our-auto is 10 X faster everyone else")
    print(f"In {np.sum(all_bst>all_our*10**2)/len(all_our)*100} % tasks our-auto is 10^2 X faster everyone else")
    print(f"In {np.sum(all_bst>all_our*10**3)/len(all_our)*100} % tasks our-auto is 10^3 X faster everyone else\n")
    print(f"In {np.sum(all_bst>all_our*10**4)/len(all_our)*100} % tasks our-auto is 10^4 X faster everyone else")
    print(f"In {np.sum(all_bst>all_our*10**5)/len(all_our)*100} % tasks our-auto is 10^5 X faster everyone else\n")


def count_table():
	print(f"----------------- PURE-SAFETY({len(s_nuX)})  -----------------\n")
	print("        ---------     NuXmv --BDD      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_nuX)}\n")
	print(f"delay_2: {get_success_count(s2_dly_nuX)}\n")
	print(f"LCD_1  : {get_success_count(s1_lcd_nuX)}\n")
	print(f"LCD_2  : {get_success_count(s2_lcd_nuX)}\n")
	print(f"VGA_1  : {get_success_count(s1_vga_nuX)}\n")
	print(f"VGA_2  : {get_success_count(s2_vga_nuX)}\n")
	print(f"Blink_1: {get_success_count(s1_blk_nuX)}\n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_nuX)}\n")
	print(f"7sg_1  : {get_success_count(s1_sg7_nuX)}\n")
	print(f"i2c_1  : {get_success_count(s1_i2c_nuX)}\n")
	print(f"PWM_1  : {get_success_count(s1_pwm_nuX)}\n")
	print(f"UART_1 : {get_success_count(s1_utt_nuX)}\n")
	print(f"LS_1   : {get_success_count(s1_ls_nuX)} \n")
	print(f"Gray_1 : {get_success_count(s1_gry_nuX)}\n")
	print(f"Total  : {get_success_count(s_nuX)}\n")

	print("        ---------     rIC3      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_rIC3)}\n")
	print(f"delay_2: {get_success_count(s2_dly_rIC3)}\n")
	print(f"LCD_1  : {get_success_count(s1_lcd_rIC3)}\n")
	print(f"LCD_2  : {get_success_count(s2_lcd_rIC3)}\n")
	print(f"VGA_1  : {get_success_count(s1_vga_rIC3)}\n")
	print(f"VGA_2  : {get_success_count(s2_vga_rIC3)}\n")
	print(f"Blink_1: {get_success_count(s1_blk_rIC3)}\n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_rIC3)}\n")
	print(f"7sg_1  : {get_success_count(s1_sg7_rIC3)}\n")
	print(f"i2c_1  : {get_success_count(s1_i2c_rIC3)}\n")
	print(f"PWM_1  : {get_success_count(s1_pwm_rIC3)}\n")
	print(f"UART_1 : {get_success_count(s1_utt_rIC3)}\n")
	print(f"LS_1   : {get_success_count(s1_ls_rIC3)} \n")
	print(f"Gray_1 : {get_success_count(s1_gry_rIC3)}\n")
	print(f"Total  : {get_success_count(s_rIC3)}\n")

	print("        ---------     Our-Auto      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_nuRauto)}\n")
	print(f"delay_2: {get_success_count(s2_dly_nuRauto)}\n")
	print(f"LCD_1  : {get_success_count(s1_lcd_nuRauto)}\n")
	print(f"LCD_2  : {get_success_count(s2_lcd_nuRauto)}\n")
	print(f"VGA_1  : {get_success_count(s1_vga_nuRauto)}\n")
	print(f"VGA_2  : {get_success_count(s2_vga_nuRauto)}\n")
	print(f"Blink_1: {get_success_count(s1_blk_nuRauto)}\n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_nuRauto)}\n")
	print(f"7sg_1  : {get_success_count(s1_sg7_nuRauto)}\n")
	print(f"i2c_1  : {get_success_count(s1_i2c_nuRauto)}\n")
	print(f"PWM_1  : {get_success_count(s1_pwm_nuRauto)}\n")
	print(f"UART_1 : {get_success_count(s1_utt_nuRauto)}\n")
	print(f"LS_1   : {get_success_count( s1_ls_nuRauto)}\n")
	print(f"Gray_1 : {get_success_count(s1_gry_nuRauto)}\n")
	print(f"Total  : {get_success_count(s_nuRauto)}\n")

	print("        ---------     Our-Linear      ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_nuRLin)}\n")
	print(f"delay_2: {get_success_count(s2_dly_nuRLin)}\n")
	print(f"LCD_1  : {get_success_count(s1_lcd_nuRLin)}\n")
	print(f"LCD_2  : {get_success_count(s2_lcd_nuRLin)}\n")
	print(f"VGA_1  : {get_success_count(s1_vga_nuRLin)}\n")
	print(f"VGA_2  : {get_success_count(s2_vga_nuRLin)}\n")
	print(f"Blink_1: {get_success_count(s1_blk_nuRLin)}\n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_nuRLin)}\n")
	print(f"7sg_1  : {get_success_count(s1_sg7_nuRLin)}\n")
	print(f"i2c_1  : {get_success_count(s1_i2c_nuRLin)}\n")
	print(f"PWM_1  : {get_success_count(s1_pwm_nuRLin)}\n")
	print(f"UART_1 : {get_success_count(s1_utt_nuRLin)}\n")
	print(f"LS_1   : {get_success_count( s1_ls_nuRLin)}\n")
	print(f"Gray_1 : {get_success_count(s1_gry_nuRLin)}\n")
	print(f"Total  : {get_success_count(s_nuRLin)}\n")

	print("        ---------     ABC     ---------        \n")
	print(f"delay_1: {get_success_count(s1_dly_abc)}\n")
	print(f"delay_2: {get_success_count(s2_dly_abc)}\n")
	print(f"LCD_1  : {get_success_count(s1_lcd_abc)}\n")
	print(f"LCD_2  : {get_success_count(s2_lcd_abc)}\n")
	print(f"VGA_1  : {get_success_count(s1_vga_abc)}\n")
	print(f"VGA_2  : {get_success_count(s2_vga_abc)}\n")
	print(f"Blink_1: {get_success_count(s1_blk_abc)}\n")
	print(f"Tmcp_1 : {get_success_count(s1_tmp_abc)}\n")
	print(f"7sg_1  : {get_success_count(s1_sg7_abc)}\n")
	print(f"i2c_1  : {get_success_count(s1_i2c_abc)}\n")
	print(f"PWM_1  : {get_success_count(s1_pwm_abc)}\n")
	print(f"UART_1 : {get_success_count(s1_utt_abc)}\n")
	print(f"LS_1   : {get_success_count( s1_ls_abc)}\n")
	print(f"Gray_1 : {get_success_count(s1_gry_abc)}\n")
	print(f"Total  : {get_success_count(s_abc)}\n")


	print(f"\n\n\n----------------- PURE-LIVENESS({len(l_nuX)})  -----------------\n")
	print("        ---------     NuXmv --BDD      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_nuX)}\n")
	print(f"delay_2: {get_success_count(l2_dly_nuX)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_nuX)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_nuX)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_nuX)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_nuX)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_nuX)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_nuX)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_nuX)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_nuX)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_nuX)}\n")
	print(f"LS_1   : {get_success_count(l1_ls_nuX)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_nuX)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_nuX)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_nuX)}\n")

	print(f"Total  : {get_success_count(l_nuX)}\n")

	print("        ---------     rIC3     ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_rIC3)}\n")
	print(f"delay_2: {get_success_count(l2_dly_rIC3)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_rIC3)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_rIC3)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_rIC3)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_rIC3)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_rIC3)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_rIC3)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_rIC3)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_rIC3)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_rIC3)}\n")
	print(f"LS_1   : {get_success_count( l1_ls_rIC3)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_rIC3)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_rIC3)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_rIC3)}\n")

	print(f"Total  : {get_success_count(l_rIC3)}\n")

	print("        ---------     Our-Auto      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_nuRauto)}\n")
	print(f"delay_2: {get_success_count(l2_dly_nuRauto)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_nuRauto)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_nuRauto)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_nuRauto)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_nuRauto)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_nuRauto)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_nuRauto)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_nuRauto)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_nuRauto)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_nuRauto)}\n")
	print(f"LS_1   : {get_success_count( l1_ls_nuRauto)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_nuRauto)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_nuRauto)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_nuRauto)}\n")

	print(f"Total  : {get_success_count(l_nuRauto)}\n")

	print("        ---------     Our-Linear      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_nuRLin)}\n")
	print(f"delay_2: {get_success_count(l2_dly_nuRLin)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_nuRLin)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_nuRLin)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_nuRLin)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_nuRLin)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_nuRLin)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_nuRLin)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_nuRLin)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_nuRLin)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_nuRLin)}\n")
	print(f"LS_1   : {get_success_count( l1_ls_nuRLin)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_nuRLin)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_nuRLin)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_nuRLin)}\n")

	print(f"Total  : {get_success_count(l_nuRLin)}\n")

	print("        ---------     NMC'24      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_NMC24)}\n")
	print(f"delay_2: {get_success_count(l2_dly_NMC24)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_NMC24)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_NMC24)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_NMC24)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_NMC24)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_NMC24)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_NMC24)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_NMC24)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_NMC24)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_NMC24)}\n")
	print(f"LS_1   : {get_success_count( l1_ls_NMC24)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_NMC24)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_NMC24)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_NMC24)}\n")

	print(f"Total  : {get_success_count(l_NMC24)}\n")

	print("        ---------     ABC      ---------        \n")
	print(f"delay_1: {get_success_count(l1_dly_abc)}\n")
	print(f"delay_2: {get_success_count(l2_dly_abc)}\n")
	print(f"LCD_1  : {get_success_count(l1_lcd_abc)}\n")
	print(f"VGA_1  : {get_success_count(l1_vga_abc)}\n")
	print(f"Blink_1: {get_success_count(l1_blk_abc)}\n")
	print(f"Tmcp_1 : {get_success_count(l1_tmp_abc)}\n")
	print(f"7sg_1  : {get_success_count(l1_sg7_abc)}\n")
	print(f"7sg_2  : {get_success_count(l2_sg7_abc)}\n")
	print(f"i2c_1  : {get_success_count(l1_i2c_abc)}\n")
	print(f"PWM_1  : {get_success_count(l1_pwm_abc)}\n")
	print(f"UART_1 : {get_success_count(l1_utt_abc)}\n")
	print(f"LS_1   : {get_success_count( l1_ls_abc)} \n")
	print(f"Gray_1 : {get_success_count(l1_gry_abc)}\n")
	print(f"Gray_2 : {get_success_count(l2_gry_abc)}\n")
	print(f"Gray_3 : {get_success_count(l3_gry_abc)}\n")

	print(f"Total  : {get_success_count(l_abc)}\n")


	print(f"\n\n\n----------------- SAFETY-LIVENESS({len(sl_nuX)})  -----------------\n")
	print("        ---------     NuXmv --BDD     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_nuX)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_nuX)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_nuX)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_nuX)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_nuX)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_nuX)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_nuX)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_nuX)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_nuX)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_nuX)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_nuX)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_nuX)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_nuX)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_nuX)}\n")

	print(f"Total  : {get_success_count(sl_nuX)}\n")

	print("        ---------     rIC3     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_rIC3)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_rIC3)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_rIC3)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_rIC3)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_rIC3)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_rIC3)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_rIC3)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_rIC3)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_rIC3)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_rIC3)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_rIC3)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_rIC3)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_rIC3)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_rIC3)}\n")

	print(f"Total  : {get_success_count(sl_rIC3)}\n")

	print("        ---------     our (auto)     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_nuRauto)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_nuRauto)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_nuRauto)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_nuRauto)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_nuRauto)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_nuRauto)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_nuRauto)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_nuRauto)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_nuRauto)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_nuRauto)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_nuRauto)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_nuRauto)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_nuRauto)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_nuRauto)}\n")

	print(f"Total  : {get_success_count(sl_nuRauto)}\n")

	print("        ---------     our (Linear)     ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_nuRLin)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_nuRLin)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_nuRLin)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_nuRLin)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_nuRLin)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_nuRLin)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_nuRLin)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_nuRLin)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_nuRLin)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_nuRLin)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_nuRLin)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_nuRLin)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_nuRLin)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_nuRLin)}\n")

	print(f"Total  : {get_success_count(sl_nuRLin)}\n")
	
	print("        ---------     ABC      ---------        \n")
	print(f"delay_1: {get_success_count(sl1_dly_abc)}\n")
	print(f"delay_2: {get_success_count(sl2_dly_abc)}\n")
	print(f"LCD_1  : {get_success_count(sl1_lcd_abc)}\n")
	print(f"VGA_1  : {get_success_count(sl1_vga_abc)}\n")
	print(f"Blink_1: {get_success_count(sl1_blk_abc)}\n")
	print(f"Tmcp_1 : {get_success_count(sl1_tmp_abc)}\n")
	print(f"7sg_1  : {get_success_count(sl1_sg7_abc)}\n")
	print(f"i2c_1  : {get_success_count(sl1_i2c_abc)}\n")
	print(f"PWM_1  : {get_success_count(sl1_pwm_abc)}\n")
	print(f"UART_1 : {get_success_count(sl1_utt_abc)}\n")
	print(f"LS_1   : {get_success_count( sl1_ls_abc)} \n")
	print(f"LS_2   : {get_success_count( sl2_ls_abc)} \n")
	print(f"Gray_1 : {get_success_count(sl1_gry_abc)}\n")
	print(f"Gray_2 : {get_success_count(sl2_gry_abc)}\n")

	print(f"Total  : {get_success_count(sl_abc)}\n")
	



#----------------------------------------------------------------------------------
#							 Choices
#----------------------------------------------------------------------------------
stat1()
stat2()
stat3()
stat4()
stat5()
stat6()
stat7()
stat8()
stat9()

while(True):
	print("1)Cactus Plot (safety) 2)Cactus Plot (Liveness) 3)Cactus Plot (Safety+ Liveness)\n4)Scatter Plot (safety) 5)Scatter Plot (Liveness) 6)Scatter Plot (Safety+ Liveness) 7) Table Compare")
	ch = int(input("Enter your choice: "))
	if(ch == 1):
		cactusPlot(s_nuX, s_nuRauto, s_abc, s_rIC3, s_NMC24, s_nuRLin)
	elif(ch == 2):
		cactusPlot(l_nuX, l_nuRauto, l_abc, l_rIC3, l_NMC24, l_nuRLin)
	elif(ch == 3):
		cactusPlot(sl_nuX, sl_nuRauto, sl_abc, sl_rIC3, sl_NMC24, sl_nuRLin)
	elif(ch == 4):
		matrixPlot(np.minimum(np.minimum(s_nuX,s_abc), s_rIC3), s_nuRauto, "Best of Academic", "our-auto", s_sss)
	elif(ch == 5):
		matrixPlot(np.minimum(np.minimum(np.minimum(l_nuX,l_abc), l_NMC24), l_rIC3), l_nuRauto, "Best of Academic", "our-auto", l_sss)
	elif(ch == 6):
		matrixPlot(np.minimum(np.minimum(sl_nuX,sl_abc), sl_rIC3), sl_nuRauto, "Best of Academic", "our-auto", sl_sss)
	elif(ch == 7):
		count_table()
	else:
		print("Please enter an number between 1 to 1 ")



