# Deep Latent Variable Model based Vertical Federated Learning with Flexible Alignment and Labeling Scenarios

This is a description of the supplementary material for the paper **"Deep Latent Variable Model based Vertical Federated Learning with Flexible Alignment and Labeling Scenarios"**.

---

### Requirements

- `numpy==1.26.4`

- `torch==2.2.2`

- `torchvision==0.17.2`

---

### Pretraining and Finetuning

To run the experiments, execute 'main.py' with the following options:

#### Main Options

- `--task_name`: `isolet` | `hapt` | `fashionmnist` | `modelnet10`
- `--num_clients`: The number of participating parties
- `--labeled_aligned_num`: The number of labeled aligned samples
- `--labeled_unaligned_num`: The number of labeled unaligned samples
- `--missing_type`: `mcar` | `mar` | `mnar`
- `--p_mcar`: Missing rate for MCAR
- `--p_miss`: Hyperparameter controlling missingness in MNAR
- `--option`: Hyperparameter controlling missingness in MAR
- `--method` (**required**): `ours` (FALSE-VFL-I) | `ours_mnar` (FALSE-VFL-II)
- `--K`: The kappa parameter as defined in the paper
- `--K_test`: The L parameter as defined in the paper
- `--ours_agg`: Use `mean` option

#### Pretraining Options

- `--pretrain`: Enable pretraining mode
- `--label_only`: Skip pretraining and train only on labeled data

#### Loading Options (for Fine-tuning)

These options are used **only to identify the correct pretrained model checkpoint**.
They do **not** affect the actual fine-tuning hyperparameters, which are defined on task_config.yaml.

- `--lr_load`: Learning rate used during pretraining (× 1e-5)
- `--wd_load`: Weight decay used during pretraining (× 1e-5)
- `--bs_load`: Batch size used during pretraining

---

### Example Commands

#### Pretraining

```bash
python main.py --task_name isolet --num_clients 8 --missing_type mnar --p_miss 0.9 --method ours --pretrain
```

#### Fine-tuning

```bash
python main.py --task_name isolet --num_clients 8 --missing_type mnar --p_miss 0.9 --method ours --lr_load 50 --wd_load 10 --bs_load 512
```

---