# Supplementary Material for **SONIC: Spectral Oriented Neural Invariant Convolutions**


## Repository Layout

```
src/
├── sonicnet.py
├── modules/
│   └── sonic.py
experiments/
│   └── synthshape.py
weights/
│   ├── sonic_cityscape.pth
│   └── sonic_picaimodel.pth
readme.md
requirements.txt
```

---

## Installation

- Tested with **Python 3.8** and **PyTorch 1.10**.

Install with:
```bash
pip install -r requirements.txt
```

---
## Quick Start: Using the SONIC Layer

The primary entry point is `src/sonicnet.py`, which provides a minimal example.

All SONIC-specific keyword arguments (`**sonic_kwargs`) are documented in `src/modules/sonic.py`.
---

## Experiments

### 1) Synthshape
- Script: `experiments/synthshape.py`
- Run directly to reproduce the Synthshape results.

### 2) PI-CAI
- Trained using **nnU-Net (v2)**: https://github.com/MIC-DKFZ/nnUNet
- Steps:
  1. Follow nnU-Net’s setup instructions and dataset preparation.
  2. In the `nnunetv2` repository, create a `model/` directory, place `SonicNet.py`, and include `modules/sonic.py`.
  3. Implement a new trainer `SonicTrainer` in `nnunetv2.training.network_training.nnUNetTrainer` that imports and uses `SonicNet` as the network.
  4. Download **PI-CAI** (https://zenodo.org/records/6624726) and convert it using nnU-Net’s preprocessing pipeline, run training with `SonicTrainer` or;
  5. Use the pretrained weights provided in `weights/` to run inference directly on Prostate158 (https://zenodo.org/records/6481141) or on promis (https://ncita.org.uk/promis-data-set-open-access-request/)
  

**Hyperparameters.** For Prostate MRI we use the default hyperparameters defined in `modules/sonic.py`. 

**Pretrained weights.** We provide pretrained weights in `weights/`:
- Prostate MRI: `sonic_csPCa_weights.pth`

