# ∂gym: Differentiable Gym Environment for Learning with Temporal Logic


## Dependencies
 - [Python](https://www.python.org/) (3.10)
 - [Owl](https://owl.model.in.tum.de/) (21.0) : ```ltl2ldba``` and ```ltl2dpa``` must be in ```PATH```
 - [Spot](https://spot.lrde.epita.fr/) (2.12.1)
 - [CUDA](https://developer.nvidia.com/cuda-12-4-1-download-archive) (12.4)


## Installation on Ubuntu 22.04

## Tools
```sh
sudo apt install zip git build-essential python3-dev python3-venv
```

## CUDA
```sh
wget https://developer.download.nvidia.com/compute/cuda/repos/ubuntu2204/x86_64/cuda-ubuntu2204.pin
sudo mv cuda-ubuntu2204.pin /etc/apt/preferences.d/cuda-repository-pin-600
wget https://developer.download.nvidia.com/compute/cuda/12.4.1/local_installers/cuda-repo-ubuntu2204-12-4-local_12.4.1-550.54.15-1_amd64.deb
sudo dpkg -i cuda-repo-ubuntu2204-12-4-local_12.4.1-550.54.15-1_amd64.deb
sudo cp /var/cuda-repo-ubuntu2204-12-4-local/cuda-*-keyring.gpg /usr/share/keyrings/
sudo apt-get update
sudo apt-get -y install cuda-toolkit-12-4
sudo apt-get install -y nvidia-driver-550-open
sudo apt-get install -y cuda-drivers-550
```

### Virtual Environment
```sh
unzip dgym.zip
cd dgym
python3 -m venv .venv
source .venv/bin/activate
```

### Python Packages
```sh
pip install --upgrade pip
pip install -r requirements.txt
```

### Owl and Spot
```sh
wget https://github.com/owl-toolkit/owl/releases/download/release-21.0/owl-linux-amd64-21.0.zip
unzip owl-linux-amd64-21.0.zip
sudo cp owl-linux-musl-amd64-21.0/bin/* /usr/local/bin/
sudo cp owl-linux-musl-amd64-21.0/lib/* /usr/local/lib/

export PROJECT_HOME=$PWD
wget http://www.lrde.epita.fr/dload/spot/spot-2.12.1.tar.gz
tar -xzf spot-2.12.1.tar.gz
cd spot-2.12.1
./configure --prefix=/usr/local --with-pythondir=$PROJECT_HOME/.venv/lib/python3.10/site-packages
make -j8
sudo make install
cd ..
```

### SHAC, AHAC, and dFlex
```sh
git clone https://github.com/imgeorgiev/DiffRL.git
cd DiffRL
git checkout bb59db5cf65e63740787bf22f91bae3103b30d19
cp ../modified_DiffRL/cheetah.py dflex/dflex/envs/cheetah.py
cp ../modified_DiffRL/shac.py src/shac/algorithms/shac.py 
cp ../modified_DiffRL/ahac.py src/shac/algorithms/ahac.py
pip install -e dflex
pip install -e .
cd ..
```

## Basic Usage
Modify the wandb configuration in `cfg/config.yaml`
```sh
python train.py alg=shac env=cheetah general.seed=0 general.device=cuda:0 wandb.project=project 'general.ltl="F\"tip_velocity_x>0.5\""'
```
(Rewards should be divided by 1024 for normalization)
