#!/bin/bash
#
for i in {1..10}
do
    echo "seed"${i}""
    python ../online.py --model=EXP3_B \
    --seed=${i} \
    --ckpt_save_name="1026_1_final"${i}"" \
    --data_index=1 \
    --res_name="1026_1_final"${i}"" \
    >../Log/EXP3_B/""${i}"online_1026_1_final".log 2>&1

    python ../online.py --model=EXP3_B \
    --seed=${i} \
    --ckpt_save_name="1026_2_final"${i}"" \
    --data_index=2 \
    --res_name="1026_2_final"${i}"" \
    >../Log/EXP3_B/""${i}"online_1026_2_final".log 2>&1

    python ../online.py --model=EXP3_B \
    --seed=${i} \
    --ckpt_load_name="1026_1_final"${i}"" \
    --ckpt_save_name="1026_1+2_final"${i}"" \
    --data_index=2 \
    --res_name="1026_1+2_final"${i}"" \
    >../Log/EXP3_B/""${i}"online_1026_1+2_final".log 2>&1

    python ../batch.py --model=EXP3_B \
    --seed=${i} \
    --base_model_save_name="1101_1_final"${i}"" \
    --ckpt_load_name="1026_1_final"${i}"" \
    --data_index=2 \
    --res_name="1026_1to2_final"${i}"" \
    >../Log/EXP3_B/""${i}"batch_1026_1to2_final".log 2>&1

    python ../baseline.py --model=BBL \
    --seed=${i} \
    --base_model=EXP3_B \
    --base_model_save_name="1026_1_final"${i}"" \
    --data_index=2 \
    --res_name="1026_final"${i}"" \
    >../Log/EXP3_B/Baseline/""${i}"BBL_1026_final".log 2>&1

    python ../baseline.py --model=LL \
    --seed=${i} \
    --base_model=EXP3_B \
    --base_model_save_name="1026_1_final"${i}"" \
    --data_index=2 \
    --res_name="1026_final"${i}"" \
    >../Log/EXP3_B/Baseline/""${i}"LL_1026_final".log 2>&1


    for data_selection in S D
    do
        for j in {5..20..5}
        do
            python ../baseline.py --model=NIIDC \
            --seed=${i} \
            --base_model=EXP3_B \
            --K=${j} \
            --base_model_save_name="1026_1_final"${i}"" \
            --history_data_name="1026_1_final"${i}"" \
            --data_index=2 \
            --data_selection=${data_selection} \
            --res_name="1026_final"${i}""${data_selection}"_K"${j}"" \
            >../Log/EXP3_B/Baseline/""${i}""${data_selection}"_NIIDC_1026_final_K"${j}"".log 2>&1

            python ../baseline.py --model=SAC \
            --seed=${i} \
            --base_model=EXP3_B \
            --K=${j} \
            --base_model_save_name="1026_1_final"${i}"" \
            --data_index=2 \
            --data_selection=${data_selection} \
            --res_name="1026_final"${i}""${data_selection}"_K"${j}"" \
            >../Log/EXP3_B/Baseline/""${i}""${data_selection}"_SAC_1026_final_K"${j}"".log 2>&1

            python ../baseline.py --model=VC \
            --seed=${i} \
            --base_model=EXP3_B \
            --K=${j} \
            --base_model_save_name="1026_1_final"${i}"" \
            --data_index=2 \
            --data_selection=${data_selection} \
            --res_name="1026_final"${i}""${data_selection}"_K"${j}"" \
            >../Log/EXP3_B/Baseline/""${i}""${data_selection}"_VC_1026_final_K"${j}"".log 2>&1

            python ../baseline.py --model=CW \
            --seed=${i} \
            --base_model=EXP3_B \
            --K=${j} \
            --base_model_save_name="1026_1_final"${i}"" \
            --data_index=2 \
            --data_selection=${data_selection} \
            --res_name="1026_final"${i}""${data_selection}"_K"${j}"" \
            >../Log/EXP3_B/Baseline/""${i}""${data_selection}"_CW_1026_final_K"${j}"".log 2>&1

            if [ ${data_selection} == S ]
            then
                batch_size=512
                lr=0.01
                weight_decay=1e-5
            elif [ ${data_selection} == R ]
            then
                batch_size=512
                lr=0.01
                weight_decay=1e-3
            elif [ ${data_selection} == D ]
            then
                batch_size=2048
                lr=0.001
                weight_decay=1e-5
            fi

            python ../main_adao2b.py \
            --seed=${i} \
            --base_model=EXP3_B \
            --K=${j} \
            --batch_size=${batch_size} \
            --lr=${lr} \
            --weight_decay=${weight_decay} \
            --base_model_save_name="1026_1_final"${i}"" \
            --history_data_name="1026_1_final"${i}"" \
            --adao2b_ckpt_name="1026_adao2b_EXP3_B_final"${i}""${data_selection}"_K"${j}"" \
            --data_selection=${data_selection} \
            >../Log/AdaO2B/""${i}""${data_selection}"_1026_adao2b_EXP3_B_final_K"${j}"".log 2>&1

            python ../batch.py --model=EXP3_B \
            --seed=${i} \
            --K=${j} \
            --base_model_save_name="1026_1_final"${i}"" \
            --adao2b_ckpt_name="1026_adao2b_EXP3_B_final"${i}""${data_selection}"_K"${j}"" \
            --adao2b=1 \
            --data_index=2 \
            --res_name="AdaO2B_1026_final"${i}""${data_selection}"_K"${j}"" \
            --data_selection=${data_selection} \
            >../Log/AdaO2B/""${i}""${data_selection}"_1026_adao2b_EXP3_B_batch_test_final_K"${j}"".log 2>&1
        done
    done
done
  





