#!/bin/bash
trap 'exit' SIGINT
set -e

export CUDA_VISIBLE_DEVICES=1
export DS_SKIP_CUDA_CHECK=1

export NCCL_P2P_DISABLE=1
export NCCL_IB_DISABLE=1

log_dir=logs/
log_step=50
checkpoints_dir=checkpoints/
save_step=5
val_step=1
seed=42
use_resume=false
# 训练参数 
lr=0.0003
batch_size=128
# 数据参数
subj_list=(1)
nsddir=/opt/data/private/dataset/nsd
space=MNI_2mm
func=betas_fithrf_GLMdenoise_RR
clip_model=CLIP-ViT-H-14
norm_nii=true
# 损失函数参数
text_scale=1
mixup_pct=0
# 模型参数
patch_size=14
num_blocks=12
patch_drop=0
attn_drop=0
block_drop=0
nii_mask=brain
patch_type=conv
# 其他参数
buffer_size=4096

beta=0.1
var=0.1
layer=6
ibba_lr=1
tr_steps=5

subj_list_param="${subj_list[@]}"
subj_list_string=$(IFS=','; echo "${subj_list[*]}")

name="ddp2-0.01-qwen25vl-s${subj_list_string}-${clip_model}-mask=${nii_mask}-blocks=${num_blocks}-patch=${patch_type}_${patch_size}-pt_dp=${patch_drop}-at_dp=${attn_drop}-bo_dp=${block_drop}-txt_scl=${text_scale}-m_pct=${mixup_pct}-bs=${batch_size}-lr=${lr}-bf=${buffer_size}"


if ${norm_nii}; then 
        name+="-norm_nii" 
fi

tag=last
subj=1
run_cmd="python "
run_cmd+="src/gen_map_brain_ba.py 
        --name ${name} 
        --checkpoints_dir ${checkpoints_dir} 
        --seed ${seed} 
        --batch_size ${batch_size} 
        --subj_list ${subj_list_param} 
        --nsddir ${nsddir} 
        --space ${space} 
        --func ${func} 
        --clip_model ${clip_model} 
        --patch_size ${patch_size} 
        --num_blocks ${num_blocks} 
        --patch_type ${patch_type} 
        --patch_drop ${patch_drop} 
        --attn_drop ${attn_drop} 
        --block_drop ${block_drop} 
        --nii_mask ${nii_mask} 
        --tag ${tag} 
        --subj ${subj}
        --beta ${beta} 
        --var ${var} 
        --lr ${ibba_lr} 
        --layer ${layer} 
        --tr_steps ${tr_steps}
        "
if ${norm_nii}; then 
        run_cmd+=" --norm_nii" 
fi

echo ${run_cmd}
eval ${run_cmd} 
