sim = SIMULATOR_MODEL()
sim.create_pusher('3.0 3.0 0.05')

# Define physical parameters for different types of objects
physical_parameters_for_bottle = { 
    'sliding-friction': 0.2,
    'armature': 0.2,
    'stiffness': 0.3,
    'mass': 20.0,
    'damping': 5.7
}

physical_parameters_for_martini_glass = { 
    'sliding-friction': 0.4,
    'armature': 0.4,
    'stiffness': 1.0,
    'mass': 10.0,
    'damping': 8.8
}

physical_parameters_for_wine_glass = { 
    'sliding-friction': 0.5,
    'armature': 0.8,
    'stiffness': 0.6,
    'mass': 4.0,
    'damping': 8.3
}

# Define objects and their locations and colors based on provided images

# Row 1
sim.create_object(object_id=1, object_name='martini_glass', object_location=('row_1', 'column_1'), object_color='yellow', object_physics=physical_parameters_for_martini_glass)
sim.create_object(object_id=2, object_name='martini_glass', object_location=('row_1', 'column_2'), object_color='pink', object_physics=physical_parameters_for_martini_glass)

# Row 2
sim.create_object(object_id=4, object_name='bottle', object_location=('row_2', 'column_1'), object_color='red', object_physics=physical_parameters_for_bottle)
sim.create_object(object_id=5, object_name='martini_glass', object_location=('row_2', 'column_2'), object_color='gray', object_physics=physical_parameters_for_martini_glass)

# Row 3
sim.create_object(object_id=7, object_name='bottle', object_location=('row_3', 'column_1'), object_color='green', object_physics=physical_parameters_for_bottle)

# Add this line to the simulation creation
sim.create_scene()
sim_out = sim.run_simulation()
del sim
