sim = SIMULATOR_MODEL()
sim.create_pusher('3.0 3.0 0.05')

# General physical parameters used for defining objects
physical_parameters_bottle = {
    'sliding-friction': 0.19,
    'armature': 0.12,
    'stiffness': 0.22,
    'mass': 20.0,
    'damping': 7.7
}

physical_parameters_martini_glass = {
    'sliding-friction': 0.32,
    'armature': 0.35,
    'stiffness': 0.67,
    'mass': 10.0,
    'damping': 6.4
}

physical_parameters_wine_glass = {
    'sliding-friction': 0.29,
    'armature': 0.68,
    'stiffness': 0.46,
    'mass': 4.0,
    'damping': 8.3
}

# Creating the objects in the scene with their attributes
sim.create_tray()

# Correctly positioned objects in the scene
sim.create_object(object_id=1, object_name='bottle', object_location=('row_1', 'column_1'), object_color='olive', object_physics=physical_parameters_bottle)
sim.create_object(object_id=2, object_name='martini_glass', object_location=('row_2', 'column_1'), object_color='cyan', object_physics=physical_parameters_martini_glass)
sim.create_object(object_id=3, object_name='wine_glass', object_location=('row_2', 'column_2'), object_color='red', object_physics=physical_parameters_wine_glass)
sim.create_object(object_id=4, object_name='wine_glass', object_location=('row_3', 'column_2'), object_color='blue', object_physics=physical_parameters_wine_glass)
sim.create_object(object_id=5, object_name='martini_glass', object_location=('row_3', 'column_1'), object_color='green', object_physics=physical_parameters_martini_glass)

sim.create_scene()
sim_out = sim.run_simulation()
del sim
