sim = SIMULATOR_MODEL()
sim.create_pusher('3.0 3.0 0.05')

physical_parameters_for_object_id_tray = { 
             'sliding-friction': 0.1,
             'armature': 0.1,
             'stiffness': 0.0,
             'mass': 0.5,
             'damping': 20
}
sim.create_tray(object_physics = physical_parameters_for_object_id_tray)

# Common physical attributes
bottle_attrs = { 
    'sliding-friction': 0.2,
    'armature': 0.3,
    'stiffness': 0.3,
    'mass': 20.0,
    'damping': 5.6
}

martini_glass_attrs = { 
    'sliding-friction': 0.5,
    'armature': 0.2,
    'stiffness': 0.9,
    'mass': 10.0,
    'damping': 8.5
}

wine_glass_attrs = { 
    'sliding-friction': 0.5,
    'armature': 0.7,
    'stiffness': 0.6,
    'mass': 4.0,
    'damping': 8.0
}

# Creating objects for the new scene
sim.create_object(object_id=1, object_name='wine_glass', object_location=('row_1', 'column_1'), object_color='green', object_physics=wine_glass_attrs)
sim.create_object(object_id=2, object_name='wine_glass', object_location=('row_1', 'column_2'), object_color='yellow', object_physics=wine_glass_attrs)
sim.create_object(object_id=3, object_name='bottle', object_location=('row_1', 'column_3'), object_color='pink', object_physics=bottle_attrs)
sim.create_object(object_id=4, object_name='bottle', object_location=('row_2', 'column_1'), object_color='red', object_physics=bottle_attrs)
sim.create_object(object_id=5, object_name='martini_glass', object_location=('row_2', 'column_2'), object_color='cyan', object_physics=martini_glass_attrs)
sim.create_object(object_id=6, object_name='wine_glass', object_location=('row_2', 'column_3'), object_color='blue', object_physics=wine_glass_attrs)
sim.create_object(object_id=7, object_name='bottle', object_location=('row_3', 'column_1'), object_color='gray', object_physics=bottle_attrs)
sim.create_object(object_id=8, object_name='martini_glass', object_location=('row_3', 'column_2'), object_color='orange', object_physics=martini_glass_attrs)
sim.create_object(object_id=9, object_name='wine_glass', object_location=('row_3', 'column_3'), object_color='brown', object_physics=wine_glass_attrs)

# Create scene and run simulation
sim.create_scene()
sim_out=sim.run_simulation()
del sim
