# Define the new scene configuration script
sim = SIMULATOR_MODEL()
sim.create_pusher('3.0 3.0 0.05')

# Define physical parameters for each object type
physical_parameters_bottle = { 
    'sliding-friction': 0.2,
    'armature': 0.3,
    'stiffness': 0.3,
    'mass': 20.0,
    'damping': 6.0
}

physical_parameters_martini_glass = { 
    'sliding-friction': 0.6,
    'armature': 0.4,
    'stiffness': 1.0,
    'mass': 10.0,
    'damping': 8.0
}

physical_parameters_wine_glass = { 
    'sliding-friction': 0.6,
    'armature': 0.7,
    'stiffness': 0.5,
    'mass': 4.0,
    'damping': 7.0
}

# Create the tray
sim.create_tray(object_physics = {'sliding-friction': 0.1, 'armature': 0.1, 'stiffness': 0.0, 'mass': 0.5, 'damping': 20})

# Create the objects with their respective locations and colors
sim.create_object(object_id=1, object_name='bottle', object_location=('row_1', 'column_1'), object_color='cyan', object_physics=physical_parameters_bottle)
sim.create_object(object_id=2, object_name='martini_glass', object_location=('row_1', 'column_3'), object_color='brown', object_physics=physical_parameters_martini_glass)
sim.create_object(object_id=3, object_name='martini_glass', object_location=('row_2', 'column_3'), object_color='red', object_physics=physical_parameters_martini_glass)
sim.create_object(object_id=4, object_name='martini_glass', object_location=('row_3', 'column_2'), object_color='gray', object_physics=physical_parameters_martini_glass)
sim.create_object(object_id=5, object_name='martini_glass', object_location=('row_2', 'column_2'), object_color='purple', object_physics=physical_parameters_martini_glass)
sim.create_object(object_id=6, object_name='wine_glass', object_location=('row_3', 'column_1'), object_color='blue', object_physics=physical_parameters_wine_glass)
sim.create_object(object_id=7, object_name='wine_glass', object_location=('row_3', 'column_3'), object_color='green', object_physics=physical_parameters_wine_glass)

# Create and run the simulation
sim.create_scene()
sim_out = sim.run_simulation()
del sim
