sim = SIMULATOR_MODEL()
sim.create_pusher('3.0 3.0 0.05')
physical_parameters_for_object_id_tray = { 
             'sliding-friction': 0.1,
             'armature': 0.1,
             'stiffness': 0.0,
             'mass': 0.5,
             'damping': 20
         }
sim.create_tray(object_physics = physical_parameters_for_object_id_tray)

# Set up physical attributes for different object types
bottle_physical_params = { 
    'sliding-friction': 0.2,
    'armature': 0.3,
    'stiffness': 0.4,
    'mass': 20.0, 
    'damping': 6.0
}

martini_glass_physical_params = { 
    'sliding-friction': 0.5,
    'armature': 0.3,
    'stiffness': 0.9,
    'mass': 10.0, 
    'damping': 8.0
}

wine_glass_physical_params = { 
    'sliding-friction': 0.5,
    'armature': 0.7,
    'stiffness': 0.5,
    'mass': 4.0, 
    'damping': 7.5
}

# Create objects based on the task images

sim.create_object(object_id=1, object_name='martini_glass', object_location=('row_1', 'column_1'), object_color='red', object_physics=martini_glass_physical_params)
sim.create_object(object_id=2, object_name='martini_glass', object_location=('row_2', 'column_1'), object_color='purple', object_physics=martini_glass_physical_params)
sim.create_object(object_id=3, object_name='bottle', object_location=('row_2', 'column_2'), object_color='green', object_physics=bottle_physical_params)
sim.create_object(object_id=4, object_name='wine_glass', object_location=('row_3', 'column_2'), object_color='blue', object_physics=wine_glass_physical_params)
sim.create_object(object_id=5, object_name='bottle', object_location=('row_3', 'column_3'), object_color='gray', object_physics=bottle_physical_params)

sim.create_scene()
sim_out = sim.run_simulation()
del sim
