import os
import shutil

wandb_offline_folders = os.listdir('wandb')
# move all *.tar files to other folders
for folder in wandb_offline_folders:
    if folder.startswith('offline-run'):
        files = os.listdir(os.path.join('wandb', folder, 'files'))
        wandb_id = folder.split('-')[-1]
        # move all *.tar files to models/wandb_id/.tar
        for file in files:
            if file.endswith('.tar'):
                os.makedirs(os.path.join('models', wandb_id), exist_ok=True)
                shutil.move(os.path.join('wandb', folder, 'files', file), os.path.join('models', wandb_id, file))