# DecVFAL

**[NeurIPS-25] Accelerate Vertical Federated Adversarial Learning with Dual-level Decoupled Backpropagation**


# Abstract

Vertical Federated Learning (VFL) enables participants to collaboratively train models on aligned samples while keeping their heterogeneous features private and distributed.
Despite their utility, VFL models remain vulnerable to adversarial attacks during inference. 
Adversarial Training (AT), which generates adversarial examples at each training iteration, stands as the most effective defense for improving model robustness. 
However, applying AT in VFL settings (VFAL) faces significant computational efficiency challenges, as the distributed training framework necessitates iterative propagations across participants.
To this end, we propose **_DecVFAL_** framework, which substantially accelerates **_VFAL_** training through a dual-level **_Dec_**oupling mechanism applied during adversarial sample generation.
Specifically, we first decouple the bottom modules of clients (directly responsible for adversarial updates) from the remaining networks, enabling efficient _lazy sequential propagations_ that reduce communication frequency through delayed gradients. 
We further introduce _decoupled parallel backpropagation_ to accelerate delayed gradient computation by eliminating idle waiting through parallel processing across modules.
Additionally, we are the first to establish convergence analysis for VFAL, rigorously characterizing how our decoupling mechanism interacts with existing VFL dynamics, and prove that _DecVFAL_ achieves an $\mathcal{O}(1/\sqrt{K})$ convergence rate matching that of standard VFLs.
Experimental results show that _DecVFAL_ ensures competitive robustness while significantly achieving about $3\sim10\times$ speed up.

#### env and run

##### env-docker

```sh
apt update
# apt upgrade
apt install git vim screen tree htop pciutils pkg-config
vim ~/.ssh/authorized_keys
```

```sh
vim ~/.bashrc
```

```sh
git config --global http.sslVerify "false"
alias py='python'
# export TMOUT=600
# conda activate py311
```

##### env-pip

```sh
python -m pip install --upgrade pip wheel setuptools
python -m pip install pillow matplotlib tqdm pandas scikit-learn scipy
```

##### env-conda-mirror

```sh
# https://help.mirrorz.org/
# Windows:
conda config --set show_channel_urls yes
# Linux:
vim ~/.condarc
```

```sh
channels:
  - defaults
show_channel_urls: true
default_channels:
  - https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/main
  - https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/r
  - https://mirrors.tuna.tsinghua.edu.cn/anaconda/pkgs/msys2
custom_channels:
  conda-forge: https://mirrors.tuna.tsinghua.edu.cn/anaconda/cloud
  pytorch: https://mirrors.tuna.tsinghua.edu.cn/anaconda/cloud
```

##### env-conda

```sh
# torch 2.2.1
# cuda 12.1.1
# python 3.11
conda clean -i
# conda update -n base -c defaults conda
conda create -y -n py311 python=3.11
conda activate py311
which python
# https://pytorch.org/
# conda install pytorch==2.2.1 torchvision==0.17.1 torchaudio==2.2.1 pytorch-cuda=12.1 -c pytorch -c nvidia -y
# conda install pillow matplotlib numpy tqdm pandas scikit-learn scipy -c pytorch -c nvidia -y
conda install pytorch==2.2.1 torchvision==0.17.1 torchaudio==2.2.1 pillow matplotlib numpy tqdm pandas scikit-learn scipy pytorch-cuda=12.1 -c pytorch -c nvidia -y
```

##### check

```sh
nvidia-smi
which python
python -c 'import torch;print(torch.cuda.is_available())'
lscpu
lsmem
# lspci
uname -a
```

##### run

```sh
screen -R screen1
cd exp
python train.py
# python eval.py
# Ctrl A D
```
