# $\text{D}^2\text{Controller}$

## Environment Setup
Create a new virtual environment with `Python==3.9.16`
```
conda create --name d2controller python=3.9.16
```

Install `requirement.txt`
```
pip install -r requirement.txt
```

## Datasets and Models
Please download datasets and models from the Internet since the limitation of size of extra material. Put the datasets under `data/` directory and models under `llm/` directory. For example
```
data/
  |--sst2/
      |--train.jsonal
      |--test.jsonal
      |--dev_subsample.jsonal

llm/
  |--gpt2-medium/
      |--config.json
      |--merges.txt
      |--pytorch_model.bin
      |--tokenizer.json
      |--vocab.json
```

# Running Code
### Preprocess 
run the bash script `do_preprocess.sh` to transform original dataset files
```
bash do_preprocess.sh
```

### Run ICL
To obtain results on validation set, run script `run_icl.sh`
```
bash run_icl.sh
```
Notice that you should allocate names and directories for datasets and models in the script.

### Select k-shot setting
To obtain selected $k$-shot settings, run script `run_selectk.sh`
```
bash run_selectk.sh
```
Notice that you should allocate names and directories for datasets and models in the script.

For OPT-30B model, we use script `run_selectk_multi.sh` to obtain results
```
bash run_selectk_multi.sh
```