#!/bin/bash

mkdir -p data
cd data
# Note that torchtext implementations change constantly. 
# If these urls do not work, please download datasets separately.

# Download dbpedia from torchtext: https://pytorch.org/text/stable/_modules/torchtext/datasets/dbpedia.html#DBpedia (v 0.12.0)
dbpedia_url="https://drive.google.com/uc?id=0Bz8a_Dbh9QhbQ2Vic1kxMmZZQ1k"
gdown ${dbpedia_url}
tar -xvzf dbpedia_csv.tar.gz

# Download ag_news from torchtext: https://pytorch.org/text/stable/_modules/torchtext/datasets/ag_news.html#AG_NEWS (v 0.12.0)
mkdir -p ag_news_csv
cd ag_news_csv
wget https://raw.githubusercontent.com/mhjabreel/CharCnn_Keras/master/data/ag_news_csv/train.csv
wget https://raw.githubusercontent.com/mhjabreel/CharCnn_Keras/master/data/ag_news_csv/test.csv

cd ../../
