# Supplementary Material for the paper A scalable tester for samplers (Paper ID:4566)

  

Pacoco is a framework developed to test whether a sampler is epsilon-close or eta-far from a given distribution with confidence greater than 1-delta.

  
The full paper has two Appendices(A-B).

Appendix A contains the theoretical justification for the theorems and lemmas mentioned in the paper.

Appendix B has the results for the entire set of benchmarks and all the tested samplers.

The results presented in the extended tables of Appendix B can be verified with the code and benchmarks presented in this folder.

  

## Requirements to run the code

  

* Python 2.7
  

To install the required libraries, run:

  

```

sudo pip install -r requirements.txt

```

  

## Getting Started

  

To run with the parameter values used in the paper for the sampler wSTS:

  

```

cp benchmarks/scalable/scal3.cnf code/

cd code

python pacoco.py --eta 0.9 --epsilon 0.05 --delta 0.2 --sampler 3 --seed 42 scal3.cnf

```

  
  

For the command-

  

```

python pacoco.py --eta ETA --epsilon EPSILON --delta DELTA --sampler SAMPLER-TYPE --seed SEED mycnf.cnf

```

  

ETA takes values in (0,1),

EPSILON takes values in (0,0.09),

DELTA takes values in (0,0.5),

SEED takes integer values, and

  

SAMPLER-TYPE takes the following values:

  

* UniGen3 = 1

* QuickSampler = 2

* STS = 3

  

Note that only UniGen3 shows identical behavior with a fixed seed.

  

### Samplers used

  

In the "samplers" directory, you will find 64-bit x86 Linux compiled binaries for:

  

* UniGen3- an almost-uniform sampler, version 3

* Quick Sampler

* STS
