#!/usr/bin/env bash

export SAVE_STEPS=100
export FILTER=-1
export EPOCHS=3
export LAYERS=2
export SEED=49
export BATCH_SIZE=32
export LR=0.0001
export RENY_TRAINING=2
export HIDDEN_SIZE=128
export NOISE_P=0.2
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=128

for checkpoints_number in "500000"; do
  for STYLE_DIM in 1; do
    for MODEL in 'no_reny_128' 'baseline_128' 'reny_1_3_128' 'reny_1_5_128' 'reny_1_8_128'; do

      for MUL in 0.001 0.01 0.1 1 5 10 15 20; do
        MODEL_PATH="style_emb_lambda_${MUL}_classif_mention_${MODEL}"
        echo $MODEL_PATH
        echo $checkpoints_number
        export suffix=${MODEL_PATH}_${checkpoints_number}
        export MODEL_PATH=${MODEL_PATH}/checkpoint-${checkpoints_number}
        export OUTPUT_DIR="${MODEL_PATH}_${checkpoints_number}"

        sbatch --job-name=${MODEL}_${MUL}_${SUFFIX} \
          --partition=gpu_p3 \
          --gres=gpu:1 \
          --no-requeue \
          --cpus-per-task=3 \
          --hint=nomultithread \
          --time=1:00:00 \
          --output=jobinfo/${MODEL}_${MUL}_${SUFFIX}_%j.out \
          --error=jobinfo/${MODEL}_${MUL}_${SUFFIX}_%j.err \
          --qos=qos_gpu-t4 \
          --wrap="module purge; module load pytorch-gpu/py3/1.1 ;  python evaluate_for_classification.py --use_mention  --save_step=$SAVE_STEPS  --suffix=$suffix  --num_train_epochs=$EPOCHS   --output_dir=$OUTPUT_DIR  --batch_size=$BATCH_SIZE --model=$MODEL  --model_path_to_load=$MODEL_PATH"

      done

    done

  done
done

#for checkpoints_number in "500000"; do
#  for STYLE_DIM in 1; do
#    for MODEL in 'no_reny_128' 'baseline_128' 'reny_1_3_128' 'reny_1_5_128' 'reny_1_8_128'; do

#      for MUL in 0.001 0.01 0.1 1 5 10 15 20; do
#       MODEL_PATH="style_emb_lambda_${MUL}_classif_mention_${MODEL}"
#       echo $MODEL_PATH
#       echo $checkpoints_number
#       export suffix=${MODEL_PATH}_${checkpoints_number}
#       export MODEL_PATH=${MODEL_PATH}/checkpoint-${checkpoints_number}
#       export OUTPUT_DIR="${MODEL_PATH}_${checkpoints_number}"

#        sbatch --job-name=${MODEL}_${MUL}_${SUFFIX} \
#          --partition=gpu_p1 \
#         --gres=gpu:1 \
#          --no-requeue \
#         --cpus-per-task=10 \
#         --hint=nomultithread \
#         --time=10:00:00 \
#         --output=jobinfo/${MODEL}_${MUL}_${SUFFIX}_%j.out \
#         --error=jobinfo/${MODEL}_${MUL}_${SUFFIX}_%j.err \
#         --qos=qos_gpu-t4 \
#         --wrap="module purge; module load pytorch-gpu/py3/1.1 ;  python evaluate_for_classification.py  --use_mention --save_step=$SAVE_STEPS  --suffix=$suffix  --num_train_epochs=$EPOCHS   --output_dir=$OUTPUT_DIR  --batch_size=$BATCH_SIZE --model=$MODEL  --model_path_to_load=$MODEL_PATH"

#     done

#   done

#  done
#done
