 #!/usr/bin/env bash

export SAVE_STEPS=100
export FILTER=-1
export EPOCHS=1
export SEED=49
export BATCH_SIZE=256

export NB_SEQ=100
export MODEL=style_emb

export MODEL=style_emb
for suffix1 in "baseline" "no_reny" "reny_1_3" "reny_1_5"; do
  for lambdavalue in 0.1 0.5 1 5 10 15 20; do
    for CHECKPOINTS in 80000 90000; do
      export DATA_PATH=style_emb_lambda_${lambdavalue}_very_new_gender_${suffix1}_${CHECKPOINTS}
      export SENTENCE_FOLDER=sentences_new
      bsub -q prod.med -n 2 -R "rusage[ngpus_excl_p=1]" -e "${DATA_PATH}.stderr.%J" -o "${DATA_PATH}.stdout.%J" -J "${DATA_PATH}" python evaluate_generated_sentences.py --sentences=${SENTENCE_FOLDER} --data_name=$DATA_PATH --lm_folder="gpt_2_for_gender" --fastText_folder="gender_fastText"
    done
  done

done


export MODEL=style_emb
for suffix1 in "no_reny" "reny_1_3" "reny_1_5"; do
  for lambdavalue in 0.1 0.5 1 5 10 15 20; do
    for CHECKPOINTS in 200000 210000 220000; do
      export SENTENCE_FOLDER=sentences_new_jeanzay
      export DATA_PATH=style_emb_lambda_${lambdavalue}_new_new_sentiment_${suffix1}_10_128_csc_128_${CHECKPOINTS}
      bsub -q prod.med -n 2 -R "rusage[ngpus_excl_p=1]" -e "${DATA_PATH}.stderr.%J" -o "${DATA_PATH}.stdout.%J" -J "${DATA_PATH}" python evaluate_generated_sentences.py --sentences=${SENTENCE_FOLDER} --data_name=$DATA_PATH --lm_folder="gpt_2_for_yelp" --fastText_folder="yelp_fastText"
    done
  done

done

export MODEL=style_emb
for suffix1 in "baseline"; do
  for lambdavalue in 0.1 0.5 1 5 10 15 20; do
    for CHECKPOINTS in 90000 100000; do
      export SENTENCE_FOLDER=sentences_new_jeanzay
      export DATA_PATH=style_emb_lambda_${lambdavalue}_new_new_sentiment_${suffix1}_10_128_s_${CHECKPOINTS}
      bsub -q prod.med -n 2 -R "rusage[ngpus_excl_p=1]" -e "${DATA_PATH}.stderr.%J" -o "${DATA_PATH}.stdout.%J" -J "${DATA_PATH}" python evaluate_generated_sentences.py --sentences=${SENTENCE_FOLDER} --data_name=$DATA_PATH --lm_folder="gpt_2_for_yelp" --fastText_folder="yelp_fastText"
    done
  done
done

export MODEL=style_emb
for suffix1 in "no_reny" "reny_1_3" "reny_1_5" "baseline"; do
  for lambdavalue in 0.1 0.5 1 5 10 15 20; do
    for CHECKPOINTS in 160000 170000 180000; do
      export SENTENCE_FOLDER=sentences_new_jeanzay
      export DATA_PATH=style_emb_lambda_${lambdavalue}_new_new_sentiment_${suffix1}_10_128_csc__${CHECKPOINTS}
      bsub -q prod.med -n 2 -R "rusage[ngpus_excl_p=1]" -e "${DATA_PATH}.stderr.%J" -o "${DATA_PATH}.stdout.%J" -J "${DATA_PATH}" python evaluate_generated_sentences.py --sentences=${SENTENCE_FOLDER} --data_name=$DATA_PATH --lm_folder="gpt_2_for_yelp" --fastText_folder="yelp_fastText"
    done
  done

done
