#!/usr/bin/env bash
export SAVE_STEPS=10000
export FILTER=-1
export EPOCHS=200
export EVAL_STEPS=1000
export LAYERS=2
export SEED=49
export BATCH_SIZE=32
export LR=0.00005
export RENY_TRAINING=3
export HIDDEN_SIZE=128
export NOISE_P=0.2

HOST="tsicluster13 tsicluster14 tsicluster15 tsicluster16 tsicluster17 tsicluster18 tsicluster19 tsicluster20 tsicluster21 tsicluster22 tsicluster24 tsicluster25 tsicluster26 tsicluster27 tsicluster28 tsicluster29 tsicluster30 tsicluster31 tsicluster32 tsicluster33"
ARRHOS=($HOST)

export HOSTNUM=0

for STYLE_DIM in 1; do
  for MODEL in 'style_emb'; do
    for MUL in 0.001 15 20; do # 15 20 0.001 0.1

      export ALPHA=1.3
      export CONTENT_DIM=128
      export DEC_HIDDEN_DIM=128
      export SUFFIX=very_new_category_no_reny_c_128_${RENY_TRAINING}_no_reset_cp
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      PROG="/$USER/anaconda3/bin/python /$USER/DIT/train.py  --use_category  --use_complex_classifier --complex_proj_content  --no_reny --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA"
      echo $PROG | tee ${OUTPUT_DIR}.sh
      qsub -l gpu=1 -l hostname=${ARRHOS[$HOSTNUM]} ${OUTPUT_DIR}.sh
      export HOSTNUM=$HOSTNUM+1
      echo $HOSTNUM
      echo ${ARRHOS[$HOSTNUM]}
      export ALPHA=1.3
      export CONTENT_DIM=128
      export DEC_HIDDEN_DIM=128
      export SUFFIX=very_new_category_reny_1_3_c_128_${RENY_TRAINING}_no_reset_cp
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}
      sleep 2s

      PROG="/$USER/anaconda3/bin/python /$USER/DIT/train.py  --use_category   --use_complex_classifier --complex_proj_content  --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA"
      echo $PROG | tee ${OUTPUT_DIR}.sh
      qsub -l gpu=1 -l hostname=${ARRHOS[$HOSTNUM]} ${OUTPUT_DIR}.sh
      export HOSTNUM=$HOSTNUM+1
      echo ${ARRHOS[$HOSTNUM]}
      echo $HOSTNUM
      export ALPHA=1.5
      export CONTENT_DIM=128
      export DEC_HIDDEN_DIM=128
      export SUFFIX=very_new_category_reny_1_5_c_128_${RENY_TRAINING}_no_reset_cp
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}
      sleep 2s
      PROG="/$USER/anaconda3/bin/python /$USER/DIT/train.py  --use_category  --use_complex_classifier --complex_proj_content  --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA"
      echo $PROG | tee ${OUTPUT_DIR}.sh
      qsub -l gpu=1 -l hostname=${ARRHOS[$HOSTNUM]} ${OUTPUT_DIR}.sh
      export HOSTNUM=$HOSTNUM+1
      echo ${ARRHOS[$HOSTNUM]}
      echo $HOSTNUM

      export ALPHA=1.8
      export CONTENT_DIM=128
      export DEC_HIDDEN_DIM=128
      export SUFFIX=very_new_category_reny_1_8_c_128_${RENY_TRAINING}_no_reset_cp
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}
      sleep 2s
      PROG="/$USER/anaconda3/bin/python /$USER/DIT/train.py  --use_category   --use_complex_classifier --complex_proj_content --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA"
      echo $PROG | tee ${OUTPUT_DIR}.sh
      qsub -l gpu=1 -l hostname=${ARRHOS[$HOSTNUM]} ${OUTPUT_DIR}.sh
      export HOSTNUM=$HOSTNUM+1
      echo ${ARRHOS[$HOSTNUM]}
      echo $HOSTNUM

      export ALPHA=1.3
      export CONTENT_DIM=128
      export DEC_HIDDEN_DIM=128
      export SUFFIX=very_new_category_baseline_c_12_small_${RENY_TRAINING}_no_reset
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}
      sleep 2s
      PROG="/$USER/anaconda3/bin/python /$USER/DIT/train.py   --use_category --complex_proj_content --use_complex_classifier --no_minimization_of_mi_training --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA"
      echo $PROG | tee ${OUTPUT_DIR}.sh
      qsub -l gpu=1 -l hostname=${ARRHOS[$HOSTNUM]} ${OUTPUT_DIR}.sh
      export HOSTNUM=$HOSTNUM+1
      echo ${ARRHOS[$HOSTNUM]}
      echo $HOSTNUM
      sleep 2s
    done

  done

done

