#!/usr/bin/env bash

export SAVE_STEPS=20000
export FILTER=-1
export EPOCHS=200
export EVAL_STEPS=1000
export LAYERS=2
export SEED=49
export BATCH_SIZE=64
export LR=0.0001
export RENY_TRAINING=2
export HIDDEN_SIZE=136
export NUMBER_TRAINING_ENCODER=10
export NOISE_P=0.2

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=20
export SUFFIX=no_reny
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}.stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_reny \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=15
export SUFFIX=no_reny
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_reny \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=10
export SUFFIX=no_reny
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_reny \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=5
export SUFFIX=no_reny
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_reny \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=1
export SUFFIX=no_reny
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_reny \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=20
export SUFFIX=reny_1_3
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=15
export SUFFIX=reny_1_3
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=10
export SUFFIX=reny_1_3
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=5
export SUFFIX=reny_1_3
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=1
export SUFFIX=reny_1_3
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=20
export SUFFIX=baseline
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_minimization_of_mi_training \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=15
export SUFFIX=baseline
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_minimization_of_mi_training \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=10
export SUFFIX=baseline
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_minimization_of_mi_training \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=5
export SUFFIX=baseline
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_minimization_of_mi_training \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER

export ALPHA=1.3
export STYLE_DIM=8
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=136
export MODEL=dae
export MUL=1
export SUFFIX=baseline
export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

bsub -q prod.long -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py \
  --no_minimization_of_mi_training \
  --add_noise \
  --noise_p=$NOISE_P \
  --content_dim=$CONTENT_DIM \
  --hidden_dim=$HIDDEN_SIZE \
  --dec_hidden_dim=$DEC_HIDDEN_DIM \
  --not_use_ema \
  --mul_mi=$MUL \
  --reny_training=$RENY_TRAINING \
  --style_dim=$STYLE_DIM \
  --batch_size=$BATCH_SIZE \
  --seed=$SEED \
  --save_step=$SAVE_STEPS \
  --learning_rate=$LR \
  --output_dir=$OUTPUT_DIR \
  --num_train_epochs=$EPOCHS \
  --eval_step=$EVAL_STEPS \
  --number_of_layers=$LAYERS \
  --model=$MODEL \
  --filter=$FILTER \
  --alpha=$ALPHA \
  --number_of_training_encoder=$NUMBER_TRAINING_ENCODER
