#!/usr/bin/env bash

export SAVE_STEPS=100
export FILTER=-1
export EPOCHS=1
export SEED=49
export BATCH_SIZE=256

export NB_SEQ=100
export MODEL=style_emb
for suffix1 in "reny_1_5" "reny_1_3" "no_reny" "baseline"; do
  for lambdavalue in 0.1 1 5 10 15 20; do
    for CHECKPOINTS in 500000 510000; do
      export MODEL_PATH=style_emb_lambda_${lambdavalue}_very_new_gender_${suffix1}
      export suffix=${MODEL_PATH}_${CHECKPOINTS}
      export MODEL_PATH=${MODEL_PATH}/checkpoint-${CHECKPOINTS}
      export OUTPUT_DIR=${MODEL_PATH}_${CHECKPOINTS}_
      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "eval_${suffix}.stderr.%J" -o "eval_${suffix}.stdout.%J" -J "${suffix}" python evaluate_for_style_transfert.py \
        --save_step=$SAVE_STEPS \
        --use_gender \
        --suffix=$suffix \
        --num_train_epochs=$EPOCHS \
        --do_train_classifer \
        --do_test_transfer \
        --do_test_reconstruction \
        --do_eval \
        --output_dir=$OUTPUT_DIR \
        --batch_size=$BATCH_SIZE \
        --filter=-1 \
        --use_complex_classifier \
        --model=$MODEL \
        --model_path_to_load=$MODEL_PATH \
        --saving_result_file=evaluate_for_style_transfert.txt
    done
  done
done
#export MODEL=style_emb
#for suffix1 in "baseline" "no_reny" "reny_1_3" "reny_1_5"; do
#  for lambdavalue in 0.1 0.5 1 5 10 15 20; do
#    for CHECKPOINTS in 480000 500000 520000; do
#      export DATA_PATH=style_emb_lambda_${lambdavalue}_new_sentiment_${suffix1}
#      export suffix=${MODEL_PATH}_${CHECKPOINTS}
#      export OUTPUT_DIR=${MODEL_PATH}_${CHECKPOINTS}_

#      bsub -q prod.med -n 2 -R "rusage[ngpus_excl_p=1]" -e "${DATA_PATH}.stderr.%J" -o "${DATA_PATH}.stdout.%J" -J "${DATA_PATH}" python evaluate_generated_sentences.py \
#        --data_name=$DATA_PATH
#    done
#  done

#done
