#!/usr/bin/env bash

export SAVE_STEPS=5000
export FILTER=-1
export EPOCHS=5
export SEED=49
export BATCH_SIZE=256

export NB_SEQ=100

export MODEL=style_emb
for MODEL_PATH in "style_emb_lambda_10_baseline" "style_emb_lambda_10_no_reny" "style_emb_lambda_10_reny_1_3" "style_emb_lambda_15_baseline" "style_emb_lambda_15_no_reny" "style_emb_lambda_15_reny_1_3" "style_emb_lambda_20_baseline" "style_emb_lambda_20_no_reny" "style_emb_lambda_20_reny_1_3"; do
  export suffix=$MODEL_PATH
  export MODEL_PATH=${MODEL_PATH}/checkpoint-540000
  export OUTPUT_DIR="${MODEL_PATH}_"
  bsub -q prod.short -n 1 -R "rusage[ngpus_excl_p=1]" -e "${suffix}.stderr.%J" -o "${suffix}.stdout.%J" -J "${suffix}" python evaluate_for_style_transfert.py \
    --save_step=$SAVE_STEPS \
    --suffix=$suffix \
    --num_train_epochs=$EPOCHS \
    --do_train_classifer \
    --do_test_transfer \
    --do_test_reconstruction \
    --do_train_classifer \
    --do_eval \
    --output_dir=$OUTPUT_DIR \
    --batch_size=$BATCH_SIZE \
    --filter=-1 \
    --model=$MODEL \
    --model_path_to_load=$MODEL_PATH \
    --saving_result_file=evaluate_for_style_transfert.txt

done

export MODEL=multi_dec
for MODEL_PATH in "multi_dec_lambda_1_baseline" "multi_dec_lambda_1_no_reny" "multi_dec_lambda_1_reny_1_3" "multi_dec_lambda_5_baseline" "multi_dec_lambda_5_no_reny" "multi_dec_lambda_5_reny_1_3" "multi_dec_lambda_10_baseline" "multi_dec_lambda_10_no_reny" "multi_dec_lambda_10_reny_1_3" "multi_dec_lambda_15_baseline" "multi_dec_lambda_15_no_reny" "multi_dec_lambda_15_reny_1_3" "multi_dec_lambda_20_baseline" "multi_dec_lambda_20_no_reny" "multi_dec_lambda_20_reny_1_3"; do
  export suffix=$MODEL_PATH
  export MODEL_PATH=${MODEL_PATH}/checkpoint-500000
  export OUTPUT_DIR="${MODEL_PATH}_"
  bsub -q prod.short -n 1 -R "rusage[ngpus_excl_p=1]" -e "${suffix}.stderr.%J" -o "${suffix}.stdout.%J" -J "${suffix}" python evaluate_for_style_transfert.py \
    --save_step=$SAVE_STEPS \
    --suffix=$suffix \
    --num_train_epochs=$EPOCHS \
    --do_train_classifer \
    --do_test_transfer \
    --do_train_classifer \
    --do_eval \
    --do_test_reconstruction \
    --output_dir=$OUTPUT_DIR \
    --batch_size=$BATCH_SIZE \
    --filter=-1 \
    --model=$MODEL \
    --model_path_to_load=$MODEL_PATH \
    --saving_result_file=evaluate_for_style_transfert.txt

done

export MODEL=dae
for MODEL_PATH in "dae_lambda_1_baseline" "dae_lambda_1_no_reny" "dae_lambda_1_reny_1_3" "dae_lambda_5_baseline" "dae_lambda_5_no_reny" "dae_lambda_5_reny_1_3" "dae_lambda_10_baseline" "dae_lambda_10_no_reny" "dae_lambda_10_reny_1_3" "dae_lambda_15_baseline" "dae_lambda_15_no_reny" "dae_lambda_15_reny_1_3" "dae_lambda_20_baseline" "dae_lambda_20_no_reny" "dae_lambda_20_reny_1_3"; do
  export suffix=$MODEL_PATH
  export MODEL_PATH=${MODEL_PATH}/checkpoint-80000
  export OUTPUT_DIR="${MODEL_PATH}_"
  bsub -q prod.short -n 1 -R "rusage[ngpus_excl_p=1]" -e "${suffix}.stderr.%J" -o "${suffix}.stdout.%J" -J "${suffix}" python evaluate_for_style_transfert.py \
    --save_step=$SAVE_STEPS \
    --suffix=$suffix \
    --num_train_epochs=$EPOCHS \
    --do_test_transfer \
    --do_train_classifer \
    --do_eval \
    --do_test_reconstruction \
    --output_dir=$OUTPUT_DIR \
    --batch_size=$BATCH_SIZE \
    --filter=-1 \
    --model=$MODEL \
    --model_path_to_load=$MODEL_PATH \
    --saving_result_file=evaluate_for_style_transfert.txt

done
