#!/usr/bin/env bash

export SAVE_STEPS=10000
export FILTER=-1
export EPOCHS=200
export EVAL_STEPS=500
export LAYERS=2
export SEED=49
export BATCH_SIZE=32
export LR=0.0001
export RENY_TRAINING=3
export HIDDEN_SIZE=128
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=128
export NOISE_P=0.2

for STYLE_DIM in 1; do
  for MODEL in 'style_emb'; do
    for MUL in 0.001 0.01 0.1 1 5 10 15 20; do

      export ALPHA=1.3
      export SUFFIX=classif_mention_no_reny_128_${RENY_TRAINING}_no_reset_128
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py --use_mention --classif --use_complex_classifier --no_reny --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA

      export ALPHA=1.3
      export SUFFIX=classif_mention_reny_1_3_128_${RENY_TRAINING}_no_reset_128
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py --use_mention --classif --use_complex_classifier --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA

      export ALPHA=1.5
      export SUFFIX=classif_mention_reny_1_5_128_${RENY_TRAINING}_no_reset_128
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py --use_mention --classif --use_complex_classifier --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA

      export ALPHA=1.8
      export SUFFIX=classif_mention_reny_1_8_128_${RENY_TRAINING}_no_reset_128
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py --use_mention --classif --use_complex_classifier --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA

      export ALPHA=1.3
      export SUFFIX=classif_mention_baseline_128_${RENY_TRAINING}_no_reset_128
      export OUTPUT_DIR=${MODEL}_lambda_${MUL}_${SUFFIX}

      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${OUTPUT_DIR}.stderr.%J" -o "${OUTPUT_DIR}stdout.%J" -J "${OUTPUT_DIR}" python train.py --use_mention --classif --use_complex_classifier --no_minimization_of_mi_training --add_noise --noise_p=$NOISE_P --content_dim=$CONTENT_DIM --hidden_dim=$HIDDEN_SIZE --dec_hidden_dim=$DEC_HIDDEN_DIM --not_use_ema --mul_mi=$MUL --reny_training=$RENY_TRAINING --style_dim=$STYLE_DIM --batch_size=$BATCH_SIZE --seed=$SEED --save_step=$SAVE_STEPS --learning_rate=$LR --output_dir=$OUTPUT_DIR --num_train_epochs=$EPOCHS --eval_step=$EVAL_STEPS --number_of_layers=$LAYERS --model=$MODEL --filter=$FILTER --alpha=$ALPHA
    done
  done
done
