#!/usr/bin/env bash

export SAVE_STEPS=500
export FILTER=-1
export EPOCHS=10
export EVAL_STEPS=500
export LAYERS=2
export SEED=49
export BATCH_SIZE=500
export LR=0.0001
export RENY_TRAINING=3
export HIDDEN_SIZE=128
export CONTENT_DIM=128
export DEC_HIDDEN_DIM=128
export NOISE_P=0.2

export MODEL='style_emb'
for checkpoints_number in "500000"; do
  for MUL in 0.1 1; do
    for MODEL_TYPE in 'reny_1_3' 'no_reny' 'baseline' 'reny_1_5' 'reny_1_8'; do

      export MODEL_PATH=/  /DIT/style_emb_lambda_${MUL}_very_new_sent_${MODEL_TYPE}_128_3_no_reset_128
      export suffix=style_emb_lambda_${MUL}_very_new_sent_${MODEL_TYPE}_128_3_no_reset_128_${checkpoints_number}
      export MODEL_PATH=${MODEL_PATH}/checkpoint-${checkpoints_number}
      export OUTPUT_DIR=${MODEL_PATH}_${checkpoints_number}_use_complex_classifier
      echo "${MODEL_TYPE}_${MUL}.stderr.%J"
      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${MODEL_TYPE}_${MUL}.stderr.%J" -o "${MODEL_TYPE}_${MUL}.stdout.%J" -J "${MODEL_PATH}" python evalutate_for_related_work.py --use_complex_classifier --save_step=$SAVE_STEPS --suffix=$suffix --num_train_epochs=$EPOCHS --do_train_classifer --do_test_transfer --do_test_reconstruction --do_eval --output_dir=$OUTPUT_DIR --batch_size=$BATCH_SIZE --filter=-1 --use_complex_classifier --model=$MODEL --model_path_to_load=$MODEL_PATH --saving_result_file=evaluate_for_style_transfert_${checkpoints_number}_use_complex_classifier.txt
    done
  done
done

export MODEL='style_emb'
for checkpoints_number in "500000"; do
  for MUL in 0.01; do
    for MODEL_TYPE in 'reny_1_3'; do

      export MODEL_PATH=/  /DIT/style_emb_lambda_${MUL}_very_new_sent_${MODEL_TYPE}_128_3_no_reset_128
      export suffix=style_emb_lambda_${MUL}_very_new_sent_${MODEL_TYPE}_128_3_no_reset_128_${checkpoints_number}
      export MODEL_PATH=${MODEL_PATH}/checkpoint-${checkpoints_number}
      export OUTPUT_DIR=${MODEL_PATH}_${checkpoints_number}_use_complex_classifier
      echo "${MODEL_TYPE}_${MUL}.stderr.%J"
      bsub -q prod.med -n 1 -R "rusage[ngpus_excl_p=1]" -e "${MODEL_TYPE}_${MUL}.stderr.%J" -o "${MODEL_TYPE}_${MUL}.stdout.%J" -J "${MODEL_PATH}" python evalutate_for_related_work.py --use_complex_classifier --save_step=$SAVE_STEPS --suffix=$suffix --num_train_epochs=$EPOCHS --do_train_classifer --do_test_transfer --do_test_reconstruction --do_eval --output_dir=$OUTPUT_DIR --batch_size=$BATCH_SIZE --filter=-1 --use_complex_classifier --model=$MODEL --model_path_to_load=$MODEL_PATH --saving_result_file=evaluate_for_style_transfert_${checkpoints_number}_use_complex_classifier.txt
    done
  done
done
