#!/usr/bin/env bash

export SAVE_STEPS=100
export FILTER=-1
export EPOCHS=15
export SEED=49
export BATCH_SIZE=256

export NB_SEQ=100
export MODEL=style_emb

for suffix1 in "reny_1_8" "reny_1_5" "reny_1_3" "no_reny" "baseline"; do
  for lambdavalue in 0.1 1 5 10 15; do
    for CHECKPOINTS in 200000 210000 220000; do
      export SUFFIX=new_new_sentiment_${suffix1}_10_128_csc_128
      export MODEL_PATH=${MODEL}_lambda_${lambdavalue}_${SUFFIX}
      export suffix=${MODEL_PATH}_${CHECKPOINTS}
      export MODEL_PATH=${MODEL_PATH}/checkpoint-${CHECKPOINTS}
      export OUTPUT_DIR=${MODEL_PATH}_${CHECKPOINTS}_

      sbatch --job-name=${lambdavalue}_${suffix1} \
        --partition=gpu_p1 \
        --gres=gpu:1 \
        --no-requeue \
        --cpus-per-task=10 \
        --hint=nomultithread \
        --time=2:00:00 \
        --output=jobinfo/${lambdavalue}_${suffix1}_%j.out \
        --error=jobinfo/${lambdavalue}_${suffix1}_%j.err \
        --qos=qos_gpu-t4 \
        --wrap="module purge; module load pytorch-gpu/py3/1.1 ;  python evaluate_for_style_transfert.py --save_step=${SAVE_STEPS} --suffix=${suffix} --num_train_epochs=${EPOCHS} --do_train_classifer --do_test_transfer --do_test_reconstruction --do_eval --output_dir=${OUTPUT_DIR} --batch_size=${BATCH_SIZE} --filter=-1 --model=${MODEL} --model_path_to_load=${MODEL_PATH} --saving_result_file=evaluate_for_style_transfert.txt --use_complex_classifier"
    done
  done
done


