#!/usr/bin/env bash

export TRAIN_FILE=data/multiple_attribute/processed/category.train_for_gpt2.txt
export TEST_FILE=data/multiple_attribute/processed/category.valid_for_gpt2.txt
export OUTPUT_DIR=gpt_2_for_category
export EPOCHS=5

CUDA_VISIBLE_DEVICES=2 python3 train_lm.py \
      --overwrite_output_dir \
      --output_dir=$OUTPUT_DIR \
      --evaluate_during_training \
      --num_train_epochs=$EPOCHS \
      --model_type=gpt2 \
      --model_name_or_path=gpt2  \
      --cache_dir=gpt \
      --do_train \
      --train_data_file=$TRAIN_FILE \
      --do_eval \
      --eval_data_file=$TEST_FILE