# LAMP: LAMP: Data-Efficient Linear Affine Weight-Space Models for Parameter-Controlled 3D Shape Generation and Extrapolation

## Installation

```bash
# Install required packages
pip install torch torchvision numpy pandas scipy scikit-image plyfile

# Or if using conda
conda install pytorch torchvision numpy pandas scipy scikit-image
pip install plyfile
```

## Usage

### Basic Generation

```bash
python generate.py \
    --csv filtered_drivaernet_small.csv \
    --logs_root ../HyperDiffusion-main/logs \
    --targets "A_Car_Length=50.0,A_Car_Width=75.0" \
    --output_dir output \
    --output_name my_car \
    --resolution 256
```

### Arguments

- `--csv`: CSV file with experiments and parameters
- `--logs_root`: Directory containing trained model weights
- `--targets`: Target parameters as comma-separated key=value pairs
- `--output_dir`: Output directory (default: output)
- `--output_name`: Base name for output files (default: generated_car)
- `--resolution`: Mesh resolution (default: 256, higher = more detailed)
- `--weight_file`: Weight filename in experiment folders (default: occ_model_jitter_0_model_final.pt)
- `--verbose`: Show detailed parameter statistics
