To install the anaconda environment that was used in our experiments, you may run
the following command in an anaconda prompt:

```console
conda env create -f env.yml
```

* Note that a CUDA enabled machine is required as the enviroment uses a CUDA enabled version of torch 
* To import the UCI datasets see the following github repo: https://github.com/treforevans/uci_datasets 

These are the most relevant files of the directory:

* **`variationalRegressionTree.py`**:
	```
    Contains the main VaRT class that is used in all the experiments. 
	It features an sklearn-like interface for fitting the model.
    ```
* **`utils_reg.py`**:
	```
    Contains several useful helper functions.
    ```
* **`ihdp.ipynb`**:
    ```
    The file containing the ihdp experiments. All VaRT runs are fully seeded to ensure reproducibility.
    ```
* **`test_bed_1.ipynb`**:
    ```
    The file containing the regression experiments. All VaRT runs are fully seeded to ensure reproducibility.
    ```
* **`excel_files` and `uci_experiment_results`**:
    ```
    They either contain data that was used in the experiments or data pertaining the performance of classifiers. The latter were used to generate the tables of the paper. 
    ```
* **`CIToy.ipynb`**:
    ```
    File to reproduce the causal inference experiments on toy data. 
    ```
* **`clippedAdam.py`**:
    ```
    The clipped adam custom optimizer was obtained from the Pyro website: https://docs.pyro.ai/en/stable/_modules/pyro/optim/clipped_adam.html
    ```
