from BaseDesign import BaseDesign


class Design(BaseDesign):
    def __init__(self, design_dict: dict):
        self.metadata: str = design_dict["metadata"].strip()
        self.evict: str = design_dict["evict"].strip()
        self.update_after_hit: str = design_dict["update_after_hit"].strip()
        self.update_after_insert: str = design_dict["update_after_insert"].strip()
        self.update_after_evict: str = design_dict["update_after_evict"].strip()

    def _format(self, descrip: str, is_lower=True):
        cleaned_descrip = descrip.strip()
        if len(cleaned_descrip) > 1:
            if is_lower == True:
                return cleaned_descrip[0].lower() + cleaned_descrip[1:]
            else:
                return cleaned_descrip[0].upper() + cleaned_descrip[1:]
        elif len(cleaned_descrip) == 1:
            if is_lower == True:
                return cleaned_descrip[0].lower()
            else:
                return cleaned_descrip[0].upper()
        else:
            return ""
        
    def to_str(self):
        design_str = ""
        design_str += self._format(self.metadata, False)
        design_str += "\n" + "During eviction, " + self._format(self.evict)
        design_str += "\n" + "Immediately after a hit, " + self._format(self.update_after_hit)
        design_str += "\n" + "Immediately after insertion, " + self._format(self.update_after_insert)
        design_str += "\n" + "Immdiately after eviction, " + self._format(self.update_after_evict)
        return design_str
    
    def to_dict(self):
        return {
            "metadata": self.metadata,
            "evict": self.evict,
            "update_after_hit": self.update_after_hit,
            "update_after_insert": self.update_after_insert,
            "update_after_evict": self.update_after_evict,
        }