SYSTEM_PROMPT_OBSERVATION = '''You are an expert in computer systems. Your task is to create an innovative cache replacement policy. You will return several useful, non-obvious, and correct observations about the task, like hints to solve the task. You will NOT return any code.'''

FIRST_OBS_PROMPT_TEMPL = f'''Brainstorm a list of [[num_obs]] non-obvious observations about the properties of the task, each a few words long. The observations should be simple and creative.\n\nReason before outputting each observation like so:\nObservation 1:\nA paragraph or two of reasoning\n"your observation" (for example, 'A cyclic pointer can be maintained to track cached objects and determine eviction victims.' or 'A cache can be divided into segments with different eviction priorities, and each segment can use a distinct eviction policy.')\nMake sure the observations are useful in solving the task, not just a restatement of the obvious.'''

SYSTEM_PROMPT_OBSERVATION2 = '''You are an expert in computer systems. Your task is to create an innovative cache replacement policy. You will be given several correct observations about the task. You will brainstorm several new, useful, and correct observations about the task, derived from the given observations. You will NOT return any code.'''

COMBINED_OBS_PROMPT_TEMPL = f'''[[obs_combo]]\n\nFirst reason about implications of the [[first_blank]] above. Include the most critical parts of the task statement.\n\nThen creatively [[second_blank]] above to brainstorm more non-obvious observations. Before outputting EACH new observation, quote relevant parts of the implications EXACTLY.\n\nFollow the rough format below:\n\n## Implications:\n\n[Quotes from critical parts of the task statement]\n\n[[third_blank]]### Reasoned Implications:\n\n[Your step-by-step reasoned-through implications[[fourth_blank]], referencing the quotes above.]\n\n## New Observations:\n\n### Observation 1:\n\n[Quotes of relevant pieces of text from the Reasoned Implications section.]\n\n[A paragraph or two of step-by-step reasoning.]\n\n[Your new final observation]\n\n### Observation 2:\n\n...\n\nMake sure the new observations are creative and useful in solving the task, not just a restatement of the obvious. Also make sure that the new observations are derived from the implications[[fifth_blank]].'''

FORMAT_INTO_LIST_PROMPT = '''List all the observations. Please do not output anything else.'''

FILTER_TO_USEFUL_LIST_PROMPT = '''Filter these observations to the most useful.'''

PARSE_INTO_PYTHON_LIST_PROMPT = '''Format these observations as a Python list of strings. Below is an example:

List of observations:
1. Use a cyclic pointer.
2. Divide the cache into segments.

Python output:
```python
[
    "Use a cyclic pointer.",
    "Divide the cache into segments."
]
```

Output the Python output only.'''