# -*- coding: utf-8 -*-
"""523UCI HAR

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/14WDkGkFK-Cy6uOgH2s2UqQOTZYTqUhhm
"""

import numpy as np
from sklearn.cluster import SpectralClustering
from sklearn.cluster import KMeans
import matplotlib.pyplot as plt
from itertools import permutations
from sklearn.cluster import DBSCAN
import scipy.io
import collections

def grassmannian_fusion(X:np.ndarray, Omega:np.ndarray, r:int, lamb = 5, max_iter = 10, step_size = 0.1, g_threshold = 0.15, init_U = None, bound_zero = 1e-10, singular_value_bound = 1e-2, g_column_norm_bound = 1e-5, U_manifold_bound = 1e-2):
  [m,n] = X.shape
  
  if init_U == None:
    #init
    U_array = [np.random.randn(m,r) for i in range(n)]
    for i in range(n):
      U_array[i][:,0] = X[:,i] / np.linalg.norm(X[:,i])
      q_i,r_i = np.linalg.qr(U_array[i])
      U_array[i] = q_i * r_i[0,0]
      
      #print(U_array[i].shape)
      #make sure the first col is x_i
      assert np.linalg.norm(U_array[i][:,0] - X[:,i] / np.linalg.norm(X[:,i])) < bound_zero
      #make sure its orthogonal
      assert np.linalg.norm(U_array[i].T @ U_array[i] - np.identity(r)) < bound_zero
      #make sure its normal
      assert  np.linalg.norm( np.linalg.norm(U_array[i], axis = 0) - np.ones(r) )  < bound_zero
  else:
    U_array = init_U

  #construct X^0_i
  Omega_i = [np.sort(Omega[Omega % n == i]) // n for i in range(n)]
  #find the compliment of Omega_i
  Omega_i_compliment = [sorted(list(set([i for i in range(m)]) - set(list(o_i)))) for o_i in Omega_i]

  #calculate length of U
  len_Omega = [o.shape[0] for o in Omega_i]
  #init X^0
  X0 = [np.zeros((m, m - len_Omega[i] + 1)) for i in range(n)]
  for i in range(n):
    #fill in the first row with normalized column
    X0[i][:,0] = X[:,i] / np.linalg.norm(X[:,i])
    for col_index,row_index in enumerate(Omega_i_compliment[i]):
      #fill in the "identity matrix"
      X0[i][row_index, col_index+1] = 1

  obj_record = []
  #main algo
  for iter in range(max_iter):
    G_array = []
    for i in range(n):
      
      #SVD
      A = X0[i] @ X0[i].T @ U_array[i]
      U_A,s_A,VT_A = np.linalg.svd(A)
      #leading vector
      u = U_A[:,0]
      vt = VT_A[0,:]
      G = -2 * s_A[0] * np.outer(u,vt)
      G_array.append(G)

   
    shape = [m,n,r]
    new_U_array, end = Armijo_step(shape, U_array, G_array, X0, lamb,singular_value_bound, alpha = step_size, beta = 0.5, sigma = 1e-5)

    if iter % 1 == 0:
      for i in range(n):
        u,s,vt = np.linalg.svd(new_U_array[i], full_matrices= False)
        new_U_array[i] = u@vt
    
    assert np.linalg.norm(new_U_array[i].T @ new_U_array[i] - np.identity(new_U_array[i].shape[1])) < U_manifold_bound

    U_array = new_U_array.copy()

    #record
    obj = cal_obj(shape, X0, U_array, lamb,singular_value_bound)
    obj_record.append(obj)

    '''
    #print log
    if iter % 100 == 0 or True:
      print('iter', iter)
      print('Obj value:', obj)
    '''
    
    if end:
      print('iter', iter)
      print('Obj value:', obj)
      break

  plt.plot(obj_record)
  plt.ylabel('Objective (from Equation 4)')
  plt.xlabel('Iteration')
  plt.show()

  info = {"obj_record": obj_record}

  return U_array, info

def dUU(U_1, U_2, r):
  u,s,vt = np.linalg.svd(U_1.T @ U_2)

  for i in range(len(s)):
    if s[i] - 1 > 1e-5:
      raise Exception('s[',i,'] = ', s[i])
    elif s[i] > 1:
      s[i] = 1

  d = sum([np.arccos(s[i])**2 for i in range(r)])

  #print(u,s,vt)
  assert d >= 0
  return np.sqrt(d)

def cal_obj(shape, X0, U_array, lamb,singular_value_bound):
  m = shape[0]
  n = shape[1]
  r = shape[2]

  obj = 0
  for i in range(n):
    u,s,vt = np.linalg.svd(X0[i].T @ U_array[i])
    if s[0]> 1 and s[0] - 1 < singular_value_bound:
      s[0] = 1
    elif s[0] > 1:
      raise Exception('s[0] = ', s[0])
    #max(np.linalg.norm(X[:,i])**2 , 1)

    if (i == 1 and iter == 99):
      print("Test:", 1 - s[0]**2)
    obj += 1 - s[0]**2
    
    for j in range(n):
      if i == j:
        continue
      
      u,s,vt = np.linalg.svd(U_array[i].T @ U_array[j])
      
      for r_index in range(r):
        if s[r_index]> 1 and s[r_index] - 1 < singular_value_bound:
          s[r_index] = 1
        elif s[r_index] > 1:
          raise Exception('Ui^T Uj, s[0] = ', s[r_index])
      sum_s = sum([np.arccos(s[i_r])**2 for i_r in range(r)])
      obj += lamb / 2 * np.sqrt(sum_s)

    return obj

def Armijo_step(shape, U_array, G_array, X0, lamb,singular_value_bound, alpha = 1, beta = 0.5, sigma = 0.9):
  L = R = 0
  m = shape[0]
  n = shape[1]
  r = shape[2]

  #calculate the true gradient
  grad_f_array = []
  for i in range(n):
    grad_f_i = (np.identity(m) - U_array[i] @ U_array[i].T) @ G_array[i]
    for j in range(n):
      u_j, s_j, vt_j = np.linalg.svd(U_array[j] @ U_array[j].T @ U_array[i])

      dg_UU = np.zeros((m,r))
      for r_index in range(r):
        if s_j[r_index] < 1:
          dg_UU += -1 * np.arccos(s_j[r_index]) / np.sqrt(1 - s_j[r_index]**2) * np.outer(u_j[:, r_index] , vt_j[r_index, :]) 
        else:
          dg_UU += -1 * np.outer(u_j[:, r_index] , vt_j[r_index, :])

      #cap singular values
      for r_index in range(r):
        if (s_j[r_index] - 1 > 0):
          s_j[r_index] = 1

      distance = np.sqrt( np.sum( np.arccos(s_j)**2 ))

      if distance > 1e-10:
        dg_UU = (np.identity(m) - U_array[i] @ U_array[i].T) / distance @ dg_UU
        #norm = np.sqrt(np.trace(dg_UU.T @ dg_UU))
        #dg_UU = dg_UU / norm
        grad_f_i += lamb / 2 * dg_UU

    grad_f_array.append(grad_f_i)



  #avoid using m
  arm_m = 0
  while True:
    #print('Testing Step size:' , (beta**arm_m) * alpha)
    new_U_array = [np.zeros((m,r)) for i in range(n)]
    L = cal_obj(shape, X0, U_array, lamb,singular_value_bound)

    for i in range(n):
      Gamma_i, Del_i, ET_i = np.linalg.svd( -1 * (beta**arm_m) * alpha * grad_f_array[i], full_matrices= False)
      first_term = np.concatenate((U_array[i]@ET_i.T, Gamma_i), axis = 1)
      second_term = np.concatenate((np.diag(np.cos( Del_i)), np.sin(np.diag(Del_i))), axis = 0)

      new_U_array[i] = first_term @ second_term @ ET_i


    L -= cal_obj(shape, X0, new_U_array, lamb,singular_value_bound)
    R =  -1 * sigma 
    inner_sum = 0
    for i in range(n):
      inner_sum += np.trace(grad_f_array[i].T @ grad_f_array[i] * (beta**arm_m) * alpha * -1)

    R = R * inner_sum
  
    #print('L:', L)
    #print('R:', R)

    if L >= R:
      #print('Step: ', (beta**arm_m) * alpha)
      return new_U_array, False
    else:

      if (beta**arm_m) * alpha < 1e-10:
        #print('No Step')
        return U_array, True

      arm_m += 1

import numpy as np
import matplotlib.pyplot as plt
import collections
from mpl_toolkits.mplot3d import Axes3D

def load_data(sample_size_per_label = 100, wanted_words = ['min','max','std','mean'] ):
  f = open('y_train.txt', "r")
  f.seek(0)
  lines = f.readlines()
  f.close()
  lines = np.array(lines).astype(int) - 1
  y = lines
  print('Raw y stats:', collections.Counter(y))

  f = open('X_train.txt', "r")
  f.seek(0)
  lines = f.readlines()
  f.close()
  X = np.array([np.array(i.split()).astype(float) for i in lines]).T
  print('Raw X shape:', X.shape)
  Xs = [X[:,y == i] for i in set(y)]

  f = open('features.txt')
  f.seek(0)
  lines = f.readlines()
  f.close()
  need_row = []

  for i,row in enumerate(lines):
      for words in wanted_words:
          if words in row:
              need_row.append(i)
              break

  X_cutted = X[need_row, :]

  y_remap = y.copy()
  y_remap[y == 1] = 0
  y_remap[y == 2] = 0
  y_remap[y == 3] = 1
  y_remap[y == 4] = 1
  y_remap[y == 5] = 1

  ys = [np.where(y_remap == i)[0] for i in [0,1]]

  ys_sampled = [np.random.choice(ys_i, size = sample_size_per_label,replace = False) for ys_i in ys]
  X_final = np.concatenate((X_cutted[:, ys_sampled[0]],X_cutted[:, ys_sampled[1]]), axis = 1)


  from sklearn.decomposition import PCA
  pca = PCA(3)  # project from 64 to 2 dimensions
  projected = pca.fit_transform(X_final.T)
  print('PCA shape:',projected.shape)

  colormap = ['r','g','b','y','pink','black']
  fig = plt.figure()
  ax = fig.add_subplot(projection='3d')

  y_final = np.array([0]*sample_size_per_label + [1]*sample_size_per_label)
  ax.scatter(projected[:,0],projected[:,1],projected[:,2],c = [colormap[i] for i in y_final])
  plt.show()


  print('X_final shape:',X_final.shape)
  print('y_final shape:',y_final.shape)

  return X_final, y_final

def main():
  #data can be downloaded at: https://archive.ics.uci.edu/ml/machine-learning-databases/00240/

  X,y = load_data(sample_size_per_label = 50, wanted_words = ['min','max','std','mean'] )
  record = []
  for argv1 in [5,15,25,35,45,55,65,75,85,95]:
    argv = [0,argv1]
    lambda_in = 10**(-1 * (int(argv[1])%10))
    missing_rate = (int(argv[1]) // 10) / 10

    m = X.shape[0]
    n = X.shape[1]


    r = 4

    #observed index
    Omega = np.random.choice(m*n, size = int(m*n * (1-missing_rate) ), replace= False )

    #create observed matrix
    X_omega = np.zeros((m,n))
    for p in Omega:
      X_omega[p // n, p % n] = X[p // n, p % n]


    print('Paramter: lambda = ',lambda_in,', m = ', m, ', n = ',n,', r = ',r,', missing_rate =', missing_rate)
    print('||X - X_omega||_2 = ', np.linalg.norm(X - X_omega))

    print('########################################\nGradient Descent Begin')
    U_array,info = grassmannian_fusion(X_omega, Omega, r, lamb = lambda_in, max_iter= 50, step_size = 1, g_threshold= 1e-3, bound_zero = 1e-10, singular_value_bound = 1e-5, g_column_norm_bound = 1e-5, U_manifold_bound = 1e-5)
    print('########################################\nGradient Descent End')

    print('Info:\n')
    print(info)


    #calculate the distance
    d_matrix = []
    for i in range(n):
      d_matrix_row = []
      for j in range(n):
        if i == j:
          d_matrix_row.append(0)
          continue
        d_matrix_row.append(dUU(U_array[i], U_array[j], r))

      d_matrix.append(d_matrix_row)

    d_matrix = np.array(d_matrix)

    K = 2
    print('\n########################################\n Classify Accuracy:')
    sc = SpectralClustering(n_clusters=K, affinity='nearest_neighbors',random_state=0).fit(d_matrix)
    #db = DBSCAN(eps=0.5, min_samples=25).fit(d_matrix)

    print(collections.Counter(sc.labels_))

    record.append(max(sum(y == sc.labels_)/len(y), 1-sum(y == sc.labels_)/len(y)))
    print(' Spectral :', record[-1] )
    print()

    #print(' DBSCAN :', 1 - evaluate(db.labels_, truth , K) )
    #print()

  print(record)
  master_record.append(record)


if __name__ == '__main__':
  main()

