﻿# Online Control of Adaptive Large Neighborhood Search using Deep Reinforcement Learning
This repository contains the code for the 2024 AAAI submission: "Online Control of Adaptive Large Neighborhood Search using Deep Reinforcement Learning".

## Algorithm Files
### 1. run_alns_*:
  - Implements the ALNS algorithm, configured for solving the following problems:
    - TSP, CVRP, MTSP (found in the routing directory).
    - AI4TSP Orienteering Problem (located in the orienteering directory).

### 2. run_drl_alns_*:
  - Implements the DR-ALNS algorithm, capable of solving:
    - TSP, CVRP, MTSP (found in the routing directory).
    - AI4TSP Orienteering Problem (located in the orienteering directory).

## Directory Structure
### -orienteering/ai4tsp:
  - Houses all the necessary files for simulating the OPSWTW problem from the IJCAI AI4TSP competition.
  - For more details, visit the AI4TSP competition repository.

### -rl:
  -Contains a Proximal Policy Optimization (PPO) wrapper.
  -Features a gym environment tailored for DR-ALNS, catering to the different problems included.
  -Provides configuration files for adjusting the training setup and accessing the trained models.

### -routing/*:
  - Encompasses all files related to the ALNS implementation for TSP, CVRP, and MTSP problems.

## Setup and Execution
1. Set up a Python 3.10 environment to utilize our pre-trained policies.
2. Install the necessary dependencies from the requirements.txt file.
3. Execute either the run_alns_* or run_drl_alns_* files to generate solutions for a specified instance.
4. (Optional) Adjust the configuration file located in the config directory to modify the setup as needed.

