"from https://cse.unl.edu/~choueiry/Documents/Allen-CACM1983.pdf"

from src.composition_tables.baseclass import SemiGroup
from dataclasses import dataclass

@dataclass
class Interval(SemiGroup):
    "ref: https://msioutis.gitlab.io/files/generator_interval.py"
    name = 'interval'
    eq = 1
    lt = 2
    gt = 4
    d  = 8
    di = 16
    o  = 32
    oi = 64
    m  = 128
    mi = 256
    s  = 512
    si = 1024
    f  = 2048
    fi = 4096
    
    str2int = {
        '=': eq, 
        '<': lt, 
        '>': gt, 
        'd': d, 
        'di': di, 
        'o': o, 
        'oi': oi, 
        'm': m, 
        'mi': mi, 
        's': s, 
        'si': si, 
        'f': f, 
        'fi': fi
        }

    elements = [eq, lt, gt, d, di, o, oi, m, mi, s, si, f, fi]


    composition_table = {
        (eq, eq): [eq],
        (eq, lt): [lt],
        (eq, gt): [gt],
        (eq, d): [d],
        (eq, di): [di],
        (eq, o): [o],
        (eq, oi): [oi],
        (eq, m): [m],
        (eq, mi): [mi],
        (eq, s): [s],
        (eq, si): [si],
        (eq, f): [f],
        (eq, fi): [fi],

        (lt, eq): [lt],
        (lt, lt): [lt],
        (lt, gt): [],
        (lt, d): [lt, o, m, d, s],
        (lt, di): [lt],
        (lt, o): [lt],
        (lt, oi): [lt, o, m, d, s],
        (lt, m): [lt],
        (lt, mi): [lt, o, m, d, s],
        (lt, s): [lt],
        (lt, si): [lt],
        (lt, f): [lt, o, m, d, s],
        (lt, fi): [lt],

        (gt, eq): [gt],
        (gt, lt): [],
        (gt, gt): [gt],
        (gt, d): [gt, oi, mi, d, f],
        (gt, di): [gt],
        (gt, o): [gt, oi, mi, d, f],
        (gt, oi): [gt],
        (gt, m): [gt, oi, mi, d, f],
        (gt, mi): [gt],
        (gt, s): [gt, oi, mi, d, f],
        (gt, si): [gt],
        (gt, f): [gt],
        (gt, fi): [gt],

        (d, eq): [d],
        (d, lt): [lt],
        (d, gt): [gt],
        (d, d): [d],
        (d, di): [],
        (d, o):  [lt, o, m, d, s],
        (d, oi): [gt, oi, mi, d, f],
        (d, m): [lt],
        (d, mi): [gt],
        (d, s): [d],
        (d, si): [gt, oi, mi, d, f],
        (d, f): [d],
        (d, fi): [lt, o, m, d, s],
        
        (di, eq): [di],
        (di, lt): [lt, o, m, di, fi],
        (di, gt): [gt, oi, di, mi, si],
        (di, d): [o, oi, d, s, f, di, si, fi, eq],
        (di, di): [di],
        (di, o):  [o, di, fi],
        (di, oi): [oi, di, si],
        (di, m): [o, di, fi],
        (di, mi): [oi, di, si],
        (di, s): [di, fi, o],
        (di, si): [di],
        (di, f): [di, si, oi],
        (di, fi): [di],
        
        (o, eq): [o],
        (o, lt): [lt],
        (o, gt): [gt, oi, di, mi, si],
        (o, d):  [o, d, s],
        (o, di): [lt, o, m, di, fi],
        (o, o):  [lt, o, m],
        (o, oi): [o, oi, d, s, f, di, si, fi, eq],
        (o, m): [lt],
        (o, mi): [oi, di, si],
        (o, s): [o],
        (o, si): [di, fi, o],
        (o, f): [d, s, o],
        (o, fi): [lt, o, m],
        
        (oi, eq): [oi],
        (oi, lt): [lt, o, m, di, fi],
        (oi, gt): [gt],
        (oi, d):  [oi, d, f],
        (oi, di): [gt, oi, mi, di, si],
        (oi, o):  [o, oi, d, s, f, di, si, fi, eq],
        (oi, oi): [gt, oi, mi],
        (oi, m): [o, di, fi],
        (oi, mi): [gt],
        (oi, s): [oi, d, f],
        (oi, si): [oi, gt, mi],
        (oi, f): [oi],
        (oi, fi): [oi, di, si],
        
        (m, eq): [m],
        (m, lt): [lt],
        (m, gt): [gt, oi, di, mi, si],
        (m, d):  [o, d, s],
        (m, di): [lt],
        (m, o):  [lt],
        (m, oi): [o, d, s],
        (m, m): [lt],
        (m, mi): [f, fi, eq],
        (m, s): [m],
        (m, si): [m],
        (m, f): [d, s, o],
        (m, fi): [lt],

        (mi, eq): [mi],
        (mi, lt): [lt, o, m, di, fi],
        (mi, gt): [gt],
        (mi, d):  [oi, d, f],
        (mi, di): [gt],
        (mi, o):  [oi, d, f],
        (mi, oi): [gt],
        (mi, m): [s, si, eq],
        (mi, mi): [gt],
        (mi, s): [d, f, oi],
        (mi, si): [gt],
        (mi, f): [mi],
        (mi, fi): [mi],
        
        (s, eq): [s],
        (s, lt): [lt],
        (s, gt): [gt],
        (s, d):  [d],
        (s, di): [lt, o, m, di, fi],
        (s, o):  [lt, o, m],
        (s, oi): [oi, d, f],
        (s, m): [lt],
        (s, mi): [mi],
        (s, s): [s],
        (s, si): [s, si, eq],
        (s, f): [d],
        (s, fi): [lt, m, o],
        
        (si, eq): [si],
        (si, lt): [lt, o, m, di, fi],
        (si, gt): [gt],
        (si, d):  [oi, d, f],
        (si, di): [di],
        (si, o):  [o, di, fi],
        (si, oi): [oi],
        (si, m): [o, di, fi],
        (si, mi): [mi],
        (si, s): [s, si, eq],
        (si, si): [si],
        (si, f): [oi],
        (si, fi): [di],
        
        (f, eq): [f],
        (f, lt): [lt],
        (f, gt): [gt],
        (f, d):  [d],
        (f, di): [gt, oi, mi, di, si],
        (f, o):  [o, d, s],
        (f, oi): [gt, oi, mi],
        (f, m): [m],
        (f, mi): [gt],
        (f, s): [d],
        (f, si): [gt, oi, mi],
        (f, f): [f],
        (f, fi): [f, fi, eq],
        
        (fi, eq): [fi],
        (fi, lt): [lt],
        (fi, gt): [gt, oi, di, mi, si],
        (fi, d):  [o, d, s],
        (fi, di): [di],
        (fi, o):  [o],
        (fi, oi): [oi, di, si],
        (fi, m): [m],
        (fi, mi): [si, oi, di],
        (fi, s): [o],
        (fi, si): [di],
        (fi, f): [f, fi, eq],
        (fi, fi): [fi],
    }
    
    @classmethod
    def translate(self, BR):
        if BR == self.eq:
            return '='
        elif BR == self.lt:
            return '<'
        elif BR == self.gt:
            return '>'
        elif BR == self.d:
            return 'd'
        elif BR == self.di:
            return 'di'
        elif BR == self.o:
            return 'o'
        elif BR == self.oi:
            return 'oi'
        elif BR == self.m:
            return 'm'
        elif BR == self.mi:
            return 'mi'
        elif BR == self.s:
            return 's'
        elif BR == self.si:
            return 'si'
        elif BR == self.f:
            return 'f'
        elif BR == self.fi:
            return 'fi'