import numpy as np
import os
import hashlib


def main():
    """
    This creates the task_sequences. It is deterministic, based on the hyperparameters.
    :return:
    """
    seed_base = 42
    dataset = ['tiny']
    total_classes = 200
    num_classes = [199, 1]

    seed_str = (str(seed_base) + str(num_classes[0]) + dataset[0]).encode('utf-8')
    seed_hash = hashlib.sha1()
    seed_hash.update(seed_str)
    seed = int(seed_hash.hexdigest(), 16) % (2**16-1)

    all_classes = np.arange(total_classes)
    gen = np.random.default_rng(seed)
    gen.shuffle(all_classes)

    task_idx = [0, *np.cumsum(num_classes)]
    task_classes = [all_classes[task_idx[i]:task_idx[i+1]] for i in range(len(task_idx) - 1)]

    class_file_name = '_'.join([*dataset, *[str(nc) for nc in num_classes], str(seed_base)]) + '.txt'

    with open(os.path.join('task_sequences', class_file_name), 'w') as f:
        for i in range(len(task_classes)):
            ds = dataset[0] if len(dataset) == 1 else dataset[i]
            f.write(','.join([ds, *[str(c) for c in task_classes[i]]]))
            f.write('\n')


if __name__ == '__main__':
    main()

