from dataclasses import dataclass
from enum import Enum

    
class _LMBackend(Enum):
    GENLM_BYTES         = "genlm_bytes"             # Byte-level GenLM from Viera et al.
    GENLM_ASYNC         = "genlm_backend_async"     # GenLM backend asynchronous call
    GENLM_SYNC          = "genlm_backend_sync"      # GenLM backend synchronous call
    TOKENIZED_LM        = "tokenized_lm"            # Token-level language model


@dataclass(slots=True)
class Config:
    """Configuration for decomposition"""
    track_powerstates: bool = True                # Implicit determinization via powerstate contstruction
    prune_threshold: float = 0.00                 # Threshold for pruning beams based on probability
    candidate_threshold: int = 200                # Threshold number of candidates
    prune_threshold_alpha: float = 0.8            # Alpha length impact for prune threshold: greater = more pruning
    max_prune_mass: float = 0.15                  # Maximum mass to prune        
    max_candidates: int = None                    # Cap the maximum amount of candidated
    ignore_remainder: bool = False                # Ignore remainder elements in decomposition
    cover_opt: bool = False                       # Set to True if you run the decomposition with a precover
    use_beam_cache: bool = True                   # Use a cache to avoid recomputing beams
    verbose: bool = False                         # Print debug information
    expand_threshold: int = 5                     # Threshold for expansion steps after adding to remainder
    stop_epsilon_mass: float = 0.1                # Threshold mass cutoff for expanding non universal states
    backend: _LMBackend = _LMBackend.GENLM_BYTES  # Backend to use for LM scoring
    batched: bool = False                         # Use batched LM scoring if available
    ngram_top_p: float = 1.0                      # Top p for ngram distribution / 1.0 to turn it of
    use_no_symloop: bool = False                  # Use optimized no-symloop logp_next for LM scoring     
