import pynini

def is_deterministic(fst) -> bool:
    """
    Check if the given FST is deterministic.

    Args:
        fst: The input FST to check.

    Returns:
        True if the FST is deterministic, False otherwise.
    """
    props = fst.properties(pynini.FstProperties.I_DETERMINISTIC, True)
    is_deterministic = bool(props & pynini.FstProperties.I_DETERMINISTIC)
    
    return is_deterministic 

def is_input_deterministic(fst) -> bool:
    """
    Check if the given FST is input deterministic.

    Args:
        fst: The input FST to check.

    Returns:
        True if the FST is input deterministic, False otherwise.
    """
    props = fst.properties(pynini.FstProperties.I_DETERMINISTIC, True)
    is_input_deterministic = bool(props & pynini.FstProperties.I_DETERMINISTIC)
    
    return is_input_deterministic

def is_output_deterministic(fst) -> bool:
    """
    Check if the given FST is output deterministic.

    Args:
        fst: The input FST to check.

    Returns:
        True if the FST is output deterministic, False otherwise.
    """
    props = fst.properties(pynini.FstProperties.O_DETERMINISTIC, True)
    is_output_deterministic = bool(props & pynini.FstProperties.O_DETERMINISTIC)
    
    return is_output_deterministic

def is_acceptor(fst) -> bool:
    """
    Check if the given FST is an acceptor.

    Args:
        fst: The input FST to check.

    Returns:
        True if the FST is an acceptor, False otherwise.
    """
    props = fst.properties(pynini.FstProperties.ACCEPTOR, True)
    is_acceptor = bool(props & pynini.FstProperties.ACCEPTOR)
    
    return is_acceptor


def calculate_num_states_arcs(fst):
    num_states = fst.num_states()
    total_arcs = sum(fst.num_arcs(state) for state in range(num_states))
    return num_states, total_arcs