"""Types and helper classes for transducedLM.py"""

from typing import Tuple, List, Dict
from dataclasses import dataclass

import numpy as np
import numpy.typing as npt

@dataclass(slots=True)
class Block:
    nstate: np.ndarray
    adv: np.ndarray
    olab: np.ndarray
    sout: np.ndarray
    acc_idx: np.ndarray
    bpref: np.ndarray | tuple
    L: int

Packed = Tuple[int, np.ndarray, np.ndarray, np.ndarray, np.ndarray]

BeamKey = Tuple[Tuple[int, ...], float]
BeamItem = Tuple[int, npt.NDArray[np.int16]]
Beam = Dict[BeamKey, List[BeamItem]]
