import os

import torch
import transformers
from peft import PeftModel
from transformers import LlamaForCausalLM, LlamaTokenizer, set_seed, AutoModelForCausalLM, AutoTokenizer

import argparse

def parse_args():
    parser = argparse.ArgumentParser(description="Federated Learning Arguments")
    parser.add_argument('--base_model', type=str, default='', help='Used to control the collaboration of critical parameters')

    ## model
    parser.add_argument('--ckpt_output', type=str, default='', help='model name')

    return parser.parse_args()

args = parse_args()

set_seed(42)

BASE_MODEL = args.base_model
ckpt_path = args.ckpt_output

tokenizer = AutoTokenizer.from_pretrained(BASE_MODEL, use_fast=False)

base_model = AutoModelForCausalLM.from_pretrained(
    BASE_MODEL,
    load_in_8bit=False,
    torch_dtype=torch.float16,
    device_map="auto",
)

first_weight = base_model.model.layers[0].self_attn.q_proj.weight
first_weight_old = first_weight.clone()

lora_model = PeftModel.from_pretrained(
    base_model,
    ckpt_path,
    # device_map={"": "cpu"},
    torch_dtype=torch.float16,
)

lora_weight = lora_model.base_model.model.model.layers[0].self_attn.q_proj.weight

# assert torch.allclose(first_weight_old, first_weight)

# merge weights - new merging method from peft
lora_model = lora_model.merge_and_unload()

lora_model.train(False)

# did we do anything?
# assert not torch.allclose(first_weight_old, first_weight)
'''
lora_model_sd = lora_model.state_dict()
deloreanized_sd = {
    k.replace("base_model.model.", ""): v
    for k, v in lora_model_sd.items()
    if "lora" not in k
}
'''
lora_model.save_pretrained("{}/output_models".format(ckpt_path))#, state_dict=deloreanized_sd, max_shard_size="20GB")
tokenizer.save_pretrained("{}/output_models".format(ckpt_path))
