AGENT_TOOLS_SCHEMA = [
    {
        "type": "function",
        "function": {
            "name": "google_search",
            "description": "Perform Google web searches then returns a string of the top search results. Accepts multiple queries.",
            "parameters": {
                "type": "object",
                "properties": {
                    "query": {
                        "type": "array",
                        "items": {"type": "string", "description": "The search query."},
                        "minItems": 1,
                        "description": "The list of search queries."
                    },
                },
                "required": ["query"]
            }
        }
    },
    {
        "type": "function",
        "function": {
            "name": "google_scholar",
            "description": "Leverage Google Scholar to retrieve relevant information from academic publications. Accepts multiple queries. This tool will alse return results from google search",
            "parameters": {
                "type": "object",
                "properties": {
                    "query": {
                        "type": "array",
                        "items": {"type": "string", "description": "The search query."},
                        "minItems": 1,
                        # "maxItems": 4,
                        "description": "The list of search queries for Google Scholar."
                    },
                },
                "required": ["query"]
            }
        }
    },
    {
        "type": "function",
        "function": {
            "name": "Visit",
            "description": 'Visit webpage(s) or paper(s) and return the summary of the content.',
            "parameters": {
                "type": "object",
                "properties": {
                    "url": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        },
                        "minItems": 1,
                        "description": "The URL(s) of the webpage(s) or paper(s) to visit. Can be a single URL or an array of URLs."
                    },
                    "goal": {
                        "type": "string",
                        "description": "The goal of the visit for webpage(s) or paper(s)."
                    },
                    "parse_type": {
                        "type": "string",
                        "enum": ["html", "pdf"],
                        "default": "html",
                        "description": "Specify whether to visit a HTML webpage or a PDF paper. Must be either 'html' or 'pdf'. Defaults to 'html' if not specified."
                    },
                },
                "required": ["url", "goal"]
            }
        }
    },
    {
        "type": "function",
        "function": {
            "name": "PythonInterpreter",
            "description": 'Executes arbitrary Python code in a secure, sandboxed environment. This tool is designed for performing complex calculations, data manipulations, string processing, logical operations, and general programming tasks that require programmatic logic. It can define variables, use built-in functions, and print results to standard output. It operates with a limited set of pre-installed libraries and cannot access local files, external networks, or system resources.',
            "parameters": {
                "type": "object",
                "properties": {
                    "code": {
                        "type": "string",
                        "description": "The Python code to execute. This should be a complete and runnable Python script or series of statements. All output should be explicitly printed using `print()` functions.",
                    },
                },
                "required": ["code"]
            }
        }
    }
]