import os
import re
from typing import Tuple, Union

ANSWER_TAG = os.getenv('ANSWER_TAG', 'answer')

def extract_answers(text: str) -> str | None:
    pattern = r"<{TAG}>(.*?)</{TAG}>".format(TAG=ANSWER_TAG)
    match = re.search(pattern, text, re.DOTALL)
    if match:
        answer_output = match.group(1).strip()
        return answer_output
    return None
    