from meteor_reasoner.utils.loader import load_dataset, load_program
from meteor_reasoner.materialization.materialize import coalescing_d, naive_immediate_consequence_operator
from meteor_reasoner.materialization.materialize import build_index
from meteor_reasoner.utils import parser as parser
from meteor_reasoner.materialization.naive_join import *
import objects


def entail(dataset, fact):
    predicate, entity, interval = parser.parse_str_fact(fact)

    if predicate in dataset:
        if entity in dataset[predicate]:
            for intv in dataset[predicate][entity]:
                if interval.left_value >= intv.left_value and interval.right_value <= intv.right_value:
                    return True
    return False


# data = ["A(a)@1", "B(a)@[1,2]", "C@(1,2]"]
# program = ["A(X):-Diamondminus[1,2]A(X)", "D(X):- Boxminus[1,2]A(X), B(X)Since[1,2]C"]

# data = ["A@[1,2]", "C@[4,6]"]
# program = ["B:- Diamondminus[1,1]A, Diamondplus[1,2]C"]
data = objects.Data([objects.DataEntry("B", (1, 1)),
                    objects.DataEntry("C", (1, 2))])
# program = ["A:- Diamondminus[1,1]A"]
program = objects.Program(rules=[objects.Rule(
    [objects.Atom(objects.AtomType.BOX_MINUS, (3, 3), "B"), objects.Atom(objects.AtomType.BOX_MINUS, (2, 3), "C")], "A")], data=data)
print(program)
dataset, delta_new = program.infer()

print("derived facts:")
print_dataset(delta_new)
print("dataset:")
print_dataset(dataset)
