from typing import Tuple, Dict, List
from .image_abs import SRImage 

class MetricABS:
    """Base class for all metrics"""

    def __init__(self, yml_options, *args, **kwargs):
        pass
    
    def __str__(self):
        """
        name of metric
        """
        pass

    def __call__(self, img_info : SRImage, *args, **kwargs) -> Tuple[List[Tuple[dict, str, float]], dict]:
        """
        This function returns tuple like (list of triplet [bbox, artifact_type, confidence], metric_results)
        """
        # use get_bbox and is_artifact in this method # TODO
        pass

    def get_bbox(self, *args, **kwargs) -> Dict[str, int]:
        """
        Returns dictionary of bbox of format {"y1" : y1, "y2" : y2, "x1" : x1, "x2" : x2}
        """
        pass

    def is_artifact(self, *args, **kwargs) -> bool:
        """
        Returns bool value means if on image was artifact
        """
        pass