import os
from pathlib import Path

import cv2
import numpy as np



all_classes_names = [
        'person', 'bicycle', 'car', 'motorcycle', 'airplane', 'bus', 'train',
        'truck', 'boat', 'traffic light', 'fire hydrant', 'stop sign',
        'parking meter', 'bench', 'bird', 'cat', 'dog', 'horse', 'sheep',
        'cow', 'elephant', 'bear', 'zebra', 'giraffe', 'backpack', 'umbrella',
        'handbag', 'tie', 'suitcase', 'frisbee', 'skis', 'snowboard',
        'sports ball', 'kite', 'baseball bat', 'baseball glove', 'skateboard',
        'surfboard', 'tennis racket', 'bottle', 'wine glass', 'cup', 'fork',
        'knife', 'spoon', 'bowl', 'banana', 'apple', 'sandwich', 'orange',
        'broccoli', 'carrot', 'hot dog', 'pizza', 'donut', 'cake', 'chair',
        'couch', 'potted plant', 'bed', 'dining table', 'toilet', 'tv',
        'laptop', 'mouse', 'remote', 'keyboard', 'cell phone', 'microwave',
        'oven', 'toaster', 'sink', 'refrigerator', 'book', 'clock', 'vase',
        'scissors', 'teddy bear', 'hair drier', 'toothbrush', 'banner',
        'blanket', 'branch', 'bridge', 'building-other', 'bush', 'cabinet',
        'cage', 'cardboard', 'carpet', 'ceiling-other', 'ceiling-tile',
        'cloth', 'clothes', 'clouds', 'counter', 'cupboard', 'curtain',
        'desk-stuff', 'dirt', 'door-stuff', 'fence', 'floor-marble',
        'floor-other', 'floor-stone', 'floor-tile', 'floor-wood', 'flower',
        'fog', 'food-other', 'fruit', 'furniture-other', 'grass', 'gravel',
        'ground-other', 'hill', 'house', 'leaves', 'light', 'mat', 'metal',
        'mirror-stuff', 'moss', 'mountain', 'mud', 'napkin', 'net', 'paper',
        'pavement', 'pillow', 'plant-other', 'plastic', 'platform',
        'playingfield', 'railing', 'railroad', 'river', 'road', 'rock', 'roof',
        'rug', 'salad', 'sand', 'sea', 'shelf', 'sky-other', 'skyscraper',
        'snow', 'solid-other', 'stairs', 'stone', 'straw', 'structural-other',
        'table', 'tent', 'textile-other', 'towel', 'tree', 'vegetable',
        'wall-brick', 'wall-concrete', 'wall-other', 'wall-panel',
        'wall-stone', 'wall-tile', 'wall-wood', 'water-other', 'waterdrops',
        'window-blind', 'window-other', 'wood'
    ]

good_classes_names = {
    'person', 'bicycle', 'car', 'motorcycle', 'airplane', 'bus', 'train',
        'truck', 'boat', 'traffic light', 'fire hydrant', 'stop sign',
        'parking meter', 'bench', 'bird', 'cat', 'dog', 'horse', 'sheep',
        'cow', 'elephant', 'bear', 'zebra', 'giraffe', 'backpack', 'umbrella',
        'handbag', 'tie', 'suitcase', 'frisbee', 'skis', 'snowboard',
        'sports ball', 'kite', 'baseball bat', 'baseball glove', 'skateboard',
        'surfboard', 'tennis racket', 'bottle', 'wine glass', 'cup', 'fork',
        'knife', 'spoon', 'bowl', 'banana', 'apple', 'sandwich', 'orange',
        'broccoli', 'carrot', 'hot dog', 'pizza', 'donut', 'cake', 'chair',
        'couch', 'potted plant', 'bed', 'dining table', 'toilet', 'tv',
        'laptop', 'mouse', 'remote', 'keyboard', 'cell phone', 'microwave',
        'oven', 'toaster', 'sink', 'refrigerator', 'book', 'clock', 'vase',
        'scissors', 'teddy bear', 'hair drier', 'toothbrush', 'banner',
        'blanket', 'branch', 'bridge', 'building-other', 'cabinet',
        'cage', 'carpet', 'ceiling-other', 'ceiling-tile',
        'cloth', 'clothes',  'counter', 'cupboard', 'curtain',
        'desk-stuff', 'door-stuff', 'fence', 'flower',  'food-other', 'fruit', 'furniture-other',
        'house', 'mat', 'mountain', 'napkin', 'net',  'pillow',
        'plastic', 'platform', 'railing', 'railroad', 'roof',  'salad', 'rug',  'shelf',
        'skyscraper',  'stairs', 'solid-other', 'table', 'tent', 'textile-other', 'towel',
        'vegetable', 'wall-brick', 'wall-panel', 'wall-tile',
        'metal', 'pavement',
        "floor-other", "dirt", "wall-stone", "sea", "sand" , "gravel", "floor-stone", "light", "clouds", "playingfield",
        "floor-tile", "wall-wood"
        }
# bad_classes_names = {
#     'clouds', 'dirt', 'floor-marble',
#     'floor-other', 'floor-stone', 'floor-tile', 'floor-wood',
#     'fog', 'grass', 'gravel',
#     'ground-other', 'leaves', 'light',
#     'mirror-stuff', 'moss', 'mud',  'paper',
#     'playingfield',  'river', 'road', 'rock',
#      'sand', 'sea', 'sky-other', 
#     'snow', 'stone', 'straw',
#      'tree',
#      'wall-concrete', 
#     'wall-stone',  'wall-wood', 'water-other', 'waterdrops',
#      'wood'}


bad_classes_names = set(all_classes_names) - good_classes_names

assert len(good_classes_names) + len(bad_classes_names) == len(all_classes_names)

good_classes = np.array([all_classes_names.index(name) for name in good_classes_names])
bad_classes = np.array([all_classes_names.index(name) for name in bad_classes_names])


def get_binary_mask(hr_path, sr_path, rf_path):
    base_name = str(Path(hr_path).stem).split('@')[0]
    san_path = os.path.join(os.path.dirname(hr_path), base_name + '@FT@SAN_segmentation.png')
    san_heatmap = cv2.imread(san_path, 0)
    assert san_heatmap is not None, f"failed reading {san_path}"
    res = np.isin(san_heatmap, good_classes) * 1

    return res

def SAN_mask_zeroing(method):
    def wrapper(hr_path, sr_path, rf_path):
        res = method(hr_path, sr_path, rf_path)
        seg_sep = get_binary_mask(hr_path, sr_path, rf_path)
        res[seg_sep == 0] = 0
        return res
    return wrapper


