
# Few-Shot Backdoor Attack against Visual Tracking

This repository is the official implementation of submisstion [Few-Shot Backdoor Attacks on Visual Object Tracking]() to ICLR 2022. 

The codes are of the main experiments on SiamFC++.

## Requirements
### Environment
A simple way to install requirements:
```setup
pip install -r requirements.txt
```
or
```setup
python setup.py develop
```


### Dataset Preparation
Set soft link to dataset directory.

```bash
ln -s path_to_datasets datasets
```

make sure the directory ``datasets`` follows:

```File Tree
datasets
├── OTB  # experiment configurations, in yaml format
│   ├── OTB2015
│   │    ├── Basketball
│   │    ├── Biker
│   │    └── ...
├── GOT-10k  # same structure as full_data.zip
│   ├── train
│   ├── val
│   └── test
├── LaSOT
│   ├── airplane
│   │    ├── airplane-1
│   │    └── ...
│   └── ...
└── ...
```

>📋  Dataset Download Links:  
> 1. [GOT10K](http://got-10k.aitestunion.com/downloads)
> 2. [OTB100](http://cvlab.hanyang.ac.kr/tracker_benchmark/datasets.html)
> 3. [LaSOT](http://vision.cs.stonybrook.edu/~lasot/download.html)


## Training

Codes for training will be releases upon acceptance.


## Evaluation

To evaluate a model on testing dataset, run:

```eval
python test.py --config "path/to/your/config"
```
for example:

```eval
# for evaluation under one-shot attack mode:
python test.py --config "experiments/siamfcpp/test_ba/siamfcpp_googlenet-dist_trn-coco_vid-ba01w05-no-baz-p1t01.yaml"

# for evaluation under few-shot attack mode:
python test.py --config "experiments/siamfcpp/test_ba/siamfcpp_googlenet-dist_trn-coco_vid-ba01w05-no-bax-p1t01-25.yaml"

# for evaluation under benign mode (no attack):
python test.py --config "experiments/siamfcpp/test_ba/siamfcpp_googlenet-dist_trn-coco_vid-ba01w05-no-p1t01.yaml"
```

The datasets to be tested can be modified at the following lines of the config file (e.g. [test_config](experiments/siamfcpp/test_ba/siamfcpp_googlenet-dist_trn-coco_vid-ba01w05-no-p1t01.yaml)) by modifying `names` of the tester.
```
tester:
      names: ['OTBTester',]  #["VOTTester",] # (VOTTester|GOT10kTester|LaSOTTester)
      VOTTester:
        exp_name: *TEST_NAME
        exp_save: *TEST_SAVE
        device_num: 1
        dataset_names: ["VOT2018"]
      GOT10kTester:
        exp_name: *TEST_NAME
        exp_save: *TEST_SAVE
        subsets: ["val"]  # (val|test)
      LaSOTTester:
        exp_name: *TEST_NAME
        exp_save: *TEST_SAVE
        subsets: ["test"]  # (train_test|test)
      OTBTester:
        exp_name: *TEST_NAME
        exp_save: *TEST_SAVE
        device_num: 1
        subsets: ["otb2015"]
```

## Demo
You can also make a demo with taken video (or image sequence).
```Bash
# demo with web camera
python3 ./demo/main/video/sot_video.py --config 'path/to/yout/config' --device cuda --video "webcam" 

# demo with video file, and dump result into video file (optional)
python3 ./demo/main/video/sot_video.py --config 'path/to/yout/config' --device cuda --video $video_dir/demo.mp4 --output $dump_path/result.mp4

# demo with extracted image files, and dump result into image files (optional)
python3 ./demo/main/video/sot_video.py --config 'path/to/yout/config' --device cuda --video $video_dir/*.jpg --output $dump_dir
```


## Acknowledgement 

Our code is based on the excellent project [video analyst](https://github.com/MegviiDetection/video_analyst).


