from parlai.core.agents import register_agent, Agent


@register_agent("hello")
class HelloAgent(Agent):
    @classmethod
    def add_cmdline_args(cls, parser):
        parser.add_argument('--name', type=str, default='Alice', help="The agent's name.")
        return parser

    def __init__(self, opt, shared=None):
        # similar to the teacher, we have the Opt and the shared memory objects!
        super().__init__(opt, shared)
        self.id = 'HelloAgent'
        self.name = opt['name']

    def observe(self, observation):
        # Gather the last word from the other user's input
        words = observation.get('text', '').split()
        # print(observation)
        for k, v in observation.items():
            print(k)
            print('      ', repr(v))
            print('      ', type(v))
        print() 
        if words:
            self.last_word = words[-1]
        else:
            self.last_word = "stranger!"

    def act(self):
        # Always return a string like this.
        return {
            'id': self.id,
            'text': f"Hello {self.last_word}, I'm {self.name}",
        }
