import os, json

from GenericTools.StayOrganizedTools.unzip import unzip_good_exps
from ariel_tests.language.utils import LoadConfig, SaveConfig
from ariel_tests.test_analysis.visualization import CompareTexts

CDIR = os.path.dirname(os.path.realpath(__file__))
DATADIR = os.path.join(CDIR, 'data')
EXPERIMENTS = os.path.join(CDIR, 'experiments')
GEXPERIMENTS = os.path.join(CDIR, 'good_experiments')

ds = unzip_good_exps(
    GEXPERIMENTS, EXPERIMENTS, exp_identifiers=['experiment'], unzip_what=['sampled_sentences.txt', 'config.txt'],
)

# I forgot to uncomment the CompareTexts in the main code, in the last run, so I have to run it now
for d in ds:
    print(d)
    texts_path = os.path.join(d, 'text', 'sampled_sentences.txt')
    config_path = os.path.join(d, 'config.txt')

    config = LoadConfig(config_path)
    if not 'memorized_ratio' in config.keys():
        r = CompareTexts(texts_path=texts_path)
        config['memorized_ratio'] = r
    SaveConfig(d, config)
