from __future__ import division, absolute_import, print_function

import ray

from models.end_to_end.search_models.critic_guided import CriticGuidedSearch
from models.end_to_end.search_models.dpp import DPPSearch
from models.end_to_end.search_models.bestfs import BestFS
from models.end_to_end.search_models.bfs import BFS
from models.end_to_end.search_models.dpp_critic import DPPCritic
from models.end_to_end.search_models.goal_models.internlm_critic import InternLMCritic
from models.end_to_end.search_models.goal_models.pair_model.model import PairGoalModel
from models.end_to_end.search_models.goal_models.state_embedding import StateEmbeddingModel
from models.end_to_end.search_models.htps import HTPS
from models.end_to_end.search_models.levin_search import LevinSearch
from models.end_to_end.search_models.search_models import GoalModel
from models.end_to_end.search_models.simple_ts import SimpleTS
from models.end_to_end.search_models.updown import UpDown

from models.end_to_end.search_models.goal_models.hard_goal_model.model import HardGoalModel
from models.end_to_end.tactic_models.diversity_model.model import DiversityModel


def get_search_model(config, device):
    """

    Initialise search model based on configuration.

    """

    if config.search == 'bestfs':
        return BestFS()
    else:
        raise NotImplementedError(f'Search approach {config.search} not implemented')
